/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics;

import java.util.Objects;

public class Tag {
    private final String tagName;
    private final String tagValue;

    public Tag(String tagName, String tagValue) throws IllegalArgumentException {
        if (tagName == null || tagValue == null || !tagName.matches("[a-zA-Z_][a-zA-Z0-9_]*")) {
            throw new IllegalArgumentException("Invalid Tag name. Tag names must match the following regex [a-zA-Z_][a-zA-Z0-9_]*");
        }
        this.tagName = tagName;
        this.tagValue = tagValue;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getTagValue() {
        return this.tagValue;
    }

    public int hashCode() {
        return Objects.hash(this.tagName, this.tagValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag that = (Tag)o;
        return Objects.equals(this.tagName, that.getTagName()) && Objects.equals(this.tagValue, that.getTagValue());
    }

    public String toString() {
        return "Tag{" + this.tagName + '=' + this.tagValue + '}';
    }
}

