/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.jdbc.WSJdbcWrapper;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class WSJdbcObject
extends WSJdbcWrapper
implements FFDCSelfIntrospectable {
    protected WSJdbcWrapper.State state = WSJdbcWrapper.State.ACTIVE;
    public WSJdbcObject parentWrapper;
    protected WSJdbcObject childWrapper;
    protected ArrayList<Wrapper> childWrappers;
    protected boolean freeResourcesOnClose;
    protected List<Array> arrays;
    protected List<Blob> blobs;
    protected List<Clob> clobs;
    protected List<Closeable> resources;
    protected List<SQLXML> xmls;

    public void beginTransactionIfNecessary() throws SQLException {
        this.getConnectionWrapper().beginTransactionIfNecessary();
    }

    public void close() throws SQLException {
        this.close(false);
    }

    protected void close(boolean closeWrapperOnly) throws SQLException {
        TraceComponent tc = this.getTracer();
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object[])new Object[0]);
        }
        if (this.state == WSJdbcWrapper.State.CLOSED) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"close", (Object)"Already closed");
            }
            return;
        }
        this.state = WSJdbcWrapper.State.CLOSED;
        if (isTraceOn && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("state --> " + this.state.name()), (Object[])new Object[0]);
        }
        this.closeChildWrappers();
        SQLException sqlX = this.freeResourcesOnClose ? this.closeResources() : null;
        SQLException sqlX2 = this.closeWrapper(closeWrapperOnly);
        sqlX = sqlX == null ? sqlX2 : sqlX;
        this.childWrappers = null;
        this.ifcToDynamicWrapper.clear();
        this.dynamicWrapperToImpl.clear();
        if (sqlX != null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"close", (Object)sqlX);
            }
            throw sqlX;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    final void closeChildWrappers() {
        TraceComponent tc = this.getTracer();
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Closing child wrappers", (Object[])new Object[0]);
            }
            WSJdbcObject wrapper = null;
            int i = this.childWrappers.size();
            while (i > 0) {
                try {
                    wrapper = (WSJdbcObject)this.childWrappers.get(--i);
                    wrapper.close();
                }
                catch (SQLException closeX) {
                    FFDCFilter.processException((Throwable)closeX, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcObject.closeChildWrappers", (String)"554", (Object)this);
                }
                catch (IndexOutOfBoundsException ioobX) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"ArrayIndexOutOfBoundsException is caught during closeChildWrappers() of the WSJdbcObject", (Object[])new Object[0]);
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Possible causes:", (Object[])new Object[0]);
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"multithreaded access of JDBC objects by the Application", (Object[])new Object[0]);
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Application is closing JDBC objects in a finalize()", (Object[])new Object[0]);
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Exception is: ", (Object[])new Object[]{ioobX});
                    }
                    throw ioobX;
                }
            }
        }
        if (this.childWrapper != null) {
            try {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Closing child wrapper", (Object[])new Object[0]);
                }
                this.childWrapper.close();
            }
            catch (SQLException closeX) {
                FFDCFilter.processException((Throwable)closeX, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcObject.closeChildWrappers", (String)"573", (Object)this);
            }
        }
    }

    protected SQLException closeResources() {
        TraceComponent tc = this.getTracer();
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"closeResources", (Object[])new Object[]{this});
        }
        SQLException result = null;
        for (Closeable resource : this.resources) {
            try {
                if (resource == null) continue;
                resource.close();
            }
            catch (IOException ioX) {
                FFDCFilter.processException((Throwable)ioX, (String)(this.getClass().getName() + ".closeResources"), (String)"316", (Object)this);
                if (result != null) continue;
                result = AdapterUtil.toSQLException(ioX);
            }
        }
        this.resources.clear();
        if (this.mcf.jdbcDriverSpecVersion >= 40) {
            if (this.mcf.doArrayCleanup) {
                for (Array ra : this.arrays) {
                    try {
                        if (ra == null) continue;
                        ra.free();
                    }
                    catch (SQLFeatureNotSupportedException supportX) {
                        this.mcf.doArrayCleanup = false;
                        if (!isTraceOn || !tc.isDebugEnabled()) continue;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Array.free is not supported.", (Object[])new Object[]{supportX});
                    }
                    catch (SQLException sqlX) {
                        FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".closeResources"), (String)"325", (Object)this);
                        if (result != null) continue;
                        result = sqlX;
                    }
                }
            }
            if (this.mcf.doBlobCleanup) {
                for (Blob blob : this.blobs) {
                    try {
                        if (blob == null) continue;
                        blob.free();
                    }
                    catch (SQLFeatureNotSupportedException supportX) {
                        this.mcf.doBlobCleanup = false;
                        if (!isTraceOn || !tc.isDebugEnabled()) continue;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Blob.free is not supported.", (Object[])new Object[]{supportX});
                    }
                    catch (SQLException sqlX) {
                        FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".closeResources"), (String)"348", (Object)this);
                        if (result != null) continue;
                        result = sqlX;
                    }
                }
            }
            if (this.mcf.doClobCleanup) {
                for (Clob clob : this.clobs) {
                    try {
                        if (clob == null) continue;
                        clob.free();
                    }
                    catch (SQLFeatureNotSupportedException supportX) {
                        this.mcf.doClobCleanup = false;
                        if (!isTraceOn || !tc.isDebugEnabled()) continue;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Clob.free is not supported.", (Object[])new Object[]{supportX});
                    }
                    catch (SQLException sqlX) {
                        FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".closeResources"), (String)"367", (Object)this);
                        if (result != null) continue;
                        result = sqlX;
                    }
                }
            }
            if (this.mcf.doXMLCleanup) {
                for (SQLXML xml : this.xmls) {
                    try {
                        if (xml == null) continue;
                        xml.free();
                    }
                    catch (SQLFeatureNotSupportedException supportX) {
                        this.mcf.doXMLCleanup = false;
                        if (!isTraceOn || !tc.isDebugEnabled()) continue;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"SQLXML.free is not supported.", (Object[])new Object[]{supportX});
                    }
                    catch (SQLException sqlX) {
                        FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".closeResources"), (String)"386", (Object)this);
                        if (result != null) continue;
                        result = sqlX;
                    }
                }
            }
        }
        this.arrays.clear();
        this.blobs.clear();
        this.clobs.clear();
        this.xmls.clear();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"closeResources", (Object)result);
        }
        return result;
    }

    protected abstract SQLException closeWrapper(boolean var1);

    protected abstract WSJdbcObject getConnectionWrapper();

    public final WSJdbcWrapper.State getState() {
        return this.state;
    }

    @Override
    protected abstract TraceComponent getTracer();

    final void init(WSJdbcObject parent) {
        if (parent != null) {
            this.parentWrapper = parent;
            this.dsConfig = parent.dsConfig;
            this.freeResourcesOnClose = parent.freeResourcesOnClose;
        }
        if (this.freeResourcesOnClose) {
            this.arrays = new LinkedList<Array>();
            this.blobs = new LinkedList<Blob>();
            this.clobs = new LinkedList<Clob>();
            this.resources = new LinkedList<Closeable>();
            this.xmls = new LinkedList<SQLXML>();
        }
    }

    protected void introspectAll(FFDCLogger info) {
        info.append(this.toString());
        this.introspectWrapperSpecificInfo(info);
        info.append("Wrapper State: ", this.state.name());
        info.append("Parent wrapper:", this.parentWrapper);
        info.append("Child wrapper:");
        info.indent(this.childWrapper);
        if (this.childWrappers != null) {
            try {
                info.append("# of Child Wrappers " + this.childWrappers.size());
                info.append("Child wrappers:");
                for (int i = 0; i < this.childWrappers.size(); ++i) {
                    info.indent(this.childWrappers.get(i));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        info.eoln();
    }

    public String[] introspectSelf() {
        FFDCLogger info = new FFDCLogger(this);
        WSJdbcObject connWrapper = null;
        try {
            connWrapper = this.getConnectionWrapper();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (connWrapper == null || connWrapper == this) {
            this.introspectAll(info);
        } else {
            this.introspectAll(info);
            info.append(connWrapper.introspectSelf());
        }
        return info.toStringArray();
    }

    protected void introspectWrapperSpecificInfo(FFDCLogger info) {
    }

    public final boolean isClosed() {
        return this.state == WSJdbcWrapper.State.CLOSED;
    }

    @Override
    protected abstract RuntimeException runtimeXIfNotClosed(RuntimeException var1) throws SQLException;
}

