/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.messaging.security.Authorization;
import com.ibm.ws.messaging.security.MessagingSecurityException;
import com.ibm.ws.messaging.security.RuntimeSecurityService;
import com.ibm.ws.messaging.security.authorization.MessagingAuthorizationException;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.processor.CommandHandler;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.processor.MPSubscription;
import com.ibm.ws.sib.processor.MulticastProperties;
import com.ibm.ws.sib.processor.TransactionalCommandHandler;
import com.ibm.ws.sib.processor.exceptions.SIMPConnectionUnavailableException;
import com.ibm.ws.sib.processor.exceptions.SIMPDestinationAlreadyExistsException;
import com.ibm.ws.sib.processor.exceptions.SIMPIncorrectCallException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotAuthorizedException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.processor.exceptions.SIMPTemporaryDestinationNotFoundException;
import com.ibm.ws.sib.processor.impl.AccessChecker;
import com.ibm.ws.sib.processor.impl.AliasDestinationHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.BifurcatedConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.BrowserSessionImpl;
import com.ibm.ws.sib.processor.impl.BusHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.ConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.DestinationConfigurationImpl;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.DurableInputHandler;
import com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl;
import com.ibm.ws.sib.processor.impl.MQLinkHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.MulticastPropertiesImpl;
import com.ibm.ws.sib.processor.impl.OrderingContextImpl;
import com.ibm.ws.sib.processor.impl.ProducerSessionImpl;
import com.ibm.ws.sib.processor.impl.SecurityContext;
import com.ibm.ws.sib.processor.impl.corespitrace.CoreSPIConnection;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.itemstreams.MQLinkPubSubBridgeItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPLocalMsgsItemStream;
import com.ibm.ws.sib.processor.utils.DestinationSessionUtils;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCallback;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.trm.TrmMeMain;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.BifurcatedConsumerSession;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.ConsumerSetChangeCallback;
import com.ibm.wsspi.sib.core.DestinationAvailability;
import com.ibm.wsspi.sib.core.DestinationConfiguration;
import com.ibm.wsspi.sib.core.DestinationListener;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.Distribution;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.SICoreUtils;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SICommandInvocationFailedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SIInvalidDestinationPrefixException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINonDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;

public final class ConnectionImpl
implements MPCoreConnection,
TransactionCallback {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsir = TraceNLS.getTraceNLS((String)"com.ibm.wsspi.sib.core.CWSIRMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private static final TraceComponent tc = SibTr.register(ConnectionImpl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private final SIMPTransactionManager _txManager;
    private final List<SICoreConnectionListener> _connectionListeners;
    private boolean _closed;
    private final List<ProducerSession> _producers;
    private final List<ConsumerSessionImpl> _consumers;
    private final List<BifurcatedConsumerSessionImpl> _bifurcatedConsumers;
    private final List<BrowserSession> _browsers;
    private final List<String> _temporaryDestinations;
    private final List<LocalTransaction> _ownedTransactions;
    private final SIBUuid12 _uuid;
    private TrmMeMain _trmMeMain;
    private Subject _subject = null;
    private boolean _copyMessagesWhenSent = true;
    private boolean _copyMessagesWhenReceived = true;
    private boolean _setWaitTimeInMessage = true;
    private final MessageProcessor _messageProcessor;
    private final DestinationManager _destinationManager;
    private AccessChecker _accessChecker;
    private Map _connectionProperties = null;
    private final RuntimeSecurityService runtimeSecurityService;
    private final Authorization _authorization;
    private boolean _isBusSecure = false;
    private int connectionType = 1;

    ConnectionImpl(MessageProcessor messageProcessor, Subject subject, Map connectionProperties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String report = "<null>";
            if (subject != null) {
                report = "subject(" + messageProcessor.getAuthorisationUtils().getUserName(subject) + ")";
            }
            SibTr.entry((TraceComponent)tc, (String)"ConnectionImpl", (Object)new Object[]{messageProcessor, report, connectionProperties});
        }
        this._messageProcessor = messageProcessor;
        this._subject = subject;
        this._connectionProperties = connectionProperties;
        this.runtimeSecurityService = messageProcessor.getRuntimeSecurityService();
        this._authorization = messageProcessor.getAuthorization();
        this._isBusSecure = messageProcessor.isBusSecure();
        if (this._isBusSecure) {
            this._accessChecker = messageProcessor.getAccessChecker();
        }
        this._txManager = messageProcessor.getTXManager();
        this._destinationManager = messageProcessor.getDestinationManager();
        this._producers = new LinkedList<ProducerSession>();
        this._consumers = new LinkedList<ConsumerSessionImpl>();
        this._bifurcatedConsumers = new LinkedList<BifurcatedConsumerSessionImpl>();
        this._browsers = new LinkedList<BrowserSession>();
        this._connectionListeners = new LinkedList<SICoreConnectionListener>();
        this._temporaryDestinations = new LinkedList<String>();
        this._ownedTransactions = new LinkedList<LocalTransaction>();
        this._uuid = new SIBUuid12();
        this._closed = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ConnectionImpl", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotClosed() throws SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkNotClosed");
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this._closed) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkNotClosed", (Object)"Connection Closed exception");
                }
                SIMPConnectionUnavailableException e = new SIMPConnectionUnavailableException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_22", new Object[]{this._messageProcessor.getMessagingEngineName()}, null));
                e.setExceptionReason(22);
                e.setExceptionInserts(new String[]{this._messageProcessor.getMessagingEngineName()});
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkNotClosed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMPStarted() throws SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkMPStarted");
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (!this._messageProcessor.isStarted()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkMPStarted", (Object)"Message Processor not started exception");
                }
                SIMPConnectionUnavailableException e = new SIMPConnectionUnavailableException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_22", new Object[]{this._messageProcessor.getMessagingEngineName()}, null));
                e.setExceptionReason(22);
                e.setExceptionInserts(new String[]{this._messageProcessor.getMessagingEngineName()});
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkMPStarted");
        }
    }

    private void checkDestinationType(DestinationType expectedDestType, SIDestinationAddress destAddr, DestinationHandler destination, boolean system) throws SINotPossibleInCurrentConfigurationException {
        SIBUuid8 encodedME;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDestinationType", (Object)new Object[]{expectedDestType, destAddr, destination, destination.getDestinationType(), system});
        }
        boolean correctType = true;
        if (expectedDestType != null) {
            correctType = false;
            if (destination.isForeign() || destination.isForeignBus() || destination.isAlias() && destination.getDestinationType() == DestinationType.UNKNOWN) {
                correctType = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Correct Type as destination is Foreign");
                }
            } else if (expectedDestType == destination.getDestinationType()) {
                correctType = true;
            } else if (expectedDestType == DestinationType.TOPICSPACE && destAddr.getDestinationName().startsWith("_T")) {
                correctType = true;
            }
        }
        if (system ^ destination.isSystem() && destination.isSystem() && (encodedME = SIMPUtils.parseME(destAddr.getDestinationName())) != null && !encodedME.equals((Object)this._messageProcessor.getMessagingEngineUuid())) {
            correctType = true;
        }
        if (!correctType) {
            String type = "SYSTEM";
            if (expectedDestType != null) {
                type = expectedDestType.toString();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkDestinationType", (Object)("Destination is of wrong type " + type + ":" + destination.getDestinationType().toString()));
            }
            String msg = this.locateCorrectMessage(destination.getDestinationType(), expectedDestType);
            SIMPNotPossibleInCurrentConfigurationException e = null;
            if (!msg.equals("DELIVERY_ERROR_SIRC_14")) {
                e = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage(msg, new Object[]{destination.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                e.setExceptionReason(Integer.parseInt(msg.replaceFirst("DELIVERY_ERROR_SIRC_", "")));
                e.setExceptionInserts(new String[]{destination.getName(), this._messageProcessor.getMessagingEngineName()});
            } else {
                e = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage(msg, new Object[]{destination.getName(), this._messageProcessor.getMessagingEngineName(), destination.getDestinationType().toString(), type}, null));
                e.setExceptionReason(14);
                e.setExceptionInserts(new String[]{destination.getName(), this._messageProcessor.getMessagingEngineName(), destination.getDestinationType().toString(), type});
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDestinationType");
        }
    }

    private String locateCorrectMessage(DestinationType realType, DestinationType expectedType) {
        if (realType == DestinationType.QUEUE) {
            if (expectedType == DestinationType.TOPICSPACE) {
                return "DELIVERY_ERROR_SIRC_2";
            }
            if (expectedType == DestinationType.SERVICE) {
                return "DELIVERY_ERROR_SIRC_3";
            }
            if (expectedType == DestinationType.PORT) {
                return "DELIVERY_ERROR_SIRC_4";
            }
            return "DELIVERY_ERROR_SIRC_14";
        }
        if (realType == DestinationType.TOPICSPACE) {
            if (expectedType == DestinationType.QUEUE) {
                return "DELIVERY_ERROR_SIRC_11";
            }
            if (expectedType == DestinationType.SERVICE) {
                return "DELIVERY_ERROR_SIRC_12";
            }
            if (expectedType == DestinationType.PORT) {
                return "DELIVERY_ERROR_SIRC_13";
            }
            return "DELIVERY_ERROR_SIRC_14";
        }
        if (realType == DestinationType.SERVICE) {
            if (expectedType == DestinationType.QUEUE) {
                return "DELIVERY_ERROR_SIRC_5";
            }
            if (expectedType == DestinationType.TOPICSPACE) {
                return "DELIVERY_ERROR_SIRC_6";
            }
            if (expectedType == DestinationType.PORT) {
                return "DELIVERY_ERROR_SIRC_7";
            }
            return "DELIVERY_ERROR_SIRC_14";
        }
        if (realType == DestinationType.PORT) {
            if (expectedType == DestinationType.QUEUE) {
                return "DELIVERY_ERROR_SIRC_8";
            }
            if (expectedType == DestinationType.TOPICSPACE) {
                return "DELIVERY_ERROR_SIRC_9";
            }
            if (expectedType == DestinationType.SERVICE) {
                return "DELIVERY_ERROR_SIRC_10";
            }
            return "DELIVERY_ERROR_SIRC_14";
        }
        return "DELIVERY_ERROR_SIRC_14";
    }

    public void close() throws SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"close", (Object)this);
        }
        this._messageProcessor.getConnectionLockManager().lock();
        try {
            this._close(true);
        }
        finally {
            this._messageProcessor.getConnectionLockManager().unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"close");
        }
    }

    public void close(boolean bForceFlag) throws SIConnectionLostException, SIResourceException, SIErrorException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _close(boolean removeConnectionListeners) throws SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_close", (Object)removeConnectionListeners);
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            Iterator<Object> itr;
            if (this._closed) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"_close", (Object)"Returning as already closed");
                }
                return;
            }
            this._closed = true;
            String busName = this._messageProcessor.getBus().getName();
            this._messageProcessor.getAuthorisationUtils().logout(busName, this._subject);
            List<Object> list = this._ownedTransactions;
            synchronized (list) {
                itr = this._ownedTransactions.iterator();
                while (itr.hasNext()) {
                    LocalTransaction tran = itr.next();
                    itr.remove();
                    try {
                        tran.rollback();
                    }
                    catch (SIException sIException) {}
                }
            }
            list = this._producers;
            synchronized (list) {
                itr = this._producers.iterator();
                while (itr.hasNext()) {
                    ProducerSessionImpl ps = (ProducerSessionImpl)itr.next();
                    itr.remove();
                    ps._close();
                }
            }
            list = this._bifurcatedConsumers;
            synchronized (list) {
                itr = this._bifurcatedConsumers.iterator();
                while (itr.hasNext()) {
                    BifurcatedConsumerSessionImpl bcs = (BifurcatedConsumerSessionImpl)itr.next();
                    itr.remove();
                    bcs._close();
                }
            }
            list = this._consumers;
            synchronized (list) {
                itr = this._consumers.iterator();
                while (itr.hasNext()) {
                    ConsumerSessionImpl cs = (ConsumerSessionImpl)itr.next();
                    itr.remove();
                    this._messageProcessor.removeConsumer(cs);
                    cs._close();
                }
            }
            list = this._browsers;
            synchronized (list) {
                itr = this._browsers.iterator();
                while (itr.hasNext()) {
                    BrowserSessionImpl bs = (BrowserSessionImpl)itr.next();
                    itr.remove();
                    bs._close();
                }
            }
            list = this._temporaryDestinations;
            synchronized (list) {
                itr = this._temporaryDestinations.iterator();
                while (itr.hasNext()) {
                    String destinationName = (String)itr.next();
                    try {
                        this._destinationManager.deleteTemporaryDestination(SIMPUtils.createJsDestinationAddress(destinationName, this._messageProcessor.getMessagingEngineUuid()));
                    }
                    catch (SIException e) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    }
                    itr.remove();
                }
            }
            if (removeConnectionListeners) {
                list = this._connectionListeners;
                synchronized (list) {
                    itr = this._connectionListeners.iterator();
                    while (itr.hasNext()) {
                        itr.next();
                        itr.remove();
                    }
                }
            }
            try {
                this._messageProcessor.getMessageProcessorMatching().removeConsumerSetMonitors(this);
            }
            catch (SINotPossibleInCurrentConfigurationException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl._close", (String)"1:745:1.347.1.25", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"_close", (Object)((Object)e));
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"ConnectionImpl", "1:754:1.347.1.25"}, null), (Throwable)e);
            }
            this._destinationManager.removeDestinationListener((SICoreConnection)this);
            this._messageProcessor.removeConnection(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBrowserSession(BrowserSessionImpl browser) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeBrowserSession", (Object)browser);
        }
        List<BrowserSession> list = this._browsers;
        synchronized (list) {
            this._browsers.remove(browser);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeBrowserSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConsumerSession(ConsumerSessionImpl consumer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumerSession", (Object)consumer);
        }
        List<ConsumerSessionImpl> list = this._consumers;
        synchronized (list) {
            this._consumers.remove(consumer);
        }
        this._messageProcessor.removeConsumer(consumer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumerSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProducerSession(ProducerSessionImpl producer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeProducerSession");
        }
        List<ProducerSession> list = this._producers;
        synchronized (list) {
            this._producers.remove(producer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeProducerSession");
        }
    }

    public SIUncoordinatedTransaction createUncoordinatedTransaction() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createUncoordinatedTransaction");
        }
        SIUncoordinatedTransaction tran = this.createUncoordinatedTransaction(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createUncoordinatedTransaction", (Object)tran);
        }
        return tran;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIUncoordinatedTransaction createUncoordinatedTransaction(boolean allowSubordinateResources) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createUncoordinatedTransaction", (Object)new Object[]{this, allowSubordinateResources});
        }
        LocalTransaction tran = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            this.checkMPStarted();
            tran = this._txManager.createLocalTransaction(!allowSubordinateResources);
            List<LocalTransaction> list = this._ownedTransactions;
            synchronized (list) {
                this._ownedTransactions.add(tran);
                tran.registerCallback((TransactionCallback)this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createUncoordinatedTransaction", (Object)tran);
        }
        return tran;
    }

    private void checkProducerSessionNullParameters(SIDestinationAddress destAddr) throws SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkProducerSessionNullParameters", (Object)destAddr);
        }
        if (destAddr == null) {
            SIMPIncorrectCallException e = new SIMPIncorrectCallException(nls_cwsir.getFormattedMessage("CREATE_PRODUCER_CWSIR0051", null, null));
            e.setExceptionReason(900);
            e.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl.checkProducerSessionNullParameters", "1:898:1.347.1.25"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkProducerSessionNullParameters", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkProducerSessionNullParameters", (Object)destAddr);
        }
    }

    public ProducerSession createProducerSession(SIDestinationAddress destAddr, String discriminator, DestinationType destType, OrderingContext extendedMessageOrderingContext, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SITemporaryDestinationNotFoundException, SIErrorException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        ProducerSession session = this.createProducerSession(destAddr, discriminator, destType, extendedMessageOrderingContext, alternateUser, false, false);
        return session;
    }

    public ProducerSession createProducerSession(SIDestinationAddress destAddr, String discriminator, DestinationType destType, OrderingContext extendedMessageOrderingContext, String alternateUser, boolean fixedQueuePoint, boolean preferLocal) throws SIConnectionDroppedException, SIConnectionUnavailableException, SITemporaryDestinationNotFoundException, SIErrorException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        ProducerSession session = this.createProducerSession(destAddr, discriminator, destType, extendedMessageOrderingContext, alternateUser, fixedQueuePoint, preferLocal, true);
        return session;
    }

    public ProducerSession createProducerSession(SIDestinationAddress destAddr, String discriminator, DestinationType destType, OrderingContext extendedMessageOrderingContext, String alternateUser, boolean fixedQueuePoint, boolean preferLocal, boolean clearPubSubFingerprints) throws SIConnectionDroppedException, SIConnectionUnavailableException, SITemporaryDestinationNotFoundException, SIErrorException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createProducerSession", (Object)new Object[]{destAddr, discriminator, destType, extendedMessageOrderingContext, alternateUser, fixedQueuePoint, preferLocal, clearPubSubFingerprints, this});
        }
        this.checkNotClosed();
        this.checkProducerSessionNullParameters(destAddr);
        SecurityContext secContext = null;
        if (this._isBusSecure) {
            secContext = new SecurityContext(this._subject, alternateUser, discriminator, this._messageProcessor.getAuthorisationUtils());
        }
        boolean keepSecurityUserid = false;
        ProducerSession session = this.internalCreateProducerSession(destAddr, destType, false, secContext, keepSecurityUserid, fixedQueuePoint, preferLocal, clearPubSubFingerprints, discriminator);
        if (discriminator != null && session != null) {
            ((ProducerSessionImpl)session).disableDiscriminatorAccessCheckAtSend(discriminator);
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createProducerSession", (Object)session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProducerSession internalCreateProducerSession(SIDestinationAddress destAddress, DestinationType destinationType, boolean system, SecurityContext secContext, boolean keepSecurityUserid, boolean fixedMessagePoint, boolean preferLocal, boolean clearPubSubFingerprints, String discriminator) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SITemporaryDestinationNotFoundException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalCreateProducerSession", (Object)new Object[]{destAddress, destinationType, system, secContext, keepSecurityUserid, fixedMessagePoint, preferLocal, clearPubSubFingerprints});
        }
        String destinationName = destAddress.getDestinationName();
        String busName = destAddress.getBusName();
        DestinationHandler destination = this._destinationManager.getDestination(destinationName, busName, false, true);
        this.checkDestinationType(destinationType, destAddress, destination, system);
        this.checkDestinationAuthority(destination, "SEND", discriminator);
        ProducerSessionImpl producer = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            producer = new ProducerSessionImpl(destAddress, destination, this, secContext, keepSecurityUserid, fixedMessagePoint, preferLocal, clearPubSubFingerprints);
            List<ProducerSession> list = this._producers;
            synchronized (list) {
                this._producers.add(producer);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalCreateProducerSession", (Object)producer);
        }
        return producer;
    }

    public ProducerSession createProducerSession(SIDestinationAddress destAddr, DestinationType destinationType, OrderingContext extendedMessageOrderingContext, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SITemporaryDestinationNotFoundException, SIErrorException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createProducerSession", (Object)new Object[]{destAddr, destinationType, extendedMessageOrderingContext, alternateUser, this});
        }
        this.checkNotClosed();
        this.checkProducerSessionNullParameters(destAddr);
        SecurityContext secContext = null;
        if (this._isBusSecure) {
            secContext = new SecurityContext(this._subject, alternateUser, null, this._messageProcessor.getAuthorisationUtils());
        }
        boolean keepSecurityUserid = false;
        ProducerSession producer = this.internalCreateProducerSession(destAddr, destinationType, false, secContext, keepSecurityUserid, false, true, true, null);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createProducerSession", (Object)producer);
        }
        return producer;
    }

    public ConsumerSession createMQInterOpConsumerSession(SIDestinationAddress destAddress, DestinationType destinationType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean nolocal, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser, boolean forwardScanning, boolean system) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createMQInterOpConsumerSession", (Object)new Object[]{this, destAddress, destinationType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable, alternateUser, forwardScanning, system});
        }
        this.checkNotClosed();
        this.checkConsumerSessionNullParameters(destAddress);
        ConsumerSession session = this.internalCreateConsumerSession(destAddress, alternateUser, destinationType, criteria, reliability, enableReadAhead, nolocal, forwardScanning, system, unrecoverableReliability, bifurcatable, true, true, false);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQInterOpConsumerSession", (Object)session);
        }
        return session;
    }

    private void checkTemporary(DestinationHandler destination, boolean mqinterop) throws SITemporaryDestinationNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkTemporary", (Object)new Object[]{destination, mqinterop});
        }
        if (destination.isTemporary() && !mqinterop && this._temporaryDestinations.indexOf(destination.getName()) == -1) {
            SIMPTemporaryDestinationNotFoundException e = new SIMPTemporaryDestinationNotFoundException(nls.getFormattedMessage("TEMPORARY_DESTINATION_CONNECTION_ERROR_CWSIP0099", new Object[]{destination.getName()}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.exit((TraceComponent)tc, (String)"checkTemporary", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkTemporary");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerSession internalCreateConsumerSession(SIDestinationAddress destAddr, String alternateUser, DestinationType destinationType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean nolocal, boolean forwardScanning, boolean system, Reliability unrecoverableReliability, boolean bifurcatable, boolean mqinterop, boolean ignoreInitialIndoubts, boolean gatherMessages) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SINotPossibleInCurrentConfigurationException, SITemporaryDestinationNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalCreateConsumerSession", (Object)new Object[]{destAddr, alternateUser, destinationType, criteria, reliability, enableReadAhead, nolocal, forwardScanning, system, unrecoverableReliability, bifurcatable, mqinterop, ignoreInitialIndoubts, gatherMessages});
        }
        try {
            ConsumerSession consumerSession = this.internalCreateConsumerSession(null, destAddr, alternateUser, destinationType, criteria, reliability, enableReadAhead, nolocal, forwardScanning, system, unrecoverableReliability, bifurcatable, mqinterop, ignoreInitialIndoubts, gatherMessages);
            return consumerSession;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"internalCreateConsumerSession");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerSession internalCreateConsumerSession(String subscriptionName, SIDestinationAddress destAddr, String alternateUser, DestinationType destinationType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean nolocal, boolean forwardScanning, boolean system, Reliability unrecoverableReliability, boolean bifurcatable, boolean mqinterop, boolean ignoreInitialIndoubts, boolean gatherMessages) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SINotPossibleInCurrentConfigurationException, SITemporaryDestinationNotFoundException {
        String destName;
        DestinationHandler destination;
        BaseDestinationHandler resolvedDestination;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalCreateConsumerSession", (Object)new Object[]{subscriptionName, destAddr, alternateUser, destinationType, destinationType, criteria, reliability, enableReadAhead, nolocal, forwardScanning, unrecoverableReliability, bifurcatable, mqinterop, ignoreInitialIndoubts, gatherMessages});
        }
        if (!(resolvedDestination = (destination = this._destinationManager.getDestination(destName = destAddr.getDestinationName(), destAddr.getBusName(), false)).getResolvedDestinationHandler()).getBus().equals(this._messageProcessor.getMessagingEngineBus())) {
            SIMPNotPossibleInCurrentConfigurationException e = new SIMPNotPossibleInCurrentConfigurationException(nls.getFormattedMessage("CONSUME_FROM_FOREIGN_BUS_ERROR_CWSIP0030", new Object[]{resolvedDestination.getName(), resolvedDestination.getBus(), this._messageProcessor.getMessagingEngineBus()}, null));
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSession", (Object)e);
            }
            throw e;
        }
        this.checkDestinationType(destinationType, destAddr, destination, system);
        if (destination.getDestinationType() == DestinationType.SERVICE) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSession", (Object)"cannot browse a service destination");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("INVALID_DESTINATION_USAGE_ERROR_CWSIP0021", new Object[]{destination.getName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        this.checkTemporary(destination, mqinterop);
        String topicName = null;
        if (criteria != null) {
            topicName = criteria.getDiscriminator();
        }
        this.checkDestinationAuthority(destination, "RECEIVE", topicName);
        ConsumerSessionImpl consumer = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            ConsumerDispatcherState state = new ConsumerDispatcherState(subscriptionName, destination.getUuid(), criteria, nolocal, null, destination.getName(), destination.getBus());
            state.setUser(this.getResolvedUserid(), this.isSIBServerSubject());
            if (null != subscriptionName) {
                state.setIsCloned(true);
            }
            try {
                consumer = new ConsumerSessionImpl(destination, destAddr, state, this, enableReadAhead, forwardScanning, unrecoverableReliability, bifurcatable, ignoreInitialIndoubts, gatherMessages);
            }
            catch (SIDurableSubscriptionNotFoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.internalCreateConsumerSession", (String)"1:1502:1.347.1.25", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSession", (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:1513:1.347.1.25", e});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:1522:1.347.1.25", e}, null), (Throwable)e);
            }
            catch (SIDurableSubscriptionMismatchException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.internalCreateConsumerSession", (String)"1:1534:1.347.1.25", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSession", (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:1545:1.347.1.25", e});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:1554:1.347.1.25", e}, null), (Throwable)e);
            }
            catch (SINonDurableSubscriptionMismatchException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.internalCreateConsumerSession", (String)"1:7704:1.347.1.25", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSession", (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:7715:1.347.1.25", e});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:7724:1.347.1.25", e}, null), (Throwable)e);
            }
            catch (SISessionUnavailableException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.internalCreateConsumerSession", (String)"1:1566:1.347.1.25", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSession", (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:1577:1.347.1.25", e});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:1586:1.347.1.25", e}, null), (Throwable)e);
            }
            List<ConsumerSessionImpl> list = this._consumers;
            synchronized (list) {
                this._consumers.add(consumer);
            }
            this._messageProcessor.addConsumer(consumer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSession", (Object)consumer);
        }
        return consumer;
    }

    public ConsumerSession createSharedConsumerSession(String subscriptionName, SIDestinationAddress destAddr, DestinationType destType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean supportsMultipleConsumers, boolean nolocal, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser, boolean ignoreInitialIndoubts, boolean allowMessageGathering, Map<String, String> messageControlProperties) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SINotPossibleInCurrentConfigurationException, SITemporaryDestinationNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createSharedConsumerSession", (Object)new Object[]{subscriptionName, destAddr, criteria, supportsMultipleConsumers, nolocal, reliability, enableReadAhead, unrecoverableReliability, bifurcatable, alternateUser});
        }
        ConsumerSession session = this.internalCreateConsumerSession(subscriptionName, destAddr, alternateUser, destType, criteria, reliability, enableReadAhead, nolocal, false, false, unrecoverableReliability, bifurcatable, false, ignoreInitialIndoubts, false);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createSharedConsumerSession", (Object)session);
        }
        return session;
    }

    public void createDurableSubscription(String subscriptionName, String durableSubscriptionHome, SIDestinationAddress destinationAddress, SelectionCriteria criteria, boolean supportsMultipleConsumers, boolean nolocal, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException, SIDurableSubscriptionAlreadyExistsException {
        durableSubscriptionHome = this._messageProcessor.getMessagingEngineName();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createDurableSubscription", (Object)new Object[]{this, subscriptionName, durableSubscriptionHome, destinationAddress, alternateUser, criteria, supportsMultipleConsumers, nolocal});
        }
        SelectionCriteria[] selectionCriteriaList = null;
        selectionCriteriaList = new SelectionCriteria[]{criteria};
        this.internalCreateDurableSubscription(subscriptionName, durableSubscriptionHome, destinationAddress, supportsMultipleConsumers, nolocal, alternateUser, selectionCriteriaList, null);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createDurableSubscription");
        }
    }

    public void createDurableSubscription(String subscriptionName, String durableSubscriptionHome, SIDestinationAddress destinationAddress, SelectionCriteria[] criteriaList, boolean supportsMultipleConsumers, boolean nolocal, String alternateUser, Map userData) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException, SIDurableSubscriptionAlreadyExistsException {
        durableSubscriptionHome = this._messageProcessor.getMessagingEngineName();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createDurableSubscription", (Object)new Object[]{this, subscriptionName, durableSubscriptionHome, destinationAddress, alternateUser, criteriaList, supportsMultipleConsumers, nolocal});
        }
        this.internalCreateDurableSubscription(subscriptionName, durableSubscriptionHome, destinationAddress, supportsMultipleConsumers, nolocal, alternateUser, criteriaList, (HashMap)userData);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createDurableSubscription");
        }
    }

    public void internalCreateDurableSubscription(String subscriptionName, String durableSubscriptionHome, SIDestinationAddress destinationAddress, boolean supportsMultipleConsumers, boolean nolocal, String alternateUser, SelectionCriteria[] criteriaList, HashMap userData) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException, SIDurableSubscriptionAlreadyExistsException {
        SelectionCriteria criteria;
        durableSubscriptionHome = this._messageProcessor.getMessagingEngineName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalCreateDurableSubscription", (Object)new Object[]{this, subscriptionName, durableSubscriptionHome, destinationAddress, supportsMultipleConsumers, nolocal, alternateUser, criteriaList, userData});
        }
        SIBUuid8 durableHomeID = this.checkDurableSubscriptionInformation(subscriptionName, durableSubscriptionHome, destinationAddress, supportsMultipleConsumers, nolocal, false, false);
        DestinationHandler destination = null;
        try {
            destination = this._destinationManager.getDestination((JsDestinationAddress)destinationAddress, false);
        }
        catch (SITemporaryDestinationNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalCreateDurableSubscription", (Object)"SINotPossibleInCurrentConfigurationException");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DURABLE_SUBSCRIPTION_USAGE_ERROR_CWSIP0098", new Object[]{subscriptionName, destinationAddress.getDestinationName()}, null));
        }
        if (!destination.isPubSub()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalCreateDurableSubscription", (Object)"Destination not a topicspace");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_USEAGE_ERROR_CWSIP0141", new Object[]{destinationAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName(), subscriptionName}, null));
        }
        if (destination.isTemporary()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalCreateDurableSubscription", (Object)"Destination is Temporary");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DURABLE_SUBSCRIPTION_USAGE_ERROR_CWSIP0098", new Object[]{subscriptionName, destinationAddress.getDestinationName()}, null));
        }
        ConsumerDispatcherState subState = null;
        boolean hasAtLeastOneTopic = false;
        SecurityContext secContext = null;
        if (this._isBusSecure) {
            secContext = new SecurityContext(this._subject, alternateUser, null, this._messageProcessor.getAuthorisationUtils());
        }
        String topicName = null;
        if (criteriaList != null && (criteria = criteriaList[0]) != null) {
            topicName = criteria.getDiscriminator();
        }
        this.checkDestinationAuthority(destination, "RECEIVE", topicName);
        if (criteriaList != null) {
            String failedDiscriminators = null;
            for (int i = 0; i < criteriaList.length; ++i) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("examining  selection criteria " + criteriaList[i]));
                }
                boolean topicIsAllowed = true;
                if (this._isBusSecure) {
                    String discriminator = null;
                    if (criteriaList[i] != null) {
                        discriminator = criteriaList[i].getDiscriminator();
                    }
                    if (discriminator != null) {
                        topicIsAllowed = this.checkConsumerDiscriminatorAccess(destination, discriminator, secContext);
                    }
                    if (!topicIsAllowed) {
                        failedDiscriminators = failedDiscriminators == null ? discriminator : failedDiscriminators + ", " + discriminator;
                    }
                }
                if (topicIsAllowed) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("adding selection criteria " + criteriaList[i]));
                    }
                    if (subState == null) {
                        hasAtLeastOneTopic = true;
                        subState = new ConsumerDispatcherState(subscriptionName, destination.getUuid(), nolocal, durableSubscriptionHome, destination.getName(), destination.getBus(), new SelectionCriteria[]{criteriaList[i]}, userData);
                        continue;
                    }
                    subState.addSelectionCriteria(criteriaList[i]);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)"null selection criteria");
            }
            if (this._isBusSecure && !hasAtLeastOneTopic) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalCreateDurableSubscription", (Object)"SINotAuthorizedException - allowedCritList.isEmpty()");
                }
                throw new SINotAuthorizedException(nls.getFormattedMessage("USER_NOT_AUTH_RECEIVE_ERROR_CWSIP0310", new Object[]{destination.getName(), failedDiscriminators, secContext.getUserName(false)}, null));
            }
        }
        if (destination.isOrdered() && supportsMultipleConsumers) {
            supportsMultipleConsumers = false;
            SibTr.warning((TraceComponent)tc, (String)"CLONED_SUBSCRIBER_OVERRIDE_CWSIP0028", (Object)new Object[]{subscriptionName, destination.getName()});
        }
        subState.setIsCloned(supportsMultipleConsumers);
        if (alternateUser == null) {
            subState.setUser(this.getResolvedUserid(), this.isSIBServerSubject());
        } else {
            subState.setUser(alternateUser, false);
        }
        if (durableHomeID.equals((Object)this._messageProcessor.getMessagingEngineUuid())) {
            destination.createDurableSubscription(subState, null);
        } else {
            DurableInputHandler.createRemoteDurableSubscription(this._messageProcessor, subState, durableHomeID, destination.getUuid());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalCreateDurableSubscription");
        }
    }

    public ConsumerSession createConsumerSessionForDurableSubscription(String subscriptionName, String durableSubscriptionHome, SIDestinationAddress destinationAddress, SelectionCriteria criteria, boolean supportsMultipleConsumers, boolean nolocal, Reliability reliability, boolean enableReadAhead, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SIDurableSubscriptionNotFoundException, SIDurableSubscriptionMismatchException, SIDestinationLockedException, SIIncorrectCallException, SIResourceException, SINotAuthorizedException {
        durableSubscriptionHome = this._messageProcessor.getMessagingEngineName();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createConsumerSessionForDurableSubscription", (Object)new Object[]{this, subscriptionName, durableSubscriptionHome, destinationAddress, criteria, supportsMultipleConsumers, nolocal, reliability, enableReadAhead, unrecoverableReliability, bifurcatable, alternateUser});
        }
        ConsumerSession session = this.internalCreateConsumerSessionForDurableSubscription(subscriptionName, durableSubscriptionHome, destinationAddress, criteria, supportsMultipleConsumers, nolocal, reliability, enableReadAhead, unrecoverableReliability, bifurcatable, alternateUser, false);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createConsumerSessionForDurableSubscription", (Object)session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerSession createConsumerSessionForDurableSubscription(String subscriptionName, boolean enableReadAhead, Reliability unrecoverableReliability, boolean bifurcatable) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SIDurableSubscriptionNotFoundException, SIDurableSubscriptionMismatchException, SIDestinationLockedException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createConsumerSessionForDurableSubscription", (Object)new Object[]{this, subscriptionName, enableReadAhead, unrecoverableReliability, bifurcatable});
        }
        HashMap durableSubs = this._destinationManager.getDurableSubscriptionsTable();
        ConsumerDispatcher cd = null;
        HashMap hashMap = durableSubs;
        synchronized (hashMap) {
            cd = (ConsumerDispatcher)durableSubs.get(subscriptionName);
            if (cd == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createConsumerSessionForDurableSubscription");
                }
                throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0072", new Object[]{subscriptionName, this._messageProcessor.getMessagingEngineName()}, null));
            }
        }
        BaseDestinationHandler destination = cd.getDestination();
        JsDestinationAddress destinationAddress = SIMPUtils.createJsDestinationAddress(destination.getName(), this._messageProcessor.getMessagingEngineUuid());
        ConsumerDispatcherState subState = cd.getConsumerDispatcherState();
        ConsumerSessionImpl consumer = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            try {
                consumer = new ConsumerSessionImpl(destination, (SIDestinationAddress)destinationAddress, subState, this, enableReadAhead, false, unrecoverableReliability, bifurcatable, true, false);
            }
            catch (SINotPossibleInCurrentConfigurationException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createConsumerSessionForDurableSubscription", (Object)"SIErrorException");
                }
                throw new SIErrorException((Throwable)e);
            }
            catch (SISessionUnavailableException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createConsumerSessionForDurableSubscription", (String)"1:2129:1.347.1.25", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:1809:1.285", e});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createConsumerSessionForDurableSubscription", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:2146:1.347.1.25", e}, null), (Throwable)e);
            }
            catch (SITemporaryDestinationNotFoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createConsumerSessionForDurableSubscription", (String)"1:2159:1.347.1.25", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:2165:1.347.1.25", e});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createConsumerSessionForDurableSubscription", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:2176:1.347.1.25", e}, null), (Throwable)e);
            }
            catch (SINonDurableSubscriptionMismatchException e) {
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:1953:1.347.1.25", e});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createConsumerSessionForDurableSubscription", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:1964:1.347.1.25", e}, null), (Throwable)e);
            }
            List<ConsumerSessionImpl> list = this._consumers;
            synchronized (list) {
                this._consumers.add(consumer);
            }
            this._messageProcessor.addConsumer(consumer);
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createConsumerSessionForDurableSubscription", (Object)consumer);
        }
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerSession internalCreateConsumerSessionForDurableSubscription(String subscriptionName, String durableSubscriptionHome, SIDestinationAddress destinationAddress, SelectionCriteria criteria, boolean supportsMultipleConsumers, boolean nolocal, Reliability reliability, boolean enableReadAhead, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser, boolean forwardScanning) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIDurableSubscriptionNotFoundException, SIDurableSubscriptionMismatchException, SIDestinationLockedException, SINotAuthorizedException {
        durableSubscriptionHome = this._messageProcessor.getMessagingEngineName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription", (Object)new Object[]{subscriptionName, durableSubscriptionHome, destinationAddress, alternateUser, criteria, supportsMultipleConsumers, nolocal, reliability, enableReadAhead, unrecoverableReliability});
        }
        SIBUuid8 durableHomeID = this.checkDurableSubscriptionInformation(subscriptionName, durableSubscriptionHome, destinationAddress, supportsMultipleConsumers, nolocal, false, true);
        HashMap durableSubs = this._destinationManager.getDurableSubscriptionsTable();
        ConsumerDispatcher cd = null;
        if (durableHomeID.equals((Object)this._messageProcessor.getMessagingEngineUuid())) {
            HashMap hashMap = durableSubs;
            synchronized (hashMap) {
                cd = (ConsumerDispatcher)durableSubs.get(subscriptionName);
                if (cd == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription");
                    }
                    throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0072", new Object[]{subscriptionName, this._messageProcessor.getMessagingEngineName()}, null));
                }
                if (cd.getConsumerDispatcherState().getTargetDestination() != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription");
                    }
                    throw new SIDurableSubscriptionMismatchException(nls.getFormattedMessage("INTERNAL_SUBSCRIPTION_ACCESS_DISALLOWED_CWSIP0147", new Object[]{subscriptionName, this._messageProcessor.getMessagingEngineName()}, null));
                }
            }
        }
        DestinationHandler destination = null;
        try {
            destination = this._destinationManager.getDestination((JsDestinationAddress)destinationAddress, false);
        }
        catch (SINotPossibleInCurrentConfigurationException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription", (Object)"SIDurableSubscriptionMismatchException");
            }
            throw new SIDurableSubscriptionMismatchException(nls.getFormattedMessage("DURABLE_MISMATCH_ERROR_CWSIP0025", new Object[]{destinationAddress.getDestinationName(), cd.getDestination() == null ? null : cd.getDestination().getName(), subscriptionName, this._messageProcessor.getMessagingEngineName()}, null));
        }
        catch (SITemporaryDestinationNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription", (Object)"SIDurableSubscriptionMismatchException");
            }
            throw new SIDurableSubscriptionMismatchException(nls.getFormattedMessage("DURABLE_MISMATCH_ERROR_CWSIP0025", new Object[]{destinationAddress.getDestinationName(), cd.getDestination() == null ? null : cd.getDestination().getName(), subscriptionName, this._messageProcessor.getMessagingEngineName()}, null));
        }
        if (!destination.isPubSub()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription", (Object)"Destination not a topicspace");
            }
            throw new SIDurableSubscriptionMismatchException(nls.getFormattedMessage("DESTINATION_USEAGE_ERROR_CWSIP0141", new Object[]{destinationAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName(), subscriptionName}, null));
        }
        String topicName = null;
        if (criteria != null) {
            topicName = criteria.getDiscriminator();
        }
        this.checkDestinationAuthority(destination, "RECEIVE", topicName);
        ConsumerDispatcherState subState = new ConsumerDispatcherState(subscriptionName, destination.getUuid(), criteria, nolocal, durableSubscriptionHome, destination.getName(), destination.getBus());
        if (destination.isOrdered() && supportsMultipleConsumers) {
            supportsMultipleConsumers = false;
            SibTr.warning((TraceComponent)tc, (String)"CLONED_SUBSCRIBER_OVERRIDE_CWSIP0028", (Object)new Object[]{subscriptionName, destination.getName()});
        }
        subState.setIsCloned(supportsMultipleConsumers);
        if (alternateUser == null) {
            subState.setUser(this.getResolvedUserid(), this.isSIBServerSubject());
        } else {
            subState.setUser(alternateUser, false);
        }
        ConsumerSessionImpl consumer = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            try {
                consumer = new ConsumerSessionImpl(destination, destinationAddress, subState, this, enableReadAhead, forwardScanning, unrecoverableReliability, bifurcatable, true, false);
            }
            catch (SINotPossibleInCurrentConfigurationException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription", (Object)"SIErrorException");
                }
                throw new SIErrorException((Throwable)e);
            }
            catch (SISessionUnavailableException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.internalCreateConsumerSessionForDurableSubscription", (String)"1:2417:1.347.1.25", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:2423:1.347.1.25", e});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:2434:1.347.1.25", e}, null), (Throwable)e);
            }
            catch (SITemporaryDestinationNotFoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.internalCreateConsumerSessionForDurableSubscription", (String)"1:2446:1.347.1.25", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:2452:1.347.1.25", e});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:2463:1.347.1.25", e}, null), (Throwable)e);
            }
            catch (SINonDurableSubscriptionMismatchException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription", (Object)"SINonDurableSubscriptionMismatchException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:2248:1.347.1.25", e}, null), (Throwable)e);
            }
            List<ConsumerSessionImpl> list = this._consumers;
            synchronized (list) {
                this._consumers.add(consumer);
            }
            this._messageProcessor.addConsumer(consumer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription", (Object)consumer);
        }
        return consumer;
    }

    public ConsumerSession createMQInterOpConsumerSessionForDurableSubscription(String subscriptionName, String durableSubscriptionHome, SIDestinationAddress destinationAddress, SelectionCriteria criteria, boolean supportsMultipleConsumers, boolean nolocal, Reliability reliability, boolean enableReadAhead, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser, boolean forwardScanning) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIDurableSubscriptionNotFoundException, SIDurableSubscriptionMismatchException, SIDestinationLockedException, SINotAuthorizedException {
        durableSubscriptionHome = this._messageProcessor.getMessagingEngineName();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createMQInterOpConsumerSessionForDurableSubscription", (Object)new Object[]{this, subscriptionName, durableSubscriptionHome, destinationAddress, criteria, supportsMultipleConsumers, nolocal, reliability, enableReadAhead, unrecoverableReliability, bifurcatable, alternateUser, forwardScanning});
        }
        ConsumerSession session = this.internalCreateConsumerSessionForDurableSubscription(subscriptionName, durableSubscriptionHome, destinationAddress, criteria, supportsMultipleConsumers, nolocal, reliability, enableReadAhead, unrecoverableReliability, bifurcatable, alternateUser, forwardScanning);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQInterOpConsumerSessionForDurableSubscription", (Object)session);
        }
        return session;
    }

    private SIBUuid8 checkDurableSubscriptionInformation(String subscriptionName, String durableSubscriptionHome, SIDestinationAddress destinationAddress, boolean supportsMultipleConsumers, boolean nolocal, boolean delete, boolean createForDurSub) throws SIIncorrectCallException, SIConnectionUnavailableException {
        durableSubscriptionHome = this._messageProcessor.getMessagingEngineName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDurableSubscriptionInformation", (Object)new Object[]{subscriptionName, destinationAddress, supportsMultipleConsumers, nolocal});
        }
        this.checkNotClosed();
        if (subscriptionName == null) {
            String exText = "CREATE_DURABLE_SUB_CWSIR0042";
            if (createForDurSub) {
                exText = "CREATE_DURABLE_SUB_CWSIR0032";
            } else if (delete) {
                exText = "DELETE_DURABLE_SUB_CWSIR0061";
            }
            SIIncorrectCallException e = new SIIncorrectCallException(nls_cwsir.getFormattedMessage(exText, null, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"checkDurableSubscriptionInformation", (Object)((Object)e));
            }
            throw e;
        }
        if (destinationAddress == null && !delete) {
            String exText = "CREATE_DURABLE_SUB_CWSIR0041";
            if (createForDurSub) {
                exText = "CREATE_DURABLE_SUB_CWSIR0031";
            }
            SIIncorrectCallException e = new SIIncorrectCallException(nls_cwsir.getFormattedMessage(exText, null, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"checkDurableSubscriptionInformation", (Object)((Object)e));
            }
            throw e;
        }
        SIBUuid8 durableHomeID = this._messageProcessor.mapMeNameToUuid(durableSubscriptionHome);
        if (durableHomeID == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkDurableSubscriptionInformation", (Object)"SIMENotFoundException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("REMOTE_ME_MAPPING_ERROR_CWSIP0156", new Object[]{durableSubscriptionHome}, null));
        }
        if (nolocal && supportsMultipleConsumers) {
            SIIncorrectCallException e = new SIIncorrectCallException(nls.getFormattedMessage("INVALID_PARAMETER_COMBINATION_ERROR_CWSIP0100", new Object[]{subscriptionName, destinationAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"checkDurableSubscriptionInformation", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDurableSubscriptionInformation", (Object)durableHomeID);
        }
        return durableHomeID;
    }

    public void deleteDurableSubscription(String subscriptionName, String durableSubscriptionHome) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDurableSubscriptionNotFoundException, SIDestinationLockedException {
        durableSubscriptionHome = this._messageProcessor.getMessagingEngineName();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"deleteDurableSubscription", (Object)new Object[]{this, subscriptionName, durableSubscriptionHome});
        }
        this.deleteDurableSubscription(subscriptionName, durableSubscriptionHome, null);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"deleteDurableSubscription");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDurableSubscription(String subscriptionName, String durableSubscriptionHome, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDurableSubscriptionNotFoundException, SIDestinationLockedException {
        durableSubscriptionHome = this._messageProcessor.getMessagingEngineName();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"deleteDurableSubscription", (Object)new Object[]{this, subscriptionName, durableSubscriptionHome, alternateUser});
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            SIBUuid8 durableHomeID = this.checkDurableSubscriptionInformation(subscriptionName, durableSubscriptionHome, null, false, false, true, false);
            HashMap durableSubs = this._destinationManager.getDurableSubscriptionsTable();
            if (durableHomeID.equals((Object)this._messageProcessor.getMessagingEngineUuid())) {
                HashMap hashMap = durableSubs;
                synchronized (hashMap) {
                    ConsumerDispatcher cd = (ConsumerDispatcher)durableSubs.get(subscriptionName);
                    if (cd == null) {
                        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"deleteDurableSubscription");
                        }
                        throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0072", new Object[]{subscriptionName, this._messageProcessor.getMessagingEngineName()}, null));
                    }
                    BaseDestinationHandler destination = cd.getDestination();
                    if (!destination.isPubSub()) {
                        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"deleteDurableSubscription", (Object)"SIDestinationWrongTypeException");
                        }
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:2759:1.347.1.25"});
                        throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"ConnectionImpl", "1:2765:1.347.1.25"}, null));
                    }
                    AuthUtils sibAuthUtils = this._messageProcessor.getAuthorisationUtils();
                    String topicName = null;
                    String topicSpaceName = null;
                    String theUser = null;
                    if (this._isBusSecure) {
                        ConsumerDispatcherState subState = cd.getConsumerDispatcherState();
                        topicName = subState.getTopic();
                        topicSpaceName = subState.getTopicSpaceName();
                        boolean isPriv = false;
                        if (alternateUser == null) {
                            theUser = this.getResolvedUserid();
                            isPriv = this.isSIBServerSubject();
                        } else {
                            theUser = alternateUser;
                        }
                        boolean userMatch = subState.equalUser(theUser, isPriv);
                        if (!userMatch) {
                            sibAuthUtils.deleteDurSubAuthorizationFailed(theUser, topicName, topicSpaceName, 0L);
                            if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"deleteDurableSubscription", (Object)"SINotAuthorizedException");
                            }
                            throw new SINotAuthorizedException(nls.getFormattedMessage("USER_NOT_AUTH_DELETE_ERROR_CWSIP0311", new Object[]{theUser, subscriptionName, destination.getName()}, null));
                        }
                    }
                    destination.deleteDurableSubscription(subscriptionName, durableSubscriptionHome);
                    if (this._isBusSecure) {
                        sibAuthUtils.deleteDurSubAuthorizationPassed(theUser, topicName, topicSpaceName, 0L);
                    }
                }
            } else {
                DurableInputHandler.deleteRemoteDurableSub(this._messageProcessor, subscriptionName, this.getResolvedUserid(), durableHomeID);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"deleteDurableSubscription");
        }
    }

    private void checkSendNullParameters(SIDestinationAddress destAddr, SIBusMessage msg) throws SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkSendNullParameters", (Object)new Object[]{destAddr, msg});
        }
        if (destAddr == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkSendNullParameters", (Object)"SIIncorrectCallException - null destAddr");
            }
            SIMPIncorrectCallException e = new SIMPIncorrectCallException(nls_cwsir.getFormattedMessage("SEND_CWSIR0111", null, null));
            e.setExceptionReason(900);
            e.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl.checkSendNullParameters", "1:2864:1.347.1.25"});
            throw e;
        }
        if (msg == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkSendNullParameters", (Object)"SIIncorrectCallException - null msg");
            }
            SIMPIncorrectCallException e = new SIMPIncorrectCallException(nls_cwsir.getFormattedMessage("SEND_CWSIR0112", null, null));
            e.setExceptionReason(900);
            e.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl.checkSendNullParameters", "1:2879:1.347.1.25"});
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkSendNullParameters");
        }
    }

    private void internalSend(SIBusMessage msg, SITransaction tran, SIDestinationAddress destAddr, DestinationType destinationType, OrderingContext extendedMessageOrderingContext, String alternateUser, boolean system) throws SIConnectionDroppedException, SIConnectionUnavailableException, SITemporaryDestinationNotFoundException, SIErrorException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalSend", (Object)new Object[]{msg, tran, destAddr, destinationType, alternateUser, extendedMessageOrderingContext, system});
        }
        this.checkNotClosed();
        this.checkSendNullParameters(destAddr, msg);
        if (tran != null && !((TransactionCommon)tran).isAlive()) {
            SIMPIncorrectCallException e = new SIMPIncorrectCallException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_16", new Object[]{destAddr}, null));
            e.setExceptionReason(16);
            e.setExceptionInserts(new String[]{destAddr.toString()});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalSend", (Object)e);
            }
            throw e;
        }
        SecurityContext secContext = null;
        if (this._isBusSecure) {
            secContext = new SecurityContext(this._subject, alternateUser, null, this._messageProcessor.getAuthorisationUtils());
        }
        ProducerSession session = this.internalCreateProducerSession(destAddr, destinationType, system, secContext, false, false, true, true, msg.getDiscriminator());
        try {
            session.send(msg, tran);
            session.close();
        }
        catch (SISessionUnavailableException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            this.checkNotClosed();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalSend", (Object)((Object)e));
            }
            throw new SIConnectionUnavailableException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_22", new Object[]{this._messageProcessor.getMessagingEngineName()}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalSend");
        }
    }

    public void send(SIBusMessage msg, SITransaction tran, SIDestinationAddress destAddr, DestinationType destinationType, OrderingContext extendedMessageOrderingContext, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SITemporaryDestinationNotFoundException, SIErrorException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"send", (Object)new Object[]{this, msg, tran, destAddr, destinationType, extendedMessageOrderingContext, alternateUser});
        }
        this.internalSend(msg, tran, destAddr, destinationType, extendedMessageOrderingContext, alternateUser, false);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"send");
        }
    }

    public SIBusMessage receiveNoWait(SITransaction tran, Reliability unrecoverableReliability, SIDestinationAddress destAddr, DestinationType destinationType, SelectionCriteria criteria, Reliability reliability, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"receiveNoWait", (Object)new Object[]{this, tran, unrecoverableReliability, destAddr, destinationType, criteria, reliability, alternateUser});
        }
        SIBusMessage msg = this.internalReceiveNoWait(tran, unrecoverableReliability, destAddr, destinationType, criteria, reliability, alternateUser, false);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"receiveNoWait", (Object)msg);
        }
        return msg;
    }

    private SIBusMessage internalReceiveNoWait(SITransaction tran, Reliability unrecoverableReliability, SIDestinationAddress destAddr, DestinationType destinationType, SelectionCriteria criteria, Reliability reliability, String alternateUser, boolean system) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalReceiveNoWait", (Object)new Object[]{destAddr, alternateUser, destinationType, criteria, tran, reliability, unrecoverableReliability, system});
        }
        if (destAddr == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalReceiveNoWait", (Object)"SIIncorrectCallException - null destAddr");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("RECEIVE_NO_WAIT_CWSIR0091", null, null));
        }
        SIBusMessage message = null;
        if (tran != null && !((TransactionCommon)tran).isAlive()) {
            SIIncorrectCallException e = new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_RECEIVE_USAGE_ERROR_CWSIP0777", new Object[]{destAddr}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalReceiveNoWait", (Object)((Object)e));
            }
            throw e;
        }
        try {
            ConsumerSession session = this.internalCreateConsumerSession(destAddr, alternateUser, destinationType, criteria, reliability, false, false, false, system, unrecoverableReliability, false, false, true, false);
            session.start(false);
            message = session.receiveNoWait(tran);
            session.close();
        }
        catch (SISessionUnavailableException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            this.checkNotClosed();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalReceiveNoWait", (Object)((Object)e));
            }
            throw new SIMPConnectionUnavailableException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_22", new Object[]{this._messageProcessor.getMessagingEngineName()}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalReceiveNoWait", (Object)message);
        }
        return message;
    }

    private SIBusMessage internalReceiveWithWait(SITransaction tran, Reliability unrecoverableReliability, SIDestinationAddress destAddr, DestinationType destinationType, SelectionCriteria criteria, Reliability reliability, long timeout, String alternateUser, boolean system) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalReceiveWithWait", (Object)new Object[]{tran, unrecoverableReliability, destAddr, destinationType, criteria, reliability, timeout, alternateUser, system});
        }
        if (tran != null && !((TransactionCommon)tran).isAlive()) {
            SIIncorrectCallException e = new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_RECEIVE_USAGE_ERROR_CWSIP0777", new Object[]{destAddr}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalReceiveWithWait", (Object)((Object)e));
            }
            throw e;
        }
        SIBusMessage message = null;
        try {
            ConsumerSession session = this.internalCreateConsumerSession(destAddr, alternateUser, destinationType, criteria, reliability, false, false, false, system, unrecoverableReliability, false, false, true, false);
            session.start(false);
            message = session.receiveWithWait(tran, timeout);
            session.close();
        }
        catch (SISessionUnavailableException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            this.checkNotClosed();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalReceiveWithWait", (Object)((Object)e));
            }
            throw new SIMPConnectionUnavailableException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_22", new Object[]{this._messageProcessor.getMessagingEngineName()}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalReceiveWithWait", (Object)message);
        }
        return message;
    }

    public SIBusMessage receiveWithWait(SITransaction tran, Reliability unrecoverableReliability, SIDestinationAddress destAddr, DestinationType destinationType, SelectionCriteria criteria, Reliability reliability, long timeout, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"receiveWithWait", (Object)new Object[]{this, timeout, destAddr, alternateUser, destinationType, criteria, tran, reliability, unrecoverableReliability});
        }
        if (destAddr == null) {
            if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"receiveWithWait", (Object)"SIIncorrectCallException - null destAddr");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("RECEIVE_WITH_WAIT_CWSIR0101", null, null));
        }
        SIBusMessage message = this.internalReceiveWithWait(tran, unrecoverableReliability, destAddr, destinationType, criteria, reliability, timeout, alternateUser, false);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"receiveWithWait", (Object)message);
        }
        return message;
    }

    private void checkBrowserSessionNullParameters(SIDestinationAddress destinationAddress) throws SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkBrowserSessionNullParameters", (Object)destinationAddress);
        }
        if (destinationAddress == null) {
            SIIncorrectCallException e = new SIIncorrectCallException(nls_cwsir.getFormattedMessage("BROWSE_METHOD_CWSIR0001", null, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkBrowserSessionNullParameters", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkBrowserSessionNullParameters");
        }
    }

    public BrowserSession createBrowserSession(SIDestinationAddress destinationAddress, DestinationType destinationType, SelectionCriteria criteria, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SITemporaryDestinationNotFoundException, SIErrorException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createBrowserSession", (Object)new Object[]{this, destinationAddress, destinationType, criteria});
        }
        this.checkNotClosed();
        this.checkBrowserSessionNullParameters(destinationAddress);
        BrowserSession session = this.createBrowserSession(destinationAddress, destinationType, criteria, false, alternateUser, false);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createBrowserSession", (Object)session);
        }
        return session;
    }

    public BrowserSession createBrowserSession(SIDestinationAddress destinationAddress, DestinationType destinationType, SelectionCriteria criteria, String alternateUser, boolean gatherMessages) throws SIConnectionDroppedException, SIConnectionUnavailableException, SITemporaryDestinationNotFoundException, SIErrorException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createBrowserSession", (Object)new Object[]{this, destinationAddress, destinationType, criteria, alternateUser, gatherMessages});
        }
        this.checkNotClosed();
        this.checkBrowserSessionNullParameters(destinationAddress);
        BrowserSession session = this.createBrowserSession(destinationAddress, destinationType, criteria, false, alternateUser, gatherMessages);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createBrowserSession", (Object)session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BrowserSession createBrowserSession(SIDestinationAddress destinationAddress, DestinationType destinationType, SelectionCriteria criteria, boolean system, String alternateUser, boolean gatherMessages) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SITemporaryDestinationNotFoundException, SIResourceException, SINotPossibleInCurrentConfigurationException, SISelectorSyntaxException, SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createBrowserSession", (Object)new Object[]{destinationAddress, destinationType, criteria, gatherMessages});
        }
        DestinationHandler destination = this._destinationManager.getDestination((JsDestinationAddress)destinationAddress, false);
        this.checkDestinationType(destinationType, destinationAddress, destination, system);
        if (destination.getDestinationType() == DestinationType.SERVICE) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createBrowserSession", (Object)"cannot browse a service destination");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("INVALID_DESTINATION_USAGE_ERROR_CWSIP0022", new Object[]{destination.getName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        this.checkTemporary(destination, false);
        this.checkDestinationAuthority(destination, "BROWSE", null);
        if (destination.isPubSub()) {
            destination = null;
        }
        BrowserSessionImpl browser = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            browser = new BrowserSessionImpl(destination, criteria, this, destinationAddress, gatherMessages);
            List<BrowserSession> list = this._browsers;
            synchronized (list) {
                this._browsers.add(browser);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createBrowserSession", (Object)browser);
        }
        return browser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(SICoreConnectionListener listener) throws SIConnectionUnavailableException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"addConnectionListener", (Object)new Object[]{this, listener});
        }
        this.checkNotClosed();
        List<SICoreConnectionListener> list = this._connectionListeners;
        synchronized (list) {
            this._connectionListeners.add(listener);
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"addConnectionListener");
        }
    }

    MessageProcessor getMessageProcessor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageProcessor");
            SibTr.exit((TraceComponent)tc, (String)"getMessageProcessor", (Object)this._messageProcessor);
        }
        return this._messageProcessor;
    }

    SIBUuid12 getUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUuid");
            SibTr.exit((TraceComponent)tc, (String)"getUuid", (Object)this._uuid);
        }
        return this._uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIDestinationAddress createTemporaryDestination(Distribution distribution, String destinationPrefix) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIInvalidDestinationPrefixException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createTemporaryDestination", (Object)new Object[]{this, destinationPrefix, distribution});
        }
        this.checkNotClosed();
        String result = SICoreUtils.isDestinationPrefixValid((String)destinationPrefix);
        if (!result.equals("VALID")) {
            if (result.equals("MAX_LENGTH_EXCEEDED")) {
                if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createTemporaryDestination", (Object)"SIInvalidDestinationPrefixException");
                }
                throw new SIInvalidDestinationPrefixException(nls.getFormattedMessage("INVALID_DESTINATION_PREFIX_MAX_LENGTH_ERROR_CWSIP0039", null, null));
            }
            if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createTemporaryDestination", (Object)"SIInvalidDestinationPrefixException");
            }
            throw new SIInvalidDestinationPrefixException(nls.getFormattedMessage("INVALID_DESTINATION_PREFIX_CHAR_ERROR_CWSIP0040", new Object[]{destinationPrefix, result}, null));
        }
        SIDestinationAddress address = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkTempDestinationCreation(destinationPrefix == null ? "" : destinationPrefix, distribution);
            List<String> list = this._temporaryDestinations;
            synchronized (list) {
                try {
                    address = this._destinationManager.createTemporaryDestination(distribution, destinationPrefix);
                }
                catch (SIMPDestinationAlreadyExistsException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createTemporaryDestination", (String)"1:3712:1.347.1.25", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:3718:1.347.1.25", e});
                    if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createTemporaryDestination", (Object)"SIErrorException");
                    }
                    throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:3729:1.347.1.25", e}, null), (Throwable)e);
                }
                this._temporaryDestinations.add(address.getDestinationName());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createTemporaryDestination", (Object)address);
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTemporaryDestination(SIDestinationAddress destAddr) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"deleteTemporaryDestination", (Object)new Object[]{this, destAddr});
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            if (destAddr == null) {
                SIIncorrectCallException e = new SIIncorrectCallException(nls_cwsir.getFormattedMessage("CREATE_PRODUCER_CWSIR0071", null, null));
                if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteTemporaryDestination", (Object)((Object)e));
                }
                throw e;
            }
            List<String> list = this._temporaryDestinations;
            synchronized (list) {
                int index = this._temporaryDestinations.indexOf(destAddr.getDestinationName());
                if (index == -1) {
                    if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteTemporaryDestination", (Object)"SITemporaryDestinationNotFoundException");
                    }
                    throw new SIMPTemporaryDestinationNotFoundException(nls.getFormattedMessage("TEMPORARY_DESTINATION_NAME_ERROR_CWSIP0097", new Object[]{destAddr}, null));
                }
                this._destinationManager.deleteTemporaryDestination((JsDestinationAddress)destAddr);
                this._temporaryDestinations.remove(index);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"deleteTemporaryDestination");
        }
    }

    public SIXAResource getSIXAResource() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getSIXAResource", (Object)this);
        }
        this.checkNotClosed();
        this.checkMPStarted();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getSIXAResource");
        }
        return this._txManager.createXAResource(true);
    }

    public SIXAResource getMSSIXAResource() throws SIConnectionDroppedException, SIConnectionUnavailableException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getMSSIXAResource", (Object)this);
        }
        this.checkNotClosed();
        this.checkMPStarted();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getMSSIXAResource");
        }
        return this._txManager.createXAResource(true);
    }

    public SICoreConnection cloneConnection() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"cloneConnection", (Object)this);
        }
        SICoreConnection clone = null;
        this._messageProcessor.getConnectionLockManager().lock();
        try {
            this.checkNotClosed();
            clone = this._messageProcessor.createConnection(this._subject, false, this._connectionProperties);
        }
        finally {
            this._messageProcessor.getConnectionLockManager().unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"cloneConnection", (Object)clone);
        }
        return clone;
    }

    public boolean isEquivalentTo(SICoreConnection rhs) {
        ConnectionImpl conImpl;
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"isEquivalentTo", (Object)new Object[]{this, rhs});
        }
        boolean result = false;
        if (rhs instanceof ConnectionImpl && (conImpl = (ConnectionImpl)rhs).getMessageProcessor() == this.getMessageProcessor()) {
            Boolean subjectResult = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    boolean result;
                    if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{ConnectionImpl.this._subject, conImpl.getSecuritySubject()});
                    }
                    boolean bl = ConnectionImpl.this._subject == null ? conImpl.getSecuritySubject() == null : (result = ConnectionImpl.this._subject.equals(conImpl.getSecuritySubject()));
                    if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"run", (Object)result);
                    }
                    return new Boolean(result);
                }
            });
            result = subjectResult;
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"isEquivalentTo", (Object)result);
        }
        return result;
    }

    public String getMeName() {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getMeName", (Object)this);
        }
        String name = this._messageProcessor.getMessagingEngineName();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getMeName", (Object)name);
        }
        return name;
    }

    public String getMeUuid() {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getMeUuid", (Object)this);
        }
        SIBUuid8 meUUID = new SIBUuid8(this._messageProcessor.getMessagingEngine().getUuid());
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getMeUuid", (Object)meUUID);
        }
        return meUUID.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(SICoreConnectionListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"removeConnectionListener", (Object)new Object[]{this, listener});
        }
        List<SICoreConnectionListener> list = this._connectionListeners;
        synchronized (list) {
            this._connectionListeners.remove(listener);
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"removeConnectionListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SICoreConnectionListener[] getConnectionListeners() throws SIConnectionUnavailableException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getConnectionListeners", (Object)this);
        }
        this.checkNotClosed();
        SICoreConnectionListener[] array = null;
        List<SICoreConnectionListener> list = this._connectionListeners;
        synchronized (list) {
            SICoreConnectionListener[] resultArray = new SICoreConnectionListener[this._connectionListeners.size()];
            array = this._connectionListeners.toArray(resultArray);
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getConnectionListeners", (Object)array);
        }
        return array;
    }

    public String getApiLevelDescription() {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getApiLevelDescription", (Object)this);
        }
        String description = this._messageProcessor.getApiLevelDescription();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getApiLevelDescription", (Object)description);
        }
        return description;
    }

    public long getApiMajorVersion() {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getApiMajorVersion", (Object)this);
        }
        long level = this._messageProcessor.getApiMajorVersion();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getApiMajorVersion", (Object)level);
        }
        return level;
    }

    public long getApiMinorVersion() {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getApiMinorVersion", (Object)this);
        }
        long level = this._messageProcessor.getApiMinorVersion();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getApiMinorVersion", (Object)level);
        }
        return level;
    }

    public void beforeCompletion(TransactionCommon transaction) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(TransactionCommon transaction, boolean committed) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"afterCompletion", (Object)new Object[]{transaction, committed});
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (!this._closed) {
                List<LocalTransaction> list = this._ownedTransactions;
                synchronized (list) {
                    this._ownedTransactions.remove(transaction);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"afterCompletion");
        }
    }

    public byte[] createUniqueId() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createUniqueId", (Object)this);
        }
        this.checkNotClosed();
        SIBUuid12 id = new SIBUuid12();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createUniqueId", (Object)id);
        }
        return id.toByteArray();
    }

    public DestinationConfiguration getDestinationConfiguration(SIDestinationAddress destAddr) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getDestinationConfiguration", (Object)new Object[]{this, destAddr});
        }
        this.checkNotClosed();
        if (destAddr == null) {
            if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getDestinationConfiguration", (Object)"SIIncorrectCallException - null destAddr");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("GET_DEST_CONFIG_CWSIR0081", null, null));
        }
        DestinationConfigurationImpl dc = null;
        DestinationHandler dh = this._destinationManager.getDestination((JsDestinationAddress)destAddr, false);
        if (destAddr.isTemporary()) {
            DestinationType destinationType = DestinationType.QUEUE;
            if (destAddr.getDestinationName().startsWith("_T")) {
                destinationType = DestinationType.TOPICSPACE;
            }
            boolean foreignTempDestination = false;
            String busName = destAddr.getBusName();
            if (busName != null && !busName.equals(this._messageProcessor.getMessagingEngineBus())) {
                foreignTempDestination = true;
            }
            if (this._isBusSecure) {
                SecurityContext secContext = new SecurityContext(this._subject, null, null, this._messageProcessor.getAuthorisationUtils());
                if (!foreignTempDestination) {
                    this.checkInquireAuthority(dh, destAddr.getDestinationName(), null, secContext, true);
                } else {
                    this.checkInquireAuthority(dh, null, busName, secContext, false);
                }
            }
            dc = new DestinationConfigurationImpl(0, Reliability.EXPRESS_NONPERSISTENT, null, null, destinationType, null, 0, Reliability.EXPRESS_NONPERSISTENT, destAddr.getDestinationName(), null, false, true, true, true, null, null, false);
        } else if (dh.isForeignBus()) {
            if (this._isBusSecure) {
                SecurityContext secContext = new SecurityContext(this._subject, null, null, this._messageProcessor.getAuthorisationUtils());
                String busName = dh.getName();
                this.checkInquireAuthority(dh, null, busName, secContext, false);
            }
            dc = new DestinationConfigurationImpl(dh.getDefaultPriority(), dh.getDefaultReliability(), dh.getDescription(), ((BusHandler)dh).getDestinationContext(), dh.getDestinationType(), dh.getExceptionDestination(), dh.getMaxFailedDeliveries(), dh.getMaxReliability(), dh.getName(), dh.getUuid().toString(), dh.isOverrideOfQOSByProducerAllowed(), dh.isReceiveAllowed(), dh.isReceiveExclusive(), dh.isSendAllowed(), dh.getDefaultForwardRoutingPath(), (SIDestinationAddress)dh.getReplyDestination(), dh.isOrdered());
        } else {
            BaseDestinationDefinition baseDefinition = dh.getDefinition();
            if (dh.isAlias()) {
                baseDefinition = ((AliasDestinationHandler)dh).getResolvedDestinationHandler().getDefinition();
            }
            DestinationDefinition definition = (DestinationDefinition)baseDefinition;
            if (this._isBusSecure) {
                SecurityContext secContext = new SecurityContext(this._subject, null, null, this._messageProcessor.getAuthorisationUtils());
                String destinationName = destAddr.getDestinationName();
                this.checkInquireAuthority(dh, destinationName, null, secContext, false);
            }
            dc = new DestinationConfigurationImpl(definition.getDefaultPriority(), definition.getDefaultReliability(), definition.getDescription(), definition.getDestinationContext(), definition.getDestinationType(), definition.getExceptionDestination(), definition.getMaxFailedDeliveries(), definition.getMaxReliability(), definition.getName(), definition.getUUID().toString(), definition.isOverrideOfQOSByProducerAllowed(), definition.isReceiveAllowed(), definition.isReceiveExclusive(), definition.isSendAllowed(), dh.getDefaultForwardRoutingPath(), (SIDestinationAddress)dh.getReplyDestination(), dh.isOrdered());
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getDestinationConfiguration", (Object)dc);
        }
        return dc;
    }

    public BrowserSession createSystemBrowserSession(SIDestinationAddress destAddress, DestinationType destinationType, SelectionCriteria criteria) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIErrorException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSystemBrowserSession", (Object)new Object[]{destAddress, destinationType, criteria});
        }
        this.checkNotClosed();
        this.checkBrowserSessionNullParameters(destAddress);
        if (!destAddress.getDestinationName().startsWith("_P")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemBrowserSession", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("SYSTEM_DESTINATION_USAGE_ERROR_CWSIP0024", new Object[]{destAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        BrowserSession session = null;
        try {
            session = this.createBrowserSession(destAddress, destinationType, criteria, true, null, false);
        }
        catch (SITemporaryDestinationNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createSystemBrowserSession", (String)"1:4363:1.347.1.25", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4369:1.347.1.25", e});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemBrowserSession", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"ConnectionImpl", "1:4380:1.347.1.25", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSystemBrowserSession", (Object)session);
        }
        return session;
    }

    public ConsumerSession createSystemConsumerSession(SIDestinationAddress destAddress, DestinationType destinationType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean nolocal, Reliability unrecoverableReliability, boolean bifurcatable) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSystemConsumerSession", (Object)new Object[]{destAddress, destinationType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable});
        }
        this.checkNotClosed();
        this.checkConsumerSessionNullParameters(destAddress);
        if (!destAddress.getDestinationName().startsWith("_P")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemConsumerSession", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("SYSTEM_DESTINATION_USAGE_ERROR_CWSIP0024", new Object[]{destAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        ConsumerSession session = null;
        try {
            session = this.internalCreateConsumerSession(destAddress, null, destinationType, criteria, reliability, enableReadAhead, nolocal, false, true, unrecoverableReliability, bifurcatable, false, true, false);
        }
        catch (SITemporaryDestinationNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createSystemConsumerSession", (String)"1:4468:1.347.1.25", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4474:1.347.1.25", e});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemConsumerSession", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"ConnectionImpl", "1:4485:1.347.1.25", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSystemConsumerSession", (Object)session);
        }
        return session;
    }

    public ProducerSession createSystemProducerSession(SIDestinationAddress destAddress, String discriminator, DestinationType destFilter, OrderingContext context, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException {
        return this.createSystemProducerSession(destAddress, discriminator, destFilter, context, alternateUser, true);
    }

    public ProducerSession createSystemProducerSession(SIDestinationAddress destAddress, String discriminator, DestinationType destFilter, OrderingContext context, String alternateUser, boolean clearPubSubFingerprints) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSystemProducerSession", (Object)new Object[]{destAddress, discriminator, destFilter, context, alternateUser, clearPubSubFingerprints});
        }
        this.checkNotClosed();
        this.checkProducerSessionNullParameters(destAddress);
        if (!destAddress.getDestinationName().startsWith("_P")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemProducerSession", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("SYSTEM_DESTINATION_USAGE_ERROR_CWSIP0024", new Object[]{destAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        SecurityContext secContext = null;
        if (this._isBusSecure) {
            secContext = new SecurityContext(this._subject, alternateUser, null, this._messageProcessor.getAuthorisationUtils());
        }
        ProducerSession session = null;
        try {
            session = this.internalCreateProducerSession(destAddress, destFilter, true, secContext, false, false, true, clearPubSubFingerprints, null);
        }
        catch (SITemporaryDestinationNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createSystemProducerSession", (String)"1:4590:1.347.1.25", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4596:1.347.1.25", e});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemProducerSession", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"ConnectionImpl", "1:4607:1.347.1.25", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSystemProducerSession", (Object)session);
        }
        return session;
    }

    public SIBusMessage systemReceiveNoWait(SITransaction tran, Reliability unrecoverableReliability, SIDestinationAddress destAddress, DestinationType destinationType, SelectionCriteria criteria, Reliability reliability) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"systemReceiveNoWait", (Object)new Object[]{tran, unrecoverableReliability, destAddress, destinationType, criteria, reliability});
        }
        if (destAddress == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"systemReceiveNoWait", (Object)"SIIncorrectCallException - null destAddr");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("RECEIVE_NO_WAIT_CWSIR0091", null, null));
        }
        if (!destAddress.getDestinationName().startsWith("_P")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"systemReceiveNoWait", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("SYSTEM_DESTINATION_USAGE_ERROR_CWSIP0024", new Object[]{destAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        SIBusMessage msg = null;
        try {
            msg = this.internalReceiveNoWait(tran, unrecoverableReliability, destAddress, destinationType, criteria, reliability, null, true);
        }
        catch (SITemporaryDestinationNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.systemReceiveNoWait", (String)"1:4687:1.347.1.25", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4693:1.347.1.25"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"systemReceiveNoWait", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"ConnectionImpl", "1:4701:1.347.1.25"}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"systemReceiveNoWait", (Object)msg);
        }
        return msg;
    }

    public SIBusMessage systemReceiveWithWait(SITransaction tran, Reliability unrecoverableReliability, SIDestinationAddress destAddress, DestinationType destinationType, SelectionCriteria criteria, Reliability reliability, long timeout) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"systemReceiveWithWait", (Object)new Object[]{tran, unrecoverableReliability, destAddress, destinationType, criteria, reliability, timeout});
        }
        if (destAddress == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"systemReceiveWithWait", (Object)"SIIncorrectCallException - null destAddr");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("RECEIVE_NO_WAIT_CWSIR0091", null, null));
        }
        if (!destAddress.getDestinationName().startsWith("_P")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"systemReceiveWithWait", (Object)"SIDestinationWrongTypeException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("SYSTEM_DESTINATION_USAGE_ERROR_CWSIP0024", new Object[]{destAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        SIBusMessage msg = null;
        try {
            msg = this.internalReceiveWithWait(tran, unrecoverableReliability, destAddress, destinationType, criteria, reliability, timeout, null, true);
        }
        catch (SITemporaryDestinationNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.systemReceiveWithWait", (String)"1:4783:1.347.1.25", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4789:1.347.1.25"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"systemReceiveWithWait", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"ConnectionImpl", "1:4797:1.347.1.25"}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"systemReceiveWithWait", (Object)msg);
        }
        return msg;
    }

    public void systemSend(SIBusMessage msg, SITransaction tran, SIDestinationAddress destAddress, DestinationType destinationType, OrderingContext context, boolean keepSecurityContext) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"systemSend", (Object)new Object[]{msg, tran, destAddress, destinationType, context, keepSecurityContext});
        }
        if (!destAddress.getDestinationName().startsWith("_P")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"systemSend", (Object)"SIDestinationWrongTypeException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("SYSTEM_DESTINATION_USAGE_ERROR_CWSIP0024", new Object[]{destAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        try {
            this.internalSend(msg, tran, destAddress, destinationType, context, null, true);
        }
        catch (SITemporaryDestinationNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.systemSend", (String)"1:4851:1.347.1.25", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4857:1.347.1.25", e});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"systemSend", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"ConnectionImpl", "1:4868:1.347.1.25", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"systemSend");
        }
    }

    public JsDestinationAddress createSystemDestination(String prefix) throws SIResourceException, SIMPDestinationAlreadyExistsException, SIIncorrectCallException {
        boolean valid = ConnectionImpl.isDestinationPrefixValid(prefix);
        if (!valid) {
            throw new SIInvalidDestinationPrefixException(nls.getFormattedMessage("INVALID_DESTINATION_PREFIX_ERROR_CWSIP0023", new Object[]{prefix}, null));
        }
        return this._destinationManager.createSystemDestination(prefix);
    }

    private static final boolean isDestinationPrefixValid(String destinationPrefix) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isDestinationPrefixValid", (Object)destinationPrefix);
        }
        boolean isValid = true;
        if (null != destinationPrefix) {
            int len = destinationPrefix.length();
            if (len > 24) {
                isValid = false;
            } else {
                for (int along = 0; along < len && isValid; ++along) {
                    char c = destinationPrefix.charAt(along);
                    if ('A' <= c && 'Z' >= c || 'a' <= c && 'z' >= c || '0' <= c && '9' >= c || '.' == c || '/' == c || '%' == c) continue;
                    isValid = false;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isDestinationPrefixValid", (Object)isValid);
        }
        return isValid;
    }

    public void deleteSystemDestination(JsDestinationAddress destAddress) throws SINotPossibleInCurrentConfigurationException, SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteSystemDestination", (Object)destAddress);
        }
        this.checkNotClosed();
        if (!destAddress.getDestinationName().startsWith("_P")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestination", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("SYSTEM_DESTINATION_USAGE_ERROR_CWSIP0024", new Object[]{destAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        this._destinationManager.deleteSystemDestination(destAddress);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestination");
        }
    }

    public void deleteSystemDestination(String prefix) throws SINotPossibleInCurrentConfigurationException, SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteSystemDestination", (Object)prefix);
        }
        this.checkNotClosed();
        this._destinationManager.deleteSystemDestination(SIMPUtils.createJsSystemDestinationAddress(prefix, this._messageProcessor.getMessagingEngineUuid()));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestination");
        }
    }

    public void setMessageCopiedWhenSent(boolean copied) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMessageCopiedWhenSent", (Object)copied);
        }
        this._copyMessagesWhenSent = copied;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMessageCopiedWhenSent");
        }
    }

    boolean getMessageCopiedWhenSent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageCopiedWhenSent");
            SibTr.exit((TraceComponent)tc, (String)"getMessageCopiedWhenSent", (Object)this._copyMessagesWhenSent);
        }
        return this._copyMessagesWhenSent;
    }

    public void setMessageCopiedWhenReceived(boolean copied) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMessageCopiedWhenReceived", (Object)copied);
        }
        this._copyMessagesWhenReceived = copied;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMessageCopiedWhenReceived");
        }
    }

    boolean getMessageCopiedWhenReceived() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageCopiedWhenReceived");
            SibTr.exit((TraceComponent)tc, (String)"getMessageCopiedWhenReceived", (Object)this._copyMessagesWhenReceived);
        }
        return this._copyMessagesWhenReceived;
    }

    private void checkConsumerSessionNullParameters(SIDestinationAddress destAddr) throws SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkConsumerSessionNullParameters", (Object)destAddr);
        }
        if (destAddr == null) {
            SIIncorrectCallException e = new SIIncorrectCallException(nls_cwsir.getFormattedMessage("CREATE_CONSUMER_CWSIR0021", null, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkConsumerSessionNullParameters", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkConsumerSessionNullParameters");
        }
    }

    public ConsumerSession createConsumerSession(SIDestinationAddress destAddr, DestinationType destinationType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean nolocal, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createConsumerSession", (Object)new Object[]{this, destAddr, alternateUser, destinationType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable});
        }
        this.checkNotClosed();
        this.checkConsumerSessionNullParameters(destAddr);
        ConsumerSession session = this.internalCreateConsumerSession(destAddr, alternateUser, destinationType, criteria, reliability, enableReadAhead, nolocal, false, false, unrecoverableReliability, bifurcatable, false, true, false);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createConsumerSession", (Object)session);
        }
        return session;
    }

    public ConsumerSession createConsumerSession(SIDestinationAddress destAddr, DestinationType destinationType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean nolocal, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser, boolean ignoreInitialIndoubts) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createConsumerSession", (Object)new Object[]{this, destAddr, alternateUser, destinationType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable, ignoreInitialIndoubts});
        }
        this.checkNotClosed();
        this.checkConsumerSessionNullParameters(destAddr);
        ConsumerSession session = this.internalCreateConsumerSession(destAddr, alternateUser, destinationType, criteria, reliability, enableReadAhead, nolocal, false, false, unrecoverableReliability, bifurcatable, false, ignoreInitialIndoubts, false);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createConsumerSession", (Object)session);
        }
        return session;
    }

    public ConsumerSession createConsumerSession(SIDestinationAddress destAddr, DestinationType destinationType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean nolocal, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser, boolean ignoreInitialIndoubts, boolean gatherMessages, Map<String, String> messageControlProperties) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createConsumerSession", (Object)new Object[]{this, destAddr, alternateUser, destinationType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable, ignoreInitialIndoubts, gatherMessages});
        }
        this.checkNotClosed();
        this.checkConsumerSessionNullParameters(destAddr);
        ConsumerSession session = this.internalCreateConsumerSession(destAddr, alternateUser, destinationType, criteria, reliability, enableReadAhead, nolocal, false, false, unrecoverableReliability, bifurcatable, false, ignoreInitialIndoubts, gatherMessages);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createConsumerSession", (Object)session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerSession createMQLinkConsumerSession(String mqLinkUuidStr, SelectionCriteria criteria, Reliability unrecoverableReliability) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createMQLinkConsumerSession", (Object)new Object[]{mqLinkUuidStr, criteria, unrecoverableReliability});
        }
        MQLinkHandler mqLinkHandler = null;
        boolean forwardScanning = false;
        this.checkNotClosed();
        if (mqLinkUuidStr == null) {
            SIIncorrectCallException e = new SIIncorrectCallException(nls.getFormattedMessage("MISSING_PARAM_ERROR_CWSIP0029", new Object[]{"1:5347:1.347.1.25"}, null));
            if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQLinkConsumerSession", (Object)((Object)e));
            }
            throw e;
        }
        SIBUuid8 mqLinkUuid = new SIBUuid8(mqLinkUuidStr);
        mqLinkHandler = this._destinationManager.getMQLinkLocalization(mqLinkUuid, false);
        if (mqLinkHandler == null) {
            if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQLinkConsumerSession", (Object)"SINotPossibleInCurrentConfigurationException");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("MQLINK_ERROR_CWSIP0026", new Object[]{mqLinkUuid, this._messageProcessor.getMessagingEngineName()}, null));
        }
        ConsumerSessionImpl consumer = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            ConsumerDispatcherState state = new ConsumerDispatcherState(null, mqLinkHandler.getUuid(), criteria, false, "", mqLinkHandler.getName(), mqLinkHandler.getBusName());
            JsDestinationAddress destAddress = DestinationSessionUtils.createJsDestinationAddress(mqLinkHandler);
            try {
                consumer = new ConsumerSessionImpl(mqLinkHandler, (SIDestinationAddress)destAddress, state, this, false, forwardScanning, unrecoverableReliability, false, true, false);
            }
            catch (SIDurableSubscriptionMismatchException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createMQLinkConsumerSession", (String)"1:5424:1.347.1.25", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQLinkConsumerSession", (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:5435:1.347.1.25", e});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:5444:1.347.1.25", e}, null), (Throwable)e);
            }
            catch (SINonDurableSubscriptionMismatchException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createMQLinkConsumerSession", (String)"1:5318:1.347.1.25", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQLinkConsumerSession", (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:5329:1.347.1.25", e});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:5338:1.347.1.25", e}, null), (Throwable)e);
            }
            catch (SIDurableSubscriptionNotFoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createMQLinkConsumerSession", (String)"1:5455:1.347.1.25", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQLinkConsumerSession", (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:5466:1.347.1.25", e});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:5475:1.347.1.25", e}, null), (Throwable)e);
            }
            catch (SISessionUnavailableException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createMQLinkConsumerSession", (String)"1:5486:1.347.1.25", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQLinkConsumerSession", (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:5497:1.347.1.25", e});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:5506:1.347.1.25", e}, null), (Throwable)e);
            }
            catch (SITemporaryDestinationNotFoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createMQLinkConsumerSession", (String)"1:5517:1.347.1.25", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQLinkConsumerSession", (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:5528:1.347.1.25", e});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:5537:1.347.1.25", e}, null), (Throwable)e);
            }
            List<ConsumerSessionImpl> list = this._consumers;
            synchronized (list) {
                this._consumers.add(consumer);
            }
            this._messageProcessor.addConsumer(consumer);
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQLinkConsumerSession", (Object)consumer);
        }
        return consumer;
    }

    public ItemStream getMQLinkPubSubBridgeItemStream(String mqLinkUuidStr) throws SIException {
        MQLinkHandler mqLinkHandler = null;
        MQLinkPubSubBridgeItemStream mqLinkPubSubBridgeItemStream = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQLinkPubSubBridgeItemStream", (Object)mqLinkUuidStr);
        }
        this.checkNotClosed();
        if (mqLinkUuidStr == null) {
            SIIncorrectCallException e = new SIIncorrectCallException(nls.getFormattedMessage("MISSING_PARAM_ERROR_CWSIP0029", new Object[]{"1:5583:1.347.1.25"}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"getMQLinkPubSubBridgeItemStream", (Object)((Object)e));
            }
            throw e;
        }
        SIBUuid8 mqLinkUuid = new SIBUuid8(mqLinkUuidStr);
        mqLinkHandler = this._destinationManager.getMQLinkLocalization(mqLinkUuid, false);
        if (mqLinkHandler == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMQLinkPubSubBridgeItemStream", (Object)"SINotPossibleInCurrentConfigurationException");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("MQLINK_PSB_ERROR_CWSIP0027", new Object[]{mqLinkUuid, this._messageProcessor.getMessagingEngineName()}, null));
        }
        mqLinkPubSubBridgeItemStream = mqLinkHandler.getMqLinkPubSubBridgeItemStream();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMQLinkPubSubBridgeItemStream", (Object)((Object)mqLinkPubSubBridgeItemStream));
        }
        return mqLinkPubSubBridgeItemStream;
    }

    public OrderingContext createOrderingContext() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createOrderingContext", (Object)this);
        }
        this.checkNotClosed();
        OrderingContextImpl context = new OrderingContextImpl();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createOrderingContext", (Object)context);
        }
        return context;
    }

    public String getResolvedUserid() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        String userName;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getResolvedUserid", (Object)this);
            }
            this.checkNotClosed();
            userName = null;
            try {
                if (this._subject != null) {
                    userName = this.runtimeSecurityService.getUniqueUserName(this._subject);
                }
            }
            catch (MessagingSecurityException mse) {
                if (!CoreSPIConnection.tc.isDebugEnabled()) break block5;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)mse));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getResolvedUserid", (Object)userName);
        }
        return userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BifurcatedConsumerSession createBifurcatedConsumerSession(long id) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createBifurcatedConsumerSession", (Object)new Object[]{this, id});
        }
        this.checkNotClosed();
        ConsumerSessionImpl session = this.findConsumerSession(id);
        if (session == null) {
            SISessionUnavailableException e = new SISessionUnavailableException(nls.getFormattedMessage("CREATE_CONSUMER_ERROR_CWSIP0092", new Object[]{id, this._messageProcessor.getMessagingEngineName()}, null));
            if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createBifurcatedConsumerSession", (Object)((Object)e));
            }
            throw e;
        }
        if (!session.isBifurcatable()) {
            SIIncorrectCallException e = new SIIncorrectCallException(nls.getFormattedMessage("CONSUMER_NOT_BIFURCATABLE_CWSIP0680", new Object[]{id}, null));
            if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createBifurcatedConsumerSession", (Object)((Object)e));
            }
            throw e;
        }
        BifurcatedConsumerSessionImpl consumerSession = new BifurcatedConsumerSessionImpl(this, session);
        List<BifurcatedConsumerSessionImpl> list = this._bifurcatedConsumers;
        synchronized (list) {
            this._bifurcatedConsumers.add(consumerSession);
        }
        if (this._isBusSecure) {
            AuthUtils sibAuthUtils = this._messageProcessor.getAuthorisationUtils();
            String destination = consumerSession.getDestinationAddress().getDestinationName();
            sibAuthUtils.createBifurcatedConsumerSessionAuthorizationPassed(this._subject, destination, id);
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createBifurcatedConsumerSession", (Object)consumerSession);
        }
        return consumerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBifurcatedConsumerSession(BifurcatedConsumerSessionImpl bifurcatedConsumer) {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"removeBifurcatedConsumerSession", (Object)new Object[]{this, bifurcatedConsumer});
        }
        List<BifurcatedConsumerSessionImpl> list = this._bifurcatedConsumers;
        synchronized (list) {
            this._bifurcatedConsumers.remove(bifurcatedConsumer);
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"removeBifurcatedConsumerSession");
        }
    }

    private ConsumerSessionImpl findConsumerSession(long id) throws SINotAuthorizedException {
        ConsumerSessionImpl sessionInternal;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findConsumerSession", (Object)id);
        }
        if ((sessionInternal = this._messageProcessor.getConsumer(id)) != null && sessionInternal.getIdInternal() == id && sessionInternal.getConnectionInternal() != this && this._isBusSecure) {
            AuthUtils sibAuthUtils = this._messageProcessor.getAuthorisationUtils();
            String destinationName = sessionInternal.getDestinationAddress().getDestinationName();
            Subject connsSubject = ((ConnectionImpl)sessionInternal.getConnectionInternal()).getSecuritySubject();
            if (connsSubject != null) {
                String resolvedUserid;
                String resolvedConnUserid;
                boolean subjectsDiffer = false;
                if (this._subject == null) {
                    subjectsDiffer = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Subjects differ - base subject is null");
                    }
                }
                if (!subjectsDiffer && this.isSIBServerSubject() && !this._messageProcessor.getAuthorisationUtils().isSIBServerSubject(connsSubject)) {
                    subjectsDiffer = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Subjects differ - base subject is privileged");
                    }
                }
                if (!subjectsDiffer && !(resolvedConnUserid = this._messageProcessor.getAuthorisationUtils().getUserName(connsSubject)).equals(resolvedUserid = this._messageProcessor.getAuthorisationUtils().getUserName(this._subject))) {
                    subjectsDiffer = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Subjects differ by userid - base " + resolvedUserid + ", connected " + resolvedConnUserid));
                    }
                }
                if (subjectsDiffer) {
                    sibAuthUtils.createBifurcatedConsumerSessionAuthorizationFailed(connsSubject, destinationName, id);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"findConsumerSession", (Object)"SINotAuthorizedException - not same");
                    }
                    throw new SINotAuthorizedException(nls.getFormattedMessage("CREATE_BIFURCATED_CONSUMER_ERROR_CWSIP0094", new Object[]{id, this._messageProcessor.getMessagingEngineName()}, null));
                }
            } else if (this._subject != null) {
                sibAuthUtils.createBifurcatedConsumerSessionAuthorizationFailed(connsSubject, destinationName, id);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"findConsumerSession", (Object)"SINotAuthorizedException - null");
                }
                throw new SINotAuthorizedException(nls.getFormattedMessage("CREATE_BIFURCATED_CONSUMER_ERROR_CWSIP0094", new Object[]{id, this._messageProcessor.getMessagingEngineName()}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findConsumerSession", (Object)sessionInternal);
        }
        return sessionInternal;
    }

    final Subject getSecuritySubject() {
        return this._subject;
    }

    @Deprecated
    private void checkProducerAuthority(SIDestinationAddress destAddr, DestinationHandler destination, String destinationName, String busName, SecurityContext secContext, boolean system) throws SIDiscriminatorSyntaxException, SINotAuthorizedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkProducerAuthority", (Object)new Object[]{destAddr, destination, destinationName, busName, secContext, system});
        }
        if (!system || destAddr.getBusName() == null || destAddr.getBusName().equals(this._messageProcessor.getMessagingEngineBus())) {
            if (secContext.isAlternateUserBased() && !destination.checkDestinationAccess(secContext, OperationType.IDENTITY_ADOPTER)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkProducerAuthority", (Object)"not authorized to perform alternate user checks on this destination");
                }
                String userName = secContext.getUserName(true);
                String nlsMessage = nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_18", new Object[]{destinationName, userName}, null);
                this._accessChecker.fireDestinationAccessNotAuthorizedEvent(destinationName, userName, OperationType.IDENTITY_ADOPTER, nlsMessage);
                SIMPNotAuthorizedException e = new SIMPNotAuthorizedException(nlsMessage);
                e.setExceptionReason(18);
                e.setExceptionInserts(new String[]{destinationName, secContext.getUserName(true)});
                throw e;
            }
            if (!destAddr.isTemporary()) {
                if (!destination.checkDestinationAccess(secContext, OperationType.SEND)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"checkProducerAuthority", (Object)"not authorized to produce to this destination");
                    }
                    String userName = secContext.getUserName(false);
                    String nlsMessage = nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_18", new Object[]{destinationName, userName}, null);
                    this._accessChecker.fireDestinationAccessNotAuthorizedEvent(destinationName, userName, OperationType.SEND, nlsMessage);
                    SIMPNotAuthorizedException e = new SIMPNotAuthorizedException(nlsMessage);
                    e.setExceptionReason(18);
                    e.setExceptionInserts(new String[]{destinationName, secContext.getUserName(false)});
                    throw e;
                }
            } else {
                String destinationPrefix = SIMPUtils.parseTempPrefix(destinationName);
                if (!this._accessChecker.checkTemporaryDestinationAccess(secContext, destinationName, destinationPrefix == null ? "" : destinationPrefix, OperationType.SEND)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"checkProducerAuthority", (Object)"not authorized to produce to temporary destination");
                    }
                    String userName = secContext.getUserName(false);
                    String nlsMessage = nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_19", new Object[]{destinationPrefix, userName}, null);
                    this._accessChecker.fireDestinationAccessNotAuthorizedEvent(destinationPrefix, userName, OperationType.SEND, nlsMessage);
                    SIMPNotAuthorizedException e = new SIMPNotAuthorizedException(nlsMessage);
                    e.setExceptionReason(19);
                    e.setExceptionInserts(new String[]{destinationPrefix, secContext.getUserName(false)});
                    throw e;
                }
            }
            if (secContext.testDiscriminatorAtCreate() && !destination.checkDiscriminatorAccess(secContext, OperationType.SEND)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkProducerAuthority", (Object)"not authorized to produce to this destination's discriminator");
                }
                SibTr.audit((TraceComponent)tc, (String)nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_20", new Object[]{destination.getName(), secContext.getDiscriminator(), secContext.getUserName(false)}, null));
                SIMPNotAuthorizedException e = new SIMPNotAuthorizedException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_20", new Object[]{destination.getName(), secContext.getDiscriminator(), secContext.getUserName(false)}, null));
                e.setExceptionReason(20);
                e.setExceptionInserts(new String[]{destination.getName(), secContext.getDiscriminator(), secContext.getUserName(false)});
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkProducerAuthority");
        }
    }

    @Deprecated
    private void checkConsumerAuthority(DestinationHandler destination, String destinationName, String discriminator, SecurityContext secContext, boolean system) throws SIDiscriminatorSyntaxException, SINotAuthorizedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkConsumerAuthority", (Object)new Object[]{destination, destinationName, discriminator, secContext, system});
        }
        if (!destination.isTemporary() && !system) {
            boolean allowed = true;
            boolean failingOpisIdentityAdopter = false;
            if (secContext.isAlternateUserBased() && !destination.checkDestinationAccess(secContext, OperationType.IDENTITY_ADOPTER)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"checkConsumerAuthority", (Object)"not authorized to perform alternate user checks on this destination");
                }
                allowed = false;
                failingOpisIdentityAdopter = true;
            }
            if (allowed) {
                if (destinationName.startsWith("_SYSTEM.Exception.Destination")) {
                    if (!this._messageProcessor.getAccessChecker().checkDestinationAccess(secContext, null, "_SYSTEM.Exception.Destination", OperationType.RECEIVE)) {
                        allowed = false;
                    }
                } else if (!destination.checkDestinationAccess(secContext, OperationType.RECEIVE)) {
                    allowed = false;
                }
            }
            if (!allowed) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkConsumerAuthority", (Object)"not authorized to consume from this destination");
                }
                String userName = secContext.getUserName(failingOpisIdentityAdopter);
                OperationType operationType = failingOpisIdentityAdopter ? OperationType.IDENTITY_ADOPTER : OperationType.RECEIVE;
                String nlsMessage = nls.getFormattedMessage("USER_NOT_AUTH_RECEIVE_ERROR_CWSIP0309", new Object[]{destination.getName(), userName}, null);
                this._accessChecker.fireDestinationAccessNotAuthorizedEvent(destination.getName(), userName, operationType, nlsMessage);
                throw new SINotAuthorizedException(nlsMessage);
            }
        }
        if (discriminator != null && !this._messageProcessor.getMessageProcessorMatching().isWildCarded(discriminator)) {
            secContext.setDiscriminator(discriminator);
            if (!destination.checkDiscriminatorAccess(secContext, OperationType.RECEIVE)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkConsumerAuthority", (Object)"not authorized to consume from this destination's discriminator");
                }
                SibTr.audit((TraceComponent)tc, (String)nls.getFormattedMessage("USER_NOT_AUTH_RECEIVE_ERROR_CWSIP0310", new Object[]{destination.getName(), discriminator, secContext.getUserName(false)}, null));
                throw new SINotAuthorizedException(nls.getFormattedMessage("USER_NOT_AUTH_RECEIVE_ERROR_CWSIP0310", new Object[]{destination.getName(), discriminator, secContext.getUserName(false)}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkConsumerAuthority");
        }
    }

    private void checkDestinationAuthority(DestinationHandler destination, String operationType, String descriminator) throws SINotAuthorizedException {
        SibTr.entry((TraceComponent)tc, (String)"checkDestinationAuthority", (Object)new Object[]{destination, operationType, descriminator});
        DestinationType destinationType = destination.getDestinationType();
        String destinationName = destination.getName();
        try {
            if (destination.isTemporary()) {
                String destinationPrefix = destinationName;
                if (destinationName.startsWith("_Q")) {
                    destinationPrefix = destinationName.substring("_Q".length());
                } else if (destinationName.startsWith("_T")) {
                    destinationPrefix = destinationName.substring("_T".length());
                }
                this._authorization.checkTemporaryDestinationAccess(this._subject, destinationPrefix, operationType);
            } else if (destination.isAlias()) {
                destination = destination.getResolvedDestinationHandler();
                int type = 0;
                if (destinationType == DestinationType.QUEUE) {
                    type = 0;
                } else if (destinationType == DestinationType.TOPICSPACE) {
                    type = 1;
                }
                this._authorization.checkAliasAccess(this._subject, destination.getName(), destinationName, type, operationType);
            } else if (destination.isPubSub()) {
                this._authorization.checkTopicAccess(this._subject, destinationName, descriminator, operationType);
            } else if (destinationType.equals(DestinationType.QUEUE)) {
                this._authorization.checkQueueAccess(this._subject, destinationName, operationType);
            }
        }
        catch (MessagingAuthorizationException mae) {
            throw new SINotAuthorizedException(mae.getMessage());
        }
        SibTr.exit((TraceComponent)tc, (String)"checkDestinationAuthority");
    }

    private void checkTempDestinationCreation(String destinationPrefix, Distribution distribution) throws SINotAuthorizedException {
        SibTr.entry((TraceComponent)tc, (String)"checkTempDestinationCreation", (Object)new Object[]{destinationPrefix, distribution});
        try {
            this._authorization.checkTemporaryDestinationAccess(this._subject, destinationPrefix, "CREATE");
        }
        catch (MessagingAuthorizationException mae) {
            throw new SINotAuthorizedException(mae.getMessage());
        }
        SibTr.exit((TraceComponent)tc, (String)"checkTempDestinationCreation");
    }

    private boolean checkConsumerDiscriminatorAccess(DestinationHandler destination, String discriminator, SecurityContext secContext) throws SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkConsumerDiscriminatorAccess", (Object)new Object[]{destination, discriminator, secContext});
        }
        boolean allowed = true;
        if (discriminator != null && !this._messageProcessor.getMessageProcessorMatching().isWildCarded(discriminator)) {
            secContext.setDiscriminator(discriminator);
            if (!destination.checkDiscriminatorAccess(secContext, OperationType.RECEIVE)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkConsumerDiscriminatorAccess", (Object)"not authorized to consume from this destination's discriminator");
                }
                SibTr.audit((TraceComponent)tc, (String)nls.getFormattedMessage("USER_NOT_AUTH_RECEIVE_ERROR_CWSIP0310", new Object[]{destination.getName(), discriminator, secContext.getUserName(false)}, null));
                allowed = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkConsumerDiscriminatorAccess", (Object)allowed);
        }
        return allowed;
    }

    @Deprecated
    private void checkBrowseAuthority(DestinationHandler destination, String destinationName, SecurityContext secContext, boolean system) throws SINotAuthorizedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkBrowseAuthority", (Object)new Object[]{destination, destinationName, secContext, system});
        }
        if (!destination.isTemporary() && !system) {
            boolean allowed = true;
            boolean failingOpisIdentityAdopter = false;
            if (secContext.isAlternateUserBased() && !destination.checkDestinationAccess(secContext, OperationType.IDENTITY_ADOPTER)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"checkBrowseAuthority", (Object)"not authorized to perform alternate user checks on this destination");
                }
                allowed = false;
                failingOpisIdentityAdopter = true;
            }
            if (allowed) {
                if (destinationName.startsWith("_SYSTEM.Exception.Destination")) {
                    if (!this._messageProcessor.getAccessChecker().checkDestinationAccess(secContext, null, "_SYSTEM.Exception.Destination", OperationType.RECEIVE)) {
                        allowed = false;
                    }
                } else if (!destination.checkDestinationAccess(secContext, OperationType.BROWSE)) {
                    allowed = false;
                }
            }
            if (!allowed) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkBrowseAuthority", (Object)"not authorized to browse this destination");
                }
                String userName = secContext.getUserName(failingOpisIdentityAdopter);
                OperationType operationType = failingOpisIdentityAdopter ? OperationType.IDENTITY_ADOPTER : OperationType.BROWSE;
                String nlsMessage = nls.getFormattedMessage("USER_NOT_AUTH_BROWSE_ERROR_CWSIP0304", new Object[]{destination.getName(), userName}, null);
                this._accessChecker.fireDestinationAccessNotAuthorizedEvent(destination.getName(), userName, operationType, nlsMessage);
                throw new SINotAuthorizedException(nlsMessage);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkBrowseAuthority");
        }
    }

    private void checkInquireAuthority(DestinationHandler destination, String destinationName, String busName, SecurityContext secContext, boolean temporary) throws SINotAuthorizedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkInquireAuthority", (Object)new Object[]{destination, destinationName, busName, secContext, temporary});
        }
        if (!temporary) {
            if (!destination.checkDestinationAccess(secContext, OperationType.INQUIRE)) {
                String nlsMessage;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkInquireAuthority", (Object)"not authorized to inquire on this destination");
                }
                String userName = secContext.getUserName(true);
                if (destinationName != null) {
                    nlsMessage = nls.getFormattedMessage("USER_NOT_AUTH_INQUIRE_ERROR_CWSIP0314", new Object[]{destinationName, userName}, null);
                    this._accessChecker.fireDestinationAccessNotAuthorizedEvent(destinationName, userName, OperationType.INQUIRE, nlsMessage);
                } else {
                    nlsMessage = nls.getFormattedMessage("USER_NOT_AUTH_INQUIRE_FB_ERROR_CWSIP0315", new Object[]{busName, userName}, null);
                    this._accessChecker.fireDestinationAccessNotAuthorizedEvent(busName, userName, OperationType.INQUIRE, nlsMessage);
                }
                throw new SINotAuthorizedException(nlsMessage);
            }
        } else {
            String destinationPrefix = SIMPUtils.parseTempPrefix(destinationName);
            if (!this._accessChecker.checkTemporaryDestinationAccess(secContext, destinationName, destinationPrefix == null ? "" : destinationPrefix, OperationType.INQUIRE)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkInquireAuthority", (Object)"not authorized to inquire on temporary destination");
                }
                String userName = secContext.getUserName(true);
                String nlsMessage = nls.getFormattedMessage("USER_NOT_AUTH_INQUIRE_ERROR_CWSIP0314", new Object[]{destinationPrefix, userName}, null);
                this._accessChecker.fireDestinationAccessNotAuthorizedEvent(destinationPrefix, userName, OperationType.INQUIRE, nlsMessage);
                throw new SINotAuthorizedException(nlsMessage);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkInquireAuthority");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIDestinationAddress[] addDestinationListener(String destinationNamePattern, DestinationListener destinationListener, DestinationType destinationType, DestinationAvailability destinationAvailability) throws SIIncorrectCallException, SICommandInvocationFailedException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addDestinationListener", (Object)new Object[]{destinationNamePattern, destinationListener, destinationType, destinationAvailability});
        }
        if (destinationListener == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addDestinationListener", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("ADD_DEST_LISTENER_ERROR_CWSIP0803", null, null));
        }
        this.checkNotClosed();
        SIDestinationAddress[] destinationAddresses = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            destinationAddresses = this._destinationManager.addDestinationListener(destinationNamePattern, destinationListener, destinationType, destinationAvailability, (SICoreConnection)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addDestinationListener", (Object)new Object[]{destinationAddresses});
        }
        return destinationAddresses;
    }

    public boolean isBusSecure() {
        return this._isBusSecure;
    }

    public void sendToExceptionDestination(SIDestinationAddress address, SIBusMessage message, int reason, String[] inserts, SITransaction tran, String alternateUser) throws SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"sendToExceptionDestination", (Object)new Object[]{this, address, alternateUser, message, reason, inserts, tran});
        }
        if (message == null) {
            if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"sendToExceptionDestination", (Object)"SIIncorrectCallException - null msg");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("SEND_EXCEPTION_DEST_CWSIR0121", null, null));
        }
        ExceptionDestinationHandlerImpl exDestHandler = new ExceptionDestinationHandlerImpl(address, this._messageProcessor);
        exDestHandler.sendToExceptionDestination(message, alternateUser, (TransactionCommon)tran, reason, this, inserts);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"sendToExceptionDestination");
        }
    }

    public void setSetWaitTimeInMessage(boolean setWaitTime) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSetWaitTimeInMessage", (Object)setWaitTime);
        }
        this._setWaitTimeInMessage = setWaitTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setSetWaitTimeInMessage");
        }
    }

    boolean getSetWaitTimeInMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSetWaitTimeInMessage");
            SibTr.exit((TraceComponent)tc, (String)"getSetWaitTimeInMessage", (Object)this._setWaitTimeInMessage);
        }
        return this._setWaitTimeInMessage;
    }

    private boolean isSIBServerSubject() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSIBServerSubject");
        }
        boolean ispriv = false;
        if (this._subject != null) {
            ispriv = this._messageProcessor.getAuthorisationUtils().isSIBServerSubject(this._subject);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSIBServerSubject", (Object)ispriv);
        }
        return ispriv;
    }

    public boolean isMulticastEnabled() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isMulticastEnabled");
        }
        boolean enabled = this._messageProcessor.isMulticastEnabled();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isMulticastEnabled", (Object)enabled);
        }
        return enabled;
    }

    public MulticastProperties getMulticastProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMulticastProperties");
        }
        MulticastPropertiesImpl props = this._messageProcessor.getMulticastProperties();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMulticastProperties", (Object)props);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIDestinationAddress checkMessagingRequired(SIDestinationAddress requestDestAddr, SIDestinationAddress replyDestAddr, DestinationType destinationType, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIErrorException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SIResourceException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkMessagingRequired", (Object)new Object[]{requestDestAddr, replyDestAddr, alternateUser, destinationType});
        }
        boolean destinationIsFastPath = false;
        boolean requestIsFastPath = false;
        boolean replyIsFastPath = true;
        boolean foreignBusFound = false;
        LinkedList<JsDestinationAddress> rrp = new LinkedList<JsDestinationAddress>();
        SIDestinationAddress targetPort = null;
        boolean loopFound = false;
        HashSet<String> duplicateDestinationNames = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            this.checkProducerSessionNullParameters(requestDestAddr);
            SecurityContext secContext = null;
            if (this._isBusSecure) {
                secContext = new SecurityContext(this._subject, alternateUser, null, this._messageProcessor.getAuthorisationUtils());
            }
            String destinationName = requestDestAddr.getDestinationName();
            String busName = requestDestAddr.getBusName();
            if (busName == null || busName.equals(this._messageProcessor.getMessagingEngineBus())) {
                JsDestinationAddress replyDest;
                DestinationHandler destination = null;
                destination = this._destinationManager.getDestination(destinationName, busName, false);
                this.checkDestinationType(destinationType, requestDestAddr, destination, false);
                boolean destinationIsSendAllowed = destination.isSendAllowed();
                if (!destination.isPubSub() && destination.hasLocal() && destinationIsSendAllowed) {
                    PtoPLocalMsgsItemStream ptoPLocalMsgsItemStream = (PtoPLocalMsgsItemStream)destination.getQueuePoint(this._messageProcessor.getMessagingEngineUuid());
                    destinationIsSendAllowed = ptoPLocalMsgsItemStream.isSendAllowed();
                }
                if (this._isBusSecure) {
                    this.checkProducerAuthority(requestDestAddr, destination, destinationName, busName, secContext, false);
                    if (replyDestAddr != null) {
                        String replyDestinationName = replyDestAddr.getDestinationName();
                        String replyBusName = replyDestAddr.getBusName();
                        DestinationHandler replyDestination = this._destinationManager.getDestination(replyDestinationName, replyBusName, false);
                        this.checkDestinationAccess(replyDestination, replyDestinationName, replyBusName, secContext);
                    }
                }
                if ((replyDest = destination.getReplyDestination()) != null && replyDestAddr != null) {
                    rrp.add(replyDest);
                }
                JsDestinationAddress entry = null;
                DestinationHandler frpDestination = destination;
                List<SIDestinationAddress> frp = destination.getForwardRoutingPath();
                if (frp != null) {
                    int frpSize = frp.size();
                    int frpCount = 0;
                    duplicateDestinationNames = new HashSet<String>();
                    duplicateDestinationNames.add(destination.getName());
                    while (!frpDestination.isPubSub() && !foreignBusFound && !loopFound && destinationIsSendAllowed && frpCount < frpSize) {
                        entry = (JsDestinationAddress)frp.get(frpCount);
                        ++frpCount;
                        String frpName = entry.getDestinationName();
                        String frpBusName = entry.getBusName();
                        if (frpBusName == null || frpBusName.equals(this._messageProcessor.getMessagingEngineBus())) {
                            List<SIDestinationAddress> additionalFRP;
                            frpDestination = this._destinationManager.getDestination(frpName, frpBusName, false);
                            if (this._isBusSecure) {
                                this.checkDestinationAccess(frpDestination, frpName, frpBusName, secContext);
                            }
                            if ((replyDest = frpDestination.getReplyDestination()) != null && replyDestAddr != null) {
                                rrp.add(replyDest);
                            }
                            if (frpCount != frpSize || (additionalFRP = frpDestination.getForwardRoutingPath()) == null) continue;
                            if (duplicateDestinationNames.contains(frpDestination.getName())) {
                                loopFound = true;
                                continue;
                            }
                            duplicateDestinationNames.add(frpDestination.getName());
                            frp = additionalFRP;
                            frpSize = frp.size();
                            frpCount = 0;
                            continue;
                        }
                        foreignBusFound = true;
                    }
                }
                if (!foreignBusFound && !loopFound && destinationIsSendAllowed && frpDestination.hasLocal() && frpDestination.getDestinationType() == DestinationType.PORT && !frpDestination.isPubSub()) {
                    requestIsFastPath = true;
                    targetPort = SIDestinationAddressFactory.getInstance().createSIDestinationAddress(frpDestination.getName(), frpDestination.getBus());
                }
                if (requestIsFastPath) {
                    DestinationHandler rrpDestination = null;
                    while (!rrp.isEmpty()) {
                        entry = (JsDestinationAddress)rrp.remove(0);
                        String rrpName = entry.getDestinationName();
                        String rrpBusName = entry.getBusName();
                        if (rrpBusName != null && !rrpBusName.equals(this._messageProcessor.getMessagingEngineBus())) {
                            replyIsFastPath = false;
                            rrp.clear();
                            continue;
                        }
                        rrpDestination = this._destinationManager.getDestination(rrpName, rrpBusName, false);
                        if (!this._isBusSecure) continue;
                        this.checkDestinationAccess(rrpDestination, rrpName, rrpBusName, secContext);
                    }
                    if (replyIsFastPath && replyDestAddr != null) {
                        destinationName = replyDestAddr.getDestinationName();
                        busName = replyDestAddr.getBusName();
                        if (busName != null && !busName.equals(this._messageProcessor.getMessagingEngineBus())) {
                            replyIsFastPath = false;
                        } else {
                            destination = this._destinationManager.getDestination(destinationName, busName, false);
                            boolean replyDestinationHasFRP = false;
                            List<SIDestinationAddress> replyDestinationFRP = destination.getForwardRoutingPath();
                            if (replyDestinationFRP != null && !replyDestinationFRP.isEmpty()) {
                                replyDestinationHasFRP = true;
                            }
                            if (!destination.hasLocal() || replyDestinationHasFRP || !destination.isReceiveAllowed()) {
                                replyIsFastPath = false;
                            }
                        }
                    }
                    if (requestIsFastPath && replyIsFastPath) {
                        destinationIsFastPath = true;
                    }
                }
            }
        }
        if (!destinationIsFastPath) {
            targetPort = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkMessagingRequired", targetPort);
        }
        return targetPort;
    }

    private void checkDestinationAccess(DestinationHandler destination, String destinationName, String busName, SecurityContext secContext) throws SINotAuthorizedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDestinationAccess", (Object)new Object[]{destination, destinationName, busName, secContext});
        }
        if (!destination.checkDestinationAccess(secContext, OperationType.SEND)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess", (Object)"not authorized to produce to this destination");
            }
            SIMPNotAuthorizedException e = new SIMPNotAuthorizedException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_18", new Object[]{destinationName, secContext.getUserName(false)}, null));
            e.setExceptionReason(18);
            e.setExceptionInserts(new String[]{destinationName, secContext.getUserName(false)});
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MPSubscription getSubscription(String subscriptionName) throws SIDurableSubscriptionNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscription", (Object)subscriptionName);
        }
        HashMap durableSubs = this._destinationManager.getDurableSubscriptionsTable();
        ConsumerDispatcher cd = null;
        HashMap hashMap = durableSubs;
        synchronized (hashMap) {
            cd = (ConsumerDispatcher)durableSubs.get(subscriptionName);
            if (cd == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getSubscription", (Object)"Durable sub not found");
                }
                throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0072", new Object[]{subscriptionName, this._messageProcessor.getMessagingEngineName()}, null));
            }
        }
        MPSubscription mpSubscription = cd.getMPSubscription();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscription", (Object)mpSubscription);
        }
        return mpSubscription;
    }

    public void registerCommandHandler(String key, CommandHandler handler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerCommandHandler", (Object)new Object[]{key, handler});
        }
        this._messageProcessor.registerCommandHandler(key, handler);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerCommandHandler");
        }
    }

    public Serializable invokeCommand(String key, String commandName, Serializable commandData, SITransaction transaction) throws SIIncorrectCallException, SINotAuthorizedException, SICommandInvocationFailedException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"invokeCommand", (Object)new Object[]{key, commandName, commandData, transaction});
        }
        Serializable returnData = this.internalInvokeCommand(key, commandName, commandData, true, transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"invokeCommand", (Object)returnData);
        }
        return returnData;
    }

    private Serializable internalInvokeCommand(String key, String commandName, Serializable commandData, boolean isTransactionalInvoke, SITransaction transaction) throws SIIncorrectCallException, SINotAuthorizedException, SICommandInvocationFailedException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalInvokeCommand", (Object)new Object[]{key, commandName, commandData, isTransactionalInvoke, transaction});
        }
        if (key == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalInvokeCommand", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("INVOKE_COMMAND_ERROR_CWSIP0802", new Object[]{"key"}, null));
        }
        if (commandName == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalInvokeCommand", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("INVOKE_COMMAND_ERROR_CWSIP0802", new Object[]{"commandName"}, null));
        }
        if (!isTransactionalInvoke && transaction != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalInvokeCommand", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"1:7172:1.347.1.25"}, null));
        }
        this.checkNotClosed();
        if (this._isBusSecure && !this.isSIBServerSubject()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalInvokeCommand", (Object)"SINotAuthorizedException");
            }
            throw new SINotAuthorizedException(nls.getFormattedMessage("USER_NOT_AUTH_INVOKE_ERROR_CWSIP0316", new Object[]{this._subject}, null));
        }
        Serializable returnValue = null;
        CommandHandler tempCmdHandler = this._messageProcessor.getRegisteredCommandHandler(key);
        if (isTransactionalInvoke || tempCmdHandler instanceof TransactionalCommandHandler) {
            if (tempCmdHandler == null || !(tempCmdHandler instanceof TransactionalCommandHandler)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalInvokeCommand", (Object)"SICommandInvocationFailedException");
                }
                throw new SICommandInvocationFailedException(nls.getFormattedMessage("INVOKE_COMMAND_ERROR_CWSIP0801", new Object[]{key}, null));
            }
            TransactionalCommandHandler cHandler = (TransactionalCommandHandler)tempCmdHandler;
            try {
                returnValue = cHandler.invoke(commandName, commandData, transaction);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.internalInvokeCommand", (String)"1:7226:1.347.1.25", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalInvokeCommand", (Object)e);
                }
                throw new SICommandInvocationFailedException(nls.getFormattedMessage("INVOKE_COMMAND_ERROR_CWSIR0150", new Object[]{e}, null), (Throwable)e);
            }
        }
        CommandHandler cHandler = this._messageProcessor.getRegisteredCommandHandler(key);
        if (cHandler == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalInvokeCommand", (Object)"SICommandInvocationFailedException");
            }
            throw new SICommandInvocationFailedException(nls.getFormattedMessage("INVOKE_COMMAND_ERROR_CWSIR0151", new Object[]{key}, null));
        }
        try {
            returnValue = cHandler.invoke(commandName, commandData);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.internalInvokeCommand", (String)"1:7267:1.347.1.25", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalInvokeCommand", (Object)e);
            }
            throw new SICommandInvocationFailedException(nls.getFormattedMessage("INVOKE_COMMAND_ERROR_CWSIR0150", new Object[]{e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalInvokeCommand", (Object)returnValue);
        }
        return returnValue;
    }

    public Serializable invokeCommand(String key, String commandName, Serializable commandData) throws SIIncorrectCallException, SINotAuthorizedException, SICommandInvocationFailedException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"invokeCommand", (Object)new Object[]{key, commandName, commandData});
        }
        Serializable returnData = this.internalInvokeCommand(key, commandName, commandData, false, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"invokeCommand", (Object)returnData);
        }
        return returnData;
    }

    public boolean registerConsumerSetMonitor(SIDestinationAddress destinationAddress, String discriminatorExpression, ConsumerSetChangeCallback callback) throws SIResourceException, SINotPossibleInCurrentConfigurationException, SIConnectionUnavailableException, SIConnectionDroppedException, SIIncorrectCallException, SICommandInvocationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerConsumerSetMonitor", (Object)new Object[]{destinationAddress, discriminatorExpression, callback});
        }
        if (callback == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"registerConsumerSetMonitor", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("NULL_CONSUMERSETCHANGECALLBACK_CWSIP0667", null, null));
        }
        if (destinationAddress == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"registerConsumerSetMonitor", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("NULL_DESTINATIONADDRESS_CWSIP0668", null, null));
        }
        if (discriminatorExpression == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"registerConsumerSetMonitor", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("NULL_DISCRIMINATOREXPRESSION_CWSIP0669", null, null));
        }
        boolean areConsumers = false;
        try {
            DestinationHandler topicSpace = this._destinationManager.getDestination((JsDestinationAddress)destinationAddress, false);
            areConsumers = this._messageProcessor.getMessageProcessorMatching().registerConsumerSetMonitor(topicSpace, discriminatorExpression, this, callback);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.registerConsumerSetMonitor", (String)"1:7378:1.347.1.25", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"registerConsumerSetMonitor", (Object)"SIErrorException");
            }
            throw new SIErrorException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerConsumerSetMonitor", (Object)areConsumers);
        }
        return areConsumers;
    }

    public void deregisterConsumerSetMonitor(ConsumerSetChangeCallback callback) throws SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterConsumerSetMonitor", (Object)new Object[]{callback});
        }
        this._messageProcessor.getMessageProcessorMatching().deregisterConsumerSetMonitor(this, callback);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterConsumerSetMonitor");
        }
    }

    public Map getConnectionProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnectionProperties");
            SibTr.exit((TraceComponent)tc, (String)"getConnectionProperties", (Object)this._connectionProperties);
        }
        return this._connectionProperties;
    }

    public void setConnectionProperties(Map connectionProperties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnectionProperties", (Object)connectionProperties);
            SibTr.exit((TraceComponent)tc, (String)"getConnectionProperties");
        }
        this._connectionProperties = connectionProperties;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(int connectionType) {
        this.connectionType = connectionType;
    }

    public boolean isConnectionClosed() {
        return this._closed;
    }
}

