/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.impl;

import com.ibm.ws.sib.matchspace.EvalCache;
import com.ibm.ws.sib.matchspace.utils.Trace;
import com.ibm.ws.sib.matchspace.utils.TraceUtils;

public class EvalCacheImpl
implements EvalCache {
    private static final Class cclass = EvalCacheImpl.class;
    private static Trace tc = TraceUtils.getTrace(EvalCacheImpl.class, (String)"SIBMatchSpace");
    int generation = 1;
    int[] cacheTag;
    Object[] cacheValue;

    public void prepareCache(int size) {
        int oldSize;
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "prepareCache", (Object)("size: " + size));
        }
        int n = oldSize = this.cacheTag == null ? 0 : this.cacheTag.length;
        if (size <= oldSize) {
            if (this.generation == Integer.MAX_VALUE) {
                this.generation = 1;
                for (int i = 0; i < size; ++i) {
                    this.cacheTag[i] = 0;
                }
            } else {
                ++this.generation;
            }
            if (tc.isEntryEnabled()) {
                tc.exit((Object)this, cclass, "prepareCache");
            }
            return;
        }
        this.cacheTag = new int[2 * size];
        this.cacheValue = new Object[2 * size];
        this.generation = 1;
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "prepareCache");
        }
    }

    public Object getExprValue(int id) {
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "getExprValue", (Object)("id: " + new Integer(id)));
        }
        Object result = null;
        if (this.cacheTag[id] == this.generation) {
            result = this.cacheValue[id];
        }
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "getExprValue", (Object)("result: " + result));
        }
        return result;
    }

    public void saveExprValue(int id, Object value) {
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "saveExprValue", (Object)("id: " + new Integer(id) + ",value: " + value));
        }
        this.cacheTag[id] = this.generation;
        this.cacheValue[id] = value;
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "saveExprValue");
        }
    }
}

