/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.client.security.oauth;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.client.security.oauth.OAuthPropagationHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Arrays;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertyJaxRsClientOAuthInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent tc = Tr.register(LibertyJaxRsClientOAuthInterceptor.class, (String)"com.ibm.ws.jaxrs20.client", (String)"com.ibm.ws.jaxrs20.client.internal.resources.JAXRSClientMessages");
    private static final String AUTHN_TOKEN = "authnToken";
    private static final String WEB_TARGET = "webTarget";
    static final long serialVersionUID = -752029308449552423L;

    public LibertyJaxRsClientOAuthInterceptor() {
        super("pre-logical");
    }

    public void handleMessage(Message message) throws Fault {
        Object handleOauth = message.get((Object)"com.ibm.ws.jaxrs.client.oauth.sendToken");
        Object handleJwt = message.get((Object)"com.ibm.ws.jaxrs.client.oidc.sendJwtToken");
        Object handleMpJwt = message.get((Object)"com.ibm.ws.jaxrs.client.mpjwt.sendToken");
        if (handleMpJwt != null && "true".equals(handleMpJwt.toString().toLowerCase())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The client configuration com.ibm.ws.jaxrs.client.mpjwt.sendToken property is set to true ", (Object[])new Object[0]);
            }
            this.handleMpJwtToken(message);
        } else if (handleOauth != null || handleJwt != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The client configuration property com.ibm.ws.jaxrs.client.oauth.sendToken value is " + handleOauth), (Object[])new Object[0]);
            }
            String handler = handleOauth != null ? handleOauth.toString().toLowerCase() : "false";
            String jwtHandler = handleJwt != null ? handleJwt.toString().toLowerCase() : "false";
            this.handleOAuthTokens(message, handler, jwtHandler);
        }
    }

    private void handleMpJwtToken(Message message) {
        String mpJwt = OAuthPropagationHelper.getMpJsonWebToken();
        if (mpJwt != null && !mpJwt.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got MpJwt token from the subject. Set it on the request" + mpJwt), (Object[])new Object[0]);
            }
            this.addAuthnHeader(mpJwt, message);
        } else {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"warn_missing_mpjwt_token", (Object[])new Object[]{AUTHN_TOKEN, WEB_TARGET, "mpjwt"});
            Tr.warning((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleOAuthTokens(Message message, String handleOauth, String jwtHandler) {
        boolean bOauth = handleOauth.equals("true");
        boolean bJwt = jwtHandler.equals("true");
        if (bOauth || bJwt) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(bOauth ? "About to get a OAuth access token" : "About to get a jwt token"), (Object[])new Object[0]);
            }
            try {
                String accessToken;
                String string = accessToken = bOauth ? OAuthPropagationHelper.getAccessToken() : OAuthPropagationHelper.getJwtToken();
                if (accessToken != null && !accessToken.isEmpty()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Retrieved an OAuth access/jwt token. About to set a request cookie: " + accessToken), (Object[])new Object[0]);
                    }
                    this.addAuthnHeader(accessToken, message);
                    return;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
                Tr.debug((TraceComponent)tc, (String)"Cannot find an OAuth access token out of the WSSubject", (Object[])new Object[0]);
                return;
            }
            catch (Exception accessToken) {
                void e;
                FFDCFilter.processException((Throwable)accessToken, (String)"com.ibm.ws.jaxrs20.client.security.oauth.LibertyJaxRsClientOAuthInterceptor", (String)"116", (Object)((Object)this), (Object[])new Object[]{message, handleOauth, jwtHandler});
                throw new ProcessingException((Throwable)e);
            }
        } else {
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)"No client OAuth handler configuration, skip", (Object[])new Object[0]);
        }
    }

    private void addAuthnHeader(String token, Message message) {
        Map headers = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
        headers.put("Authorization", Arrays.asList("Bearer " + token));
        message.put((Object)Message.PROTOCOL_HEADERS, (Object)headers);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Authorization header with Bearer token is added successfully!!!", (Object[])new Object[0]);
        }
    }
}

