/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.faulttolerance.telemetry.metrics.integration;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorderProvider;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryResultCategory;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongCounter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import java.util.List;
import java.util.function.LongSupplier;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MetricRecorderImpl
implements MetricRecorder {
    private static final TraceComponent tc = Tr.register(MetricRecorderImpl.class, (String[])new String[]{"FAULTTOLERANCE", "TELEMETRY"}, (String)"io.openliberty.microprofile.faulttolerance.telemetry.metrics.integration.resources.TelemetryMetrics", (String)"io.openliberty.microprofile.faulttolerance.telemetry.metrics.integration.MetricRecorderImpl");
    private static final AttributeKey<String> BULKHEAD_RESULT = AttributeKey.stringKey((String)"bulkheadResult");
    private static final AttributeKey<String> CIRCUIT_BREAKER_RESULT = AttributeKey.stringKey((String)"circuitBreakerResult");
    private static final AttributeKey<String> FALLBACK = AttributeKey.stringKey((String)"fallback");
    private static final AttributeKey<String> RESULT = AttributeKey.stringKey((String)"result");
    private static final AttributeKey<String> RETRIED = AttributeKey.stringKey((String)"retried");
    private static final AttributeKey<String> RETRY_RESULT = AttributeKey.stringKey((String)"retryResult");
    private static final AttributeKey<String> STATE = AttributeKey.stringKey((String)"state");
    private static final AttributeKey<String> TIMED_OUT = AttributeKey.stringKey((String)"timedOut");
    private static final AttributeKey<String> METHOD = AttributeKey.stringKey((String)"method");
    private static final List<Double> HISTOGRAM_BUCKETS = List.of(0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0);
    private final Attributes methodAttribute;
    private final LongCounter ftInvocationsTotal;
    private final boolean fallbackDefined;
    private final LongCounter ftRetryCallsTotal;
    private final LongCounter ftRetryRetriesTotal;
    private final LongCounter ftTimeoutCallsTotal;
    private final DoubleHistogram ftTimeoutExecutionDuration;
    private final LongCounter ftCircuitbreakerCallsTotal;
    private final ObservableLongCounter ftCircuitbreakerStateTotal;
    private final LongCounter ftCircuitbreakerOpenedTotal;
    private long openNanos;
    private long halfOpenNanos;
    private long closedNanos;
    private CircuitBreakerState circuitBreakerState = CircuitBreakerState.CLOSED;
    protected long lastCircuitBreakerTransitionTime;
    private final LongCounter ftBulkheadCallsTotal;
    private final ObservableLongUpDownCounter ftBulkheadExecutionsRunning;
    private final ObservableLongUpDownCounter ftBulkheadExecutionsWaiting;
    private final DoubleHistogram ftBulkheadRunningDuration;
    private final DoubleHistogram ftBulkheadWaitingDuration;
    private LongSupplier queuePopulationSupplier = null;
    private LongSupplier concurrentExecutionCountSupplier = null;
    static final long serialVersionUID = -762018727889492942L;

    public MetricRecorderImpl(String classAndMethod, Meter meter, RetryPolicy retryPolicy, CircuitBreakerPolicy circuitBreakerPolicy, TimeoutPolicy timeoutPolicy, BulkheadPolicy bulkheadPolicy, FallbackPolicy fallbackPolicy, MetricRecorderProvider.AsyncType isAsync) {
        this.methodAttribute = Attributes.builder().put(METHOD, (Object)classAndMethod).build();
        if (retryPolicy != null || timeoutPolicy != null || circuitBreakerPolicy != null || bulkheadPolicy != null || fallbackPolicy != null) {
            this.ftInvocationsTotal = meter.counterBuilder("ft.invocations.total").setDescription(Tr.formatMessage((TraceComponent)tc, (String)"ft.invocations.total.description", (Object[])new Object[0])).build();
            this.fallbackDefined = fallbackPolicy != null;
        } else {
            this.ftInvocationsTotal = null;
            this.fallbackDefined = false;
        }
        if (retryPolicy != null) {
            this.ftRetryCallsTotal = meter.counterBuilder("ft.retry.calls.total").setDescription(Tr.formatMessage((TraceComponent)tc, (String)"ft.retry.calls.total.description", (Object[])new Object[0])).build();
            this.ftRetryRetriesTotal = meter.counterBuilder("ft.retry.retries.total").setDescription(Tr.formatMessage((TraceComponent)tc, (String)"ft.retry.retries.total.description", (Object[])new Object[0])).build();
        } else {
            this.ftRetryCallsTotal = null;
            this.ftRetryRetriesTotal = null;
        }
        if (timeoutPolicy != null) {
            this.ftTimeoutCallsTotal = meter.counterBuilder("ft.timeout.calls.total").setDescription(Tr.formatMessage((TraceComponent)tc, (String)"ft.timeout.calls.total.description", (Object[])new Object[0])).build();
            this.ftTimeoutExecutionDuration = meter.histogramBuilder("ft.timeout.executionDuration").setDescription(Tr.formatMessage((TraceComponent)tc, (String)"ft.timeout.executionDuration.description", (Object[])new Object[0])).setUnit("seconds").setExplicitBucketBoundariesAdvice(HISTOGRAM_BUCKETS).build();
        } else {
            this.ftTimeoutCallsTotal = null;
            this.ftTimeoutExecutionDuration = null;
        }
        if (circuitBreakerPolicy != null) {
            this.ftCircuitbreakerCallsTotal = meter.counterBuilder("ft.circuitbreaker.calls.total").setDescription(Tr.formatMessage((TraceComponent)tc, (String)"ft.circuitbreaker.calls.total.description", (Object[])new Object[0])).build();
            this.ftCircuitbreakerStateTotal = meter.counterBuilder("ft.circuitbreaker.state.total").setUnit("nanoseconds").setDescription(Tr.formatMessage((TraceComponent)tc, (String)"ft.circuitbreaker.state.total.description", (Object[])new Object[0])).buildWithCallback(this::getCircuitBreakerAccumulatedTimes);
            this.ftCircuitbreakerOpenedTotal = meter.counterBuilder("ft.circuitbreaker.opened.total").setDescription(Tr.formatMessage((TraceComponent)tc, (String)"ft.circuitbreaker.opened.total.description", (Object[])new Object[0])).build();
        } else {
            this.ftCircuitbreakerCallsTotal = null;
            this.ftCircuitbreakerStateTotal = null;
            this.ftCircuitbreakerOpenedTotal = null;
        }
        if (bulkheadPolicy != null) {
            this.ftBulkheadCallsTotal = meter.counterBuilder("ft.bulkhead.calls.total").setDescription(Tr.formatMessage((TraceComponent)tc, (String)"ft.bulkhead.calls.total.description", (Object[])new Object[0])).build();
            this.ftBulkheadExecutionsRunning = meter.upDownCounterBuilder("ft.bulkhead.executionsRunning").setDescription(Tr.formatMessage((TraceComponent)tc, (String)"ft.bulkhead.executionsRunning.description", (Object[])new Object[0])).buildWithCallback(this::getConcurrentExecutions);
            this.ftBulkheadRunningDuration = meter.histogramBuilder("ft.bulkhead.runningDuration").setDescription(Tr.formatMessage((TraceComponent)tc, (String)"ft.bulkhead.runningDuration.description", (Object[])new Object[0])).setUnit("seconds").setExplicitBucketBoundariesAdvice(HISTOGRAM_BUCKETS).build();
            if (isAsync == MetricRecorderProvider.AsyncType.ASYNC) {
                this.ftBulkheadExecutionsWaiting = meter.upDownCounterBuilder("ft.bulkhead.executionsWaiting").setDescription(Tr.formatMessage((TraceComponent)tc, (String)"ft.bulkhead.executionsWaiting.description", (Object[])new Object[0])).buildWithCallback(this::getQueuePopulation);
                this.ftBulkheadWaitingDuration = meter.histogramBuilder("ft.bulkhead.waitingDuration").setDescription(Tr.formatMessage((TraceComponent)tc, (String)"ft.bulkhead.waitingDuration.description", (Object[])new Object[0])).setUnit("seconds").setExplicitBucketBoundariesAdvice(HISTOGRAM_BUCKETS).build();
            } else {
                this.ftBulkheadExecutionsWaiting = null;
                this.ftBulkheadWaitingDuration = null;
            }
        } else {
            this.ftBulkheadCallsTotal = null;
            this.ftBulkheadExecutionsRunning = null;
            this.ftBulkheadExecutionsWaiting = null;
            this.ftBulkheadRunningDuration = null;
            this.ftBulkheadWaitingDuration = null;
        }
    }

    @Trivial
    public void incrementInvocationSuccessCount(MetricRecorder.FallbackOccurred fallbackOccurred) {
        this.incrementFtTotalCount(fallbackOccurred, true);
    }

    @Trivial
    public void incrementInvocationFailedCount(MetricRecorder.FallbackOccurred fallbackOccurred) {
        this.incrementFtTotalCount(fallbackOccurred, false);
    }

    @Trivial
    private void incrementFtTotalCount(MetricRecorder.FallbackOccurred fallbackOccurred, boolean invocationSucceeded) {
        AttributesBuilder ab = Attributes.builder().putAll(this.methodAttribute);
        if (!this.fallbackDefined) {
            ab.put(FALLBACK, (Object)"notDefined");
        } else if (fallbackOccurred == MetricRecorder.FallbackOccurred.WITH_FALLBACK) {
            ab.put(FALLBACK, (Object)"applied");
        } else {
            ab.put(FALLBACK, (Object)"notApplied");
        }
        if (invocationSucceeded) {
            ab.put(RESULT, (Object)"valueReturned");
        } else {
            ab.put(RESULT, (Object)"exceptionThrown");
        }
        if (this.ftInvocationsTotal != null) {
            this.ftInvocationsTotal.add(1L, ab.build());
        }
    }

    @Trivial
    public void incrementRetryCalls(RetryResultCategory resultCategory, MetricRecorder.RetriesOccurred retriesOccurred) {
        if (this.ftRetryCallsTotal != null) {
            AttributesBuilder ab = Attributes.builder().putAll(this.methodAttribute);
            if (retriesOccurred == MetricRecorder.RetriesOccurred.WITH_RETRIES) {
                ab.put(RETRIED, (Object)"true");
            } else {
                ab.put(RETRIED, (Object)"false");
            }
            switch (resultCategory) {
                case NO_EXCEPTION: {
                    ab.put(RETRY_RESULT, (Object)"valueReturned");
                    break;
                }
                case EXCEPTION_NOT_IN_RETRY_ON: {
                    ab.put(RETRY_RESULT, (Object)"exceptionNotRetryable");
                    break;
                }
                case EXCEPTION_IN_RETRY_ON: {
                    break;
                }
                case EXCEPTION_IN_ABORT_ON: {
                    ab.put(RETRY_RESULT, (Object)"exceptionNotRetryable");
                    break;
                }
                case MAX_RETRIES_REACHED: {
                    ab.put(RETRY_RESULT, (Object)"maxRetriesReached");
                    break;
                }
                case MAX_DURATION_REACHED: {
                    ab.put(RETRY_RESULT, (Object)"maxDurationReached");
                    break;
                }
            }
            this.ftRetryCallsTotal.add(1L, ab.build());
        }
    }

    @Trivial
    public void incrementRetriesCount() {
        if (this.ftRetryRetriesTotal != null) {
            this.ftRetryRetriesTotal.add(1L, this.methodAttribute);
        }
    }

    @Trivial
    public void recordTimeoutExecutionTime(long executionNanos) {
        if (this.ftTimeoutExecutionDuration != null) {
            double seconds = (double)executionNanos / 1.0E9;
            this.ftTimeoutExecutionDuration.record(seconds, this.methodAttribute);
        }
    }

    @Trivial
    public void incrementTimeoutTrueCount() {
        if (this.ftTimeoutCallsTotal != null) {
            this.ftTimeoutCallsTotal.add(1L, Attributes.builder().putAll(this.methodAttribute).put(TIMED_OUT, (Object)"true").build());
        }
    }

    @Trivial
    public void incrementTimeoutFalseCount() {
        if (this.ftTimeoutCallsTotal != null) {
            this.ftTimeoutCallsTotal.add(1L, Attributes.builder().putAll(this.methodAttribute).put(TIMED_OUT, (Object)"false").build());
        }
    }

    @Trivial
    public void incrementCircuitBreakerCallsCircuitOpenCount() {
        if (this.ftCircuitbreakerCallsTotal != null) {
            this.ftCircuitbreakerCallsTotal.add(1L, Attributes.builder().putAll(this.methodAttribute).put(CIRCUIT_BREAKER_RESULT, (Object)"circuitBreakerOpen").build());
        }
    }

    @Trivial
    public void incrementCircuitBreakerCallsSuccessCount() {
        if (this.ftCircuitbreakerCallsTotal != null) {
            this.ftCircuitbreakerCallsTotal.add(1L, Attributes.builder().putAll(this.methodAttribute).put(CIRCUIT_BREAKER_RESULT, (Object)"success").build());
        }
    }

    @Trivial
    public void incrementCircuitBreakerCallsFailureCount() {
        if (this.ftCircuitbreakerCallsTotal != null) {
            this.ftCircuitbreakerCallsTotal.add(1L, Attributes.builder().putAll(this.methodAttribute).put(CIRCUIT_BREAKER_RESULT, (Object)"failure").build());
        }
    }

    @Trivial
    public void incrementBulkheadRejectedCount() {
        if (this.ftBulkheadCallsTotal != null) {
            this.ftBulkheadCallsTotal.add(1L, Attributes.builder().putAll(this.methodAttribute).put(BULKHEAD_RESULT, (Object)"rejected").build());
        }
    }

    @Trivial
    public void incrementBulkeadAcceptedCount() {
        if (this.ftBulkheadCallsTotal != null) {
            this.ftBulkheadCallsTotal.add(1L, Attributes.builder().putAll(this.methodAttribute).put(BULKHEAD_RESULT, (Object)"accepted").build());
        }
    }

    @Trivial
    public synchronized void reportCircuitOpen(long now) {
        if (this.circuitBreakerState != CircuitBreakerState.OPEN) {
            this.recordEndOfCircuitBreakerState(this.circuitBreakerState, now);
            this.circuitBreakerState = CircuitBreakerState.OPEN;
            this.ftCircuitbreakerOpenedTotal.add(1L, this.methodAttribute);
        }
    }

    @Trivial
    public synchronized void reportCircuitHalfOpen(long now) {
        if (this.circuitBreakerState != CircuitBreakerState.HALF_OPEN) {
            this.recordEndOfCircuitBreakerState(this.circuitBreakerState, now);
            this.circuitBreakerState = CircuitBreakerState.HALF_OPEN;
        }
    }

    @Trivial
    public synchronized void reportCircuitClosed(long now) {
        if (this.circuitBreakerState != CircuitBreakerState.CLOSED) {
            this.recordEndOfCircuitBreakerState(this.circuitBreakerState, now);
            this.circuitBreakerState = CircuitBreakerState.CLOSED;
        }
    }

    @Trivial
    private void recordEndOfCircuitBreakerState(CircuitBreakerState oldState, long now) {
        switch (oldState) {
            case CLOSED: {
                this.closedNanos += now - this.lastCircuitBreakerTransitionTime;
                break;
            }
            case HALF_OPEN: {
                this.halfOpenNanos += now - this.lastCircuitBreakerTransitionTime;
                break;
            }
            case OPEN: {
                this.openNanos += now - this.lastCircuitBreakerTransitionTime;
            }
        }
        this.lastCircuitBreakerTransitionTime = now;
    }

    @Trivial
    private void getCircuitBreakerAccumulatedTimes(ObservableLongMeasurement measurement) {
        long now = System.nanoTime();
        long closedNanosLocal = this.closedNanos;
        long halfOpenNanosLocal = this.halfOpenNanos;
        long openNanosLocal = this.openNanos;
        switch (this.circuitBreakerState) {
            case CLOSED: {
                closedNanosLocal += now - this.lastCircuitBreakerTransitionTime;
                break;
            }
            case HALF_OPEN: {
                halfOpenNanosLocal += now - this.lastCircuitBreakerTransitionTime;
                break;
            }
            case OPEN: {
                openNanosLocal += now - this.lastCircuitBreakerTransitionTime;
            }
        }
        measurement.record(closedNanosLocal, Attributes.builder().putAll(this.methodAttribute).put(STATE, (Object)"closed").build());
        measurement.record(halfOpenNanosLocal, Attributes.builder().putAll(this.methodAttribute).put(STATE, (Object)"halfOpen").build());
        measurement.record(openNanosLocal, Attributes.builder().putAll(this.methodAttribute).put(STATE, (Object)"open").build());
    }

    @Trivial
    public void reportQueueWaitTime(long queueWaitNanos) {
        if (this.ftBulkheadWaitingDuration != null) {
            double seconds = (double)queueWaitNanos / 1.0E9;
            this.ftBulkheadWaitingDuration.record(seconds, this.methodAttribute);
        }
    }

    @Trivial
    private synchronized long getCircuitBreakerAccumulatedOpen() {
        long computedNanos = this.openNanos;
        if (this.circuitBreakerState == CircuitBreakerState.OPEN) {
            computedNanos += System.nanoTime() - this.lastCircuitBreakerTransitionTime;
        }
        return computedNanos;
    }

    @Trivial
    private synchronized long getCircuitBreakerAccumulatedHalfOpen() {
        long computedNanos = this.halfOpenNanos;
        if (this.circuitBreakerState == CircuitBreakerState.HALF_OPEN) {
            computedNanos += System.nanoTime() - this.lastCircuitBreakerTransitionTime;
        }
        return computedNanos;
    }

    @Trivial
    private synchronized long getCircuitBreakerAccumulatedClosed() {
        long computedNanos = this.closedNanos;
        if (this.circuitBreakerState == CircuitBreakerState.CLOSED) {
            computedNanos += System.nanoTime() - this.lastCircuitBreakerTransitionTime;
        }
        return computedNanos;
    }

    @Trivial
    private void getConcurrentExecutions(ObservableLongMeasurement measurement) {
        long executions = 0L;
        if (this.concurrentExecutionCountSupplier != null) {
            executions = this.concurrentExecutionCountSupplier.getAsLong();
        }
        measurement.record(executions, Attributes.builder().putAll(this.methodAttribute).build());
    }

    @Trivial
    public void setBulkheadConcurentExecutionCountSupplier(LongSupplier concurrentExecutionCountSupplier) {
        this.concurrentExecutionCountSupplier = concurrentExecutionCountSupplier;
    }

    @Trivial
    private void getQueuePopulation(ObservableLongMeasurement measurement) {
        long pop = 0L;
        if (this.queuePopulationSupplier != null) {
            pop = this.queuePopulationSupplier.getAsLong();
        }
        measurement.record(pop, Attributes.builder().putAll(this.methodAttribute).build());
    }

    @Trivial
    public void setBulkheadQueuePopulationSupplier(LongSupplier queuePopulationSupplier) {
        this.queuePopulationSupplier = queuePopulationSupplier;
    }

    @Trivial
    public void recordBulkheadExecutionTime(long executionTime) {
        if (this.ftBulkheadRunningDuration != null) {
            double seconds = (double)executionTime / 1.0E9;
            this.ftBulkheadRunningDuration.record(seconds, this.methodAttribute);
        }
    }

    private static enum CircuitBreakerState {
        CLOSED,
        HALF_OPEN,
        OPEN;

    }
}

