/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature;

import java.util.EnumSet;
import java.util.Locale;

public enum ProcessType {
    SERVER,
    CLIENT;


    public static EnumSet<ProcessType> fromString(String s) {
        String[] values;
        if (s == null) {
            return EnumSet.of(SERVER);
        }
        EnumSet<ProcessType> result = EnumSet.noneOf(ProcessType.class);
        for (String part : values = s.split(",")) {
            try {
                result.add(ProcessType.valueOf(part.trim().toUpperCase(Locale.ENGLISH)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (result.isEmpty()) {
            result.add(SERVER);
        }
        return result;
    }

    public static String toString(EnumSet<ProcessType> processTypes) {
        StringBuilder result = new StringBuilder();
        for (ProcessType processType : processTypes) {
            if (result.length() != 0) {
                result.append(',');
            }
            result.append(processType.toString());
        }
        return result.toString();
    }
}

