/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.ControllableType;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPInvalidRuntimeIDException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.impl.AnycastOutputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.items.MessageItemReference;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPLocalSubscriptionControllable;
import com.ibm.ws.sib.processor.runtime.SIMPQueuedMessageControllable;
import com.ibm.ws.sib.processor.runtime.SIMPTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.impl.AbstractRegisteredControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.LinkedList;

public class LocalSubscriptionControl
extends AbstractRegisteredControlAdapter
implements SIMPLocalSubscriptionControllable {
    private ConsumerDispatcherState consumerDispatcherState;
    private ReferenceStream referenceItemStream;
    private static TraceComponent tc = SibTr.register(LocalSubscriptionControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private SIMPTopicSpaceControllable topicspaceControl;
    private ConsumerDispatcher consumerDispatcher;

    public LocalSubscriptionControl(ConsumerDispatcher cd, SIMPTopicSpaceControllable topicspaceControl, MessageProcessor messageProcessor) {
        super(messageProcessor, ControllableType.SUBSCRIPTION_POINT);
        this.consumerDispatcher = cd;
        this.referenceItemStream = cd.getReferenceStream();
        this.topicspaceControl = topicspaceControl;
        this.consumerDispatcherState = this.consumerDispatcher.getConsumerDispatcherState();
    }

    public SIMPTopicSpaceControllable getTopicSpace() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpace");
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpace", (Object)this.topicspaceControl);
        }
        return this.topicspaceControl;
    }

    public String getSelector() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSelector");
        }
        String selector = this.consumerDispatcherState.getSelectionCriteria().getSelectorString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSelector", (Object)selector);
        }
        return selector;
    }

    public String getSubscriberID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriberID");
        }
        String subId = this.consumerDispatcherState.getSubscriberID();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscriberID", (Object)subId);
        }
        return subId;
    }

    protected String getDurableHome() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDurableHome");
        }
        String durableHome = this.consumerDispatcherState.getDurableHome();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDurableHome", (Object)durableHome);
        }
        return durableHome;
    }

    public String[] getTopics() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopics");
        }
        String[] topics = this.consumerDispatcherState.getTopics();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopics", (Object)topics);
        }
        return topics;
    }

    public SIMPIterator getConsumerIterator() {
        return null;
    }

    public SIMPIterator getRemoteConsumerTransmit() {
        String subName;
        String pseudoDestName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteConsumerTransmitIterator");
        }
        BasicSIMPIterator remoteConsumerTransmitIterator = null;
        BaseDestinationHandler destinationHandler = this.consumerDispatcher.getDestination();
        AnycastOutputHandler aoh = destinationHandler.getAnycastOHForPseudoDest(pseudoDestName = destinationHandler.constructPseudoDurableDestName(subName = this.consumerDispatcherState.getSubscriberID()));
        remoteConsumerTransmitIterator = aoh != null ? new BasicSIMPIterator(aoh.getAOControlAdapterIterator()) : new BasicSIMPIterator(new LinkedList().iterator());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteConsumerTransmitIterator", (Object)remoteConsumerTransmitIterator);
        }
        return remoteConsumerTransmitIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIMPIterator getQueuedMessageIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuedMessageIterator");
        }
        ArrayList<ControlAdapter> messages = new ArrayList<ControlAdapter>();
        NonLockingCursor cursor = null;
        MessageItem referredItem = null;
        try {
            cursor = this.consumerDispatcher.getReferenceStream().newNonLockingCursor(null);
            cursor.allowUnavailableItems();
            MessageItemReference item = (MessageItemReference)cursor.next();
            while (item != null) {
                try {
                    ControlAdapter cAdapter;
                    referredItem = (MessageItem)item.getReferredItem();
                    if (referredItem != null) {
                        referredItem.forceCurrentMEArrivalTimeToJsMessage();
                    }
                    if ((cAdapter = item.getControlAdapter()) != null) {
                        messages.add(cAdapter);
                    }
                    item = (MessageItemReference)cursor.next();
                }
                catch (NotInMessageStore ef) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)ef));
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.LocalSubscriptionControl.getQueuedMessageIterator", (String)"1:275:1.36", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.LocalSubscriptionControl.getQueuedMessageIterator", "1:281:1.36", SIMPUtils.getStackTrace(e)});
                }
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.LocalSubscriptionControl.getQueuedMessageIterator", (String)"1:292:1.36", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.LocalSubscriptionControl.getQueuedMessageIterator", "1:298:1.36", SIMPUtils.getStackTrace(e)});
        }
        finally {
            if (cursor != null) {
                cursor.finished();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageIterator");
        }
        return new BasicSIMPIterator(messages.iterator());
    }

    public SIMPQueuedMessageControllable getQueuedMessageByID(String ID) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuedMessageByID", (Object)new Object[]{ID});
        }
        long messageID = -1L;
        try {
            messageID = Long.parseLong(ID);
        }
        catch (NumberFormatException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.LocalQueuePoint.getQueuedMessageByID", (String)"1:332:1.36", (Object)this);
            throw new SIMPInvalidRuntimeIDException((Throwable)e);
        }
        SIMPMessage message = null;
        try {
            AbstractItem abstractItem = this.consumerDispatcher.getReferenceStream().findById(messageID);
            if (abstractItem instanceof SIMPMessage) {
                message = (SIMPMessage)abstractItem;
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.LocalSubscriptionControl.getQueuedMessageByID", (String)"1:349:1.36", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageByID", (Object)((Object)e));
            }
            throw new SIMPRuntimeOperationFailedException((Throwable)e);
        }
        if (message == null) {
            throw new SIMPControllableNotFoundException(nls.getFormattedMessage("MESSAGE_EXISTS_ERROR_CWSIP0572", new Object[]{ID, this.consumerDispatcher.getDestination().getName()}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageByID");
        }
        return (SIMPQueuedMessageControllable)message.getControlAdapter();
    }

    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        String id = this.consumerDispatcher.getSubscriptionUuid().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)id);
        }
        return id;
    }

    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        String name = this.consumerDispatcher.getConsumerDispatcherState().getSubscriberID();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)name);
        }
        return name;
    }

    public long getNumberOfQueuedMessages() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfQueuedMessages");
        }
        long total = 0L;
        try {
            total = this.referenceItemStream.getStatistics().getTotalItemCount();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.LocalSubscriptionControl.getNumberOfQueuedMessages", (String)"1:422:1.36", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfQueuedMessages", (Object)new Long(total));
        }
        return total;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkValidControllable");
        }
        if (this.referenceItemStream == null || !this.referenceItemStream.isInStore()) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"LocalSubscriptionControl.assertValidControllable", "1:448:1.36", this.referenceItemStream}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        super.dereferenceControllable();
        this.referenceItemStream = null;
        this.consumerDispatcher = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
        if (!this.isRegistered()) {
            super.registerControlAdapterAsMBean();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
    }
}

