/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.matching;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.security.Principal;
import java.util.List;
import javax.security.auth.Subject;

public class MPPrincipal
implements Principal {
    private static final TraceComponent tc = SibTr.register(MPPrincipal.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private String name;
    private List<String> groups;

    public MPPrincipal(String nm) {
        this.name = nm.toLowerCase();
    }

    public MPPrincipal(String busName, Subject subject, AuthUtils utils) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String report = "<null>";
            if (subject != null) {
                report = "subject(" + utils.getUserName(subject) + ")";
            }
            SibTr.entry((TraceComponent)tc, (String)"MPPrincipal", (Object)new Object[]{report, utils});
        }
        if (subject != null) {
            this.name = utils.getUserName(subject).toLowerCase();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MPPrincipal", (Object)this);
        }
    }

    public MPPrincipal(String busName, String userName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MPPrincipal", (Object)new Object[]{busName, userName});
        }
        this.name = userName.toLowerCase();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MPPrincipal", (Object)this);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return ((MPPrincipal)o).name.equals(this.name);
    }

    @Override
    public String toString() {
        return "Principal(" + this.name + ")";
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List getGroups() {
        return this.groups;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/matching/MPPrincipal.java, SIB.processor, WASX.SIB, ff1246.02 1.18");
        }
    }
}

