/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource;
import io.openliberty.data.internal.QueryType;
import io.openliberty.data.internal.persistence.DataProvider;
import io.openliberty.data.internal.persistence.EntityInfo;
import io.openliberty.data.internal.persistence.EntityManagerBuilder;
import io.openliberty.data.internal.persistence.EntityValidator;
import io.openliberty.data.internal.persistence.QueryInfo;
import io.openliberty.data.internal.persistence.cdi.DataExtension;
import io.openliberty.data.internal.persistence.service.DBStoreEMBuilder;
import jakarta.data.exceptions.DataConnectionException;
import jakarta.data.exceptions.DataException;
import jakarta.data.exceptions.EmptyResultException;
import jakarta.data.exceptions.EntityExistsException;
import jakarta.data.exceptions.MappingException;
import jakarta.data.exceptions.OptimisticLockingFailureException;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Table;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransientConnectionException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RepositoryImpl<R>
implements InvocationHandler {
    private static final TraceComponent tc = Tr.register(RepositoryImpl.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private static final ThreadLocal<Deque<AutoCloseable>> defaultMethodResources = new ThreadLocal();
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    final CompletableFuture<EntityInfo> primaryEntityInfoFuture;
    final DataProvider provider;
    private final Map<Method, CompletableFuture<QueryInfo>> queries = new HashMap<Method, CompletableFuture<QueryInfo>>();
    final Class<R> repositoryInterface;
    final EntityValidator validator;
    static final long serialVersionUID = -8593489903857715867L;

    public RepositoryImpl(DataProvider provider, DataExtension extension, EntityManagerBuilder builder, Class<R> repositoryInterface, Class<?> primaryEntityClass, Map<Class<?>, List<QueryInfo>> queriesPerEntityClass) {
        this.primaryEntityInfoFuture = primaryEntityClass == null ? null : builder.entityInfoMap.computeIfAbsent(primaryEntityClass, EntityInfo::newFuture);
        this.provider = provider;
        this.repositoryInterface = repositoryInterface;
        Object validation = provider.validationService;
        this.validator = validation == null ? null : EntityValidator.newInstance(validation, repositoryInterface);
        CompletableFuture<RepositoryImpl> thisCF = queriesPerEntityClass.isEmpty() ? null : CompletableFuture.completedFuture(this);
        ArrayList<CompletableFuture> entityInfoFutures = new ArrayList<CompletableFuture>();
        List<QueryInfo> entitylessQueryInfos = null;
        for (Map.Entry<Class<?>, List<QueryInfo>> entry : queriesPerEntityClass.entrySet()) {
            Class<?> entityClass = entry.getKey();
            if (QueryInfo.ENTITY_TBD.equals(entityClass)) {
                entitylessQueryInfos = entry.getValue();
                continue;
            }
            CompletableFuture entityInfoFuture = builder.entityInfoMap.computeIfAbsent(entityClass, EntityInfo::newFuture);
            entityInfoFutures.add(entityInfoFuture);
            for (QueryInfo queryInfo : entry.getValue()) {
                if (queryInfo.type == QueryType.RESOURCE_ACCESS) {
                    queryInfo.validateParams = this.validator != null && this.validator.isValidatable(queryInfo.method)[1];
                    this.queries.put(queryInfo.method, CompletableFuture.completedFuture(queryInfo));
                    continue;
                }
                this.queries.put(queryInfo.method, (CompletableFuture<QueryInfo>)entityInfoFuture.thenCombine(thisCF, queryInfo::init));
            }
        }
        if (entitylessQueryInfos != null) {
            if (entityInfoFutures.isEmpty()) {
                for (QueryInfo queryInfo : entitylessQueryInfos) {
                    MappingException x2 = DataExtension.exc(MappingException.class, "CWWKD1001.no.primary.entity", queryInfo.method, repositoryInterface.getName(), "DataRepository<EntityClass, EntityIdClass>");
                    this.queries.put(queryInfo.method, CompletableFuture.failedFuture((Throwable)x2));
                }
            }
            CompletableFuture[] futures = entityInfoFutures.toArray(new CompletableFuture[entityInfoFutures.size()]);
            CompletionStage allEntityInfo = ((CompletableFuture)CompletableFuture.allOf(futures).handle((VOID, x) -> x)).thenCombine((CompletionStage)CompletableFuture.completedFuture(entityInfoFutures), this::allEntityInfoAsMap);
            for (QueryInfo queryInfo : entitylessQueryInfos) {
                this.queries.put(queryInfo.method, (CompletableFuture<QueryInfo>)((CompletableFuture)allEntityInfo).thenCombine(CompletableFuture.completedFuture(this), queryInfo::init));
            }
        }
    }

    private Map<String, CompletableFuture<EntityInfo>> allEntityInfoAsMap(Throwable x, List<CompletableFuture<EntityInfo>> futures) {
        HashMap<String, CompletableFuture<EntityInfo>> entityInfos = new HashMap<String, CompletableFuture<EntityInfo>>();
        for (CompletableFuture<EntityInfo> future : futures) {
            if (future.isCompletedExceptionally()) {
                entityInfos.putIfAbsent("ERROR!", future);
                continue;
            }
            if (future.isDone()) {
                MappingException conflictX;
                EntityInfo entityInfo = future.join();
                CompletableFuture<EntityInfo> conflict = entityInfos.put(entityInfo.name, future);
                if (entityInfo.recordClass != null && conflict == null) {
                    int end = entityInfo.name.length() - "Entity".length();
                    String recordName = entityInfo.name.substring(0, end);
                    conflict = entityInfos.put(recordName, future);
                }
                if (conflict == null) continue;
                EntityInfo conflictInfo = conflict.join();
                List<String> classNames = List.of(entityInfo.getType().getName(), conflictInfo.getType().getName());
                if (entityInfo.recordClass == null && conflictInfo.recordClass == null) {
                    conflictX = DataExtension.exc(MappingException.class, "CWWKD1068.entity.name.conflict", this.repositoryInterface.getName(), entityInfo.name, classNames, List.of(Entity.class.getName(), Table.class.getName()));
                } else {
                    String longerName = entityInfo.name;
                    String shorterName = entityInfo.name;
                    if (conflictInfo.name.length() > longerName.length()) {
                        longerName = conflictInfo.name;
                    } else {
                        shorterName = conflictInfo.name;
                    }
                    conflictX = DataExtension.exc(MappingException.class, "CWWKD1069.record.entity.name.conflict", this.repositoryInterface.getName(), shorterName, classNames, longerName);
                }
                entityInfos.putIfAbsent("ERROR!", CompletableFuture.failedFuture((Throwable)conflictX));
                continue;
            }
            entityInfos.putIfAbsent("ERROR!", CompletableFuture.failedFuture(x));
        }
        return entityInfos;
    }

    public void beanDisposed() {
        this.isDisposed.set(true);
    }

    @Trivial
    @FFDCIgnore(value={Exception.class})
    static RuntimeException failure(Exception original, EntityManagerBuilder emb) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        Object x = null;
        if (original instanceof PersistenceException) {
            for (Throwable cause = original; x == null && cause != null; cause = cause.getCause()) {
                block14: {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("checking " + cause.getClass().getName() + " with message " + cause.getMessage()), (Object[])new Object[0]);
                    }
                    if (emb instanceof DBStoreEMBuilder && cause instanceof SQLException) {
                        try {
                            WSJdbcDataSource ds = (WSJdbcDataSource)emb.getDataSource(null, null);
                            if (ds != null && ds.getDatabaseHelper().isConnectionError((SQLException)cause)) {
                                x = new DataConnectionException((Throwable)original);
                            }
                        }
                        catch (Exception e) {
                            if (!trace || !tc.isDebugEnabled()) break block14;
                            Tr.debug((TraceComponent)tc, (String)"Could not obtain DataSource during Exception checking", (Object[])new Object[0]);
                        }
                    }
                }
                if (x != null) continue;
                if (cause instanceof SQLRecoverableException || cause instanceof SQLNonTransientConnectionException || cause instanceof SQLTransientConnectionException) {
                    x = new DataConnectionException((Throwable)original);
                    continue;
                }
                if (cause instanceof SQLSyntaxErrorException) {
                    x = new MappingException((Throwable)original);
                    continue;
                }
                if (!(cause instanceof SQLIntegrityConstraintViolationException)) continue;
                x = new EntityExistsException((Throwable)original);
            }
            if (x == null) {
                x = original instanceof OptimisticLockException ? new OptimisticLockingFailureException((Throwable)original) : (original instanceof jakarta.persistence.EntityExistsException ? new EntityExistsException((Throwable)original) : (original instanceof NoResultException ? new EmptyResultException((Throwable)original) : (original instanceof NonUniqueResultException ? new jakarta.data.exceptions.NonUniqueResultException((Throwable)original) : new DataException((Throwable)original))));
            }
        } else {
            Throwable cause;
            x = original instanceof CompletionException ? ((cause = original.getCause()) == null ? new MappingException((Throwable)original) : (DataException.class.equals(cause.getClass()) ? new DataException(cause.getMessage(), (Throwable)original) : (DataConnectionException.class.equals(cause.getClass()) ? new DataConnectionException(cause.getMessage(), (Throwable)original) : (EmptyResultException.class.equals(cause.getClass()) ? new EmptyResultException(cause.getMessage(), (Throwable)original) : (MappingException.class.equals(cause.getClass()) ? new MappingException(cause.getMessage(), (Throwable)original) : (jakarta.data.exceptions.NonUniqueResultException.class.equals(cause.getClass()) ? new jakarta.data.exceptions.NonUniqueResultException(cause.getMessage(), (Throwable)original) : (UnsupportedOperationException.class.equals(cause.getClass()) ? new UnsupportedOperationException(cause.getMessage(), original) : new MappingException((Throwable)original)))))))) : (original instanceof IllegalArgumentException ? (original.getCause() == null ? (IllegalArgumentException)original : new MappingException((Throwable)original)) : (original instanceof RuntimeException ? ("org.eclipse.persistence.exceptions.DescriptorException".equals(original.getClass().getName()) ? new MappingException((Throwable)original) : (RuntimeException)original) : new DataException((Throwable)original)));
        }
        if (trace && tc.isDebugEnabled()) {
            if (x == original) {
                Tr.debug((TraceComponent)tc, (String)("Failure occurred: " + x.getClass().getName()), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)(original.getClass().getName() + " replaced with " + x.getClass().getName()), (Object[])new Object[0]);
            }
        }
        return x;
    }

    @Trivial
    public final CompletableFuture<QueryInfo> getQueryFuture(Method method) {
        return this.queries.get(method);
    }

    /*
     * WARNING - void declaration
     */
    private <T> T getResource(Method method) {
        Deque<AutoCloseable> resources = defaultMethodResources.get();
        Object resource = null;
        Class<?> type = method.getReturnType();
        if (EntityManager.class.equals(type)) {
            resource = this.primaryEntityInfoFuture.join().builder.createEntityManager();
        } else if (DataSource.class.equals(type)) {
            resource = this.primaryEntityInfoFuture.join().builder.getDataSource(method, this.repositoryInterface);
        } else if (Connection.class.equals(type)) {
            try {
                resource = this.primaryEntityInfoFuture.join().builder.getDataSource(method, this.repositoryInterface).getConnection();
            }
            catch (SQLException sQLException) {
                void x;
                FFDCFilter.processException((Throwable)sQLException, (String)"io.openliberty.data.internal.persistence.RepositoryImpl", (String)"410", (Object)this, (Object[])new Object[]{method});
                throw new DataConnectionException((Throwable)x);
            }
        }
        if (resource == null) {
            throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1044.invalid.resource.type", method.getName(), this.repositoryInterface.getName(), type.getName(), List.of(Connection.class.getName(), DataSource.class.getName(), EntityManager.class.getName()));
        }
        if (resource instanceof AutoCloseable) {
            if (resources == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    StackTraceElement[] stack = Thread.currentThread().getStackTrace();
                    String thisClassName = this.getClass().getName();
                    int s = 0;
                    while (++s < stack.length && stack[s].getClassName().equals(thisClassName)) {
                    }
                    StackTraceElement[] shortened = new StackTraceElement[stack.length - s];
                    System.arraycopy(stack, s, shortened, 0, shortened.length);
                    Tr.debug((Object)this, (TraceComponent)tc, (String)(type.getSimpleName() + " accessed outside of repository default method"), (Object[])shortened);
                }
            } else {
                resources.add((AutoCloseable)resource);
            }
        }
        EntityManager t = resource;
        return (T)t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Trivial
    @ManualTrace
    @FFDCIgnore(value={Throwable.class})
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean trace;
        CompletableFuture<QueryInfo> queryInfoFuture = this.queries.get(method);
        boolean isDefaultMethod = false;
        EntityManager em = null;
        if (queryInfoFuture == null) {
            if (method.isDefault()) {
                isDefaultMethod = true;
            } else {
                boolean bl;
                String methodName = method.getName();
                if (args == null) {
                    if ("hashCode".equals(methodName)) {
                        return System.identityHashCode(proxy);
                    }
                    if (!"toString".equals(methodName)) throw new UnsupportedOperationException(method.toString());
                    return this.repositoryInterface.getName() + "(Proxy)@" + Integer.toHexString(System.identityHashCode(proxy));
                }
                if (args.length != 1) throw new UnsupportedOperationException(method.toString());
                if (!"equals".equals(methodName)) throw new UnsupportedOperationException(method.toString());
                if (proxy == args[0]) {
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
        }
        if ((trace = TraceComponent.isAnyTracingEnabled()) && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("invoke " + this.repositoryInterface.getSimpleName() + "." + method.getName()), (Object[])this.provider.loggable(this.repositoryInterface, method, args));
        }
        EntityInfo entityInfo = null;
        try {
            Object returnValue;
            QueryType queryType;
            block60: {
                boolean startedTransaction;
                boolean failed;
                LocalTransactionCoordinator suspendedLTC;
                block59: {
                    if (this.isDisposed.get()) {
                        throw DataExtension.exc(IllegalStateException.class, "CWWKD1076.repo.disposed", method.getName(), this.repositoryInterface.getName(), new StringBuilder("RepositoryImpl@").append(Integer.toHexString(this.hashCode())).append("/(proxy)@").append(Integer.toHexString(System.identityHashCode(proxy))));
                    }
                    if (isDefaultMethod) {
                        Deque<AutoCloseable> resourceStack = defaultMethodResources.get();
                        boolean added = resourceStack == null;
                        if (added) {
                            resourceStack = new LinkedList<AutoCloseable>();
                            defaultMethodResources.set(resourceStack);
                        } else {
                            resourceStack.add(null);
                        }
                        try {
                            Object returnValue2 = InvocationHandler.invokeDefault(proxy, method, args);
                            if (trace && tc.isEntryEnabled()) {
                                Tr.exit((Object)this, (TraceComponent)tc, (String)("invoke " + this.repositoryInterface.getSimpleName() + "." + method.getName()), (Object)returnValue2);
                            }
                            Object object = returnValue2;
                            return object;
                        }
                        finally {
                            AutoCloseable resource;
                            while ((resource = resourceStack.pollLast()) != null) {
                                if (resource instanceof EntityManager && !((EntityManager)resource).isOpen()) continue;
                                try {
                                    if (trace && tc.isDebugEnabled()) {
                                        Tr.debug((Object)this, (TraceComponent)tc, (String)("close " + String.valueOf(resource)), (Object[])new Object[0]);
                                    }
                                    resource.close();
                                }
                                catch (Throwable x) {
                                    FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"1827", (Object)this);
                                }
                            }
                            if (added) {
                                defaultMethodResources.remove();
                            }
                        }
                    }
                    suspendedLTC = null;
                    failed = true;
                    queryType = null;
                    startedTransaction = false;
                    try {
                        QueryInfo queryInfo = queryInfoFuture.join();
                        entityInfo = queryInfo.entityInfo;
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)queryInfo.toString(), (Object[])new Object[0]);
                        }
                        if (queryInfo.validateParams) {
                            this.validator.validateParameters(proxy, method, args);
                        }
                        queryType = queryInfo.type;
                        if (queryType.requiresTransaction && 6 == this.provider.tranMgr.getStatus()) {
                            suspendedLTC = this.provider.localTranCurrent.suspend();
                            this.provider.tranMgr.begin();
                            startedTransaction = true;
                        }
                        if (queryType != QueryType.RESOURCE_ACCESS) {
                            em = entityInfo.builder.createEntityManager();
                        }
                        switch (queryType) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case FIND: 
                            case FIND_AND_DELETE: {
                                Object object = queryInfo.find(em, args);
                                break;
                            }
                            case COUNT: {
                                Object object = queryInfo.count(em, args);
                                break;
                            }
                            case EXISTS: {
                                Object object = queryInfo.exists(em, args);
                                break;
                            }
                            case INSERT: {
                                Object object = queryInfo.insert(args[0], em);
                                break;
                            }
                            case SAVE: {
                                Object object = queryInfo.save(args[0], em);
                                break;
                            }
                            case QM_UPDATE: 
                            case QM_DELETE: {
                                Object object = queryInfo.execute(em, args);
                                break;
                            }
                            case LC_DELETE: {
                                Object object = queryInfo.delete(args[0], em);
                                break;
                            }
                            case LC_UPDATE: {
                                Object object = queryInfo.update(args[0], em);
                                break;
                            }
                            case LC_UPDATE_RET_ENTITY: {
                                Object object = queryInfo.findAndUpdate(args[0], em);
                                break;
                            }
                            case RESOURCE_ACCESS: {
                                Object object = returnValue = this.getResource(method);
                            }
                        }
                        if (queryInfo.validateResult) {
                            this.validator.validateReturnValue(proxy, method, returnValue);
                        }
                        failed = false;
                        if (em == null) break block59;
                    }
                    catch (Throwable throwable) {
                        if (em != null) {
                            em.close();
                        }
                        try {
                            if (startedTransaction) {
                                int status = this.provider.tranMgr.getStatus();
                                if (status != 1 && !failed) {
                                    if (status == 6) throw throwable;
                                    this.provider.tranMgr.commit();
                                    throw throwable;
                                }
                                this.provider.tranMgr.rollback();
                                throw throwable;
                            }
                            if (!failed) throw throwable;
                            if (0 != this.provider.tranMgr.getStatus()) throw throwable;
                            this.provider.tranMgr.setRollbackOnly();
                            throw throwable;
                        }
                        finally {
                            if (suspendedLTC != null) {
                                this.provider.localTranCurrent.resume(suspendedLTC);
                            }
                        }
                    }
                    em.close();
                }
                try {
                    if (startedTransaction) {
                        int status = this.provider.tranMgr.getStatus();
                        if (status == 1 || failed) {
                            this.provider.tranMgr.rollback();
                            break block60;
                        }
                        if (status != 6) {
                            this.provider.tranMgr.commit();
                        }
                        break block60;
                    }
                    if (failed && 0 == this.provider.tranMgr.getStatus()) {
                        this.provider.tranMgr.setRollbackOnly();
                    }
                }
                finally {
                    if (suspendedLTC != null) {
                        this.provider.localTranCurrent.resume(suspendedLTC);
                    }
                }
            }
            if (!trace) return returnValue;
            if (!tc.isEntryEnabled()) return returnValue;
            Object valueToLog = queryType.hideReturnValue ? this.provider.loggable((Class<?>)this.repositoryInterface, method, returnValue) : returnValue;
            Tr.exit((Object)this, (TraceComponent)tc, (String)("invoke " + this.repositoryInterface.getSimpleName() + "." + method.getName()), valueToLog);
            return returnValue;
        }
        catch (Throwable x2) {
            RuntimeException x2;
            if (!isDefaultMethod && x2 instanceof Exception) {
                x2 = RepositoryImpl.failure((Exception)x2, entityInfo == null ? null : entityInfo.builder);
            }
            if (!trace) throw x2;
            if (!tc.isEntryEnabled()) throw x2;
            Tr.exit((Object)this, (TraceComponent)tc, (String)("invoke " + this.repositoryInterface.getSimpleName() + "." + method.getName()), (Object)x2);
            throw x2;
        }
    }
}

