/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi40.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.services.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.microprofile.openapi.models.Components;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Reference31Validator {
    private static final TraceComponent tc = Tr.register(Reference31Validator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final Reference31Validator INSTANCE = new Reference31Validator();
    public static final Map<String, Function<Components, Map<String, ?>>> COMPONENT_GETTERS = Map.of("callbacks", t -> t.getCallbacks(), "links", t -> t.getLinks(), "securitySchemes", t -> t.getSecuritySchemes(), "headers", t -> t.getHeaders(), "requestBodies", t -> t.getRequestBodies(), "examples", t -> t.getExamples(), "parameters", t -> t.getParameters(), "responses", t -> t.getResponses(), "schemas", t -> t.getSchemas(), "pathItems", t -> t.getPathItems());
    static final long serialVersionUID = 7396608743195483141L;

    public static Reference31Validator getInstance() {
        return INSTANCE;
    }

    private Reference31Validator() {
    }

    @FFDCIgnore(value={URISyntaxException.class})
    public Object validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String ref) {
        if (ref == null || ref.trim().isEmpty()) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNull", (Object[])new Object[0]);
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return null;
        }
        try {
            new URI(ref);
        }
        catch (URISyntaxException e) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotValidUri", (Object[])new Object[]{ref});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return null;
        }
        String[] references = ref.split("/");
        if (!ref.startsWith("#/components/")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Reference does not target components, not validating", (Object[])new Object[]{ref});
            }
            return null;
        }
        Components components = context.getModel().getComponents();
        if (components == null) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{ref});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return null;
        }
        String type = references[2];
        if (!COMPONENT_GETTERS.containsKey(type)) {
            if (type.startsWith("x-")) {
                return null;
            }
            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{ref});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return null;
        }
        Optional<Map> component = Optional.ofNullable(COMPONENT_GETTERS.get(type)).map(f -> (Map)f.apply(components));
        if (references.length == 3) {
            if (component.isPresent()) {
                return component.get();
            }
            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{ref});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return null;
        }
        String name = this.decodeJsonPointerToken(references[3]);
        Optional<Object> object = component.map(m -> m.get(name));
        if (!object.isPresent()) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{ref});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return null;
        }
        return object.get();
    }

    private String decodeJsonPointerToken(String token) {
        token = token.replaceAll("~1", "/");
        token = token.replaceAll("~0", "~");
        return token;
    }
}

