/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.ra.SibRaDelegatingXAResource;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIXAResource;
import java.util.Hashtable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

class SibRaXaResource
implements SIXAResource,
SibRaDelegatingXAResource {
    protected final SIXAResource _siXaResource;
    private static TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaXaResource.class);
    private Xid _lastXidUsed = null;
    private static final Hashtable _transactionStates = new Hashtable();

    SibRaXaResource(SIXAResource siXaResource) {
        this._siXaResource = siXaResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        String methodName = "commit";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"commit", (Object)new Object[]{xid, onePhase});
        }
        this._siXaResource.commit(xid, onePhase);
        Hashtable hashtable = _transactionStates;
        synchronized (hashtable) {
            _transactionStates.put(xid, Boolean.FALSE);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer("After adding the xid ");
                sb.append(xid);
                sb.append(" the hashtable of transactionStates now contains ");
                sb.append(_transactionStates.size());
                sb.append(" entries");
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)sb.toString());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"commit");
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        String methodName = "end";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"end", (Object)new Object[]{xid, flags});
        }
        this._siXaResource.end(xid, flags);
        this._lastXidUsed = xid;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"end");
        }
    }

    public void forget(Xid xid) throws XAException {
        String methodName = "forget";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"forget", (Object)xid);
        }
        this._siXaResource.forget(xid);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"forget");
        }
    }

    public int getTransactionTimeout() throws XAException {
        String methodName = "getTransactionTimeout";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getTransactionTimeout");
        }
        int timeout = this._siXaResource.getTransactionTimeout();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getTransactionTimeout", (Object)timeout);
        }
        return timeout;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        String methodName = "isSameRM";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"isSameRM", (Object)xares);
        }
        boolean isSameRm = xares instanceof SibRaXaResource ? this._siXaResource.isSameRM((XAResource)((SibRaXaResource)((Object)xares)).getSiXaResource()) : xares.isSameRM((XAResource)this._siXaResource);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"isSameRM", (Object)isSameRm);
        }
        return isSameRm;
    }

    public int prepare(Xid xid) throws XAException {
        String methodName = "prepare";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"prepare", (Object)xid);
        }
        int result = this._siXaResource.prepare(xid);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"prepare", (Object)result);
        }
        return result;
    }

    public Xid[] recover(int flag) throws XAException {
        String methodName = "recover";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"recover", (Object)flag);
        }
        Xid[] result = this._siXaResource.recover(flag);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"recover", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        String methodName = "rollback";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"rollback", (Object)xid);
        }
        this._siXaResource.rollback(xid);
        Hashtable hashtable = _transactionStates;
        synchronized (hashtable) {
            _transactionStates.put(xid, Boolean.TRUE);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer("After adding the xid ");
                sb.append(xid);
                sb.append(" the hashtable of transactionStates now contains ");
                sb.append(_transactionStates.size());
                sb.append(" entries");
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)sb.toString());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"rollback");
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        String methodName = "recover";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"recover", (Object)seconds);
        }
        boolean result = this._siXaResource.setTransactionTimeout(seconds);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"recover", (Object)result);
        }
        return result;
    }

    public void start(Xid xid, int flags) throws XAException {
        String methodName = "start";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"start", (Object)new Object[]{xid, flags});
        }
        this._siXaResource.start(xid, flags);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"start");
        }
    }

    public boolean isEnlisted() {
        String methodName = "isEnlisted";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"isEnlisted");
        }
        boolean enlisted = this._siXaResource.isEnlisted();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"isEnlisted", (Object)enlisted);
        }
        return enlisted;
    }

    public SIXAResource getSiXaResource() {
        return this._siXaResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isTransactionRolledBack() {
        String methodName = "isTransactionRolledBack";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"isTransactionRolledBack");
        }
        boolean isRolledBack = true;
        Boolean rolledBack = null;
        if (this._lastXidUsed != null) {
            Hashtable hashtable = _transactionStates;
            synchronized (hashtable) {
                rolledBack = (Boolean)_transactionStates.remove(this._lastXidUsed);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer("After removing the xid ");
                    sb.append(this._lastXidUsed);
                    sb.append(" the hashtable of transactionStates now contains ");
                    sb.append(_transactionStates.size());
                    sb.append(" entries");
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)sb.toString());
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"WARNING! No last Xid set");
        }
        if (rolledBack != null) {
            isRolledBack = rolledBack;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"isTransactionRolledBack", (Object)isRolledBack);
        }
        return isRolledBack;
    }

    public String toString() {
        SibRaStringGenerator generator = new SibRaStringGenerator(this);
        generator.addField("siXaResource", this._siXaResource);
        return generator.getStringRepresentation();
    }
}

