/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.session61.http.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.session.AbstractSessionData;
import com.ibm.ws.session.SessionContext;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.session.ISession;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.util.function.Consumer;
import java.util.logging.Level;

public class HttpSessionImpl61
extends AbstractSessionData {
    private static final String CLASS_NAME = HttpSessionImpl61.class.getName();
    private static TraceNLS nls = TraceNLS.getTraceNLS(HttpSessionImpl61.class, (String)"io.openliberty.session.resources.SessionMessages");

    protected HttpSessionImpl61(ISession session, SessionContext sessCtx, ServletContext servCtx) {
        super(session, sessCtx, servCtx);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINER, CLASS_NAME + " Constructor ISession [" + String.valueOf(session) + "] ; SessionContext [" + String.valueOf(sessCtx) + "] , servletContext [" + String.valueOf(servCtx) + "] this [" + String.valueOf((Object)this) + "]");
        }
    }

    public HttpSession.Accessor getAccessor() {
        ISession iSession = super.getISession();
        if (iSession == null || !iSession.isValid()) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
                LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINER, CLASS_NAME + " getAccessor , session is invalidated, throw ISE");
            }
            throw new IllegalStateException(nls.getString("session.is.invalid"));
        }
        return new SessionDataAccessor(iSession, super.getId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("# HttpSessionImpl61 # \n { ").append("\n _iSession=").append(this.getISession()).append("\n } \n");
        return sb.toString();
    }

    private static class SessionDataAccessor
    implements HttpSession.Accessor {
        private final String INNER_CLASS_NAME = "SessionDataAccessor";
        private final ISession iSession;
        String savedSessionId = null;

        public SessionDataAccessor(ISession session, String id) {
            this.iSession = session;
            this.savedSessionId = id;
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
                LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINER, "SessionDataAccessor Constructor , session id [" + this.savedSessionId + "] , this [" + String.valueOf(this) + "] . ISession [" + String.valueOf(this.iSession) + "]");
            }
        }

        public void access(Consumer<HttpSession> sessionConsumer) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
                LoggingUtil.SESSION_LOGGER_CORE.entering("SessionDataAccessor", " access");
            }
            if (!this.iSession.isValid()) {
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
                    LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINER, "SessionDataAccessor access , session is invalidated, throw ISE , this [" + String.valueOf(this) + "]");
                }
                throw new IllegalStateException(nls.getString("session.is.invalid"));
            }
            String accessSessionId = this.iSession.getId();
            if (accessSessionId == null || !accessSessionId.equals(this.savedSessionId)) {
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
                    LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINER, "SessionDataAccessor access , session id [" + (accessSessionId == null ? null : accessSessionId) + "] has changed from previous session id [" + this.savedSessionId + "] , throw ISE , this [" + String.valueOf(this) + "]");
                }
                throw new IllegalStateException(nls.getString("session.id.is.invalid"));
            }
            this.iSession.updateLastAccessTime(System.currentTimeMillis());
            sessionConsumer.accept((HttpSession)this.iSession.getAdaptation());
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting("SessionDataAccessor", " access , updated last accessed time , session id[" + accessSessionId + "] , this [" + String.valueOf(this) + "]");
            }
        }
    }
}

