/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.okhttp3;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSink;
import okio.GzipSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import zipkin2.reporter.BaseHttpSender;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.okhttp3.OkHttpSender;
import zipkin2.reporter.okhttp3.RequestBodyMessageEncoder;

final class InternalOkHttpSender
extends BaseHttpSender<HttpUrl, RequestBody> {
    final OkHttpClient client;
    final RequestBodyMessageEncoder encoder;
    final Encoding encoding;
    final int messageMaxBytes;
    final int maxRequests;
    final boolean compressionEnabled;

    InternalOkHttpSender(OkHttpSender.Builder builder) {
        super(builder.encoding, builder.endpointSupplierFactory, builder.endpoint);
        this.encoding = builder.encoding;
        this.encoder = RequestBodyMessageEncoder.forEncoding(this.encoding);
        this.maxRequests = builder.maxRequests;
        this.messageMaxBytes = builder.messageMaxBytes;
        this.compressionEnabled = builder.compressionEnabled;
        Dispatcher dispatcher = InternalOkHttpSender.newDispatcher(this.maxRequests);
        this.client = builder.clientBuilder().build().newBuilder().dispatcher(dispatcher).build();
    }

    @Override
    public int messageMaxBytes() {
        return this.messageMaxBytes;
    }

    @Override
    protected HttpUrl newEndpoint(String endpoint) {
        HttpUrl parsed = HttpUrl.parse((String)endpoint);
        if (parsed == null) {
            throw new IllegalArgumentException("invalid POST url: " + endpoint);
        }
        return parsed;
    }

    @Override
    protected RequestBody newBody(List<byte[]> encodedSpans) {
        return this.encoder.encode(encodedSpans);
    }

    @Override
    protected void postSpans(HttpUrl endpoint, RequestBody body) throws IOException {
        Request request = this.newRequest(endpoint, body);
        Call call = this.client.newCall(request);
        InternalOkHttpSender.parseResponse(call.execute());
    }

    Request newRequest(HttpUrl endpoint, RequestBody body) throws IOException {
        Request.Builder request = new Request.Builder().url(endpoint);
        request.addHeader("b3", "0");
        if (this.compressionEnabled) {
            request.addHeader("Content-Encoding", "gzip");
            Buffer gzipped = new Buffer();
            BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)gzipped));
            body.writeTo(gzipSink);
            gzipSink.close();
            body = new BufferRequestBody(body.contentType(), gzipped);
        }
        request.post(body);
        return request.build();
    }

    static void parseResponse(Response response) throws IOException {
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            if (response.isSuccessful()) {
                return;
            }
            throw new RuntimeException("response failed: " + response);
        }
        try {
            BufferedSource content = responseBody.source();
            if ("gzip".equalsIgnoreCase(response.header("Content-Encoding"))) {
                content = Okio.buffer((Source)new GzipSource((Source)responseBody.source()));
            }
            if (!response.isSuccessful()) {
                throw new RuntimeException("response for " + response.request().tag() + " failed: " + content.readUtf8());
            }
        }
        finally {
            responseBody.close();
        }
    }

    @Override
    protected void doClose() {
        Dispatcher dispatcher = this.client.dispatcher();
        dispatcher.executorService().shutdown();
        try {
            if (!dispatcher.executorService().awaitTermination(1L, TimeUnit.SECONDS)) {
                dispatcher.cancelAll();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    static Dispatcher newDispatcher(int maxRequests) {
        ThreadPoolExecutor dispatchExecutor = new ThreadPoolExecutor(0, maxRequests, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), OkHttpSenderThreadFactory.INSTANCE);
        Dispatcher dispatcher = new Dispatcher((ExecutorService)dispatchExecutor);
        dispatcher.setMaxRequests(maxRequests);
        dispatcher.setMaxRequestsPerHost(maxRequests);
        return dispatcher;
    }

    @Override
    public String toString() {
        return super.toString().replace("Internal", "");
    }

    static enum OkHttpSenderThreadFactory implements ThreadFactory
    {
        INSTANCE;


        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "OkHttpSender Dispatcher");
        }
    }

    static final class BufferRequestBody
    extends RequestBody {
        final MediaType contentType;
        final Buffer body;

        BufferRequestBody(MediaType contentType, Buffer body) {
            this.contentType = contentType;
            this.body = body;
        }

        public long contentLength() {
            return this.body.size();
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            sink.write(this.body, this.body.size());
        }
    }
}

