/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.InvalidAddOperation;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemReference;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.ReferenceCollection;
import com.ibm.ws.sib.msgstore.ReferenceConsistencyViolation;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.StreamIsFull;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.ras.SibTr;

public class ReferenceStream
extends AbstractItem {
    private static TraceComponent tc = SibTr.register(ReferenceStream.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");

    public void add(ItemReference ref, long lockID, Transaction transaction) throws ProtocolException, OutOfCacheSpace, StreamIsFull, TransactionException, PersistenceException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"add", (Object)new Object[]{ref, lockID, transaction});
        }
        if (null == this._getMembership()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"add");
            }
            throw new InvalidAddOperation("STREAM_NOT_STORED_SIMS0004", new Object[]{ref, this});
        }
        if (null != ref._getMembership()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"add");
            }
            throw new InvalidAddOperation("STREAM_ADD_CONFLICT_SIMS0005", new Object[]{ref, this});
        }
        Item item = ref.getReferredItem();
        if (null == item) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"add");
            }
            throw new ReferenceConsistencyViolation("REFERENCE_CONSISTENCY_SIMS0003", new Object[]{ref, this});
        }
        ReferenceCollection ic = (ReferenceCollection)this._getMembership();
        ic.addReference(ref, lockID, transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"add");
        }
    }

    public void add(ItemReference ref, Transaction transaction) throws ProtocolException, OutOfCacheSpace, StreamIsFull, TransactionException, PersistenceException, SevereMessageStoreException {
        long lockId = -2L;
        if (ref.getDeliveryDelay() > 0L) {
            lockId = -56789L;
        }
        this.add(ref, lockId, transaction);
    }

    public void eventWatermarkBreached() {
    }

    public final AbstractItem findById(long itemId) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findById", (Object)itemId);
        }
        AbstractItem item = null;
        ReferenceCollection ic = (ReferenceCollection)this._getMembership();
        if (null == ic) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"findById");
            }
            throw new NotInMessageStore();
        }
        item = ic.findById(itemId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findById", (Object)item);
        }
        return item;
    }

    public final ItemReference findFirstMatching(Filter filter) throws MessageStoreException {
        ReferenceCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatching", (Object)filter);
        }
        if (null == (ic = (ReferenceCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatching");
            }
            throw new NotInMessageStore();
        }
        ItemReference item = null;
        if (ic != null) {
            item = (ItemReference)ic.findFirstMatching(filter);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatching", (Object)item);
        }
        return item;
    }

    public final ItemReference findOldestReference() throws MessageStoreException {
        ReferenceCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findOldestReference");
        }
        if (null == (ic = (ReferenceCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"findOldestReference");
            }
            throw new NotInMessageStore();
        }
        ItemReference item = null;
        if (ic != null) {
            item = (ItemReference)ic.findOldestItem();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findOldestReference", (Object)item);
        }
        return item;
    }

    public long getByteHighWaterMark() {
        return -1L;
    }

    public long getByteLowWaterMark() {
        return -1L;
    }

    public long getCountHighWaterMark() {
        return -1L;
    }

    public long getCountLowWaterMark() {
        return -1L;
    }

    public final ItemStream getItemStream() throws SevereMessageStoreException {
        ReferenceCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getItemStream");
        }
        if (null == (ic = (ReferenceCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getItemStream");
            }
            throw new NotInMessageStore();
        }
        ItemStream itemStream = null;
        if (null != ic) {
            itemStream = ic.getOwningItemStream();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getItemStream", (Object)itemStream);
        }
        return itemStream;
    }

    @Override
    public long getMaximumTimeInStore() {
        return -2L;
    }

    public final Statistics getStatistics() throws SevereMessageStoreException {
        ReferenceCollection ic = (ReferenceCollection)this._getMembership();
        if (null == ic) {
            throw new NotInMessageStore();
        }
        return ic.getStatistics();
    }

    @Override
    public final boolean isCollection() {
        return true;
    }

    @Override
    public final boolean isReferenceStream() {
        return true;
    }

    public boolean isSpilling() throws NotInMessageStore {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isSpilling");
        }
        boolean spilling = false;
        ReferenceCollection ic = (ReferenceCollection)this._getMembership();
        if (null == ic) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"isSpilling");
            }
            throw new NotInMessageStore();
        }
        if (null != ic) {
            spilling = ic.isSpilling();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isSpilling", (Object)spilling);
        }
        return spilling;
    }

    public final LockingCursor newLockingCursor(Filter filter) throws MessageStoreException {
        return this.newLockingCursor(filter, true);
    }

    public final LockingCursor newLockingCursor(Filter filter, boolean jumpbackEnabled) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newLockingCursor", (Object)new Object[]{filter, jumpbackEnabled});
        }
        ReferenceCollection rc = (ReferenceCollection)this._getMembership();
        LockingCursor cursor = null;
        if (null == rc) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"newLockingCursor");
            }
            throw new NotInMessageStore();
        }
        if (rc != null) {
            cursor = rc.newLockingCursor(filter, jumpbackEnabled);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newLockingCursor", (Object)cursor);
        }
        return cursor;
    }

    public final NonLockingCursor newNonLockingCursor(Filter filter) throws MessageStoreException {
        ReferenceCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newNonLockingCursor");
        }
        if (null == (ic = (ReferenceCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingCursor");
            }
            throw new NotInMessageStore();
        }
        NonLockingCursor cursor = null;
        if (ic != null) {
            cursor = ic.newNonLockingCursor(filter);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingCursor", (Object)cursor);
        }
        return cursor;
    }

    public final ItemReference removeFirstMatching(Filter filter, Transaction transaction) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatching", (Object)new Object[]{filter, transaction});
        }
        ReferenceCollection ic = (ReferenceCollection)this._getMembership();
        ItemReference item = null;
        if (ic != null) {
            item = (ItemReference)ic.removeFirstMatching(filter, transaction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatching", (Object)item);
        }
        return item;
    }

    public final void setWatermarks(long countLow, long countHigh, long bytesLow, long bytesHigh) throws NotInMessageStore {
        ReferenceCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setWatermarks", (Object)new Object[]{countLow, countHigh, bytesLow, bytesHigh});
        }
        if (null == (ic = (ReferenceCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setWatermarks");
            }
            throw new NotInMessageStore();
        }
        if (null != ic) {
            ic.setWatermarks(countLow, countHigh, bytesLow, bytesHigh);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setWatermarks");
        }
    }
}

