/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.serialization.SerializationService;
import com.ibm.ws.session.store.cache.CacheHashMap;
import com.ibm.ws.session.store.common.BackedHashMap;
import com.ibm.ws.session.store.common.BackedSession;
import com.ibm.wsspi.session.IStoreCallback;
import jakarta.transaction.UserTransaction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CacheSession
extends BackedSession {
    private static final TraceComponent tc = Tr.register(CacheSession.class, null, (String)"com.ibm.ws.session.store.cache.resources.WASSessionCache");
    private Map<Object, Object> mSwappableData;
    private boolean populatedAppData;
    static final long serialVersionUID = 6733822737134533008L;

    CacheSession() {
    }

    public CacheSession(CacheHashMap sessions, String id, IStoreCallback storeCallback) {
        super((BackedHashMap)sessions, id, storeCallback);
    }

    public synchronized Enumeration getAttributeNames() {
        if (!this.populatedAppData) {
            this.getMultiRowAppData();
        }
        return super.getAttributeNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMultiRowAppData() {
        this.populatedAppData = true;
        Map<Object, Object> swappable = this.getSwappableData();
        Hashtable props = (Hashtable)((CacheHashMap)this.getSessions()).getAllValues(this);
        if (props != null) {
            Enumeration kys = props.keys();
            while (kys.hasMoreElements()) {
                Object key = kys.nextElement();
                swappable.put(key, props.get(key));
            }
            Hashtable hashtable = this._attributeNames;
            synchronized (hashtable) {
                this.refillAttrNames(swappable);
            }
        }
    }

    boolean getPopulatedAppData() {
        return this.populatedAppData;
    }

    protected SerializationService getSerializationService() {
        return ((CacheHashMap)this.getSessions()).cacheStoreService.serializationService;
    }

    public Map<Object, Object> getSwappableData() {
        if (this.mSwappableData == null) {
            this.mSwappableData = new ConcurrentHashMap<Object, Object>();
            if (this.isNew()) {
                this.populatedAppData = true;
            }
        }
        return this.mSwappableData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSwappableListeners(short requestedListener) {
        short thisListenerFlag = this.getListenerFlag();
        boolean rc = false;
        if (thisListenerFlag == requestedListener || thisListenerFlag == 3) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("loading data because we have listener match for " + requestedListener), (Object[])new Object[0]);
            }
            rc = true;
            if (!this.populatedAppData) {
                try {
                    this.getSessions().getIStore().setThreadContext();
                    this.getMultiRowAppData();
                }
                finally {
                    this.getSessions().getIStore().unsetThreadContext();
                }
            }
        }
        return rc;
    }

    protected UserTransaction getUserTransaction() {
        return ((CacheHashMap)this.getSessions()).cacheStoreService.userTransaction;
    }

    public void setSwappableData(Map<Object, Object> ht) {
        this.mSwappableData = ht;
    }
}

