/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.tcpchannel;

import com.ibm.wsspi.tcpchannel.TCPConnectRequestContext;
import java.net.InetSocketAddress;

public class TCPConnectRequestContextFactory {
    private static TCPConnectRequestContextFactory instanceRef = null;

    public TCPConnectRequestContext createTCPConnectRequestContext(String _localHostName, int _localPort, String _remoteHostName, int _remotePort, int _timeout) {
        return new TCPConnectRequestContextImpl(_localHostName, _localPort, _remoteHostName, _remotePort, _timeout);
    }

    public TCPConnectRequestContext createTCPConnectRequestContext(String _remoteHostName, int _remotePort, int _timeout) {
        return new TCPConnectRequestContextImpl(_remoteHostName, _remotePort, _timeout);
    }

    private static synchronized void createSingleton() {
        if (null == instanceRef) {
            instanceRef = new TCPConnectRequestContextFactory();
        }
    }

    public static TCPConnectRequestContextFactory getRef() {
        if (instanceRef == null) {
            TCPConnectRequestContextFactory.createSingleton();
        }
        return instanceRef;
    }

    public static class TCPConnectRequestContextImpl
    implements TCPConnectRequestContext {
        private InetSocketAddress localAddress = null;
        private InetSocketAddress remoteAddress = null;
        private int timeout;

        public TCPConnectRequestContextImpl(String _localHostName, int _localPort, String _remoteHostName, int _remotePort, int _timeout) {
            this.timeout = _timeout;
            this.localAddress = _localHostName != null ? new InetSocketAddress(_localHostName, _localPort) : new InetSocketAddress(_localPort);
            this.remoteAddress = _remoteHostName != null ? new InetSocketAddress(_remoteHostName, _remotePort) : new InetSocketAddress(_remotePort);
        }

        public TCPConnectRequestContextImpl(String _remoteHostName, int _remotePort, int _timeout) {
            this.timeout = _timeout;
            this.remoteAddress = _remoteHostName != null ? new InetSocketAddress(_remoteHostName, _remotePort) : new InetSocketAddress(_remotePort);
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            return this.localAddress;
        }

        @Override
        public InetSocketAddress getRemoteAddress() {
            return this.remoteAddress;
        }

        @Override
        public int getConnectTimeout() {
            return this.timeout;
        }
    }
}

