/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebErrorHandler {
    private static final String ERROR_PAGE_HTML_TITLE = "HTTP Error Message";
    private static final TraceComponent tc = Tr.register(WebErrorHandler.class, (String)"SecurityCommon", (String)"com.ibm.ws.security.common.internal.resources.SSOCommonMessages");
    static final long serialVersionUID = 732393444469355769L;

    /*
     * WARNING - void declaration
     */
    public void writeErrorHtml(HttpServletResponse response, String errorHeader, String errorMessage) {
        block2: {
            try {
                PrintWriter out = response.getWriter();
                out.println(this.getErrorPageHtml(errorHeader, errorMessage));
                out.flush();
            }
            catch (IOException out) {
                void e;
                FFDCFilter.processException((Throwable)out, (String)"com.ibm.ws.security.common.web.WebErrorHandler", (String)"38", (Object)this, (Object[])new Object[]{response, errorHeader, errorMessage});
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Failed to obtain writer for response to write exception: " + e), (Object[])new Object[0]);
            }
        }
    }

    public String getErrorPageHtml(String errorHeader, String errorMessage) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append(this.getErrorPageHead());
        sb.append(this.getErrorPageBody(errorHeader, errorMessage));
        sb.append("</html>");
        return sb.toString();
    }

    String getErrorPageHead() {
        StringBuffer sb = new StringBuffer();
        sb.append("<head>");
        sb.append("<meta http-equiv=\"Pragma\" content=\"no-cache\"/>");
        sb.append("<title>");
        sb.append(ERROR_PAGE_HTML_TITLE);
        sb.append("</title>");
        sb.append(this.createCssContentString());
        sb.append("</head>");
        return sb.toString();
    }

    String createCssContentString() {
        StringBuilder css = new StringBuilder();
        css.append("<style>");
        css.append("body {");
        css.append("background-color: #152935;");
        css.append("font-family: serif;");
        css.append("margin: 0;");
        css.append("}\n");
        css.append("#top, #bottom {");
        css.append("padding: 20px;");
        css.append("}\n");
        css.append("");
        css.append("#top-middle, #bottom-middle {");
        css.append("background-color: #001428;");
        css.append("padding: 10px;");
        css.append("}\n");
        css.append("");
        css.append(".container {");
        css.append("background-color: white;");
        css.append("padding: 20px 50px;");
        css.append("}\n");
        css.append(".error {");
        css.append("color: red;");
        css.append("font-weight: bold;");
        css.append("}\n");
        css.append("</style>");
        return css.toString();
    }

    String getErrorPageBody(String errorHeader, String errorMessage) {
        StringBuffer sb = new StringBuffer();
        sb.append("<body>");
        sb.append("<div class=\"wrapper\"></div>");
        sb.append("<div id=\"top\"></div>");
        sb.append("<div id=\"top-middle\"></div>");
        sb.append("<div class=\"container\">");
        sb.append("<h1>");
        sb.append(errorHeader);
        sb.append("</h1>");
        sb.append("<span class=\"error\">");
        sb.append("Error: " + errorMessage);
        sb.append("</span>");
        sb.append("</div>");
        sb.append("<div id=\"bottom-middle\"></div>");
        sb.append("<div id=\"bottom\"></div>");
        sb.append("</div>");
        sb.append("</body>");
        return sb.toString();
    }
}

