/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver;

import com.ibm.ws.repository.resolver.internal.LibertyVersionRange;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import wlp.lib.extract.ProductMatch;
import wlp.lib.extract.SelfExtractor;

public class ProductRequirementInformation {
    public final LibertyVersionRange versionRange;
    public final String productId;
    public final String installType;
    public final String licenseType;
    public final List<String> editions;

    public ProductRequirementInformation(String versionRange, String productId, String installType, String licenseType, List<String> editions) {
        this.versionRange = LibertyVersionRange.valueOf(versionRange);
        this.productId = productId;
        this.installType = installType;
        this.licenseType = licenseType;
        this.editions = editions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.editions == null ? 0 : this.editions.hashCode());
        result = 31 * result + (this.installType == null ? 0 : this.installType.hashCode());
        result = 31 * result + (this.licenseType == null ? 0 : this.licenseType.hashCode());
        result = 31 * result + (this.productId == null ? 0 : this.productId.hashCode());
        result = 31 * result + (this.versionRange == null ? 0 : this.versionRange.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductRequirementInformation other = (ProductRequirementInformation)obj;
        if (this.editions == null ? other.editions != null : !this.editions.equals(other.editions)) {
            return false;
        }
        if (this.installType == null ? other.installType != null : !this.installType.equals(other.installType)) {
            return false;
        }
        if (this.licenseType == null ? other.licenseType != null : !this.licenseType.equals(other.licenseType)) {
            return false;
        }
        if (this.productId == null ? other.productId != null : !this.productId.equals(other.productId)) {
            return false;
        }
        return !(this.versionRange == null ? other.versionRange != null : !this.versionRange.equals(other.versionRange));
    }

    public String toString() {
        return "ProductInformation [versionRange=" + this.versionRange + ", productId=" + this.productId + ", installType=" + this.installType + ", licenseType=" + this.licenseType + ", editions=" + this.editions + "]";
    }

    public static List<ProductRequirementInformation> createFromAppliesTo(String appliesTo) {
        if (appliesTo == null || appliesTo.isEmpty()) {
            throw new InvalidParameterException("Applies to must be set to a valid value but is " + appliesTo);
        }
        ArrayList<ProductRequirementInformation> products = new ArrayList<ProductRequirementInformation>();
        List matchers = SelfExtractor.parseAppliesTo((String)appliesTo);
        for (ProductMatch match : matchers) {
            String productId = match.getProductId();
            String version = match.getVersion();
            String versionRange = version != null && version.endsWith("+") ? version.substring(0, version.length() - 1) : (version != null ? Character.toString('[') + version + ", " + version + Character.toString(']') : null);
            String installType = match.getInstallType();
            String licenseType = match.getLicenseType();
            List editions = match.getEditions();
            products.add(new ProductRequirementInformation(versionRange, productId, installType, licenseType, editions));
        }
        return products;
    }
}

