/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.ClassExtractor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.sessions.Session;

public class MethodClassExtractor
extends ClassExtractor {
    protected transient ClassDescriptor descriptor;
    protected String classExtractionMethodName;
    protected transient Method classExtractionMethod;

    public Method getClassExtractionMethod() {
        return this.classExtractionMethod;
    }

    public String getClassExtractionMethodName() {
        return this.classExtractionMethodName;
    }

    protected void setClassExtractionMethod(Method classExtractionMethod) {
        this.classExtractionMethod = classExtractionMethod;
    }

    public void setClassExtractionMethodName(String staticClassClassExtractionMethod) {
        this.classExtractionMethodName = staticClassClassExtractionMethod;
    }

    @Override
    public void initialize(ClassDescriptor descriptor, Session session) throws DescriptorException {
        this.setDescriptor(descriptor);
        Class[] declarationParameters = new Class[]{ClassConstants.DatabaseRow_Class};
        try {
            this.setClassExtractionMethod(Helper.getDeclaredMethod(descriptor.getJavaClass(), this.getClassExtractionMethodName(), declarationParameters));
        }
        catch (NoSuchMethodException ignore) {
            declarationParameters[0] = ClassConstants.Record_Class;
            try {
                this.setClassExtractionMethod(Helper.getDeclaredMethod(descriptor.getJavaClass(), this.getClassExtractionMethodName(), declarationParameters));
            }
            catch (NoSuchMethodException exception) {
                throw DescriptorException.noSuchMethodWhileInitializingClassExtractionMethod(this.getClassExtractionMethodName(), descriptor, exception);
            }
            catch (SecurityException exception) {
                throw DescriptorException.securityWhileInitializingClassExtractionMethod(this.getClassExtractionMethodName(), descriptor, exception);
            }
        }
        catch (SecurityException exception) {
            throw DescriptorException.securityWhileInitializingClassExtractionMethod(this.getClassExtractionMethodName(), descriptor, exception);
        }
        if (!Modifier.isStatic(this.getClassExtractionMethod().getModifiers())) {
            throw DescriptorException.classExtractionMethodMustBeStatic(this.getClassExtractionMethodName(), descriptor);
        }
    }

    @Override
    public <T> Class<T> extractClassFromRow(DataRecord row, Session session) {
        return PrivilegedAccessHelper.callDoPrivilegedWithException(() -> (Class)PrivilegedAccessHelper.invokeMethod(this.getClassExtractionMethod(), null, new Object[]{row}), ex -> {
            if (ex instanceof IllegalAccessException) {
                return DescriptorException.illegalAccessWhileInvokingRowExtractionMethod((AbstractRecord)row, this.getClassExtractionMethod(), this.getDescriptor(), ex);
            }
            if (ex instanceof InvocationTargetException) {
                return DescriptorException.targetInvocationWhileInvokingRowExtractionMethod((AbstractRecord)row, this.getClassExtractionMethod(), this.getDescriptor(), ex);
            }
            throw new RuntimeException(String.format("Invocation of %s method failed", this.getClassExtractionMethod().getName()), ex);
        });
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }
}

