/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.jmf.JMFDynamicType;
import com.ibm.ws.sib.mfp.jmf.JMFEncapsulation;
import com.ibm.ws.sib.mfp.jmf.JMFEncapsulationManager;
import com.ibm.ws.sib.mfp.jmf.JMFMessageCorruptionException;
import com.ibm.ws.sib.mfp.jmf.JMFMessageData;
import com.ibm.ws.sib.mfp.jmf.JMFModelNotImplementedException;
import com.ibm.ws.sib.mfp.jmf.JMFPart;
import com.ibm.ws.sib.mfp.jmf.JMFRegistry;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFType;
import com.ibm.ws.sib.mfp.jmf.JMFUninitializedAccessException;
import com.ibm.ws.sib.mfp.jmf.JmfTr;
import com.ibm.ws.sib.mfp.jmf.impl.JSField;
import com.ibm.ws.sib.mfp.jmf.impl.JSListCoder;
import com.ibm.ws.sib.mfp.jmf.impl.JSMessageImpl;
import com.ibm.ws.sib.mfp.jmf.impl.JSType;
import com.ibm.ws.sib.mfp.jmf.impl.JSchema;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import java.util.Map;
import java.util.Set;

public final class JSDynamic
extends JSField
implements JMFDynamicType {
    private static TraceComponent tc = JmfTr.register(JSDynamic.class, "SIBJmf", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private JSType expectedType;
    private JSchema expectedSchema;

    @Override
    public JMFType getExpectedType() {
        return this.expectedType;
    }

    public JSchema getExpectedSchema(Map context) {
        if (this.expectedSchema != null) {
            return this.expectedSchema;
        }
        if (this.expectedType == null) {
            return null;
        }
        this.expectedSchema = (JSchema)context.get(this.expectedType);
        if (this.expectedSchema != null) {
            return this.expectedSchema;
        }
        this.expectedSchema = new JSchema(this.expectedType, context);
        return this.expectedSchema;
    }

    @Override
    public JMFSchema getExpectedSchema() {
        return this.expectedSchema;
    }

    @Override
    public void setExpectedType(JMFType expect) {
        this.expectedType = (JSType)expect;
    }

    @Override
    public void format(StringBuffer fmt, Set done, Set todo, int indent) {
        this.formatName(fmt, indent);
        if (this.expectedType == null) {
            fmt.append("Dynamic");
        } else {
            String name = this.expectedType.getFeatureName();
            fmt.append("<").append(name).append(">");
            if (!done.contains(this.expectedType)) {
                todo.add(this.expectedType);
            }
        }
    }

    @Override
    public int getEncodedLength(Object val, int indirect, JMFMessageData msg) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        if (val instanceof JSMessageImpl) {
            return 16 + ((JSMessageImpl)val).getEncodedLength();
        }
        return 8 + ((JMFEncapsulation)val).getEncapsulatedLength(msg);
    }

    @Override
    public Object validate(Object val, int indirect) throws JMFSchemaViolationException {
        if (val instanceof JMFPart) {
            return val;
        }
        throw new JMFSchemaViolationException("Value is not of Dynamic type");
    }

    @Override
    public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        int len;
        JMFPart part = (JMFPart)val;
        ArrayUtil.writeInt(frame, offset + 4, part.getModelID());
        if (part instanceof JSMessageImpl) {
            ArrayUtil.writeLong(frame, offset + 8, part.getJMFSchema().getID());
            JSMessageImpl msgi = (JSMessageImpl)part;
            len = 16 + msgi.toByteArray(frame, offset + 16);
        } else {
            JMFEncapsulation encap = (JMFEncapsulation)part;
            len = encap.getEncapsulatedLength(msg);
            len = 8 + encap.encapsulate(frame, offset + 8, len, msg);
        }
        ArrayUtil.writeInt(frame, offset, len - 4);
        return offset + len;
    }

    @Override
    public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        int length = ArrayUtil.readInt(frame, offset);
        JSListCoder.evaluateMessageLength(length, frame, offset);
        int model = ArrayUtil.readInt(frame, offset + 4);
        if (model == 0) {
            length -= 12;
            long schemaId = ArrayUtil.readLong(frame, offset + 8);
            JSchema schema = (JSchema)JMFRegistry.instance.retrieve(schemaId);
            if (schema == null) {
                throw new JMFSchemaViolationException("No schema: " + schemaId);
            }
            return new JSMessageImpl(schema, frame, offset + 16, length, false);
        }
        JMFEncapsulationManager mgr = JMFRegistry.instance.retrieve(model);
        if (mgr == null) {
            throw new JMFModelNotImplementedException("No encapsulation manager for model: " + model);
        }
        return mgr.deencapsulate(frame, offset + 8, length -= 4, msg);
    }

    @Override
    public Object copy(Object val, int indirect) throws JMFSchemaViolationException {
        if (val instanceof JSMessageImpl) {
            return ((JSMessageImpl)val).getCopy();
        }
        return ((JMFEncapsulation)val).copy();
    }

    @Override
    public int estimateUnassembledSize(Object val) {
        return 500;
    }

    @Override
    public int estimateUnassembledSize(byte[] frame, int offset) {
        return 500 + ArrayUtil.readInt(frame, offset);
    }

    @Override
    public int encodedTypeLength() {
        return 1;
    }

    @Override
    public void encodeType(byte[] frame, int[] limits) {
        JSDynamic.setByte(frame, limits, (byte)1);
    }
}

