/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.url.WSJarURLConnection;
import com.ibm.ws.classloading.configuration.GlobalClassloadingConfiguration;
import com.ibm.ws.classloading.internal.LibertyLoader;
import com.ibm.ws.classloading.internal.NativeLibrary;
import com.ibm.ws.classloading.internal.NativeLibraryAdapter;
import com.ibm.ws.classloading.internal.Util;
import com.ibm.ws.classloading.internal.util.ClassRedefiner;
import com.ibm.ws.classloading.internal.util.Keyed;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.boot.classloader.ClassLoaderHook;
import com.ibm.ws.kernel.boot.classloader.ClassLoaderHookFactory;
import com.ibm.ws.kernel.feature.ServerStarted;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.kernel.service.util.ServiceCaller;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.util.CacheHashMap;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.Notifier;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import com.ibm.wsspi.kernel.service.utils.CompositeEnumeration;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
abstract class ContainerClassLoader
extends LibertyLoader
implements Keyed<ClassLoaderIdentity> {
    private static final boolean disableSharedClassesCache = Boolean.getBoolean("liberty.disableApplicationClassSharing");
    static final CheckpointPhase checkpointPhase = CheckpointPhase.getPhase();
    static final TraceComponent tc;
    private volatile SmartClassPath smartClassPath;
    private final List<UniversalContainer> nativeLibraryContainers = new ArrayList<UniversalContainer>();
    private final ClassRedefiner redefiner;
    final String jarProtocol;
    private final ClassLoaderHook hook;
    protected static final ExecutorService mapCreationQueue;
    private static ServiceCaller<ArtifactContainerFactory> acf;
    static final long serialVersionUID = 8193250483852414133L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private static byte[] getBytes(InputStream stream, int knownSize) throws IOException {
        int read;
        if (knownSize == -1) {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            try {
                int read2;
                byte[] bytes = new byte[1024];
                while (0 <= (read2 = stream.read(bytes))) {
                    byteOut.write(bytes, 0, read2);
                }
                byte[] byArray = byteOut.toByteArray();
                return byArray;
            }
            finally {
                Util.tryToClose(byteOut);
            }
        }
        byte[] bytes = new byte[knownSize];
        int offset = 0;
        while (knownSize > 0 && (read = stream.read(bytes, offset, knownSize)) > 0) {
            offset += read;
            knownSize -= read;
        }
        byte[] byArray = bytes;
        return byArray;
        finally {
            Util.tryToClose(stream);
        }
    }

    static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    public ContainerClassLoader(List<Container> classpath, ClassLoader parent, ClassRedefiner redefiner, GlobalClassloadingConfiguration config) {
        super(parent);
        this.jarProtocol = config.useJarUrls() ? "jar:" : "wsjar:";
        JarCacheDisabler.disableJarCaching();
        this.hook = disableSharedClassesCache ? null : ClassLoaderHookFactory.getClassLoaderHook((ClassLoader)this);
        this.smartClassPath = new UnreadSmartClassPath(this.hook);
        if (classpath != null) {
            for (Container c : classpath) {
                this.smartClassPath.addContainer(c);
            }
        }
        this.redefiner = redefiner;
    }

    @Override
    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (url != null) {
            return url;
        }
        url = this.smartClassPath.getResourceURL(name, this.jarProtocol);
        if (url == null && !name.endsWith("/") && (url = super.findResource(name)) != null) {
            url = ContainerClassLoader.stripTrailingSlash(url);
        }
        return url;
    }

    public CompositeEnumeration<URL> findResources(String name) throws IOException {
        CompositeEnumeration enumerations = new CompositeEnumeration(super.findResources(name));
        Collection<URL> urls = this.smartClassPath.getResourceURLs(name, this.jarProtocol);
        if (!name.endsWith("/")) {
            enumerations.add(super.findResources(name + "/"));
            HashMap<String, URL> resourceMap = new HashMap<String, URL>();
            URL url = null;
            while (enumerations.hasMoreElements()) {
                url = ContainerClassLoader.stripTrailingSlash((URL)enumerations.nextElement());
                resourceMap.put(url.toExternalForm(), url);
            }
            enumerations = new CompositeEnumeration(Collections.enumeration(resourceMap.values()));
        }
        enumerations.add(Collections.enumeration(urls));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            int i = 0;
            StringBuilder sb = new StringBuilder();
            ArrayList<URL> urlList = new ArrayList<URL>();
            while (enumerations.hasMoreElements()) {
                URL url = (URL)enumerations.nextElement();
                urlList.add(url);
                sb.append("\n  ").append(url);
                ++i;
            }
            sb.append("\n  ").append("Total elements: ").append(i);
            enumerations = new CompositeEnumeration(Collections.enumeration(urlList));
            Tr.debug((TraceComponent)tc, (String)sb.toString(), (Object[])new Object[0]);
        }
        return enumerations;
    }

    @Override
    protected String findLibrary(String libName) {
        String mappedName = System.mapLibraryName(libName);
        for (UniversalContainer uc : this.nativeLibraryContainers) {
            String path;
            UniversalContainer.UniversalResource ur = uc.getResource(mappedName);
            if (ur == null || (path = ur.getNativeLibraryPath()) == null) continue;
            return path;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    final ByteResourceInformation findClassBytes(String className, String resourceName) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            ByteResourceInformation byteResourceInformation = this.smartClassPath.getByteResourceInformation(className, resourceName, this.hook);
            return byteResourceInformation;
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader", (String)"1930", (Object)this, (Object[])new Object[]{className, resourceName});
            Tr.error((TraceComponent)tc, (String)"cls.class.file.not.readable", (Object[])new Object[]{className, resourceName});
            String message = String.format("Could not read class '%s' as resource '%s'", className, resourceName);
            ClassFormatError error = new ClassFormatError(message);
            error.initCause((Throwable)e);
            throw error;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    protected final void addToClassPath(Iterable<ArtifactContainer> artifacts, boolean prepend) {
        this.smartClassPath.addArtifactContainers(artifacts, prepend);
    }

    @FFDCIgnore(value={IllegalStateException.class})
    protected void addLibraryFile(final File f) {
        if (!ContainerClassLoader.exists(f)) {
            if (tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"cls.library.archive", (Object[])new Object[]{f, new FileNotFoundException(f.getName())});
            }
            return;
        }
        if (!ContainerClassLoader.isDirectory(f) && !this.isArchive(f)) {
            return;
        }
        BundleContext bc = FrameworkUtil.getBundle(ContainerClassLoader.class).getBundleContext();
        File dataFile = null;
        try {
            dataFile = bc == null ? null : bc.getDataFile("");
        }
        catch (IllegalStateException e) {
            Tr.debug((TraceComponent)tc, (String)"Invalid context. Liberty is likely shutting down.", (Object[])new Object[0]);
            return;
        }
        if (dataFile == null) {
            Tr.debug((TraceComponent)tc, (String)"Context returned null data file.", (Object[])new Object[0]);
            return;
        }
        final File df = dataFile;
        acf.call((Consumer)new Consumer<ArtifactContainerFactory>(){
            static final long serialVersionUID = -5059248947527210084L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void accept(ArtifactContainerFactory factory) {
                ArtifactContainer ac = factory.getContainer(df, (Object)f);
                if (ac == null) {
                    Tr.info((TraceComponent)tc, (String)"cls.library.file.forbidden", (Object[])new Object[]{f});
                } else {
                    ContainerClassLoader.this.smartClassPath.addArtifactContainer(ac);
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$3", 3.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        });
    }

    protected void addNativeLibraryContainer(Container container) {
        this.nativeLibraryContainers.add(new ContainerUniversalContainer(container, this.hook));
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private boolean isArchive(File f) {
        final File target = f;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){
                static final long serialVersionUID = -3198341696021680289L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() throws IOException {
                    new ZipFile(target).close();
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$4", 4.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception innerException = e.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The following file can not be added to the classpath " + f + " due to error "), (Object[])new Object[]{innerException});
            }
            return false;
        }
        return true;
    }

    protected void lazyInit() {
    }

    private static URL stripTrailingSlash(URL url) {
        String externalForm = url.toExternalForm();
        if (externalForm.endsWith("/")) {
            externalForm = externalForm.substring(0, externalForm.length() - 1);
            try {
                url = new URL(externalForm);
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader", (String)"2049", null, (Object[])new Object[]{url});
            }
        }
        return url;
    }

    /*
     * WARNING - void declaration
     */
    public boolean redefineClasses(Notifier.Notification notification) {
        boolean success;
        if (notification.getPaths().isEmpty()) {
            return true;
        }
        Container container = notification.getContainer();
        if (!this.smartClassPath.containsContainer(container)) {
            success = true;
        } else {
            ArrayList<String> classFilePaths = new ArrayList<String>();
            for (String path : notification.getPaths()) {
                if (!path.endsWith(".class")) continue;
                classFilePaths.add(path);
            }
            if (classFilePaths.isEmpty()) {
                return true;
            }
            if (this.redefiner != null && this.redefiner.canRedefine()) {
                success = true;
                HashSet<ClassDefinition> classesToRedefine = new HashSet<ClassDefinition>();
                for (String path : classFilePaths) {
                    String className = ContainerClassLoader.convertToClassName(path);
                    Class<?> clazz = this.findLoadedClass(className);
                    if (clazz != null && clazz.getClassLoader() == this) {
                        try {
                            InputStream is = (InputStream)container.getEntry(path).adapt(InputStream.class);
                            byte[] classBytes = ContainerClassLoader.loadBytes(is);
                            ClassDefinition def = new ClassDefinition(clazz, classBytes);
                            classesToRedefine.add(def);
                            continue;
                        }
                        catch (Exception is) {
                            void e;
                            FFDCFilter.processException((Throwable)is, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader", (String)"2118", (Object)this, (Object[])new Object[]{notification});
                            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".redefineClasses"), (String)"1557", (Object)this, (Object[])new Object[]{className, notification.getContainer(), path});
                            success = false;
                            break;
                        }
                    }
                    if (clazz != null) continue;
                    return false;
                }
                if (success && !classesToRedefine.isEmpty()) {
                    success = this.redefiner.redefineClasses(classesToRedefine);
                }
            } else {
                success = false;
            }
        }
        return success;
    }

    private static String convertToClassName(String fileName) {
        String className = fileName.replace(".class", "");
        className = className.replace("WEB-INF/classes/", "");
        className = className.replace('/', '.');
        if ((className = className.replace('\\', '.')).startsWith(".")) {
            className = className.substring(1);
        }
        return className;
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private static byte[] loadBytes(final InputStream is) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){
                static final long serialVersionUID = 191173505348069700L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @Trivial
                public byte[] run() throws IOException {
                    byte[] buf = new byte[2048];
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        int bytesRead = is.read(buf);
                        while (bytesRead > -1) {
                            baos.write(buf, 0, bytesRead);
                            bytesRead = is.read(buf);
                        }
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                    return baos.toByteArray();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$5", 5.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    @Trivial
    Collection<Collection<URL>> getClassPath() {
        return this.smartClassPath.getClassPath();
    }

    static boolean exists(final File f) {
        return System.getSecurityManager() == null ? f.exists() : AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 6282267603384434588L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return f.exists();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$6", 6.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        }).booleanValue();
    }

    static boolean isDirectory(final File f) {
        return System.getSecurityManager() == null ? f.isDirectory() : AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 7286420153888324341L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return f.isDirectory();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$7", 7.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        }).booleanValue();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        ClassLoader.registerAsParallelCapable();
        tc = Tr.register(ContainerClassLoader.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        mapCreationQueue = Executors.newSingleThreadExecutor(new ThreadFactory(){
            static final long serialVersionUID = -5799275501645335577L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("ClassloaderMapProcessing" + t.getName());
                return t;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"CCL: blocking the new map building thread", (Object[])new Object[0]);
        }
        mapCreationQueue.submit(new Runnable(){
            static final long serialVersionUID = 6253493480160996126L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void run() {
                block4: {
                    BundleContext bc;
                    Bundle b = FrameworkUtil.getBundle(ContainerClassLoader.class);
                    if (b != null && (bc = b.getBundleContext()) != null) {
                        ServiceTracker st = new ServiceTracker(bc, ServerStarted.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ServerStarted, ServerStarted>(){
                            static final long serialVersionUID = -6003806214263243709L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            public ServerStarted addingService(ServiceReference<ServerStarted> arg0) {
                                return null;
                            }

                            public void modifiedService(ServiceReference<ServerStarted> arg0, ServerStarted arg1) {
                            }

                            public void removedService(ServiceReference<ServerStarted> arg0, ServerStarted arg1) {
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$2$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                            }
                        });
                        try {
                            st.waitForService(120000L);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"CCL: map building thread unblocked due to server start notify", (Object[])new Object[0]);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$2", (String)"1207", (Object)this, (Object[])new Object[0]);
                            if (!tc.isDebugEnabled()) break block4;
                            Tr.debug((TraceComponent)tc, (String)"CCL: map building thread unblocked due to interrupt", (Object[])new Object[0]);
                        }
                    }
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$2", 2.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        });
        acf = new ServiceCaller(ContainerClassLoader.class, ArtifactContainerFactory.class);
    }

    private static interface SmartClassPath {
        public void addContainer(Container var1);

        public void addArtifactContainer(ArtifactContainer var1);

        public void addArtifactContainers(Iterable<ArtifactContainer> var1, boolean var2);

        public ByteResourceInformation getByteResourceInformation(String var1, String var2, ClassLoaderHook var3) throws IOException;

        public URL getResourceURL(String var1, String var2);

        public Collection<URL> getResourceURLs(String var1, String var2);

        public boolean containsContainer(Container var1);

        public Collection<Collection<URL>> getClassPath();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class JarCacheDisabler {
        static final long serialVersionUID = -3816849760898710298L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private JarCacheDisabler() {
        }

        public static void disableJarCaching() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$JarCacheDisabler", JarCacheDisabler.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            try {
                URLConnection connection = new URL("jar:file:///something.jar!/").openConnection();
                connection.setDefaultUseCaches(false);
            }
            catch (MalformedURLException connection) {
                FFDCFilter.processException((Throwable)connection, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$JarCacheDisabler", (String)"109", null, (Object[])new Object[0]);
                Tr.warning((TraceComponent)tc, (String)"WARN_JARS_STILL_CACHED", (Object[])new Object[0]);
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$JarCacheDisabler", (String)"111", null, (Object[])new Object[0]);
                Tr.warning((TraceComponent)tc, (String)"WARN_JARS_STILL_CACHED", (Object[])new Object[0]);
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class UnreadSmartClassPath
    implements SmartClassPath {
        SmartClassPathImpl delegate;
        static final long serialVersionUID = 1749281345125960983L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        UnreadSmartClassPath(ClassLoaderHook hook) {
            this.delegate = new SmartClassPathImpl(hook);
        }

        @Override
        public void addContainer(Container container) {
            this.delegate.addContainer(container);
        }

        @Override
        public void addArtifactContainer(ArtifactContainer container) {
            this.delegate.addArtifactContainer(container);
        }

        @Override
        public void addArtifactContainers(Iterable<ArtifactContainer> containers, boolean prepend) {
            this.delegate.addArtifactContainers(containers, prepend);
        }

        @Override
        public synchronized ByteResourceInformation getByteResourceInformation(String className, String path, ClassLoaderHook hook) throws IOException {
            this.unwrap();
            return this.delegate.getByteResourceInformation(className, path, hook);
        }

        @Override
        public synchronized URL getResourceURL(String path, String jarProtocol) {
            this.unwrap();
            return this.delegate.getResourceURL(path, jarProtocol);
        }

        @Override
        public synchronized Collection<URL> getResourceURLs(String path, String jarProtocol) {
            this.unwrap();
            return this.delegate.getResourceURLs(path, jarProtocol);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unwrap() {
            String methodName = "UnreadSmartClassPath.unwrap(): ";
            if (ContainerClassLoader.this.smartClassPath == this.delegate) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"UnreadSmartClassPath.unwrap(): Another thread has snuck in and performed the lazy initialisation already", (Object[])new Object[0]);
                }
                return;
            }
            UnreadSmartClassPath unreadSmartClassPath = this;
            synchronized (unreadSmartClassPath) {
                if (ContainerClassLoader.this.smartClassPath == this) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"UnreadSmartClassPath.unwrap(): First read operation on class loader: perform lazy initialisation", (Object[])new Object[0]);
                        }
                        ContainerClassLoader.this.lazyInit();
                    }
                    finally {
                        ContainerClassLoader.this.smartClassPath = this.delegate;
                    }
                }
            }
        }

        @Trivial
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public boolean containsContainer(Container container) {
            return this.delegate.containsContainer(container);
        }

        @Override
        public Collection<Collection<URL>> getClassPath() {
            return this.delegate.getClassPath();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$UnreadSmartClassPath", UnreadSmartClassPath.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }

    static interface UniversalContainer {
        public UniversalResource getResource(String var1);

        public void updatePackageMap(Map<Integer, UniversalContainerList> var1, boolean var2);

        public Collection<URL> getContainerURLs();

        public void definePackage(String var1, LibertyLoader var2, ContainerURL var3);

        public ContainerURL getContainerURL(UniversalResource var1);

        public URL getSharedClassCacheURL(UniversalResource var1);

        public static interface UniversalResource {
            public URL getResourceURL(String var1);

            public ByteResourceInformation getByteResourceInformation(String var1, ClassLoaderHook var2) throws IOException;

            public String getNativeLibraryPath();

            public String getResourceName();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class ByteResourceInformation {
        private final byte[] bytes;
        private final UniversalContainer resourceContainer;
        private final ContainerURL containerURL;
        private final URL sharedClassCacheURL;
        private final boolean fromClassCache;
        private final Supplier<byte[]> actualBytes;
        private final ClassLoaderHook hook;
        static final long serialVersionUID = 1360481633503167718L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ByteResourceInformation(UniversalContainer root, UniversalContainer.UniversalResource resource, String className, Supplier<byte[]> actualBytes, ClassLoaderHook hook) {
            byte[] classBytes = null;
            if (hook == null) {
                this.sharedClassCacheURL = null;
            } else {
                this.sharedClassCacheURL = root.getSharedClassCacheURL(resource);
                if (this.sharedClassCacheURL != null) {
                    classBytes = hook.loadClass(this.sharedClassCacheURL, className);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        if (classBytes != null) {
                            Tr.debug((TraceComponent)tc, (String)"Found class in shared class cache", (Object[])new Object[]{className, this.sharedClassCacheURL});
                        } else {
                            Tr.debug((TraceComponent)tc, (String)"Did not find class in shared class cache", (Object[])new Object[]{className, this.sharedClassCacheURL});
                        }
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No shared class cache URL to find class", (Object[])new Object[]{className});
                }
            }
            boolean bl = this.fromClassCache = classBytes != null;
            if (!this.fromClassCache) {
                classBytes = actualBytes.get();
            }
            this.bytes = classBytes;
            this.resourceContainer = root;
            this.containerURL = root.getContainerURL(resource);
            this.actualBytes = actualBytes;
            this.hook = hook;
        }

        @Trivial
        public byte[] getBytes() {
            return this.bytes;
        }

        void definePackage(String packageName, LibertyLoader loader) {
            this.resourceContainer.definePackage(packageName, loader, this.containerURL);
        }

        public ContainerURL getContainerURL() {
            return this.containerURL;
        }

        public boolean foundInClassCache() {
            return this.fromClassCache;
        }

        @Trivial
        public byte[] getActualBytes() throws IOException {
            return this.actualBytes.get();
        }

        @Trivial
        public void storeInClassCache(Class<?> clazz, byte[] definedBytes) {
            if (this.fromClassCache || this.hook == null) {
                return;
            }
            if (this.sharedClassCacheURL == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No shared class cache URL to store class", (Object[])new Object[]{clazz.getName()});
                }
                return;
            }
            if (!Arrays.equals(definedBytes, this.bytes)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Did not store class because defined bytes got modified", (Object[])new Object[]{clazz.getName()});
                }
                return;
            }
            this.hook.storeClass(this.sharedClassCacheURL, clazz);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Called shared class cache to store class", (Object[])new Object[]{clazz.getName(), this.sharedClassCacheURL});
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ByteResourceInformation", ByteResourceInformation.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ContainerUniversalContainer
    extends AbstractUniversalContainer<Entry> {
        private final Container container;
        private final boolean isRoot;
        private String debugString;
        static final long serialVersionUID = 5859768962861095303L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ContainerUniversalContainer(Container container, ClassLoaderHook hook) {
            super(container.getURLs(), hook);
            this.container = container;
            this.isRoot = container.isRoot();
            if (!checkpointPhase.restored()) {
                this.getManifestMainAttributes();
            }
        }

        @Override
        public UniversalContainer.UniversalResource getResource(String path) {
            if (!this.isRoot) {
                if (!PathUtils.isNormalizedPathAbsolute((String)(path = PathUtils.normalize((String)path)))) {
                    return null;
                }
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
            }
            if (path.length() == 0 || path.equals("/")) {
                return new ContainerUniversalResource(this.container);
            }
            Entry e = this.container.getEntry(path);
            if (e != null) {
                return new EntryUniversalResource(this, e, path);
            }
            return null;
        }

        @Trivial
        private void processContainer(Container c, Map<Integer, UniversalContainerList> map, int chop, boolean prepend) {
            for (Entry e : c) {
                try {
                    Container child = (Container)e.adapt(Container.class);
                    if (child == null || child.isRoot()) continue;
                    Integer key = child.getPath().substring(chop).hashCode();
                    UniversalContainerList listForThisPath = map.get(key);
                    if (listForThisPath == null) {
                        listForThisPath = new UniversalContainerList(new ArrayList<UniversalContainer>());
                        map.put(key, listForThisPath);
                    }
                    if (!listForThisPath.contains(this)) {
                        listForThisPath.add(this, prepend);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("CCL: {" + listForThisPath.size() + "} [" + this.hashCode() + "] adding : [" + key + "] " + child.getPath().substring(chop)), (Object[])new Object[0]);
                        }
                    }
                    this.processContainer(child, map, chop, prepend);
                }
                catch (UnableToAdaptException unableToAdaptException) {
                    FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ContainerUniversalContainer", (String)"854", (Object)this, (Object[])new Object[]{c, map, chop, prepend});
                }
            }
        }

        @Override
        @Trivial
        public synchronized void updatePackageMap(Map<Integer, UniversalContainerList> map, boolean prepend) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CCL: updating map for adaptable container with path " + this.container.getPath()), (Object[])new Object[0]);
            }
            int chop = 1;
            if (!"/".equals(this.container.getPath())) {
                chop = this.container.getPath().length() + 1;
            }
            this.processContainer(this.container, map, chop, prepend);
        }

        @Override
        public Collection<URL> getContainerURLs() {
            return this.container == null ? null : this.container.getURLs();
        }

        public String toString() {
            if (this.debugString == null) {
                String physicalPath = this.container.getPhysicalPath();
                if (physicalPath == null) {
                    physicalPath = this.container.getPath();
                }
                this.debugString = physicalPath;
            }
            return this.debugString;
        }

        @Override
        Entry getEntry(String path) {
            return this.container.getEntry(path);
        }

        @Override
        InputStream getInputStream(Entry e) throws IOException {
            try {
                return (InputStream)e.adapt(InputStream.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ContainerUniversalContainer", (String)"900", (Object)this, (Object[])new Object[]{e});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"UnableToAdaptException thrown opening resource {0}", (Object[])new Object[]{e.getResource()});
                }
                return null;
            }
        }

        @Override
        URL getResourceURL(Entry e) {
            return e.getResource();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ContainerUniversalContainer", ContainerUniversalContainer.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class SmartClassPathImpl
    implements SmartClassPath {
        final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
        final AtomicInteger outstandingContainers = new AtomicInteger(0);
        static final boolean usePackageMap;
        static final Integer maxLastNotFound;
        static final Integer maxLastFound;
        static final Integer maxLastReallyNotFound;
        static final boolean propsInUse;
        final List<UniversalContainer> classPath = new CopyOnWriteArrayList<UniversalContainer>();
        final UniversalContainerList classPathContainers = new UniversalContainerList(this.classPath);
        final int MAX_LASTNOTFOUND = maxLastNotFound;
        final List<Set<String>> lastNotFound = new CopyOnWriteArrayList<Set<String>>();
        final int MAX_LASTFOUND = maxLastFound;
        final Map<String, URL> lastFoundURL = Collections.synchronizedMap(new CacheHashMap(this.MAX_LASTFOUND));
        final int MAX_LASTREALLYNOTFOUND = maxLastReallyNotFound;
        final Map<String, Object> lastReallyNotFoundURL = Collections.synchronizedMap(new CacheHashMap(this.MAX_LASTREALLYNOTFOUND));
        final Map<Integer, UniversalContainerList> packageMap = usePackageMap ? new HashMap() : null;
        final Set<Container> containers = Collections.newSetFromMap(new WeakHashMap());
        final ClassLoaderHook hook;
        static final long serialVersionUID = -3467138158141685837L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SmartClassPathImpl(ClassLoaderHook hook) {
            this.hook = hook;
        }

        private synchronized void addUniversalContainer(final UniversalContainer uc, final boolean prepend) {
            if (tc.isDebugEnabled()) {
                if (uc instanceof ArtifactContainerUniversalContainer) {
                    Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " cpelt idx " + this.classPathContainers.size() + "wraps " + ((ArtifactContainerUniversalContainer)uc).container), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " cpelt idx " + this.classPathContainers.size() + " ART url " + ((ArtifactContainerUniversalContainer)uc).container.getPhysicalPath()), (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " cpelt idx " + this.classPathContainers.size() + " wraps " + ((ContainerUniversalContainer)uc).container), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " cpelt idx " + this.classPathContainers.size() + " CON url " + ((ContainerUniversalContainer)uc).container.getPhysicalPath()), (Object[])new Object[0]);
                }
            }
            if (usePackageMap) {
                this.outstandingContainers.incrementAndGet();
                mapCreationQueue.submit(new Runnable(){
                    static final long serialVersionUID = -2142723384013338278L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public void run() {
                        if (tc.isDebugEnabled()) {
                            if (uc instanceof ArtifactContainerUniversalContainer) {
                                Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " building package map for " + ((ArtifactContainerUniversalContainer)uc).container.getPhysicalPath()), (Object[])new Object[0]);
                            } else {
                                Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " building package map for " + ((ContainerUniversalContainer)uc).container.getPhysicalPath()), (Object[])new Object[0]);
                            }
                        }
                        ReentrantReadWriteLock.WriteLock write = rwLock.writeLock();
                        write.lock();
                        try {
                            uc.updatePackageMap(packageMap, prepend);
                            outstandingContainers.decrementAndGet();
                        }
                        finally {
                            write.unlock();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " done building package map."), (Object[])new Object[0]);
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$SmartClassPathImpl$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                    }
                });
            }
            this.classPathContainers.add(uc, prepend);
            this.lastNotFound.add(Collections.synchronizedSet(new LinkedHashSet()));
        }

        @Override
        public void addContainer(Container container) {
            this.containers.add(container);
            this.addUniversalContainer(new ContainerUniversalContainer(container, this.hook), false);
        }

        @Override
        public void addArtifactContainer(ArtifactContainer container) {
            this.addUniversalContainer(new ArtifactContainerUniversalContainer(container, this.hook), false);
        }

        @Override
        public void addArtifactContainers(Iterable<ArtifactContainer> containers, boolean prepend) {
            for (ArtifactContainer container : containers) {
                this.addUniversalContainer(new ArtifactContainerUniversalContainer(container, this.hook), prepend);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Trivial
        private UniversalContainerList getUniversalContainersForPath(String path, UniversalContainerList classpath) {
            if (this.outstandingContainers.get() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CCL: request for " + path + " made to use map while map update pending, reverting request to full classpath"), (Object[])new Object[0]);
                }
                return classpath;
            }
            int startidx = (path = PathUtils.normalizeUnixStylePath((String)path)).startsWith("/") ? 1 : 0;
            int slashidx = path.lastIndexOf(47);
            if (slashidx > 0) {
                UniversalContainerList containersForKey;
                Integer key = path.substring(startidx, slashidx).hashCode();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CCL: checking map using key {" + key + "} for path '" + path.substring(0, slashidx) + "'    :    origpath: '" + path + "'"), (Object[])new Object[0]);
                }
                ReentrantReadWriteLock.ReadLock read = this.rwLock.readLock();
                read.lock();
                try {
                    containersForKey = this.packageMap.get(key);
                }
                finally {
                    read.unlock();
                }
                if (containersForKey != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("CCL: got hit for key, returning container set with " + containersForKey.size() + " containers."), (Object[])new Object[0]);
                    }
                    return containersForKey;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"CCL: key was unknown, returning empty set. ", (Object[])new Object[0]);
                }
                return UniversalContainerList.EMPTY;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CCL: request for a root level resource... : '" + path + "' returning original set with " + classpath.size()), (Object[])new Object[0]);
            }
            return classpath;
        }

        @Override
        public ByteResourceInformation getByteResourceInformation(String className, String path, ClassLoaderHook hook) throws IOException {
            int idx = 0;
            UniversalContainerList locationsToCheck = this.classPathContainers;
            if (usePackageMap) {
                locationsToCheck = this.getUniversalContainersForPath(path, locationsToCheck);
            }
            for (UniversalContainer uc : locationsToCheck) {
                Set<String> lastNotFoundForThisContainer = this.lastNotFound.get(idx);
                if (usePackageMap || this.pathNotInlastNotFound(path, lastNotFoundForThisContainer)) {
                    UniversalContainer.UniversalResource ur = uc.getResource(path);
                    if (ur != null) {
                        ByteResourceInformation is = ur.getByteResourceInformation(className, hook);
                        if (is != null) {
                            return is;
                        }
                    } else if (!usePackageMap && lastNotFoundForThisContainer != null) {
                        this.addPath(lastNotFoundForThisContainer, path);
                    }
                }
                ++idx;
            }
            return null;
        }

        @Override
        public URL getResourceURL(String path, String jarProtocol) {
            URL cached = this.lastFoundURL.get(path);
            if (cached != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CCL: [" + this.hashCode() + "]  getResourceURL : '" + path + "' lastFound hit."), (Object[])new Object[0]);
                }
                return cached;
            }
            if (this.lastReallyNotFoundURL.containsKey(path)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CCL: [" + this.hashCode() + "]  getResourceURL : '" + path + "' lastReallyNotFound hit."), (Object[])new Object[0]);
                }
                return null;
            }
            UniversalContainerList locationsToCheck = this.classPathContainers;
            if (usePackageMap) {
                locationsToCheck = this.getUniversalContainersForPath(path, locationsToCheck);
            }
            int idx = 0;
            int skipped = 0;
            for (UniversalContainer uc : locationsToCheck) {
                Set<String> lastNotFoundForThisContainer = this.lastNotFound.get(idx);
                if (usePackageMap || this.pathNotInlastNotFound(path, lastNotFoundForThisContainer)) {
                    UniversalContainer.UniversalResource ur = uc.getResource(path);
                    if (ur != null) {
                        URL url = ur.getResourceURL(jarProtocol);
                        if (url != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("CCL: [" + this.hashCode() + "]  getResourceURL : '" + path + "' found at classpath index " + idx + " local not found caches allowed us to skip " + skipped + " locations. Found cache is now.. " + this.lastFoundURL.size() + " and path was known to cache? " + this.lastFoundURL.containsKey(path)), (Object[])new Object[0]);
                            }
                            this.lastFoundURL.put(path, url);
                            return url;
                        }
                    } else if (!usePackageMap && lastNotFoundForThisContainer != null) {
                        this.addPath(lastNotFoundForThisContainer, path);
                    }
                } else {
                    ++skipped;
                }
                ++idx;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CCL: [" + this.hashCode() + "]  getResourceURL : '" + path + "' really not found. Cache size is now.. " + this.lastReallyNotFoundURL.size() + " path already known to cache? " + this.lastReallyNotFoundURL.containsKey(path)), (Object[])new Object[0]);
            }
            this.lastReallyNotFoundURL.put(path, null);
            return null;
        }

        @Override
        public Collection<URL> getResourceURLs(String path, String jarProtocol) {
            ArrayList<URL> urls = new ArrayList<URL>();
            if (this.lastReallyNotFoundURL.containsKey(path)) {
                return urls;
            }
            UniversalContainerList locationsToCheck = this.classPathContainers;
            if (usePackageMap) {
                locationsToCheck = this.getUniversalContainersForPath(path, locationsToCheck);
            }
            int idx = 0;
            for (UniversalContainer uc : locationsToCheck) {
                Set<String> lastNotFoundForThisContainer = this.lastNotFound.get(idx);
                if (usePackageMap || this.pathNotInlastNotFound(path, lastNotFoundForThisContainer)) {
                    UniversalContainer.UniversalResource ur = uc.getResource(path);
                    if (ur != null) {
                        URL url = ur.getResourceURL(jarProtocol);
                        if (url != null) {
                            urls.add(url);
                        }
                    } else if (!usePackageMap && lastNotFoundForThisContainer != null) {
                        this.addPath(lastNotFoundForThisContainer, path);
                    }
                }
                ++idx;
            }
            if (urls.isEmpty()) {
                this.lastReallyNotFoundURL.put(path, null);
            }
            return urls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addPath(Set<String> lastNotFoundForThisContainer, String path) {
            Set<String> set = lastNotFoundForThisContainer;
            synchronized (set) {
                if (lastNotFoundForThisContainer.size() >= this.MAX_LASTNOTFOUND) {
                    Iterator<String> i = lastNotFoundForThisContainer.iterator();
                    i.next();
                    i.remove();
                }
                lastNotFoundForThisContainer.add(path);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean pathNotInlastNotFound(String path, Set<String> lastNotFoundForThisContainer) {
            boolean pathFound = false;
            if (lastNotFoundForThisContainer != null) {
                Set<String> set = lastNotFoundForThisContainer;
                synchronized (set) {
                    pathFound = lastNotFoundForThisContainer.contains(path);
                }
            }
            return !pathFound;
        }

        @Trivial
        public String toString() {
            return String.valueOf(this.classPathContainers);
        }

        @Override
        public boolean containsContainer(Container container) {
            return this.containers.contains(container);
        }

        @Override
        public Collection<Collection<URL>> getClassPath() {
            ArrayList<Collection<URL>> containerURLs = new ArrayList<Collection<URL>>();
            for (UniversalContainer uc : this.classPathContainers) {
                containerURLs.add(uc.getContainerURLs());
            }
            return containerURLs;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$SmartClassPathImpl", SmartClassPathImpl.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            usePackageMap = !Boolean.getBoolean("com.ibm.ws.classloading.container.disableMap");
            maxLastNotFound = Integer.getInteger("com.ibm.ws.classloading.container.lastNotFound", 250);
            maxLastFound = Integer.getInteger("com.ibm.ws.classloading.container.lastFound", 900);
            maxLastReallyNotFound = Integer.getInteger("com.ibm.ws.classloading.container.lastReallyNotFound", 900);
            boolean bl = propsInUse = !usePackageMap || System.getProperty("com.ibm.ws.classloading.container.lastNotFound") != null || System.getProperty("com.ibm.ws.classloading.container.lastFound") != null || System.getProperty("com.ibm.ws.classloading.container.lastReallyNotFound") != null;
            if (propsInUse && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CCL: custom cache properties in use : lastNotFound=" + maxLastNotFound + " lastFound=" + maxLastFound + " lastReallyNotFound=" + maxLastReallyNotFound), (Object[])new Object[0]);
                if (usePackageMap) {
                    Tr.debug((TraceComponent)tc, (String)"CCL: experimental package map engaged.. utoh!", (Object[])new Object[0]);
                }
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class UniversalContainerList
    implements Iterable<UniversalContainer> {
        static final UniversalContainerList EMPTY;
        private final List<UniversalContainer> containers;
        private int prependIndex = 0;
        static final long serialVersionUID = -7828321816965763362L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private UniversalContainerList() {
            this.containers = Collections.emptyList();
        }

        UniversalContainerList(List<UniversalContainer> containers) {
            this.containers = containers;
        }

        @Trivial
        public boolean contains(UniversalContainer container) {
            return this.containers.contains(container);
        }

        @Trivial
        void add(UniversalContainer container, boolean prepend) {
            if (prepend) {
                this.containers.add(this.prependIndex++, container);
            } else {
                this.containers.add(container);
            }
        }

        @Trivial
        int size() {
            return this.containers.size();
        }

        @Override
        @Trivial
        public Iterator<UniversalContainer> iterator() {
            return this.containers.iterator();
        }

        @Trivial
        public String toString() {
            return this.containers.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$UniversalContainerList", UniversalContainerList.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            EMPTY = new UniversalContainerList();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ArtifactContainerUniversalResource
    implements UniversalContainer.UniversalResource {
        private final ArtifactContainer container;
        static final long serialVersionUID = 5813932956101291463L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ArtifactContainerUniversalResource(ArtifactContainer c) {
            this.container = c;
        }

        @Override
        public URL getResourceURL(String jarProtocol) {
            Collection urls = this.container.getURLs();
            if (urls.isEmpty()) {
                return null;
            }
            return (URL)urls.iterator().next();
        }

        @Override
        public ByteResourceInformation getByteResourceInformation(String className, ClassLoaderHook hook) throws IOException {
            return null;
        }

        @Override
        public String getNativeLibraryPath() {
            return null;
        }

        @Override
        public String getResourceName() {
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ArtifactContainerUniversalResource", ArtifactContainerUniversalResource.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ArtifactContainerUniversalContainer
    extends AbstractUniversalContainer<ArtifactEntry> {
        final ArtifactContainer container;
        final boolean isRoot;
        static final long serialVersionUID = -7020033825713539403L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ArtifactContainerUniversalContainer(ArtifactContainer container, ClassLoaderHook hook) {
            super(container.getURLs(), hook);
            this.container = container;
            this.isRoot = container.isRoot();
            if (!checkpointPhase.restored()) {
                this.getManifestMainAttributes();
            }
        }

        @Override
        public UniversalContainer.UniversalResource getResource(String path) {
            if (!this.isRoot) {
                if (!PathUtils.isNormalizedPathAbsolute((String)(path = PathUtils.normalize((String)path)))) {
                    return null;
                }
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
            }
            if (path.length() == 0 || path.equals("/")) {
                return new ArtifactContainerUniversalResource(this.container);
            }
            try {
                ArtifactEntry e = this.container.getEntry(path);
                if (e != null) {
                    return new ArtifactEntryUniversalResource(this, e, path);
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ArtifactContainerUniversalContainer", (String)"1043", (Object)this, (Object[])new Object[]{path});
                return null;
            }
        }

        private void processContainer(ArtifactContainer c, Map<Integer, UniversalContainerList> map, int chop, boolean prepend) {
            for (ArtifactEntry e : c) {
                ArtifactContainer child = e.convertToContainer(true);
                if (child == null) continue;
                Integer key = child.getPath().substring(chop).hashCode();
                UniversalContainerList listForThisPath = map.get(key);
                if (listForThisPath == null) {
                    listForThisPath = new UniversalContainerList(new ArrayList<UniversalContainer>());
                    map.put(key, listForThisPath);
                }
                if (!listForThisPath.contains(this)) {
                    listForThisPath.add(this, prepend);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("CCL: {" + listForThisPath.size() + "} [" + this.hashCode() + "] adding : [" + key + "] " + child.getPath().substring(chop)), (Object[])new Object[0]);
                    }
                }
                this.processContainer(child, map, chop, prepend);
            }
        }

        @Override
        public synchronized void updatePackageMap(Map<Integer, UniversalContainerList> map, boolean prepend) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CCL: updating map for artifact container with path " + this.container.getPath()), (Object[])new Object[0]);
            }
            int chop = 1;
            if (!"/".equals(this.container.getPath())) {
                chop = this.container.getPath().length() + 1;
            }
            this.processContainer(this.container, map, chop, prepend);
        }

        @Override
        public Collection<URL> getContainerURLs() {
            return this.container == null ? null : this.container.getURLs();
        }

        @Override
        ArtifactEntry getEntry(String path) {
            return this.container.getEntry(path);
        }

        @Override
        InputStream getInputStream(ArtifactEntry e) throws IOException {
            return e.getInputStream();
        }

        @Override
        URL getResourceURL(ArtifactEntry e) {
            return e.getResource();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ArtifactContainerUniversalContainer", ArtifactContainerUniversalContainer.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ArtifactEntryUniversalResource
    implements UniversalContainer.UniversalResource {
        final UniversalContainer container;
        final ArtifactEntry entry;
        final String resourceName;
        static final long serialVersionUID = 5980928994644514919L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ArtifactEntryUniversalResource(UniversalContainer container, ArtifactEntry entry, String resourceName) {
            this.container = container;
            this.entry = entry;
            this.resourceName = resourceName;
        }

        @Override
        public URL getResourceURL(String jarProtocol) {
            boolean pSlash;
            URL url = this.entry.getResource();
            if (url == null) {
                return null;
            }
            boolean uSlash = url.getPath().endsWith("/");
            if (uSlash == (pSlash = this.resourceName.endsWith("/"))) {
                return url;
            }
            if (uSlash) {
                return ContainerClassLoader.stripTrailingSlash(url);
            }
            return null;
        }

        @Override
        public ByteResourceInformation getByteResourceInformation(String className, ClassLoaderHook hook) throws IOException {
            return new ByteResourceInformation(this.container, this, className, this::getActualBytes, hook);
        }

        /*
         * WARNING - void declaration
         */
        @Trivial
        byte[] getActualBytes() {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CCL: ArtifactEntryUniversalResource.getActualBytes for " + this.resourceName), (Object[])new Object[0]);
            }
            try {
                InputStream is = this.entry.getInputStream();
                return ContainerClassLoader.getBytes(is, (int)this.entry.getSize());
            }
            catch (IOException is) {
                void e;
                FFDCFilter.processException((Throwable)is, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ArtifactEntryUniversalResource", (String)"969", (Object)this, (Object[])new Object[0]);
                ContainerClassLoader.sneakyThrow((Throwable)e);
                return null;
            }
        }

        @Override
        public String getNativeLibraryPath() {
            try {
                File f = NativeLibraryAdapter.getFileForLibraryEntry(this.entry);
                if (f != null) {
                    return f.getPath();
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ArtifactEntryUniversalResource", (String)"980", (Object)this, (Object[])new Object[0]);
            }
            return null;
        }

        @Override
        public String getResourceName() {
            return this.resourceName;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ArtifactEntryUniversalResource", ArtifactEntryUniversalResource.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static abstract class AbstractUniversalContainer<E>
    implements UniversalContainer {
        private static final Map<Attributes.Name, String> NULL_MAIN_ATTRIBUTES;
        private static final Map<Attributes.Name, Attributes.Name> packageAttributes;
        private volatile Map<Attributes.Name, String> manifestMainAttributes = null;
        private volatile Map<String, Map<Attributes.Name, String>> manifestEntryAttributes = null;
        private final ContainerURL resourceContainerURL;
        private final URL resourceSharedClassCacheURL;
        private final File resourceContainerDir;
        static final long serialVersionUID = -4386286469562789530L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public AbstractUniversalContainer(Collection<URL> containerURLs, ClassLoaderHook hook) {
            URL originalRoot = null;
            URL convertedRoot = null;
            boolean multiple = false;
            for (URL url : containerURLs) {
                String path;
                URL converted = this.createContainerURL(url);
                if (converted == null || (path = converted.getPath()).endsWith(".overlay/")) continue;
                if (convertedRoot == null) {
                    convertedRoot = converted;
                    originalRoot = url;
                    continue;
                }
                multiple = true;
            }
            if (multiple || convertedRoot == null) {
                this.resourceContainerURL = null;
                this.resourceContainerDir = null;
                this.resourceSharedClassCacheURL = null;
            } else {
                this.resourceContainerURL = new ContainerURL(convertedRoot);
                File containerFile = null;
                try {
                    containerFile = new File(this.resourceContainerURL.url.toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                    FFDCFilter.processException((Throwable)uRISyntaxException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$AbstractUniversalContainer", (String)"449", (Object)this, (Object[])new Object[]{containerURLs, hook});
                }
                this.resourceContainerDir = containerFile != null && ContainerClassLoader.isDirectory(containerFile) ? containerFile : null;
                this.resourceSharedClassCacheURL = hook != null ? this.createSharedClassCacheURL(this.resourceContainerURL, originalRoot, this.resourceContainerDir) : null;
            }
        }

        /*
         * WARNING - void declaration
         */
        URL createContainerURL(URL base) {
            try {
                if ("file".equals(base.getProtocol())) {
                    return base;
                }
                URLConnection conn = base.openConnection();
                if (conn instanceof JarURLConnection) {
                    return ((JarURLConnection)conn).getJarFileURL();
                }
                if (conn instanceof WSJarURLConnection) {
                    return ((WSJarURLConnection)conn).getFile().toURI().toURL();
                }
                throw new UnsupportedOperationException(base.getProtocol());
            }
            catch (IOException conn) {
                void err;
                FFDCFilter.processException((Throwable)conn, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$AbstractUniversalContainer", (String)"471", (Object)this, (Object[])new Object[]{base});
                throw new RuntimeException((Throwable)err);
            }
        }

        URL createSharedClassCacheURL(ContainerURL containerURL, URL originalRoot, File containerDir) {
            if (containerURL == null) {
                return null;
            }
            if (containerDir != null) {
                return containerURL.url;
            }
            try {
                String bangSlashPath;
                String containerPath = containerURL.url.getPath();
                if (containerPath.endsWith(".jar") || containerPath.endsWith(".zip")) {
                    return containerURL.url;
                }
                String basePath = originalRoot.getPath();
                int bangSlash = basePath.lastIndexOf("!/");
                if (bangSlash >= 0 && (bangSlashPath = basePath.substring(bangSlash)).length() > 2) {
                    return new URL(containerURL.urlString + bangSlashPath);
                }
                return new URL(containerURL.urlString + "!/l");
            }
            catch (MalformedURLException containerPath) {
                FFDCFilter.processException((Throwable)containerPath, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$AbstractUniversalContainer", (String)"509", (Object)this, (Object[])new Object[]{containerURL, originalRoot, containerDir});
                return null;
            }
        }

        @Override
        public ContainerURL getContainerURL(UniversalContainer.UniversalResource resource) {
            URL resourceUrl;
            if (this.resourceContainerURL != null) {
                if (this.resourceContainerDir != null) {
                    if (ContainerClassLoader.exists(new File(this.resourceContainerDir, resource.getResourceName()))) {
                        return this.resourceContainerURL;
                    }
                } else {
                    return this.resourceContainerURL;
                }
            }
            if ((resourceUrl = resource.getResourceURL("jar")) != null) {
                String protocol = resourceUrl.getProtocol();
                try {
                    if ("jar".equals(protocol)) {
                        URLConnection conn = resourceUrl.openConnection();
                        if (conn instanceof JarURLConnection) {
                            return new ContainerURL(((JarURLConnection)conn).getJarFileURL());
                        }
                        throw new IOException(conn.getClass().getName());
                    }
                    if ("wsjar".equals(protocol)) {
                        URLConnection conn = resourceUrl.openConnection();
                        if (conn instanceof WSJarURLConnection) {
                            return new ContainerURL(((WSJarURLConnection)conn).getFile().toURI().toURL());
                        }
                        throw new IOException(conn.getClass().getName());
                    }
                    if ("file".equals(protocol)) {
                        return new ContainerURL(new URL(resourceUrl.toString().replace(resource.getResourceName(), "")));
                    }
                    throw new IOException(protocol);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$AbstractUniversalContainer", (String)"553", (Object)this, (Object[])new Object[]{resource});
                }
            }
            return null;
        }

        @Override
        public URL getSharedClassCacheURL(UniversalContainer.UniversalResource resource) {
            if (this.resourceSharedClassCacheURL != null) {
                if (this.resourceContainerDir != null) {
                    if (ContainerClassLoader.exists(new File(this.resourceContainerDir, resource.getResourceName()))) {
                        return this.resourceSharedClassCacheURL;
                    }
                } else {
                    return this.resourceSharedClassCacheURL;
                }
            }
            return this.getSharedClassCacheURLFromResource(resource);
        }

        private URL getSharedClassCacheURLFromResource(UniversalContainer.UniversalResource resource) {
            URL sharedClassCacheURL;
            URL resourceURL = resource.getResourceURL("jar");
            String resourceName = resource.getResourceName();
            if (resourceURL == null) {
                return null;
            }
            String protocol = resourceURL.getProtocol();
            if ("jar".equals(protocol) || "wsjar".equals(protocol)) {
                String path = resourceURL.getPath();
                if (path.endsWith(resourceName)) {
                    if ((path = path.substring(0, path.length() - resourceName.length())).endsWith(".jar!/") || path.endsWith(".zip!/")) {
                        path = path.substring(0, path.length() - 2);
                    } else if (path.endsWith("!/")) {
                        path = path + "l";
                    }
                }
                try {
                    sharedClassCacheURL = new URL(path);
                }
                catch (MalformedURLException malformedURLException) {
                    FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$AbstractUniversalContainer", (String)"609", (Object)this, (Object[])new Object[]{resource});
                    sharedClassCacheURL = null;
                }
            } else if (!"file".equals(protocol)) {
                sharedClassCacheURL = null;
            } else {
                String externalForm = resourceURL.toExternalForm();
                if (externalForm.endsWith(resourceName)) {
                    try {
                        sharedClassCacheURL = new URL(externalForm.substring(0, externalForm.length() - resourceName.length()));
                    }
                    catch (MalformedURLException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$AbstractUniversalContainer", (String)"619", (Object)this, (Object[])new Object[]{resource});
                        sharedClassCacheURL = null;
                    }
                } else {
                    sharedClassCacheURL = null;
                }
            }
            return sharedClassCacheURL;
        }

        @Override
        @FFDCIgnore(value={IllegalArgumentException.class})
        public final void definePackage(String packageName, LibertyLoader loader, ContainerURL containerURL) {
            Map<Attributes.Name, String> mainAttributes = this.getManifestMainAttributes();
            try {
                if (mainAttributes == NULL_MAIN_ATTRIBUTES && this.manifestEntryAttributes == null) {
                    loader.definePackage(packageName, null, null, null, null, null, null, null);
                } else {
                    String unixName;
                    Map<Attributes.Name, String> entryAttributes;
                    String specTitle = null;
                    String specVersion = null;
                    String specVendor = null;
                    String implTitle = null;
                    String implVersion = null;
                    String implVendor = null;
                    String sealedString = null;
                    if (this.manifestEntryAttributes != null && (entryAttributes = this.manifestEntryAttributes.get(unixName = packageName.replace('.', '/') + "/")) != null) {
                        specTitle = entryAttributes.get(Attributes.Name.SPECIFICATION_TITLE);
                        specVersion = entryAttributes.get(Attributes.Name.SPECIFICATION_VERSION);
                        specVendor = entryAttributes.get(Attributes.Name.SPECIFICATION_VENDOR);
                        implTitle = entryAttributes.get(Attributes.Name.IMPLEMENTATION_TITLE);
                        implVersion = entryAttributes.get(Attributes.Name.IMPLEMENTATION_VERSION);
                        implVendor = entryAttributes.get(Attributes.Name.IMPLEMENTATION_VENDOR);
                        sealedString = entryAttributes.get(Attributes.Name.SEALED);
                    }
                    if (mainAttributes != NULL_MAIN_ATTRIBUTES) {
                        if (specTitle == null) {
                            specTitle = mainAttributes.get(Attributes.Name.SPECIFICATION_TITLE);
                        }
                        if (specVersion == null) {
                            specVersion = mainAttributes.get(Attributes.Name.SPECIFICATION_VERSION);
                        }
                        if (specVendor == null) {
                            specVendor = mainAttributes.get(Attributes.Name.SPECIFICATION_VENDOR);
                        }
                        if (implTitle == null) {
                            implTitle = mainAttributes.get(Attributes.Name.IMPLEMENTATION_TITLE);
                        }
                        if (implVersion == null) {
                            implVersion = mainAttributes.get(Attributes.Name.IMPLEMENTATION_VERSION);
                        }
                        if (implVendor == null) {
                            implVendor = mainAttributes.get(Attributes.Name.IMPLEMENTATION_VENDOR);
                        }
                        if (sealedString == null) {
                            sealedString = mainAttributes.get(Attributes.Name.SEALED);
                        }
                    }
                    URL sealBase = null;
                    if (sealedString != null && sealedString.equalsIgnoreCase("true")) {
                        sealBase = containerURL.url;
                    }
                    loader.definePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @FFDCIgnore(value={IOException.class})
        Map<Attributes.Name, String> getManifestMainAttributes() {
            if (this.manifestMainAttributes == null) {
                AbstractUniversalContainer abstractUniversalContainer = this;
                synchronized (abstractUniversalContainer) {
                    if (this.manifestMainAttributes == null) {
                        E e = this.getEntry("META-INF/MANIFEST.MF");
                        if (e != null) {
                            InputStream manifestStream = null;
                            try {
                                manifestStream = this.getInputStream(e);
                                if (manifestStream != null) {
                                    Attributes mainAttributes;
                                    Manifest manifest = new Manifest(manifestStream);
                                    Map<String, Attributes> manifestEntries = manifest.getEntries();
                                    if (!manifestEntries.isEmpty()) {
                                        this.manifestEntryAttributes = AbstractUniversalContainer.filterEntryAttributes(manifestEntries);
                                    }
                                    if (!(mainAttributes = manifest.getMainAttributes()).isEmpty()) {
                                        this.manifestMainAttributes = AbstractUniversalContainer.filterAttributes(mainAttributes);
                                    }
                                }
                            }
                            catch (IOException e2) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"IOException thrown opening resource {0}", (Object[])new Object[]{this.getResourceURL(e)});
                                }
                            }
                            finally {
                                Util.tryToClose(manifestStream);
                            }
                        }
                        if (this.manifestMainAttributes == null) {
                            this.manifestMainAttributes = NULL_MAIN_ATTRIBUTES;
                        }
                    }
                }
            }
            return this.manifestMainAttributes;
        }

        private static Map<String, Map<Attributes.Name, String>> filterEntryAttributes(Map<String, Attributes> manifestEntries) throws IOException {
            HashMap<String, Map<Attributes.Name, String>> entries = null;
            for (Map.Entry<String, Attributes> entry : manifestEntries.entrySet()) {
                Map<Attributes.Name, String> newAttributes;
                Attributes attributes;
                String key = entry.getKey();
                if (key == null || !key.endsWith("/") || (attributes = entry.getValue()).isEmpty() || (newAttributes = AbstractUniversalContainer.filterAttributes(attributes)) == null) continue;
                if (entries == null) {
                    entries = new HashMap<String, Map<Attributes.Name, String>>(7);
                }
                entries.put(key, newAttributes);
            }
            return entries;
        }

        private static Map<Attributes.Name, String> filterAttributes(Attributes attributes) {
            HashMap<Attributes.Name, String> newAttributes = null;
            for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
                Attributes.Name validName;
                Object key = entry.getKey();
                if (!(key instanceof Attributes.Name) || (validName = packageAttributes.get(key)) == null) continue;
                if (newAttributes == null) {
                    newAttributes = new HashMap<Attributes.Name, String>(7);
                }
                newAttributes.put(validName, (String)entry.getValue());
            }
            return newAttributes;
        }

        abstract E getEntry(String var1);

        abstract InputStream getInputStream(E var1) throws IOException;

        abstract URL getResourceURL(E var1);

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$AbstractUniversalContainer", AbstractUniversalContainer.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            NULL_MAIN_ATTRIBUTES = Collections.emptyMap();
            HashMap<Attributes.Name, Attributes.Name> packageAttrs = new HashMap<Attributes.Name, Attributes.Name>();
            packageAttrs.put(Attributes.Name.SPECIFICATION_TITLE, Attributes.Name.SPECIFICATION_TITLE);
            packageAttrs.put(Attributes.Name.SPECIFICATION_VERSION, Attributes.Name.SPECIFICATION_VERSION);
            packageAttrs.put(Attributes.Name.SPECIFICATION_VENDOR, Attributes.Name.SPECIFICATION_VENDOR);
            packageAttrs.put(Attributes.Name.IMPLEMENTATION_TITLE, Attributes.Name.IMPLEMENTATION_TITLE);
            packageAttrs.put(Attributes.Name.IMPLEMENTATION_VERSION, Attributes.Name.IMPLEMENTATION_VERSION);
            packageAttrs.put(Attributes.Name.IMPLEMENTATION_VENDOR, Attributes.Name.IMPLEMENTATION_VENDOR);
            packageAttrs.put(Attributes.Name.SEALED, Attributes.Name.SEALED);
            packageAttributes = Collections.unmodifiableMap(packageAttrs);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ContainerUniversalResource
    implements UniversalContainer.UniversalResource {
        private final Container container;
        static final long serialVersionUID = 3147566586506923275L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ContainerUniversalResource(Container c) {
            this.container = c;
        }

        @Override
        public URL getResourceURL(String jarProtocol) {
            Collection urls = this.container.getURLs();
            if (urls.isEmpty()) {
                return null;
            }
            URL result = (URL)urls.iterator().next();
            if ("file".equals(result.getProtocol()) && !result.getPath().endsWith("/")) {
                try {
                    return new URL(jarProtocol + result.toExternalForm() + "!/");
                }
                catch (MalformedURLException malformedURLException) {
                    FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ContainerUniversalResource", (String)"372", (Object)this, (Object[])new Object[]{jarProtocol});
                    return result;
                }
            }
            return result;
        }

        @Override
        public ByteResourceInformation getByteResourceInformation(String className, ClassLoaderHook hook) throws IOException {
            return null;
        }

        @Override
        public String getNativeLibraryPath() {
            return null;
        }

        @Override
        public String getResourceName() {
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ContainerUniversalResource", ContainerUniversalResource.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class EntryUniversalResource
    implements UniversalContainer.UniversalResource {
        final UniversalContainer container;
        final Entry entry;
        final String resourceName;
        static final long serialVersionUID = -2062608773468259221L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public EntryUniversalResource(UniversalContainer container, Entry entry, String resourceName) {
            this.container = container;
            this.entry = entry;
            this.resourceName = resourceName;
        }

        @Override
        public URL getResourceURL(String jarProtocol) {
            boolean pSlash;
            URL url = this.entry.getResource();
            if (url == null) {
                return null;
            }
            boolean uSlash = url.getPath().endsWith("/");
            if (uSlash == (pSlash = this.resourceName.endsWith("/"))) {
                return url;
            }
            if (uSlash) {
                return ContainerClassLoader.stripTrailingSlash(url);
            }
            return null;
        }

        @Override
        public ByteResourceInformation getByteResourceInformation(String className, ClassLoaderHook hook) throws IOException {
            return new ByteResourceInformation(this.container, this, className, this::getActualBytes, hook);
        }

        /*
         * WARNING - void declaration
         */
        @Trivial
        private byte[] getActualBytes() {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CCL: EntryUniversalResource.getActualBytes for " + this.resourceName), (Object[])new Object[0]);
            }
            try {
                try {
                    InputStream is = (InputStream)this.entry.adapt(InputStream.class);
                    return ContainerClassLoader.getBytes(is, (int)this.entry.getSize());
                }
                catch (UnableToAdaptException is) {
                    void e;
                    FFDCFilter.processException((Throwable)is, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$EntryUniversalResource", (String)"326", (Object)this, (Object[])new Object[0]);
                    throw new IOException((Throwable)e);
                }
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$EntryUniversalResource", (String)"329", (Object)this, (Object[])new Object[0]);
                ContainerClassLoader.sneakyThrow(e);
                return null;
            }
        }

        @Override
        public String getNativeLibraryPath() {
            try {
                NativeLibrary nl = (NativeLibrary)this.entry.adapt(NativeLibrary.class);
                if (nl != null) {
                    return nl.getLibraryFile().getPath();
                }
            }
            catch (UnableToAdaptException unableToAdaptException) {
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$EntryUniversalResource", (String)"341", (Object)this, (Object[])new Object[0]);
            }
            return null;
        }

        @Override
        public String getResourceName() {
            return this.resourceName;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$EntryUniversalResource", EntryUniversalResource.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class ContainerURL {
        final URL url;
        final String urlString;
        static final long serialVersionUID = -615464311668885463L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ContainerURL(URL url) {
            this.url = url;
            this.urlString = url.toString();
        }

        public String toString() {
            return this.urlString;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ContainerURL", ContainerURL.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }
}

