/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.jfapchannel.impl.IdTableFullException;
import com.ibm.ws.sib.utils.ras.SibTr;

public class IdTable {
    private static final TraceComponent tc = SibTr.register(IdTable.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private Object[] table = null;
    private int maxSize = 0;
    private int highWaterMark = 0;
    private int lowestPossibleFree = 0;
    private static final int DEFAULT_INITIAL_SIZE = 50;
    private static final int TABLE_GROWTH_INCREMENT = 50;

    public IdTable(int maxSize) throws IllegalArgumentException {
        this(maxSize, Math.min(maxSize, 50));
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public IdTable(int maxSize, int startSize) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"idTable", (Object)new Object[]{"" + maxSize, "" + startSize});
        }
        if (maxSize < 1) {
            throw new SIErrorException(nls.getFormattedMessage("IDTABLE_INTERNAL_SICJ0050", null, "IDTABLE_INTERNAL_SICJ0050"));
        }
        if (startSize < 1 || startSize > maxSize) {
            throw new SIErrorException(nls.getFormattedMessage("IDTABLE_INTERNAL_SICJ0050", null, "IDTABLE_INTERNAL_SICJ0050"));
        }
        this.maxSize = maxSize;
        this.table = new Object[startSize + 1];
        this.lowestPossibleFree = 1;
        this.highWaterMark = 1;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"idTable");
        }
    }

    public synchronized int add(Object value) throws IdTableFullException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"add", (Object)value);
        }
        if (value == null) {
            throw new SIErrorException(nls.getFormattedMessage("IDTABLE_INTERNAL_SICJ0050", null, "IDTABLE_INTERNAL_SICJ0050"));
        }
        int id = 0;
        if (this.highWaterMark < this.table.length) {
            id = this.highWaterMark;
            if (this.table[id] != null) {
                throw new SIErrorException(nls.getFormattedMessage("IDTABLE_INTERNAL_SICJ0050", null, "IDTABLE_INTERNAL_SICJ0050"));
            }
            this.table[id] = value;
            if (this.lowestPossibleFree == this.highWaterMark) {
                ++this.lowestPossibleFree;
            }
            ++this.highWaterMark;
        } else if (this.table.length < this.maxSize) {
            this.growTable();
            id = this.highWaterMark;
            if (this.table[id] != null) {
                throw new SIErrorException(nls.getFormattedMessage("IDTABLE_INTERNAL_SICJ0050", null, "IDTABLE_INTERNAL_SICJ0050"));
            }
            this.table[id] = value;
            if (this.lowestPossibleFree == this.highWaterMark) {
                ++this.lowestPossibleFree;
            }
            ++this.highWaterMark;
        } else {
            id = this.findFreeSlot();
            if (id == 0) {
                throw new IdTableFullException();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"add", (Object)("" + id));
        }
        return id;
    }

    public synchronized Object remove(int id) throws IllegalArgumentException {
        Object returnValue;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"remove", (Object)("" + id));
        }
        if ((returnValue = this.get(id)) != null) {
            this.table[id] = null;
        }
        if (id < this.lowestPossibleFree) {
            this.lowestPossibleFree = id;
        }
        if (id + 1 == this.highWaterMark) {
            for (int index = id; index >= this.lowestPossibleFree; --index) {
                if (this.table[index] != null) continue;
                this.highWaterMark = index;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"remove", (Object)returnValue);
        }
        return returnValue;
    }

    public synchronized boolean contains(int id) throws IllegalArgumentException {
        boolean returnValue;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"contains", (Object)("" + id));
        }
        if (id < 1 || id > this.maxSize) {
            throw new SIErrorException(nls.getFormattedMessage("IDTABLE_INTERNAL_SICJ0050", null, "IDTABLE_INTERNAL_SICJ0050"));
        }
        boolean bl = returnValue = id < this.table.length && this.table[id] != null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"contains", (Object)("" + returnValue));
        }
        return returnValue;
    }

    public synchronized Object get(int id) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"get", (Object)("" + id));
        }
        if (id < 1 || id > this.maxSize) {
            throw new SIErrorException(nls.getFormattedMessage("IDTABLE_INTERNAL_SICJ0050", null, "IDTABLE_INTERNAL_SICJ0050"));
        }
        Object returnValue = null;
        if (id < this.table.length) {
            returnValue = this.table[id];
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"get", (Object)("" + returnValue));
        }
        return returnValue;
    }

    private void growTable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"growTable");
        }
        int newSize = Math.min(this.table.length + 50, this.maxSize);
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("existing size=" + this.table.length + " new size=" + newSize));
        }
        Object[] newTable = new Object[newSize + 1];
        System.arraycopy(this.table, 0, newTable, 0, this.table.length);
        this.table = newTable;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"growTable");
        }
    }

    private int findFreeSlot() {
        int index;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFreeSlot");
        }
        boolean foundFreeSlot = false;
        int largestIndex = Math.min(this.highWaterMark, this.table.length - 1);
        for (index = this.lowestPossibleFree; !foundFreeSlot && index <= largestIndex; ++index) {
            foundFreeSlot = this.table[index] == null;
        }
        int freeSlot = 0;
        if (foundFreeSlot) {
            freeSlot = index - 1;
            if (index * 2 > largestIndex) {
                boolean quit = false;
                int lowest = index;
                for (index = largestIndex; !quit && index >= lowest; --index) {
                    if (this.table[index] == null) {
                        this.highWaterMark = index;
                        continue;
                    }
                    quit = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFreeSlot", (Object)("" + freeSlot));
        }
        return freeSlot;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/IdTable.java, SIB.comms, WASX.SIB, uu1215.01 1.12");
        }
    }
}

