/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.yoko.orb.IOP.ServiceContexts;
import org.apache.yoko.orb.OB.CodeBaseProxy;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.exceptions.Transients;
import org.apache.yoko.osgi.ProviderLocator;
import org.apache.yoko.util.Assert;
import org.apache.yoko.util.Collectors;
import org.apache.yoko.util.MinorCodes;
import org.apache.yoko.util.PrivilegedActions;
import org.apache.yoko.util.TriFunction;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_CONTEXT;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_QOS;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.FREE_MEM;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.INV_FLAG;
import org.omg.CORBA.INV_IDENT;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CORBA.REBIND;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSACTION_MODE;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TRANSACTION_UNAVAILABLE;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.IOP.ServiceContext;
import org.omg.SendingContext.CodeBase;

public final class Util {
    static final Logger logger = Logger.getLogger(Util.class.getName());

    public static void printOctets(PrintStream out, byte[] oct, int offset, int length) {
        int inc = 8;
        for (int i = offset; i < offset + length; i += 8) {
            int j = i;
            while (j - i < 8) {
                if (j < offset + length) {
                    int n = oct[j];
                    if (n < 0) {
                        n += 256;
                    }
                    String s = n < 10 ? "  " + n : (n < 100 ? " " + n : "" + n);
                    out.print(s + " ");
                } else {
                    out.print("    ");
                }
                ++j;
            }
            out.print('\"');
            for (j = i; j < offset + length && j - i < 8; ++j) {
                if (oct[j] >= 32 && oct[j] < 127) {
                    out.print((char)oct[j]);
                    continue;
                }
                out.print('.');
            }
            out.println('\"');
        }
    }

    public static SystemException copy(SystemException ex) {
        SystemException result;
        try {
            Class<?> c = ((Object)((Object)ex)).getClass();
            Class[] paramTypes = new Class[]{String.class};
            Constructor<?> constr = c.getConstructor(paramTypes);
            Object[] initArgs = new Object[]{ex.getMessage()};
            result = (SystemException)((Object)constr.newInstance(initArgs));
            result.minor = ex.minor;
            result.completed = ex.completed;
            result.initCause((Throwable)ex);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw Assert.fail((Throwable)ex);
        }
        return result;
    }

    public static SystemException readSysEx(InputStream in) {
        String id = in.read_string();
        int minor = in.read_ulong();
        CompletionStatus status = CompletionStatus.from_int((int)in.read_ulong());
        return (SystemException)((Object)SysEx.fromId((String)id).factory.apply(minor, status));
    }

    public static void marshalSystemException(OutputStream out, SystemException ex) {
        out.write_string(Util.getExceptionId((Exception)((Object)ex)));
        out.write_ulong(ex.minor);
        out.write_ulong(ex.completed.value());
    }

    public static boolean isSystemException(String id) {
        return SysEx.isValidId(id);
    }

    public static String getExceptionId(Exception ex) {
        if (ex instanceof SystemException) {
            return SysEx.valueOf((SystemException)((SystemException)((Object)ex))).id;
        }
        if (ex instanceof UserException) {
            Class<?> exClass = ex.getClass();
            String className = exClass.getName();
            String id = null;
            try {
                Class c = ProviderLocator.loadClass((String)(className + "Helper"), exClass, null);
                Method m = c.getMethod("id", new Class[0]);
                id = (String)m.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | SecurityException c) {
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                throw Assert.fail((Throwable)ex);
            }
            if (id == null) {
                return "IDL:omg.org/CORBA/UserException:1.0";
            }
            return id;
        }
        throw Assert.fail((Throwable)ex);
    }

    public static Any insertException(Any any, Exception ex) {
        try {
            Class<?> exClass = ex.getClass();
            String helper = exClass.getName() + "Helper";
            Class c = ProviderLocator.loadClass((String)helper, exClass, (ClassLoader)((ClassLoader)AccessController.doPrivileged(PrivilegedActions.GET_CONTEXT_CLASS_LOADER)));
            Class[] paramTypes = new Class[]{Any.class, exClass};
            Method m = c.getMethod("insert", paramTypes);
            Object[] args = new Object[]{any, ex};
            m.invoke(null, args);
        }
        catch (ClassNotFoundException | SecurityException exClass) {
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw Assert.fail((Throwable)ex);
        }
        return any;
    }

    public static CodeBase getSendingContextRuntime(ORBInstance orbInstance_, ServiceContexts contexts) {
        ServiceContext serviceContext = contexts.get(6);
        return serviceContext == null ? null : new CodeBaseProxy(orbInstance_, serviceContext);
    }

    static enum SysEx {
        BAD_CONTEXT(BAD_CONTEXT::new),
        BAD_INV_ORDER(BAD_INV_ORDER::new, MinorCodes::describeBadInvOrder),
        BAD_OPERATION(BAD_OPERATION::new),
        BAD_PARAM(BAD_PARAM::new, MinorCodes::describeBadParam),
        BAD_QOS(BAD_QOS::new),
        BAD_TYPECODE(BAD_TYPECODE::new),
        CODESET_INCOMPATIBLE(CODESET_INCOMPATIBLE::new),
        COMM_FAILURE(COMM_FAILURE::new, MinorCodes::describeCommFailure),
        DATA_CONVERSION(DATA_CONVERSION::new),
        FREE_MEM(FREE_MEM::new),
        IMP_LIMIT(IMP_LIMIT::new, MinorCodes::describeImpLimit),
        INITIALIZE(INITIALIZE::new, MinorCodes::describeInitialize),
        INTERNAL(INTERNAL::new),
        INTF_REPOS(INTF_REPOS::new, MinorCodes::describeIntfRepos),
        INV_FLAG(INV_FLAG::new),
        INV_IDENT(INV_IDENT::new),
        INV_OBJREF(INV_OBJREF::new),
        INV_POLICY(INV_POLICY::new, MinorCodes::describeInvPolicy),
        INVALID_TRANSACTION(INVALID_TRANSACTION::new),
        MARSHAL(MARSHAL::new, MinorCodes::describeMarshal),
        NO_IMPLEMENT(NO_IMPLEMENT::new, MinorCodes::describeNoImplement),
        NO_MEMORY(NO_MEMORY::new, MinorCodes::describeNoMemory),
        NO_PERMISSION(NO_PERMISSION::new),
        NO_RESOURCES(NO_RESOURCES::new, MinorCodes::describeNoResources),
        NO_RESPONSE(NO_RESPONSE::new),
        OBJ_ADAPTER(OBJ_ADAPTER::new),
        OBJECT_NOT_EXIST(OBJECT_NOT_EXIST::new, MinorCodes::describeObjectNotExist),
        PERSIST_STORE(PERSIST_STORE::new),
        REBIND(REBIND::new),
        TIMEOUT(TIMEOUT::new),
        TRANSACTION_MODE(TRANSACTION_MODE::new),
        TRANSACTION_REQUIRED(TRANSACTION_REQUIRED::new),
        TRANSACTION_ROLLEDBACK(TRANSACTION_ROLLEDBACK::new),
        TRANSACTION_UNAVAILABLE(TRANSACTION_UNAVAILABLE::new),
        TRANSIENT(Transients::create),
        UNKNOWN(UNKNOWN::new, MinorCodes::describeUnknown);

        public static final String ID_PREFIX = "IDL:omg.org/CORBA/";
        public static final String ID_SUFFIX = ":1.0";
        final String id = "IDL:omg.org/CORBA/" + this.name() + ":1.0";
        private static final Map<String, SysEx> INDEX;
        final Constructor factory;

        private SysEx(Constructor factory) {
            this.factory = factory;
        }

        private SysEx(ReasonConstructor factory, ReasonDescriber desc) {
            this(factory.addDescriber(desc));
        }

        static SysEx valueOf(SystemException e) {
            try {
                return SysEx.valueOf(((Object)((Object)e)).getClass().getSimpleName());
            }
            catch (Exception t) {
                return UNKNOWN;
            }
        }

        static SysEx fromId(String id) {
            SysEx result = Optional.of(id).map(INDEX::get).orElse(UNKNOWN);
            if (!result.id.equals(id)) {
                logger.warning("Using " + (Object)((Object)result) + " for unrecognised system exception id: " + id);
            }
            return result;
        }

        static boolean isValidId(String id) {
            return INDEX.containsKey(id);
        }

        static {
            INDEX = (Map)Stream.of(SysEx.values()).collect(Collectors.toUnmodifiableMap(HashMap::new, se -> se.id));
        }

        private static interface ReasonDescriber {
            public String describe(int var1);
        }

        private static interface ReasonConstructor
        extends TriFunction<String, Integer, CompletionStatus, SystemException> {
            default public Constructor addDescriber(ReasonDescriber describer) {
                return (minorCode, completionStatus) -> (SystemException)((Object)((Object)this.apply(describer.describe((int)minorCode), minorCode, completionStatus)));
            }
        }

        private static interface Constructor
        extends BiFunction<Integer, CompletionStatus, SystemException> {
        }
    }
}

