/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import jakarta.el.FunctionMapper;
import java.lang.reflect.Method;
import java.util.HashMap;

public final class ProtectedFunctionMapper
extends FunctionMapper {
    private HashMap<String, Method> fnmap = null;
    private Method theMethod = null;

    private ProtectedFunctionMapper() {
    }

    public static ProtectedFunctionMapper getInstance() {
        ProtectedFunctionMapper funcMapper = new ProtectedFunctionMapper();
        funcMapper.fnmap = new HashMap();
        return funcMapper;
    }

    public void mapFunction(String prefix, String fnName, Class<?> c, String methodName, Class<?>[] args) {
        Method method;
        if (fnName == null) {
            return;
        }
        try {
            method = c.getMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Invalid function mapping - no such method: " + e.getMessage());
        }
        this.fnmap.put(prefix + ":" + fnName, method);
    }

    public static ProtectedFunctionMapper getMapForFunction(String fnQName, Class<?> c, String methodName, Class<?>[] args) {
        Method method = null;
        ProtectedFunctionMapper funcMapper = new ProtectedFunctionMapper();
        if (fnQName != null) {
            try {
                method = c.getMethod(methodName, args);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Invalid function mapping - no such method: " + e.getMessage());
            }
        }
        funcMapper.theMethod = method;
        return funcMapper;
    }

    public Method resolveFunction(String prefix, String localName) {
        if (this.fnmap != null) {
            return this.fnmap.get(prefix + ":" + localName);
        }
        return this.theMethod;
    }
}

