/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.TransmissionData;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ObjectPool;
import java.util.NoSuchElementException;

public class TransmissionDataIterator {
    private static final TraceComponent tc = SibTr.register(TransmissionDataIterator.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static ObjectPool pool;
    private final TransmissionData xmitData = new TransmissionData(this);
    private Connection connection;
    private boolean transmissionsRemaining;
    private JFapChannelConstants.TransmissionLayout layout;
    private JFapByteBuffer buffer;
    private int priority;
    private boolean isPooled;
    private boolean isExchange;
    private int segmentType;
    private int conversationId;
    private int requestNumber;
    private Conversation conversation;
    private SendListener sendListener;
    private boolean isTerminal;
    private int size;
    private int bytesRemaining;

    private TransmissionDataIterator() {
    }

    private void setFields(Connection connection, JFapByteBuffer buffer, int priority, boolean isPooled, boolean isExchange, int segmentType, int conversationId, int requestNumber, Conversation conversation, SendListener sendListener, boolean isTerminal, int size) {
        this.connection = connection;
        this.buffer = buffer;
        this.priority = priority;
        this.isPooled = isPooled;
        this.isExchange = isExchange;
        this.segmentType = segmentType;
        this.conversationId = conversationId;
        this.requestNumber = requestNumber;
        this.conversation = conversation;
        this.sendListener = sendListener;
        this.isTerminal = isTerminal;
        this.size = size;
        this.bytesRemaining = size;
    }

    private void reset(Connection connection, JFapByteBuffer buffer, int priority, boolean isPooled, boolean isExchange, int segmentType, int conversationId, int requestNumber, Conversation conversation, SendListener sendListener, boolean isTerminal, int size) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reset", (Object)new Object[]{connection, buffer, "" + priority, "" + isPooled, "" + isExchange, "" + segmentType, "" + conversationId, "" + requestNumber, conversation, sendListener, "" + isTerminal, "" + size});
        }
        this.setFields(connection, buffer, priority, isPooled, isExchange, segmentType, conversationId, requestNumber, conversation, sendListener, isTerminal, size);
        int sizeIncludingHeaders = size + 10 + 4;
        this.transmissionsRemaining = true;
        if (sizeIncludingHeaders > connection.getMaxTransmissionSize()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"segmenting");
            }
            this.layout = JFapChannelConstants.XMIT_SEGMENT_START;
        } else {
            this.layout = JFapChannelConstants.XMIT_CONVERSATION;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reset");
        }
    }

    public boolean hasNext() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"hasNext");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"hasNext", (Object)("" + this.transmissionsRemaining));
        }
        return this.transmissionsRemaining;
    }

    public TransmissionData next() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"next");
        }
        if (!this.transmissionsRemaining) {
            throw new NoSuchElementException();
        }
        this.xmitData.reset(this.buffer, this.isTerminal, this.connection);
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("layout=" + this.layout));
        }
        if (this.layout == JFapChannelConstants.XMIT_PRIMARY_ONLY) {
            int segmentLength = this.size + 10;
            this.xmitData.setLayoutToPrimary(segmentLength, this.priority, this.isPooled, this.isExchange, this.connection.getNextRequestNumber(), this.segmentType, this.sendListener);
            this.bytesRemaining = 0;
            this.layout = JFapChannelConstants.XMIT_LAYOUT_UNKNOWN;
            this.transmissionsRemaining = false;
        } else if (this.layout == JFapChannelConstants.XMIT_CONVERSATION) {
            int segmentLength = this.size + 10 + 4;
            this.xmitData.setLayoutToConversation(segmentLength, this.priority, this.isPooled, this.isExchange, this.connection.getNextRequestNumber(), this.segmentType, this.conversationId, this.requestNumber, this.conversation, this.sendListener);
            this.bytesRemaining = 0;
            this.layout = JFapChannelConstants.XMIT_LAYOUT_UNKNOWN;
            this.transmissionsRemaining = false;
        } else if (this.layout == JFapChannelConstants.XMIT_SEGMENT_START) {
            int segmentLength = this.connection.getMaxTransmissionSize();
            this.xmitData.setLayoutToStartSegment(segmentLength, this.priority, this.isPooled, this.isExchange, this.connection.getNextRequestNumber(), this.segmentType, this.conversationId, this.requestNumber, this.size);
            this.bytesRemaining -= this.connection.getMaxTransmissionSize() - 26;
            int maxPayloadInNextTransmission = this.connection.getMaxTransmissionSize() - 14;
            this.layout = this.bytesRemaining <= maxPayloadInNextTransmission ? JFapChannelConstants.XMIT_SEGMENT_END : JFapChannelConstants.XMIT_SEGMENT_MIDDLE;
        } else if (this.layout == JFapChannelConstants.XMIT_SEGMENT_MIDDLE) {
            int segmentLength = this.connection.getMaxTransmissionSize();
            this.xmitData.setLayoutToMiddleSegment(segmentLength, this.priority, this.isPooled, this.isExchange, this.connection.getNextRequestNumber(), this.conversationId, this.requestNumber);
            this.bytesRemaining -= this.connection.getMaxTransmissionSize() - 14;
            int maxPayloadInNextTransmission = this.connection.getMaxTransmissionSize() - 14;
            if (this.bytesRemaining <= maxPayloadInNextTransmission) {
                this.layout = JFapChannelConstants.XMIT_SEGMENT_END;
            }
        } else if (this.layout == JFapChannelConstants.XMIT_SEGMENT_END) {
            int segmentLength = this.bytesRemaining + 10 + 4;
            this.xmitData.setLayoutToEndSegment(segmentLength, this.priority, this.isPooled, this.isExchange, this.connection.getNextRequestNumber(), this.conversationId, this.requestNumber, this.conversation, this.sendListener);
            this.bytesRemaining = 0;
            this.layout = JFapChannelConstants.XMIT_LAYOUT_UNKNOWN;
            this.transmissionsRemaining = false;
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("invalid layout: " + this.layout));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"next", (Object)this.xmitData);
        }
        return this.xmitData;
    }

    protected static TransmissionDataIterator allocateFromPool(Connection connection, JFapByteBuffer buffer, int priority, boolean isPooled, boolean isExchange, int segmentType, int conversationId, int requestNumber, Conversation conversation, SendListener sendListener, boolean isTerminal, int size) {
        TransmissionDataIterator retValue;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"allocateFromPool");
        }
        if ((retValue = (TransmissionDataIterator)pool.remove()) == null) {
            retValue = new TransmissionDataIterator();
        }
        retValue.reset(connection, buffer, priority, isPooled, isExchange, segmentType, conversationId, requestNumber, conversation, sendListener, isTerminal, size);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"allocateFromPool", (Object)retValue);
        }
        return retValue;
    }

    protected void release() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"release");
        }
        if (!this.transmissionsRemaining) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"no more transmissions remaining - repooling");
            }
            if (this.buffer != null) {
                this.buffer.release();
            }
            this.connection = null;
            this.conversation = null;
            this.buffer = null;
            this.sendListener = null;
            pool.add((Object)this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"release");
        }
    }

    protected int getPriority() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPriority");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPriority", (Object)("" + this.priority));
        }
        return this.priority;
    }

    protected void setPriority(int priority) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setPriority", (Object)("" + priority));
        }
        this.priority = priority;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setPriority");
        }
    }

    protected int getSize() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSize");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSize", (Object)("" + this.size));
        }
        return this.size;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/TransmissionDataIterator.java, SIB.comms, WASX.SIB, uu1215.01 1.19");
        }
        pool = new ObjectPool("Transmission Data Iterator Pool", 100);
    }
}

