/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.diagnostics.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.SensitiveIntrospector;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConfigAdminIntrospection
extends SensitiveIntrospector {
    private ConfigurationAdmin configAdmin;
    static final long serialVersionUID = -7671658440942144962L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    protected void unsetConfigAdmin(ConfigurationAdmin configAdmin) {
        if (configAdmin == this.configAdmin) {
            this.configAdmin = null;
        }
    }

    public String getIntrospectorName() {
        return "ConfigAdminIntrospection";
    }

    public String getIntrospectorDescription() {
        return "Introspect all Configurations.";
    }

    public void introspect(PrintWriter pw) throws IOException, InvalidSyntaxException {
        Configuration[] configurations = this.configAdmin.listConfigurations(null);
        if (configurations != null) {
            Arrays.sort(configurations, new Comparator<Configuration>(){
                static final long serialVersionUID = -4711066202527758640L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public int compare(Configuration arg0, Configuration arg1) {
                    if (arg0.getBundleLocation() == null) {
                        return arg1.getBundleLocation() == null ? 0 : 1;
                    }
                    if (arg1.getBundleLocation() == null) {
                        return -1;
                    }
                    return arg0.getBundleLocation().compareTo(arg1.getBundleLocation());
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.diagnostics.osgi.ConfigAdminIntrospection$1", 1.class, null, null);
                }
            });
            for (Configuration config : configurations) {
                pw.println("BundleLocation: " + config.getBundleLocation());
                pw.println("PID: " + config.getPid());
                pw.println("FactoryPID: " + config.getFactoryPid());
                Dictionary properties = config.getProperties();
                if (properties != null) {
                    Enumeration e = properties.keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        pw.append("  ").append(key).append(": ");
                        Object value = properties.get(key);
                        if (value != null && value.getClass().isArray()) {
                            pw.append("[");
                            int length = Array.getLength(value);
                            for (int i = 0; i < length; ++i) {
                                if (i > 0) {
                                    if (length > 10) {
                                        pw.println(",");
                                        pw.append("      ");
                                    } else {
                                        pw.append(", ");
                                    }
                                }
                                pw.append(this.getObscuredValue(key, Array.get(value, i)));
                            }
                            pw.append("]");
                        } else {
                            pw.append(this.getObscuredValue(key, value));
                        }
                        pw.println();
                    }
                }
                pw.println();
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.diagnostics.osgi.ConfigAdminIntrospection", ConfigAdminIntrospection.class, null, null);
    }
}

