/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.client;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.sib.trm.security.SecurityUtils;
import com.ibm.ws.sib.trm.utils.TraceUtils;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;

final class CredentialType
implements FFDCSelfIntrospectable {
    static String className = CredentialType.class.getName();
    static TraceComponent tc = SibTr.register(CredentialType.class, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private static SecurityUtils _utils;
    private String credentialType = "Userid+Password";
    private Subject subject = null;
    private byte[] OAT = null;
    private String _busName;
    private String userid = "";
    private String password = "";

    public CredentialType(String busName, Subject subject) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"CredentialType", (Object)new Object[]{busName, TraceUtils.subjectToString(subject)});
        }
        this._busName = busName;
        if (!this.isEmpty(subject)) {
            this.subject = subject;
            try {
                if (_utils != null) {
                    this.credentialType = _utils.isSIBServerSubject(subject) ? "SIB subject" : "Subject";
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(className + "<init>"), (String)"1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)this.toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"CredentialType", (Object)this);
        }
    }

    public CredentialType(String u, String p) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"CredentialType", (Object)new Object[]{u});
        }
        this.userid = u;
        this.password = p;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)this.toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"CredentialType", (Object)this);
        }
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getUserid() {
        return this.userid;
    }

    public String getPassword() {
        return this.password;
    }

    public byte[] getOAT(String meName) {
        if (this.OAT == null && _utils != null) {
            this.OAT = _utils.getOpaqueAuthorizationToken(this._busName, meName, this.subject);
        }
        return this.OAT;
    }

    private boolean isEmpty(Subject identity) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isEmpty", (Object)new Object[]{TraceUtils.subjectToString(identity)});
        }
        boolean retVal = false;
        if (identity == null) {
            retVal = true;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("publicCred.isEmpty: " + identity.getPublicCredentials().isEmpty()));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("privateCred.isEmpty: " + identity.getPrivateCredentials().isEmpty()));
            }
            boolean bl = retVal = identity.getPublicCredentials().isEmpty() && identity.getPrivateCredentials().isEmpty();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isEmpty", (Object)retVal);
        }
        return retVal;
    }

    public String toString() {
        String displayPW = null;
        displayPW = this.password == null ? "<null>" : "****";
        return "credentialType=" + this.credentialType + ",userid=" + this.userid + ",password=" + displayPW;
    }

    public String[] introspectSelf() {
        return new String[]{this.toString()};
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    boolean suppressFFDC = RuntimeInfo.isThinClient() || RuntimeInfo.isFatClient();
                    return null;
                }
            });
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClassNotFoundException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"CNFE received - this is NORMAL if we are running in a client environment");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)cause.getMessage());
                }
            }
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
    }
}

