/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.certificateutil;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;

public class DefaultSubjectDN {
    private final String subjectDN;

    public DefaultSubjectDN() {
        this(null, null);
    }

    public DefaultSubjectDN(String hostName, String serverName) {
        if (hostName == null) {
            hostName = this.getHostName();
        }
        this.subjectDN = serverName == null ? "CN=" + hostName : "CN=" + hostName + ",OU=" + serverName;
    }

    public String getSubjectDN() {
        return this.subjectDN;
    }

    public static String buildSanIpStringFromNetworkInterface() {
        ArrayList<String> sanIpAddress = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface n = e.nextElement();
                Enumeration<InetAddress> ee = n.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress ip = ee.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    sanIpAddress.add(ip.getHostAddress());
                }
            }
        }
        catch (IOException e) {
            sanIpAddress.add("127.0.0.1");
        }
        if (!sanIpAddress.isEmpty()) {
            StringBuilder sb = new StringBuilder("ip:" + ((String)sanIpAddress.get(0)).toString());
            for (int i = 1; i < sanIpAddress.size(); ++i) {
                sb.append(",ip:");
                sb.append(((String)sanIpAddress.get(i)).toString());
            }
            return sb.toString();
        }
        return null;
    }

    private String getHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }
}

