/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.jta.ExtendedTransactionManager;
import com.ibm.tx.jta.impl.JCARecoveryWrapper;
import com.ibm.tx.jta.impl.PartnerLogData;
import com.ibm.tx.jta.impl.PartnerLogTable;
import com.ibm.tx.jta.impl.TranManagerImpl;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.jta.impl.XARecoveryWrapper;
import com.ibm.tx.jta.util.TxTMHelper;
import com.ibm.tx.util.TMHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.UOWCallback;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.wsspi.tx.UOWEventListener;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.io.Serializable;
import javax.transaction.xa.XAResource;

public class TranManagerSet
implements ExtendedTransactionManager,
UOWCurrent {
    private static final TraceComponent tc = Tr.register(TranManagerSet.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected static ExtendedTransactionManager _instance;
    protected volatile boolean _replayComplete;
    protected volatile boolean _quiesced;
    protected static ThreadLocal<?> _thread;

    protected TranManagerSet() {
    }

    public static synchronized ExtendedTransactionManager instance() {
        if (_instance == null) {
            _instance = new TranManagerSet();
            _thread = new ThreadLocal<TranManagerImpl>(){

                @Override
                public TranManagerImpl initialValue() {
                    return new TranManagerImpl();
                }
            };
        }
        return _instance;
    }

    protected TranManagerImpl self() {
        return (TranManagerImpl)_thread.get();
    }

    public void cleanup() {
        if (_thread != null) {
            _thread.remove();
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        TMHelper.checkTMState();
        this.self().begin();
    }

    @Override
    public void begin(int timeout) throws NotSupportedException, SystemException {
        TMHelper.checkTMState();
        this.self().begin(timeout);
    }

    public void beginUserTran() throws NotSupportedException, SystemException {
        TMHelper.checkTMState();
        this.self().beginUserTran();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.self().commit();
    }

    public int getStatus() {
        return this.self().getStatus();
    }

    public Transaction getTransaction() {
        return this.self().getTransaction();
    }

    public TransactionImpl getTransactionImpl() {
        return this.self().getTransactionImpl();
    }

    public void resume(Transaction tran) throws InvalidTransactionException, IllegalStateException {
        this.self().resume(tran);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.self().rollback();
    }

    public void setRollbackOnly() throws IllegalStateException {
        this.self().setRollbackOnly();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        this.self().setTransactionTimeout(timeout);
    }

    public Transaction suspend() {
        return this.self().suspend();
    }

    @Override
    public boolean delist(XAResource xaRes, int flag) {
        return this.self().delist(xaRes, flag);
    }

    public void replayComplete(boolean localFailureScope) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"replayComplete", (Object[])new Object[]{localFailureScope});
        }
        if (localFailureScope) {
            TMHelper.asynchRecoveryProcessingComplete(null);
        }
        this._replayComplete = true;
    }

    public boolean isReplayComplete() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isReplayComplete", (Object[])new Object[]{this._replayComplete});
        }
        return this._replayComplete;
    }

    @Override
    public int registerResourceInfo(String xaResFactoryClassName, Serializable xaResInfo) {
        return this.registerResourceInfo(xaResFactoryClassName, xaResInfo, 0);
    }

    @Override
    public int registerResourceInfo(String xaResFactoryClassName, Serializable xaResInfo, int priority) {
        PartnerLogTable plt;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"registerResourceInfo", (Object[])new Object[]{xaResFactoryClassName, xaResInfo, priority, this});
            }
            try {
                TMHelper.checkTMState();
            }
            catch (NotSupportedException ex) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"registerResourceInfo: checkTMState failed: ", (Object[])new Object[]{ex});
            }
        }
        int index = -1;
        if (xaResFactoryClassName != null && xaResFactoryClassName.length() != 0 && TxTMHelper.ready() && (plt = Configuration.getFailureScopeController().getPartnerLogTable()) != null) {
            XARecoveryWrapper xaWrapper = new XARecoveryWrapper(xaResFactoryClassName, xaResInfo, null, priority);
            PartnerLogData pld = plt.findEntry(xaWrapper);
            pld._terminating = false;
            index = pld.getIndex();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerResourceInfo", (Object)index);
        }
        return index;
    }

    @Override
    public boolean enlist(XAResource xaRes, int recoveryId) throws RollbackException, IllegalStateException, SystemException {
        return this.self().enlist(xaRes, recoveryId);
    }

    public PartnerLogData registerJCAProvider(String providerId) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerJCAProvider", (Object[])new Object[]{providerId});
        }
        JCARecoveryWrapper jcarw = new JCARecoveryWrapper(providerId);
        PartnerLogTable plt = Configuration.getFailureScopeController().getPartnerLogTable();
        PartnerLogData pld = plt.findEntry(jcarw);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerJCAProvider", (Object)pld);
        }
        return pld;
    }

    public void quiesce() {
        this._quiesced = true;
    }

    public boolean isQuiesced() {
        return this._quiesced;
    }

    @Override
    public UOWCoordinator getUOWCoord() {
        return this.self().getUOWCoord();
    }

    @Override
    public int getUOWType() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUOWType", (Object[])new Object[0]);
        }
        UOWCoordinator uowCoord = this.getUOWCoord();
        int result = 0;
        if (uowCoord != null) {
            int n = result = uowCoord.isGlobal() ? 2 : 1;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUOWType", (Object)result);
        }
        return result;
    }

    @Override
    public void registerLTCCallback(UOWCallback callback) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerLTCCallback", (Object[])new Object[]{callback});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerLTCCallback");
        }
    }

    @Override
    public void setUOWEventListener(UOWEventListener el) {
        this.self().setUOWEventListener(el);
    }

    @Override
    public void unsetUOWEventListener(UOWEventListener el) {
        this.self().unsetUOWEventListener(el);
    }
}

