/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.mbean.internal;

import com.ibm.websphere.persistence.mbean.DDLGenerationMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import com.ibm.wsspi.kernel.service.utils.ServiceAndServiceReferencePair;
import com.ibm.wsspi.logging.TextFileOutputStreamFactory;
import com.ibm.wsspi.persistence.DDLGenerationParticipant;
import com.ibm.wsspi.persistence.DDLGenerationWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.DynamicMBean;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={DDLGenerationMBean.class, DynamicMBean.class}, immediate=true, property={"service.vendor=IBM", "jmx.objectname=WebSphere:feature=persistence,type=DDLGenerationMBean,name=DDLGenerationMBean"})
public class DDLGenerationMBeanImpl
extends StandardMBean
implements DDLGenerationMBean {
    private static final TraceComponent tc = Tr.register(DDLGenerationMBeanImpl.class, (String)"persistenceService", null);
    private static final String OUTPUT_DIR = "${server.output.dir}/ddl" + File.separator;
    private static final String KEY_GENERATOR = "generator";
    private final ConcurrentServiceReferenceSet<DDLGenerationParticipant> generators = new ConcurrentServiceReferenceSet("generator");
    private final AtomicReference<WsLocationAdmin> locationService = new AtomicReference();
    static final long serialVersionUID = 164048722294698089L;

    public DDLGenerationMBeanImpl() throws NotCompliantMBeanException {
        super(DDLGenerationMBean.class);
    }

    @Reference(name="generator", service=DDLGenerationParticipant.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void setGenerator(ServiceReference<DDLGenerationParticipant> ref) {
        this.generators.addReference(ref);
    }

    protected void unsetGenerator(ServiceReference<DDLGenerationParticipant> ref) {
        this.generators.removeReference(ref);
    }

    @Reference(name="locationService")
    protected void setLocationService(WsLocationAdmin locationService) {
        this.locationService.set(locationService);
    }

    protected void unsetLocationService(WsLocationAdmin locationService) {
        this.locationService.set(null);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.generators.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.generators.deactivate(cc);
    }

    @Override
    public synchronized Map<String, Serializable> generateDDL() {
        HashMap<String, Serializable> returnMap = new HashMap<String, Serializable>();
        WsResource ddlOutputDirectory = this.locationService.get().resolveResource(OUTPUT_DIR);
        if (!ddlOutputDirectory.exists()) {
            ddlOutputDirectory.create();
        }
        try {
            returnMap.put("output.directory", (Serializable)((Object)ddlOutputDirectory.asFile().getCanonicalPath()));
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.persistence.mbean.internal.DDLGenerationMBeanImpl", (String)"131", (Object)this, (Object[])new Object[0]);
            returnMap.put("output.directory", (Serializable)((Object)OUTPUT_DIR));
        }
        boolean success = true;
        int fileCount = 0;
        HashMap<String, TreeSet<DDLGenerationParticipant>> participants = new HashMap<String, TreeSet<DDLGenerationParticipant>>();
        Iterator i = this.generators.getServicesWithReferences();
        while (i.hasNext()) {
            ServiceAndServiceReferencePair generatorPair = (ServiceAndServiceReferencePair)i.next();
            DDLGenerationParticipant generator = (DDLGenerationParticipant)generatorPair.getService();
            try {
                String rawId = generator.getDDLFileName();
                if (rawId == null) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Service " + generator.toString() + " DDL file name: " + rawId + " : skipping"), (Object[])new Object[0]);
                    continue;
                }
                String id = PathUtils.replaceRestrictedCharactersInFileName((String)rawId);
                if (id == null || id.length() == 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Service " + generator.toString() + " DDL file name null or empty : skipping with error"), (Object[])new Object[0]);
                    }
                    throw new IllegalArgumentException("Service " + generator.toString() + " DDL file name null or empty");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Service " + generator.toString() + " DDL file name: " + id), (Object[])new Object[0]);
                }
                DDLGenerationParticipantComparator comparator = new DDLGenerationParticipantComparator();
                TreeSet<DDLGenerationParticipant> participantList = (TreeSet<DDLGenerationParticipant>)participants.get(id);
                if (participantList == null) {
                    participantList = new TreeSet<DDLGenerationParticipant>(comparator);
                    participants.put(id, participantList);
                }
                participantList.add(generator);
            }
            catch (Throwable rawId) {
                FFDCFilter.processException((Throwable)rawId, (String)"com.ibm.ws.persistence.mbean.internal.DDLGenerationMBeanImpl", (String)"178", (Object)this, (Object[])new Object[0]);
                success = false;
            }
        }
        for (Map.Entry entry : participants.entrySet()) {
            String id = (String)entry.getKey();
            TreeSet participantList = (TreeSet)entry.getValue();
            WsResource ddlOutputResource = this.locationService.get().resolveResource(OUTPUT_DIR + id + ".ddl");
            if (!ddlOutputResource.exists()) {
                ddlOutputResource.create();
            }
            try {
                TextFileOutputStreamFactory f = TrConfigurator.getFileOutputStreamFactory();
                FileOutputStream os = f.createOutputStream(ddlOutputResource.asFile(), false);
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8));
                DDLGenerationWriter out = new DDLGenerationWriter((Writer)bw);
                for (DDLGenerationParticipant participant : participantList) {
                    participant.generate((Writer)out);
                }
                out.writeExitAndClose();
                ++fileCount;
            }
            catch (Throwable f) {
                FFDCFilter.processException((Throwable)f, (String)"com.ibm.ws.persistence.mbean.internal.DDLGenerationMBeanImpl", (String)"223", (Object)this, (Object[])new Object[0]);
                success = false;
            }
        }
        returnMap.put("success", Boolean.valueOf(success));
        returnMap.put("file.count", Integer.valueOf(fileCount));
        return returnMap;
    }

    @Override
    protected final String getDescription(MBeanInfo info) {
        return "Generates DDL for components using the PersistenceService.";
    }

    @Override
    protected final String getDescription(MBeanOperationInfo info) {
        String operationName;
        String description = "Unknown operation";
        if (info != null && (operationName = info.getName()) != null && operationName.equals("generateDDL")) {
            description = "Generates DDL for components using the PersistenceService.";
        }
        return description;
    }

    @Override
    protected final String getParameterName(MBeanOperationInfo opInfo, MBeanParameterInfo parmInfo, int sequence) {
        String operation;
        String name = "Unknown";
        if (opInfo == null || parmInfo == null || sequence < 0 || (operation = opInfo.getName()) == null || operation.equals("generateDDL")) {
            // empty if block
        }
        return name;
    }

    @Override
    protected final String getDescription(MBeanOperationInfo opInfo, MBeanParameterInfo parmInfo, int sequence) {
        String parmName;
        String description = "Unknown";
        if (opInfo == null || parmInfo == null || sequence < 0 || (parmName = this.getParameterName(opInfo, parmInfo, sequence)) != null) {
            // empty if block
        }
        return description;
    }

    @Trivial
    private static final class DDLGenerationParticipantComparator
    implements Comparator<DDLGenerationParticipant> {
        private DDLGenerationParticipantComparator() {
        }

        @Override
        public int compare(DDLGenerationParticipant o1, DDLGenerationParticipant o2) {
            boolean matchedTypes;
            if (o1.equals(o2)) {
                return 0;
            }
            boolean bl = matchedTypes = o1.getClass() == o2.getClass();
            if (matchedTypes && o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            if (!matchedTypes) {
                return o1.getClass().getCanonicalName().compareTo(o2.getClass().getCanonicalName());
            }
            return 1;
        }
    }
}

