/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapInterceptor;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractSoapInterceptor
extends AbstractPhaseInterceptor<SoapMessage>
implements SoapInterceptor {
    private static final Logger LOG = Logger.getLogger(AbstractSoapInterceptor.class.getName());
    private static final TraceComponent tc = Tr.register(AbstractSoapInterceptor.class, null, null);
    static final long serialVersionUID = -5040049064117290697L;

    public AbstractSoapInterceptor(String p) {
        super(p);
    }

    public AbstractSoapInterceptor(String i, String p) {
        super(i, p);
    }

    @Override
    public Set<URI> getRoles() {
        return Collections.emptySet();
    }

    @Override
    public Set<QName> getUnderstoodHeaders() {
        return Collections.emptySet();
    }

    protected String getFaultCodePrefix(XMLStreamWriter writer, QName faultCode) throws XMLStreamException {
        String codeNs = faultCode.getNamespaceURI();
        String prefix = null;
        if (codeNs.length() > 0) {
            prefix = faultCode.getPrefix();
            if (!StringUtils.isEmpty((String)prefix)) {
                String boundNS = writer.getNamespaceContext().getNamespaceURI(prefix);
                if (StringUtils.isEmpty((String)boundNS)) {
                    writer.writeNamespace(prefix, codeNs);
                } else if (!codeNs.equals(boundNS)) {
                    prefix = null;
                }
            }
            if (StringUtils.isEmpty((String)prefix)) {
                prefix = StaxUtils.getUniquePrefix((XMLStreamWriter)writer, (String)codeNs, (boolean)true);
            }
        }
        return prefix;
    }

    protected void prepareStackTrace(SoapMessage message, SoapFault fault) throws Exception {
        boolean config;
        if (fault.getCause() != null && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Fault occured, printing Exception cause to trace.");
            String stackTraceString = this.buildStackTrace(fault);
            LOG.fine(stackTraceString);
        }
        if ((config = MessageUtils.getContextualBoolean((Message)message, (String)"faultStackTraceEnabled", (boolean)false)) && fault.getCause() != null) {
            String stackTraceString = this.buildStackTraceCXF(fault);
            Element detail = fault.getDetail();
            String soapNamespace = message.getVersion().getNamespace();
            if (detail == null) {
                Document doc = DOMUtils.getEmptyDocument();
                Element stackTrace = doc.createElementNS("http://cxf.apache.org/fault", "stackTrace");
                stackTrace.setTextContent(stackTraceString);
                detail = doc.createElementNS(soapNamespace, "detail");
                fault.setDetail(detail);
                detail.appendChild(stackTrace);
            } else {
                Element stackTrace = detail.getOwnerDocument().createElementNS("http://cxf.apache.org/fault", "stackTrace");
                stackTrace.setTextContent(stackTraceString);
                detail.appendChild(stackTrace);
            }
        }
    }

    private String buildStackTrace(SoapFault fault) {
        StringBuilder sb = new StringBuilder();
        Throwable throwable = fault.getCause();
        sb.append(throwable.getClass().getCanonicalName()).append(": ").append(throwable.getMessage()).append("\n");
        while (throwable != null) {
            for (StackTraceElement ste : throwable.getStackTrace()) {
                sb.append(ste.getClassName()).append(".").append(ste.getMethodName()).append("(").append(ste.getFileName()).append(":").append(ste.getLineNumber()).append(")\n");
            }
            if ((throwable = throwable.getCause()) == null) continue;
            sb.append("Caused by: ").append(throwable.getClass().getCanonicalName()).append(" : ").append(throwable.getMessage()).append("\n");
        }
        return sb.toString();
    }

    private String buildStackTraceCXF(SoapFault fault) {
        StringBuilder sb = new StringBuilder();
        Throwable throwable = fault.getCause();
        sb.append("Caused by: ").append(throwable.getClass().getCanonicalName()).append(": ").append(throwable.getMessage()).append("\n").append("#*#");
        while (throwable != null) {
            for (StackTraceElement ste : throwable.getStackTrace()) {
                sb.append(ste.getClassName()).append("!").append(ste.getMethodName()).append("!").append(ste.getFileName()).append("!").append(ste.getLineNumber()).append("#*#");
            }
            if ((throwable = throwable.getCause()) == null) continue;
            sb.append("Caused by: ").append(throwable.getClass().getCanonicalName()).append(" : ").append(throwable.getMessage()).append("#*#");
        }
        return sb.toString();
    }

    static String getFaultMessage(SoapMessage message, SoapFault fault) {
        if (message.get("forced.faultstring") != null) {
            return (String)message.get("forced.faultstring");
        }
        boolean config = MessageUtils.getContextualBoolean((Message)message, (String)"exceptionMessageCauseEnabled", (boolean)false);
        if (fault.getMessage() != null) {
            if (config && fault.getCause() != null && fault.getCause().getMessage() != null && !fault.getMessage().equals(fault.getCause().getMessage())) {
                return fault.getMessage() + " Caused by: " + fault.getCause().getMessage();
            }
            return fault.getMessage();
        }
        if (config && fault.getCause() != null) {
            if (fault.getCause().getMessage() != null) {
                return fault.getCause().getMessage();
            }
            return fault.getCause().toString();
        }
        return "Fault occurred while processing.";
    }
}

