/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.interceptors.InterceptorProxy;
import com.ibm.ejs.container.util.MethodAttribUtils;
import com.ibm.websphere.csi.ActivitySessionAttribute;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.MethodInterface;
import com.ibm.websphere.csi.TransactionAttribute;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.EJBComponentMetaData;
import com.ibm.ws.ejbcontainer.EJBMethodInterface;
import com.ibm.ws.ejbcontainer.EJBMethodMetaData;
import com.ibm.ws.ejbcontainer.EJBTransactionAttribute;
import com.ibm.ws.ejbcontainer.diagnostics.IntrospectionWriter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataImpl;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ejb.LockType;

public class EJBMethodInfoImpl
extends MetaDataImpl
implements EJBMethodMetaData {
    private static final TraceComponent tc = Tr.register(EJBMethodInfoImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private String methodSignature;
    private String jdiMethodSignature = "- NO JDI SIGNATURE AVAILABLE - ";
    private TransactionAttribute txAttr;
    private ActivitySessionAttribute asAttr = ActivitySessionAttribute.AS_UNKNOWN;
    protected MethodInterface ivInterface;
    private String methodName;
    private boolean isHome;
    private boolean isStatefulSessionBean;
    protected BeanMetaData bmd;
    boolean isStatelessSessionBean;
    boolean isSingletonSessionBean;
    boolean isHomeCreate;
    boolean isComponentRemove;
    protected int isolationAttr;
    boolean readOnlyAttr;
    private boolean isaCMP11CustomFinderWithForUpdateAI = false;
    private boolean isaCMP11FBPK = false;
    private boolean isLocal;
    protected boolean setClassLoader;
    public boolean isCMRSetMethod = false;
    protected boolean isLightweight = false;
    public boolean isLightweightTxCapable = false;
    private String ivJPATaskName = null;
    InterceptorProxy[] ivAroundInterceptors = null;
    Method ivMethod = null;
    int ivNumberOfMethodParms;
    Method ivBridgeMethod = null;
    boolean ivSFSBRemove = false;
    boolean ivRetainIfException = false;
    long ivAccessTimeout = -1L;
    LockType ivLockType;
    boolean ivAsynchMethod = false;
    Class<?>[][] ivDeclaredExceptions;
    Class<?>[] ivDeclaredExceptionsComp;
    boolean ivDenyAll;
    boolean ivPermitAll;
    String[] ivRolesAllowed;

    public EJBMethodInfoImpl(int slotSize) {
        super(slotSize);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.methodSignature + ", " + (Object)((Object)(this.ivInterface != null ? this.getEJBMethodInterface() : null)) + ", " + (this.bmd != null ? this.bmd.j2eeName : null) + ']';
    }

    public void setSecurityPolicy(boolean denyAll, boolean permitAll, String[] rolesAllowed) {
        this.ivDenyAll = denyAll;
        this.ivPermitAll = permitAll;
        this.ivRolesAllowed = rolesAllowed;
    }

    public String getBeanClassName() {
        return this.bmd.enterpriseBeanClassName;
    }

    public String getAbstractBeanClassName() {
        return this.bmd.enterpriseBeanAbstractClass.getName();
    }

    @Deprecated
    public String getHomeName() {
        String returnValue = this.bmd.simpleJndiBindingName;
        if ((returnValue == null || returnValue.equals("")) && ((returnValue = this.bmd.ivRemoteHomeJndiName) == null || returnValue.equals(""))) {
            returnValue = this.bmd.ivLocalHomeJndiName;
        }
        return returnValue;
    }

    @Override
    public String getMethodName() {
        if (this.methodName == null && this.methodSignature != null) {
            this.methodName = this.methodSignature.substring(0, this.methodSignature.indexOf(":"));
        }
        return this.methodName;
    }

    @Override
    public String getMethodSignature() {
        return this.methodSignature;
    }

    public void setMethodDescriptor(String descriptor) {
        this.jdiMethodSignature = descriptor;
    }

    @Override
    public String getMethodDescriptor() {
        return this.jdiMethodSignature;
    }

    public String getJDIMethodSignature() {
        return this.jdiMethodSignature;
    }

    public TransactionAttribute getTransactionAttribute() {
        return this.txAttr;
    }

    @Override
    public EJBTransactionAttribute getEJBTransactionAttribute() {
        return EJBTransactionAttribute.forValue(this.txAttr.getValue());
    }

    public void setCMP11FBPK(boolean value) {
        this.isaCMP11FBPK = value;
    }

    public boolean getIsCMP11FBPK() {
        return this.isaCMP11FBPK;
    }

    public void setCMP11CustomFinderWithForUpdateAI(boolean value) {
        this.isaCMP11CustomFinderWithForUpdateAI = value;
    }

    public boolean getIsCMP11CustomFinderWithForUpdateAI() {
        return this.isaCMP11CustomFinderWithForUpdateAI;
    }

    public void setIsolationLevel(int isolationLevel) {
        this.isolationAttr = isolationLevel;
    }

    public int getIsolationLevel() {
        return this.isolationAttr;
    }

    public void setActivitySessionAttribute(ActivitySessionAttribute asAttr) {
        this.asAttr = asAttr;
    }

    public ActivitySessionAttribute getActivitySessionAttribute() {
        return this.asAttr;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnlyAttr = readOnly;
    }

    public boolean getReadOnlyAttribute() {
        return this.readOnlyAttr;
    }

    @Override
    public EJBMethodInterface getEJBMethodInterface() {
        return EJBMethodInterface.forValue(this.ivInterface.getValue());
    }

    public MethodInterface getInterfaceType() {
        return this.ivInterface;
    }

    public boolean isHome() {
        return this.isHome;
    }

    public boolean isStatefulSessionBean() {
        return this.isStatefulSessionBean;
    }

    public boolean isStatelessSessionBean() {
        return this.isStatelessSessionBean;
    }

    public boolean isSingletonSessionBean() {
        return this.isSingletonSessionBean;
    }

    public boolean isHomeCreate() {
        return this.isHomeCreate;
    }

    public boolean isComponentRemove() {
        return this.isComponentRemove;
    }

    public void setComponentRemove(boolean componentRemove) {
        this.isComponentRemove = componentRemove;
    }

    public boolean isLocalInterface() {
        return this.isLocal;
    }

    public boolean isLightweight() {
        return this.isLightweight;
    }

    public ComponentMetaData getComponentMetaData() {
        return this.bmd;
    }

    @Override
    public EJBComponentMetaData getEJBComponentMetaData() {
        return this.bmd;
    }

    public BeanMetaData getBeanMetaData() {
        return this.bmd;
    }

    public boolean getCommitDanglingWork() {
        return this.bmd.commitDanglingWork;
    }

    public String getName() {
        return this.methodName;
    }

    public void release() {
    }

    public void initializeInstanceData(String methodSign, String methodNameOnly, BeanMetaData beanMetaData, MethodInterface methodInterface, TransactionAttribute tranAttr, boolean asyncMethod) {
        this.methodSignature = methodSign;
        this.methodName = methodNameOnly;
        this.bmd = beanMetaData;
        this.ivInterface = methodInterface;
        this.txAttr = tranAttr;
        this.ivAsynchMethod = asyncMethod;
        if (this.bmd != null) {
            this.isStatefulSessionBean = this.bmd.type == 4;
            this.isStatelessSessionBean = this.bmd.type == 3;
            this.isSingletonSessionBean = this.bmd.type == 2;
        }
        this.isHome = methodInterface == MethodInterface.HOME || methodInterface == MethodInterface.LOCAL_HOME;
        this.isLocal = methodInterface == MethodInterface.LOCAL || methodInterface == MethodInterface.LOCAL_HOME;
        this.isHomeCreate = this.isHome && "create".equals(this.methodName);
        this.setClassLoader = methodInterface == MethodInterface.LOCAL || methodInterface == MethodInterface.LOCAL_HOME || methodInterface == MethodInterface.SERVICE_ENDPOINT || methodInterface == MethodInterface.MESSAGE_LISTENER || methodInterface == MethodInterface.TIMED_OBJECT || this.ivAsynchMethod;
        this.isLightweight = this.isLocal && beanMetaData != null && beanMetaData.isLightweight;
        this.isLightweightTxCapable = !(!this.isLightweight || tranAttr != TransactionAttribute.TX_REQUIRED && tranAttr != TransactionAttribute.TX_SUPPORTS && tranAttr != TransactionAttribute.TX_MANDATORY || this.asAttr != ActivitySessionAttribute.AS_UNKNOWN && this.asAttr != ActivitySessionAttribute.AS_SUPPORTS);
    }

    public String getAMCName() {
        J2EEName j2eeName = this.bmd.getJ2EEName();
        String app = j2eeName.getApplication();
        String mod = j2eeName.getModule();
        String comp = j2eeName.getComponent();
        String retval = app + "::" + mod + "::" + comp;
        return retval;
    }

    public J2EEName getJ2EEName() {
        return this.bmd.getJ2EEName();
    }

    public int getBeanType() {
        return this.bmd.type;
    }

    public boolean isReentrant() {
        return this.bmd.reentrant;
    }

    @Override
    public Method getMethod() {
        return this.ivMethod;
    }

    public void setMethod(Method method) {
        this.ivMethod = method;
    }

    public int getNumberOfMethodParms() {
        return this.ivNumberOfMethodParms;
    }

    public void setNumberOfMethodParms(int numberOfParms) {
        this.ivNumberOfMethodParms = numberOfParms;
    }

    public void setBridgeMethod(Method bridgeMethod) {
        this.ivBridgeMethod = bridgeMethod;
    }

    public Method getBridgeMethod() {
        return this.ivBridgeMethod;
    }

    public boolean methodsMatch(Method method) {
        Class<?>[] parms2;
        Class<?>[] parms1;
        boolean match = false;
        if (method == this.ivMethod || method == this.ivBridgeMethod) {
            match = true;
        } else if (method.getName().equals(this.ivMethod.getName()) && (parms1 = method.getParameterTypes()).length == (parms2 = this.ivMethod.getParameterTypes()).length) {
            int i;
            match = true;
            int length = parms1.length;
            for (i = 0; i < length; ++i) {
                if (parms1[i] == parms2[i]) continue;
                match = false;
                break;
            }
            if (!match && this.ivBridgeMethod != null) {
                match = true;
                parms2 = this.ivBridgeMethod.getParameterTypes();
                for (i = 0; i < length; ++i) {
                    if (parms1[i] == parms2[i]) continue;
                    match = false;
                    break;
                }
            }
        }
        return match;
    }

    public InterceptorProxy[] getAroundInterceptorProxies() {
        return this.ivAroundInterceptors;
    }

    public void setAroundInterceptorProxies(InterceptorProxy[] proxies) {
        this.ivAroundInterceptors = proxies;
    }

    public void setSFSBRemove(boolean retainIfException) {
        this.ivSFSBRemove = true;
        this.ivRetainIfException = retainIfException;
    }

    public String getRunAsSpecifiedIdentity() {
        return this.bmd.ivRunAs;
    }

    public void setRunAsSpecifiedIdentity(String identity) {
        this.bmd.ivRunAs = identity;
    }

    public boolean isRunAsCallerIdentity() {
        return this.bmd.ivUseCallerIdentity;
    }

    public void setRunAsCallerIdentity(boolean runAs) {
        this.bmd.ivUseCallerIdentity = runAs;
    }

    public String getRole(String link) {
        String result = null;
        if (this.bmd.ivRoleLinkMap != null) {
            result = this.bmd.ivRoleLinkMap.get(link);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRoleFromLink returning " + result), (Object[])new Object[0]);
        }
        return result;
    }

    public void introspect(IntrospectionWriter writer, String type, int methodId, boolean dumpCMP2xAccessIntent) {
        writer.begin(null);
        writer.println("Method signature  = " + this.methodSignature + (type != null ? "  (" + type + ")" : ""));
        writer.println("Method index      = " + (methodId != Integer.MAX_VALUE ? Integer.valueOf(methodId) : "unknown"));
        writer.println("TX attribute      = " + MethodAttribUtils.TX_ATTR_STR[this.txAttr.getValue()]);
        if (this.asAttr != null) {
            writer.println("AS attribute      = " + this.asAttr.toString());
        }
        if (this.bmd.ivModuleVersion <= 11) {
            writer.println("CMP 1.x Isolation Level = " + MethodAttribUtils.getIsolationLevelString(this.isolationAttr));
            if (this.bmd.cmpVersion == 1) {
                writer.println("CMP 1.x access intent(read-only attribute) = " + this.readOnlyAttr);
            }
        } else if (this.bmd.cmpVersion == 2 && dumpCMP2xAccessIntent) {
            this.introspectCMP2xAccessIntent(writer);
        } else if (this.bmd.cmpVersion == 1) {
            writer.println("CMP 1.x Isolation Level = " + MethodAttribUtils.getIsolationLevelString(this.isolationAttr));
            writer.println("CMP 1.x access intent(read-only attribute) = " + this.readOnlyAttr);
        }
        writer.println("isAsynchMethod    = " + this.ivAsynchMethod);
        writer.println("JDI signature     = " + this.jdiMethodSignature);
        if (this.isSingletonSessionBean) {
            if (this.bmd.ivSingletonUsesBeanManagedConcurrency) {
                writer.println("Singleton LockType       = Bean Managed");
            } else {
                String lockType = null;
                if (this.ivLockType != null) {
                    lockType = this.ivLockType.name();
                } else if (this.ivInterface == MethodInterface.LIFECYCLE_INTERCEPTOR) {
                    lockType = "not applicable for lifecycle methods";
                }
                writer.println("Singleton LockType       = " + lockType);
                writer.println("Singleton Access Timeout = " + this.ivAccessTimeout);
            }
        } else if (this.isStatefulSessionBean) {
            writer.println("Stateful Access Timeout = " + this.ivAccessTimeout);
        }
        this.introspectDeclaredExceptions(writer);
        this.introspectSecurityInfo(writer);
        writer.end();
    }

    private void introspectDeclaredExceptions(IntrospectionWriter writer) {
        if (this.ivDeclaredExceptions != null) {
            int interfaceidx = 0;
            for (Object[] objectArray : this.ivDeclaredExceptions) {
                writer.println("Declared exceptions in business interface [" + interfaceidx++ + "] = " + Arrays.toString(objectArray));
            }
        }
        if (this.ivDeclaredExceptionsComp != null) {
            writer.println("Declared exceptions in component interface    = " + Arrays.toString(this.ivDeclaredExceptionsComp));
        }
    }

    protected void introspectCMP2xAccessIntent(IntrospectionWriter writer) {
    }

    public boolean isSFSBRemoveMethod() {
        return this.ivSFSBRemove;
    }

    @Override
    public boolean isStatefulRemove() {
        return this.ivSFSBRemove;
    }

    public boolean isBeanRemove() {
        return this.isComponentRemove || this.ivSFSBRemove;
    }

    public String getJPATaskName() {
        if (this.ivJPATaskName == null) {
            this.ivJPATaskName = this.bmd.enterpriseBeanClassName + "." + this.getMethodName();
        }
        return this.ivJPATaskName;
    }

    public boolean isAsynchMethod() {
        return this.ivAsynchMethod;
    }

    public void setCMLockType(LockType lockType) {
        this.ivLockType = lockType;
    }

    public void setCMLockAccessTimeout(long accessTimeout) {
        this.ivAccessTimeout = accessTimeout;
    }

    public void setDeclaredExceptions(Class<?>[][] declaredExceptions) {
        this.ivDeclaredExceptions = declaredExceptions;
    }

    public void setDeclaredExceptionsComp(Class<?>[] declaredExceptionsComp) {
        this.ivDeclaredExceptionsComp = declaredExceptionsComp;
    }

    @Override
    public boolean isDenyAll() {
        return this.ivDenyAll;
    }

    @Override
    public boolean isPermitAll() {
        return this.ivPermitAll;
    }

    @Override
    public List<String> getRolesAllowed() {
        return this.ivRolesAllowed == null ? Collections.emptyList() : Arrays.asList(this.ivRolesAllowed);
    }

    @Override
    public boolean isUseCallerPrincipal() {
        throw new UnsupportedOperationException("This method is not currently implemented");
    }

    @Override
    public boolean isUseSystemPrincipal() {
        throw new UnsupportedOperationException("This method is not currently implemented");
    }

    @Override
    public String getRunAs() {
        return this.bmd.ivRunAs;
    }

    protected void introspectSecurityInfo(IntrospectionWriter writer) {
        writer.println("DenyAll       = " + this.ivDenyAll);
        writer.println("PermitAll     = " + this.ivPermitAll);
        writer.println("RolesAllowed  = " + this.getRolesAllowed());
    }
}

