/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.persistence.PersistenceException;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitProperty;

public class SEPersistenceUnitInfo
implements PersistenceUnitInfo {
    protected SharedCacheMode cacheMode;
    protected ValidationMode validationMode;
    protected String persistenceUnitName;
    protected String persistenceProviderClassName;
    protected DataSource jtaDataSource;
    protected DataSource nonJtaDataSource;
    protected PersistenceUnitTransactionType persistenceUnitTransactionType;
    protected List<String> mappingFiles;
    private Collection<String> jarFiles = new ArrayList<String>();
    protected List<URL> jarFileUrls;
    protected List<String> managedClassNames;
    protected URL persistenceUnitRootUrl;
    protected boolean excludeUnlistedClasses = true;
    protected List<SEPersistenceUnitProperty> persistenceUnitProperties = new ArrayList<SEPersistenceUnitProperty>();
    protected Properties properties;
    protected ClassLoader tempClassLoader;
    protected ClassLoader realClassLoader;

    public SEPersistenceUnitInfo() {
        this.mappingFiles = new ArrayList<String>();
        this.managedClassNames = new ArrayList<String>();
        this.properties = new Properties();
        this.persistenceUnitTransactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public List<SEPersistenceUnitProperty> getPersistenceUnitProperties() {
        return this.persistenceUnitProperties;
    }

    public void setPersistenceUnitProperties(List<SEPersistenceUnitProperty> persistenceUnitProperties) {
        this.persistenceUnitProperties = persistenceUnitProperties;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    public void setPersistenceProviderClassName(String persistenceProviderClassName) {
        this.persistenceProviderClassName = persistenceProviderClassName;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.persistenceUnitTransactionType;
    }

    public void setTransactionType(PersistenceUnitTransactionType persistenceUnitTransactionType) {
        this.persistenceUnitTransactionType = persistenceUnitTransactionType;
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public void setJtaDataSource(DataSource jtaDataSource) {
        this.jtaDataSource = jtaDataSource;
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public void setNonJtaDataSource(DataSource nonJtaDataSource) {
        this.nonJtaDataSource = nonJtaDataSource;
    }

    public List<String> getMappingFileNames() {
        return this.mappingFiles;
    }

    public void setMappingFileNames(List<String> mappingFiles) {
        this.mappingFiles = mappingFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URL> getJarFileUrls() {
        if (this.jarFileUrls == null) {
            ArrayList<URL> jarFileUrls = new ArrayList<URL>(this.jarFiles.size());
            for (String jarFile : this.jarFiles) {
                try {
                    URL jarFileURL = new URL(this.persistenceUnitRootUrl, jarFile);
                    jarFileUrls.add(jarFileURL);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            SEPersistenceUnitInfo sEPersistenceUnitInfo = this;
            synchronized (sEPersistenceUnitInfo) {
                this.jarFileUrls = jarFileUrls;
            }
        }
        return Collections.unmodifiableList(this.jarFileUrls);
    }

    public void setJarFileUrls(List<URL> jarFileUrls) {
        this.jarFileUrls = jarFileUrls;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitRootUrl;
    }

    public void setPersistenceUnitRootUrl(URL persistenceUnitRootUrl) {
        this.persistenceUnitRootUrl = persistenceUnitRootUrl;
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public void setManagedClassNames(List<String> managedClassNames) {
        this.managedClassNames = managedClassNames;
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.excludeUnlistedClasses = excludeUnlistedClasses;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public ClassLoader getClassLoader() {
        return this.realClassLoader;
    }

    public void addTransformer(ClassTransformer transformer) {
    }

    public ClassLoader getNewTempClassLoader() {
        return this.tempClassLoader;
    }

    public void setNewTempClassLoader(ClassLoader loader) {
        this.tempClassLoader = loader;
    }

    public void setSharedCacheMode(String sharedCacheMode) {
        this.cacheMode = SharedCacheMode.valueOf((String)sharedCacheMode);
    }

    public void setValidationMode(String validationMode) {
        this.validationMode = ValidationMode.valueOf((String)validationMode);
    }

    public void setClassLoader(ClassLoader loader) {
        this.realClassLoader = loader;
    }

    public Collection<String> getJarFiles() {
        return this.jarFiles;
    }

    public String getPersistenceXMLSchemaVersion() {
        throw new PersistenceException("Not Yet Implemented");
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.cacheMode;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }
}

