/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import org.eclipse.microprofile.openapi.models.info.Contact;

public class ContactValidator
extends TypeValidator<Contact> {
    private static final TraceComponent tc = Tr.register(ContactValidator.class);
    private static final ContactValidator INSTANCE = new ContactValidator();

    public static ContactValidator getInstance() {
        return INSTANCE;
    }

    private ContactValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Contact t) {
        if (t != null) {
            String email;
            String url = t.getUrl();
            if (url != null && !ValidatorUtils.isValidURI(url)) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"contactInvalidURL", (Object[])new Object[]{url});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("url"), message));
            }
            if ((email = t.getEmail()) != null && !ValidatorUtils.isValidEmailAddress(email)) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"contactInvalidEmail", (Object[])new Object[]{email});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("email"), message));
            }
        }
    }
}

