/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.items;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class SIMPItem
extends Item {
    private static final TraceComponent tc = SibTr.register(SIMPItem.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int DEFAULT_PERSISTENT_VERSION = 1;

    public int getPersistentVersion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentVersion");
            SibTr.exit((TraceComponent)tc, (String)"getPersistentVersion", (Object)1);
        }
        return 1;
    }

    protected void getPersistentData(ObjectOutputStream oos) {
    }

    protected void restore(ObjectInputStream ois, int dataVersion) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{dataVersion});
        }
        this.checkPersistentVersionId(dataVersion);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    protected void checkPersistentVersionId(int dataVersion) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkPersistentVersionId", (Object)dataVersion);
        }
        if (dataVersion != this.getPersistentVersion()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkPersistentVersionId", (Object)"SIErrorException");
            }
            SibTr.error((TraceComponent)tc, (String)"ITEM_RESTORE_ERROR_CWSIP0261", (Object)new Object[]{this.getPersistentVersion(), dataVersion});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkPersistentVersionId", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("ITEM_RESTORE_ERROR_CWSIP0261", new Object[]{this.getPersistentVersion(), dataVersion}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkPersistentVersionId");
        }
    }

    public final List<DataSlice> getPersistentData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeInt(this.getPersistentVersion());
            this.getPersistentData(oos);
            oos.close();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.SIMPItem.getPersistentData", (String)"1:208:1.21", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)e);
            }
            throw new SIErrorException((Throwable)e);
        }
        byte[] data = bos.toByteArray();
        ArrayList<DataSlice> dataSlices = new ArrayList<DataSlice>(1);
        dataSlices.add(new DataSlice(data));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData", dataSlices);
        }
        return dataSlices;
    }

    public final void restore(List<DataSlice> dataSlices) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", dataSlices);
        }
        try {
            DataSlice slice = dataSlices.get(0);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(slice.getBytes()));
            this.restore(ois, ois.readInt());
            ois.close();
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.SIMPItem.restore", (String)"1:255:1.21", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)e);
            }
            throw new SIErrorException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }
}

