/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.impl;

import com.ibm.ws.sib.matchspace.selector.impl.Pattern;
import com.ibm.ws.sib.matchspace.utils.Trace;
import com.ibm.ws.sib.matchspace.utils.TraceUtils;

class PatternWrapper {
    private static final Class cclass = PatternWrapper.class;
    private static Trace tc = TraceUtils.getTrace(PatternWrapper.class, (String)"SIBMatchSpace");
    static final int PREFIX_CHARS = 0;
    static final int SUFFIX_CHARS = 1;
    static final int SWITCH_TO_SUFFIX = 2;
    static final int FINAL_EXACT = 3;
    static final int FINAL_MANY = 4;
    static final int SKIP_ONE_PREFIX = 5;
    static final int SKIP_ONE_SUFFIX = 6;
    private Pattern pattern;
    boolean prefixDone;
    int next;

    PatternWrapper(Pattern pattern) {
        if (tc.isEntryEnabled()) {
            tc.entry(cclass, "PatternWrapper", (Object)pattern);
        }
        this.pattern = pattern;
        if (tc.isEntryEnabled()) {
            tc.exit(cclass, "PatternWrapper");
        }
    }

    int getState() {
        int state;
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "getState");
        }
        if (!this.prefixDone) {
            Pattern.Clause suffix;
            Pattern.Clause prefix = this.pattern.getPrefix();
            state = prefix == null || this.next >= prefix.items.length ? ((suffix = this.pattern.getSuffix()) == null ? 4 : (suffix == prefix ? 3 : 2)) : (prefix.items[this.next] == Pattern.matchOne ? 5 : 0);
        } else {
            Pattern.Clause suffix = this.pattern.getSuffix();
            int n = this.next < 0 ? 4 : (state = suffix.items[this.next] == Pattern.matchOne ? 6 : 1);
        }
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "getState", (Object)new Integer(state));
        }
        return state;
    }

    void advance() {
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "advance");
        }
        if (!this.prefixDone) {
            Pattern.Clause prefix = this.pattern.getPrefix();
            if (prefix == null || this.next >= prefix.items.length) {
                Pattern.Clause suffix = this.pattern.getSuffix();
                if (suffix != null && suffix != prefix) {
                    this.prefixDone = true;
                    this.next = suffix.items.length - 1;
                }
            } else {
                ++this.next;
            }
        } else {
            --this.next;
        }
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "advance");
        }
    }

    char[] getChars() {
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "getChars");
        }
        char[] ans = this.prefixDone ? (char[])this.pattern.getSuffix().items[this.next--] : (char[])this.pattern.getPrefix().items[this.next++];
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "getChars", (Object)new String(ans));
        }
        return ans;
    }

    public boolean hasMidClauses() {
        return this.pattern.hasMidClauses();
    }

    public boolean matchMidClauses(char[] chars, int start, int length) {
        return this.pattern.matchMiddle(chars, start, start + length);
    }

    public boolean equals(Object o) {
        if (o instanceof PatternWrapper) {
            PatternWrapper other = (PatternWrapper)o;
            return this.pattern.equals(other.pattern);
        }
        return false;
    }
}

