/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;

public class OAuthFlowValidator
extends TypeValidator<OAuthFlow> {
    private static final TraceComponent tc = Tr.register(OAuthFlowValidator.class);
    private static final OAuthFlowValidator INSTANCE = new OAuthFlowValidator();

    public static OAuthFlowValidator getInstance() {
        return INSTANCE;
    }

    private OAuthFlowValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, OAuthFlow t) {
        if (t != null) {
            String message;
            if (t.getAuthorizationUrl() != null && !ValidatorUtils.isValidURI(t.getAuthorizationUrl())) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"oAuthFlowInvalidURL", (Object[])new Object[]{t.getAuthorizationUrl()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("authorizationUrl"), message));
            }
            if (t.getTokenUrl() != null && !ValidatorUtils.isValidURI(t.getTokenUrl())) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"oAuthFlowInvalidURL", (Object[])new Object[]{t.getTokenUrl()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("tokenUrl"), message));
            }
            if (t.getRefreshUrl() != null && !ValidatorUtils.isValidURI(t.getRefreshUrl())) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"oAuthFlowInvalidURL", (Object[])new Object[]{t.getRefreshUrl()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("refreshUrl"), message));
            }
            ValidatorUtils.validateRequiredField(t.getScopes(), context, "scopes").ifPresent(helper::addValidationEvent);
        }
    }
}

