/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LibertyVersion
implements Comparable<LibertyVersion> {
    private final int major;
    private final int minor;
    private final int micro;
    private final int qualifier;
    private static final Pattern VALID_VERSION = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)");

    public static LibertyVersion valueOf(String versionString) {
        if (versionString == null) {
            return null;
        }
        Matcher versionMatcher = VALID_VERSION.matcher(versionString = versionString.trim());
        if (!versionMatcher.matches()) {
            return null;
        }
        return new LibertyVersion(Integer.parseInt(versionMatcher.group(1)), Integer.parseInt(versionMatcher.group(2)), Integer.parseInt(versionMatcher.group(3)), Integer.parseInt(versionMatcher.group(4)));
    }

    private LibertyVersion(int major, int minor, int micro, int qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
    }

    public boolean matchesToMicros(LibertyVersion other) {
        if (other == null) {
            return true;
        }
        return this.major == other.major && this.minor == other.minor && this.micro == other.micro;
    }

    @Override
    public int compareTo(LibertyVersion o) {
        if (this.equals(o)) {
            return 0;
        }
        if (o == null) {
            throw new NullPointerException();
        }
        if (this.major < o.major) {
            return -1;
        }
        if (this.major > o.major) {
            return 1;
        }
        if (this.minor < o.minor) {
            return -1;
        }
        if (this.minor > o.minor) {
            return 1;
        }
        if (this.micro < o.micro) {
            return -1;
        }
        if (this.micro > o.micro) {
            return 1;
        }
        if (this.qualifier < o.qualifier) {
            return -1;
        }
        if (this.qualifier > o.qualifier) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.micro + "." + this.qualifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.micro;
        result = 31 * result + this.minor;
        result = 31 * result + this.qualifier;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LibertyVersion other = (LibertyVersion)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.micro != other.micro) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.qualifier == other.qualifier;
    }
}

