/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.enablement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.api.helpers.AbstractBootstrapService;
import org.jboss.weld.bootstrap.enablement.EnablementListView;
import org.jboss.weld.bootstrap.enablement.Item;
import org.jboss.weld.bootstrap.enablement.ModuleEnablement;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.logging.LogMessageCallback;
import org.jboss.weld.logging.MessageCallback;
import org.jboss.weld.logging.ValidatorLogger;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.Function;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.ImmutableMap;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.collections.Iterables;
import org.jboss.weld.util.reflection.Reflections;

public class GlobalEnablementBuilder
extends AbstractBootstrapService {
    private final List<Item> alternatives = Collections.synchronizedList(new ArrayList());
    private final List<Item> interceptors = Collections.synchronizedList(new ArrayList());
    private final List<Item> decorators = Collections.synchronizedList(new ArrayList());
    private volatile Map<Class<?>, Integer> cachedAlternativeMap;
    private volatile boolean sorted;

    private void addItem(List<Item> list, Class<?> javaClass, int priority) {
        list.add(new Item(javaClass, priority));
    }

    public void addAlternative(Class<?> javaClass, int priority) {
        this.addItem(this.alternatives, javaClass, priority);
    }

    public void addInterceptor(Class<?> javaClass, int priority) {
        this.addItem(this.interceptors, javaClass, priority);
    }

    public void addDecorator(Class<?> javaClass, int priority) {
        this.addItem(this.decorators, javaClass, priority);
    }

    public List<Class<?>> getAlternativeList(final Extension extension) {
        this.initialize();
        return new EnablementListView(){

            @Override
            protected Extension getExtension() {
                return extension;
            }

            @Override
            protected EnablementListView.ViewType getViewType() {
                return EnablementListView.ViewType.ALTERNATIVES;
            }

            @Override
            protected List<Item> getDelegate() {
                return GlobalEnablementBuilder.this.alternatives;
            }
        };
    }

    public List<Class<?>> getInterceptorList(final Extension extension) {
        this.initialize();
        return new EnablementListView(){

            @Override
            protected Extension getExtension() {
                return extension;
            }

            @Override
            protected EnablementListView.ViewType getViewType() {
                return EnablementListView.ViewType.INTERCEPTORS;
            }

            @Override
            protected List<Item> getDelegate() {
                return GlobalEnablementBuilder.this.interceptors;
            }
        };
    }

    public List<Class<?>> getDecoratorList(final Extension extension) {
        this.initialize();
        return new EnablementListView(){

            @Override
            protected Extension getExtension() {
                return extension;
            }

            @Override
            protected EnablementListView.ViewType getViewType() {
                return EnablementListView.ViewType.DECORATORS;
            }

            @Override
            protected List<Item> getDelegate() {
                return GlobalEnablementBuilder.this.decorators;
            }
        };
    }

    private Map<Class<?>, Integer> getGlobalAlternativeMap() {
        if (this.cachedAlternativeMap == null) {
            HashMap map = new HashMap();
            ListIterator<Item> iterator = this.alternatives.listIterator();
            while (iterator.hasNext()) {
                Item item = iterator.next();
                map.put(item.getJavaClass(), iterator.previousIndex());
            }
            this.cachedAlternativeMap = ImmutableMap.copyOf(map);
        }
        return this.cachedAlternativeMap;
    }

    private void initialize() {
        if (!this.sorted) {
            Collections.sort(this.alternatives);
            Collections.sort(this.interceptors);
            Collections.sort(this.decorators);
            this.sorted = true;
        }
    }

    public ModuleEnablement createModuleEnablement(BeanDeployment deployment) {
        ClassLoader loader = new ClassLoader(deployment.getBeanManager().getServices().get(ResourceLoader.class));
        BeansXml beansXml = deployment.getBeanDeploymentArchive().getBeansXml();
        Set<Class<Object>> alternativeClasses = null;
        Set alternativeStereotypes = null;
        List<Class<?>> globallyEnabledInterceptors = this.getInterceptorList(null);
        List<Class<?>> globallyEnabledDecorators = this.getDecoratorList(null);
        ImmutableList.Builder<Class<?>> moduleInterceptorsBuilder = ImmutableList.builder();
        moduleInterceptorsBuilder.addAll((Iterable<Class<?>>)globallyEnabledInterceptors);
        ImmutableList.Builder<Class<?>> moduleDecoratorsBuilder = ImmutableList.builder();
        moduleDecoratorsBuilder.addAll((Iterable<Class<?>>)globallyEnabledDecorators);
        if (beansXml != null) {
            this.checkForDuplicates(beansXml.getEnabledInterceptors(), ValidatorLogger.INTERCEPTOR_SPECIFIED_TWICE);
            this.checkForDuplicates(beansXml.getEnabledDecorators(), ValidatorLogger.DECORATOR_SPECIFIED_TWICE);
            this.checkForDuplicates(beansXml.getEnabledAlternativeClasses(), ValidatorLogger.ALTERNATIVE_CLASS_SPECIFIED_MULTIPLE_TIMES);
            this.checkForDuplicates(beansXml.getEnabledAlternativeStereotypes(), ValidatorLogger.ALTERNATIVE_STEREOTYPE_SPECIFIED_MULTIPLE_TIMES);
            ArrayList interceptorClasses = new ArrayList();
            for (Metadata<String> stringMetadata : beansXml.getEnabledInterceptors()) {
                interceptorClasses.add(loader.apply(stringMetadata));
            }
            moduleInterceptorsBuilder.addAll((Iterable<Class<?>>)this.filter(interceptorClasses, globallyEnabledInterceptors, ValidatorLogger.INTERCEPTOR_ENABLED_FOR_APP_AND_ARCHIVE, deployment));
            ArrayList decoratorClasses = new ArrayList();
            for (Metadata<String> stringMetadata : beansXml.getEnabledDecorators()) {
                decoratorClasses.add(loader.apply(stringMetadata));
            }
            moduleDecoratorsBuilder.addAll((Iterable<Class<?>>)this.filter(decoratorClasses, globallyEnabledDecorators, ValidatorLogger.DECORATOR_ENABLED_FOR_APP_AND_ARCHIVE, deployment));
            alternativeClasses = ImmutableSet.copyOf(Iterables.transform(beansXml.getEnabledAlternativeClasses(), loader));
            alternativeStereotypes = (Set)Reflections.cast(ImmutableSet.copyOf(Iterables.transform(beansXml.getEnabledAlternativeStereotypes(), loader)));
        } else {
            alternativeClasses = Collections.emptySet();
            alternativeStereotypes = Collections.emptySet();
        }
        Map<Class<?>, Integer> globalAlternatives = this.getGlobalAlternativeMap();
        return new ModuleEnablement(moduleInterceptorsBuilder.build(), moduleDecoratorsBuilder.build(), globalAlternatives, alternativeClasses, alternativeStereotypes);
    }

    @Override
    public void cleanupAfterBoot() {
        this.alternatives.clear();
        this.interceptors.clear();
        this.decorators.clear();
    }

    public String toString() {
        return "GlobalEnablementBuilder [alternatives=" + this.alternatives + ", interceptors=" + this.interceptors + ", decorators=" + this.decorators + "]";
    }

    private <T> void checkForDuplicates(List<Metadata<T>> list, MessageCallback<DeploymentException> messageCallback) {
        HashMap<T, Metadata<T>> map = new HashMap<T, Metadata<T>>();
        for (Metadata<T> item : list) {
            Metadata<T> previousOccurrence = map.put(item.getValue(), item);
            if (previousOccurrence == null) continue;
            throw messageCallback.construct(item.getValue(), item, previousOccurrence);
        }
    }

    private <T> List<Class<?>> filter(List<Class<?>> enabledClasses, List<Class<?>> globallyEnabledClasses, LogMessageCallback logMessageCallback, BeanDeployment deployment) {
        Iterator<Class<?>> iterator = enabledClasses.iterator();
        while (iterator.hasNext()) {
            Class<?> enabledClass = iterator.next();
            if (!globallyEnabledClasses.contains(enabledClass)) continue;
            logMessageCallback.log(enabledClass, deployment.getBeanDeploymentArchive().getId());
            iterator.remove();
        }
        return enabledClasses;
    }

    private static class ClassLoader
    implements Function<Metadata<String>, Class<?>> {
        private final ResourceLoader resourceLoader;

        public ClassLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }

        @Override
        public Class<?> apply(Metadata<String> from) {
            try {
                return this.resourceLoader.classForName(from.getValue());
            }
            catch (ResourceLoadingException e) {
                throw BootstrapLogger.LOG.errorLoadingBeansXmlEntry(from.getValue(), from.getLocation(), e.getCause());
            }
            catch (Exception e) {
                throw BootstrapLogger.LOG.errorLoadingBeansXmlEntry(from.getValue(), from.getLocation(), e);
            }
        }
    }
}

