/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.event.ExceptionQueuedEventContext;
import jakarta.faces.view.Location;
import java.util.HashSet;
import java.util.Set;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.view.facelets.compiler.DuplicateIdException;
import org.apache.myfaces.view.facelets.compiler.UILeaf;

public final class CheckDuplicateIdFaceletUtils {
    public static void checkIdsStatefulComponents(FacesContext context, UIComponent view) {
        CheckDuplicateIdFaceletUtils.checkIdsStatefulComponents(context, view, new HashSet<String>());
    }

    private static void checkIdsStatefulComponents(FacesContext context, UIComponent component, Set<String> existingIds) {
        if (component == null) {
            return;
        }
        String id = component.getClientId(context);
        if (!existingIds.add(id)) {
            DuplicateIdException duplicateIdException = CheckDuplicateIdFaceletUtils.createAndQueueException(context, component, id);
            throw duplicateIdException;
        }
        int facetCount = component.getFacetCount();
        if (facetCount > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                if (facet instanceof UILeaf) continue;
                CheckDuplicateIdFaceletUtils.checkIdsStatefulComponents(context, facet, existingIds);
            }
        }
        int childCount = component.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            UIComponent child = (UIComponent)component.getChildren().get(i);
            if (child instanceof UILeaf) continue;
            CheckDuplicateIdFaceletUtils.checkIdsStatefulComponents(context, child, existingIds);
        }
    }

    public static void checkIds(FacesContext context, UIComponent view) {
        CheckDuplicateIdFaceletUtils.checkIds(context, view, new HashSet<String>());
    }

    private static void checkIds(FacesContext context, UIComponent component, Set<String> existingIds) {
        if (component == null) {
            return;
        }
        String id = component.getClientId(context);
        if (!existingIds.add(id)) {
            DuplicateIdException duplicateIdException = CheckDuplicateIdFaceletUtils.createAndQueueException(context, component, id);
            throw duplicateIdException;
        }
        int facetCount = component.getFacetCount();
        if (facetCount > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                CheckDuplicateIdFaceletUtils.checkIds(context, facet, existingIds);
            }
        }
        int childCount = component.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            UIComponent child = (UIComponent)component.getChildren().get(i);
            CheckDuplicateIdFaceletUtils.checkIds(context, child, existingIds);
        }
    }

    private static DuplicateIdException createAndQueueException(FacesContext context, UIComponent component, String id) {
        String message = "Component with duplicate id \"" + id + "\" found.";
        UIComponent firstComponent = context.getViewRoot().findComponent(id);
        if (firstComponent != null) {
            Location location = (Location)firstComponent.getAttributes().get("jakarta.faces.component.VIEW_LOCATION_KEY");
            message = location != null ? message + " The first component is " + location.toString() : message + " The first component is " + RendererUtils.getPathToComponent((UIComponent)firstComponent);
        }
        DuplicateIdException duplicateIdException = new DuplicateIdException(message, firstComponent, component);
        ExceptionQueuedEventContext exceptionContext = new ExceptionQueuedEventContext(context, (Throwable)((Object)duplicateIdException), component, context.getCurrentPhaseId());
        context.getApplication().publishEvent(context, ExceptionQueuedEvent.class, (Object)exceptionContext);
        return duplicateIdException;
    }
}

