/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.common.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.DebugUtils;
import com.ibm.ws.wsat.tm.impl.TranManagerImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.ws.EndpointReference;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextJAXBUtils;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;
import org.apache.cxf.ws.addressing.ReferenceParametersType;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class WSATEndpoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static int MISROUTE_PORT = AccessController.doPrivileged(new PrivilegedAction<Integer>(){
        static final long serialVersionUID = 1214872510424455792L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public Integer run() {
            return Integer.getInteger("MISROUTE_PORT", 0);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsat.common.impl.WSATEndpoint$1", 1.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
        }
    });
    private static final TraceComponent TC = Tr.register(WSATEndpoint.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private static TranManagerImpl tranService = TranManagerImpl.getInstance();
    private transient EndpointReferenceType endpointRef;
    private transient EndpointReferenceType testRef;
    private transient EndpointReference wsEpr;
    private transient EndpointReference testEpr;
    private transient boolean isSecure;

    public WSATEndpoint(EndpointReferenceType epr) {
        this.init(epr);
    }

    public void init(EndpointReferenceType epr) {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"WSATEndpoint.init: ", (Object[])new Object[]{new Exception("WSATEndpoint.init stack")});
        }
        this.endpointRef = epr;
        if (epr != null) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Endpoint:\n{0}", (Object[])new Object[]{DebugUtils.printEPR(epr)});
            }
            this.isSecure = epr.getAddress().getValue().startsWith("https");
            this.wsEpr = AccessController.doPrivileged(new PrivilegedAction<EndpointReference>(){
                static final long serialVersionUID = 2679007733144031930L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public EndpointReference run() {
                    ClassLoader saveLoader = Thread.currentThread().getContextClassLoader();
                    ClassLoader localLoader = tranService.getThreadClassLoader(WSATEndpoint.class);
                    try {
                        Thread.currentThread().setContextClassLoader(localLoader);
                        EndpointReference endpointReference = EndpointReference.readFrom((Source)EndpointReferenceUtils.convertToXML((EndpointReferenceType)WSATEndpoint.this.endpointRef));
                        return endpointReference;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(saveLoader);
                        tranService.destroyThreadClassLoader(localLoader);
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsat.common.impl.WSATEndpoint$2", 2.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
                }
            });
            this.testRef = this.cloneEPR(this.endpointRef);
            try {
                this.misRoute(this.testRef);
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.wsat.common.impl.WSATEndpoint", (String)"109", (Object)this, (Object[])new Object[]{epr});
            }
            this.testEpr = AccessController.doPrivileged(new PrivilegedAction<EndpointReference>(){
                static final long serialVersionUID = -2996238443232592612L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public EndpointReference run() {
                    ClassLoader saveLoader = Thread.currentThread().getContextClassLoader();
                    ClassLoader localLoader = tranService.getThreadClassLoader(WSATEndpoint.class);
                    try {
                        Thread.currentThread().setContextClassLoader(localLoader);
                        EndpointReference endpointReference = EndpointReference.readFrom((Source)EndpointReferenceUtils.convertToXML((EndpointReferenceType)WSATEndpoint.this.testRef));
                        return endpointReference;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(saveLoader);
                        tranService.destroyThreadClassLoader(localLoader);
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsat.common.impl.WSATEndpoint$3", 3.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
                }
            });
        }
    }

    @Trivial
    private void misRoute(EndpointReferenceType epr) throws MalformedURLException {
        if (MISROUTE_PORT != 0) {
            AttributedURIType uri = epr.getAddress();
            URL url = new URL(uri.getValue());
            URL newURL = new URL(url.getProtocol(), "localhost", MISROUTE_PORT, url.getFile());
            AttributedURIType newURI = new AttributedURIType();
            newURI.setValue(newURL.toString());
            epr.setAddress(newURI);
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)("Misrouting: " + epr.getAddress().getValue()), (Object[])new Object[0]);
            }
        }
    }

    @Trivial
    public EndpointReferenceType getEndpointReference() {
        return this.endpointRef;
    }

    @Trivial
    public EndpointReference getWsEpr() {
        return this.wsEpr;
    }

    @Trivial
    public EndpointReference getTestEpr() {
        return this.testEpr;
    }

    @Trivial
    public boolean isSecure() {
        return this.isSecure;
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        try {
            stream.writeObject(this.getXML());
        }
        catch (JAXBException jAXBException) {
            void e;
            FFDCFilter.processException((Throwable)jAXBException, (String)"com.ibm.ws.wsat.common.impl.WSATEndpoint", (String)"180", (Object)this, (Object[])new Object[]{stream});
            throw new IOException((Throwable)e);
        }
    }

    @Trivial
    private String getXML() throws JAXBException {
        if (this.endpointRef != null) {
            StringWriter xmlWriter = new StringWriter();
            JAXBContext jbCtx = ContextJAXBUtils.getJAXBContext();
            JAXBElement jbEpr = ContextUtils.WSA_OBJECT_FACTORY.createEndpointReference(this.endpointRef);
            jbCtx.createMarshaller().marshal((Object)jbEpr, (Writer)xmlWriter);
            return xmlWriter.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        try {
            EndpointReferenceType epr = null;
            String xml = (String)stream.readObject();
            if (xml != null) {
                StringReader xmlReader = new StringReader(xml);
                JAXBContext jbCtx = ContextJAXBUtils.getJAXBContext();
                Object jbEpr = jbCtx.createUnmarshaller().unmarshal((Reader)xmlReader);
                epr = (EndpointReferenceType)((JAXBElement)jbEpr).getValue();
            }
            this.init(epr);
        }
        catch (JAXBException epr) {
            void e;
            FFDCFilter.processException((Throwable)epr, (String)"com.ibm.ws.wsat.common.impl.WSATEndpoint", (String)"213", (Object)this, (Object[])new Object[]{stream});
            throw new IOException((Throwable)e);
        }
    }

    public EndpointReferenceType cloneEPR(EndpointReferenceType epr) {
        EndpointReferenceType newEpr = EndpointReferenceUtils.duplicate((EndpointReferenceType)epr);
        ReferenceParametersType oldParams = epr.getReferenceParameters();
        if (oldParams != null) {
            ReferenceParametersType newParams = new ReferenceParametersType();
            for (Object ref : oldParams.getAny()) {
                newParams.getAny().add(ref);
            }
            newEpr.setReferenceParameters(newParams);
        }
        return newEpr;
    }
}

