/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.globalhandler;

import com.ibm.webservices.handler.impl.GlobalHandlerService;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.bus.LibertyApplicationBus;
import com.ibm.ws.jaxws.globalhandler.AbstractJAXWSGlobalHandlerInterceptor;
import com.ibm.ws.jaxws.globalhandler.GlobalHandlerChainInvoker;
import com.ibm.ws.jaxws.globalhandler.GlobalHandlerJaxWsMessageContext;
import com.ibm.ws.jaxws.globalhandler.JaxwsGlobalHandlerServiceImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.webservices.handler.Handler;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.handler.logical.LogicalMessageContextImpl;
import org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class GlobalHandlerInterceptor
extends AbstractJAXWSGlobalHandlerInterceptor<Message> {
    private final String flow;
    private final LibertyApplicationBus.Type busType;
    private static final TraceComponent tc = Tr.register(GlobalHandlerInterceptor.class, null, null);
    private List<Handler> handlersList;
    static final long serialVersionUID = -5241910472139358602L;

    public GlobalHandlerInterceptor(String phase, String flowType, LibertyApplicationBus.Type bus) {
        super(phase);
        this.flow = flowType.toLowerCase();
        this.busType = bus;
        if (flowType.equalsIgnoreCase("in")) {
            this.addBefore(SOAPHandlerInterceptor.class.getName());
        }
        if (flowType.equalsIgnoreCase("out")) {
            this.addAfter(SOAPHandlerInterceptor.class.getName() + ".ENDING");
        }
    }

    public void handleMessage(Message message) {
        SOAPMessage msg;
        this.handlersList = this.getHanderList(this.busType, this.flow);
        if (this.handlersList.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"no registered global handlers", (Object[])new Object[0]);
            }
            return;
        }
        LogicalMessageContextImpl lctx = new LogicalMessageContextImpl(message);
        boolean requestor = this.isRequestor(message);
        if (!requestor) {
            this.setupBindingOperationInfo(message.getExchange(), lctx);
        }
        Exchange ex = message.getExchange();
        BindingOperationInfo bop = ex.getBindingOperationInfo();
        if (message == ex.getInMessage() && bop != null && ex.getBindingOperationInfo() == null) {
            ex.put((Object)"jakarta.xml.ws.wsdl.operation", (Object)bop.getName());
        }
        GlobalHandlerChainInvoker invoker = new GlobalHandlerChainInvoker();
        GlobalHandlerJaxWsMessageContext ctx = new GlobalHandlerJaxWsMessageContext(message);
        invoker.invokeGlobalHandlers(ctx, this.handlersList);
        if (!MessageUtils.isOutbound((Message)message) && (msg = (SOAPMessage)message.getContent(SOAPMessage.class)) != null) {
            XMLStreamReader xmlReader = this.createXMLStreamReaderFromSOAPMessage(msg);
            message.setContent(XMLStreamReader.class, (Object)xmlReader);
            try {
                SAAJInInterceptor.replaceHeaders((SOAPMessage)msg, (SoapMessage)((SoapMessage)message));
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.jaxws.globalhandler.GlobalHandlerInterceptor", (String)"110", (Object)((Object)this), (Object[])new Object[]{message});
            }
        }
    }

    public void handleFault(Message message) {
    }

    private List<Handler> getHanderList(LibertyApplicationBus.Type busType, String flow) {
        GlobalHandlerService globalHandlerService = (GlobalHandlerService)JaxwsGlobalHandlerServiceImpl.globalHandlerServiceSR.getService();
        List registeredHandlers1 = globalHandlerService.getJAXWSClientSideInFlowGlobalHandlers();
        List registeredHandlers2 = globalHandlerService.getJAXWSClientSideOutFlowGlobalHandlers();
        List registeredHandlers3 = globalHandlerService.getJAXWSServerSideInFlowGlobalHandlers();
        List registeredHandlers4 = globalHandlerService.getJAXWSServerSideOutFlowGlobalHandlers();
        if (busType == LibertyApplicationBus.Type.SERVER && flow.equalsIgnoreCase("IN")) {
            return registeredHandlers3;
        }
        if (busType == LibertyApplicationBus.Type.SERVER && flow.equalsIgnoreCase("OUT")) {
            return registeredHandlers4;
        }
        if (busType == LibertyApplicationBus.Type.CLIENT && flow.equalsIgnoreCase("IN")) {
            return registeredHandlers1;
        }
        if (busType == LibertyApplicationBus.Type.CLIENT && flow.equalsIgnoreCase("OUT")) {
            return registeredHandlers2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private XMLStreamReader createXMLStreamReaderFromSOAPMessage(SOAPMessage soapMessage) {
        XMLStreamReader xmlReader = null;
        try {
            DOMSource bodySource = new DOMSource((Node)soapMessage.getSOAPPart().getEnvelope().getBody());
            xmlReader = StaxUtils.createXMLStreamReader((Source)bodySource);
            xmlReader.nextTag();
            xmlReader.nextTag();
        }
        catch (SOAPException bodySource) {
            void e;
            FFDCFilter.processException((Throwable)bodySource, (String)"com.ibm.ws.jaxws.globalhandler.GlobalHandlerInterceptor", (String)"154", (Object)((Object)this), (Object[])new Object[]{soapMessage});
            throw new Fault((Throwable)e);
        }
        catch (XMLStreamException xMLStreamException) {
            FFDCFilter.processException((Throwable)xMLStreamException, (String)"com.ibm.ws.jaxws.globalhandler.GlobalHandlerInterceptor", (String)"157", (Object)((Object)this), (Object[])new Object[]{soapMessage});
        }
        return xmlReader;
    }
}

