/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.token;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.token.IDTokenValidationFailedException;
import com.ibm.ws.security.openidconnect.token.JWSHeader;
import com.ibm.ws.security.openidconnect.token.JWT;
import com.ibm.ws.security.openidconnect.token.JsonTokenUtil;
import com.ibm.ws.security.openidconnect.token.Payload;
import com.ibm.ws.security.openidconnect.token.PayloadParameter;
import com.ibm.ws.security.openidconnect.token.impl.IdTokenImpl;
import java.util.List;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class IDToken
extends JWT {
    private static final TraceComponent tc = Tr.register(IDToken.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.common.internal.resources.OidcCommonMessages");
    Payload payload = null;
    String ath = null;
    static final long serialVersionUID = 5380828378834957669L;

    public IDToken(JWSHeader header, Payload payload, @Sensitive Object key) {
        super(header, payload, key);
        this.payload = payload;
    }

    public IDToken(JWSHeader header, Payload payload) {
        super(header, payload);
        this.payload = payload;
    }

    public IDToken(JWSHeader header, Payload payload, @Sensitive Object Key2, String accessToken) {
        super(header, payload, Key2);
        this.payload = payload;
        if (accessToken != null) {
            this.payload.setAccessTokenHash(this.accessTokenHash(accessToken));
        }
    }

    public IDToken(String tokenString, @Sensitive Object key, String clientId, String issuer, String signingAlgorithm) {
        super(tokenString, key, clientId, issuer, signingAlgorithm);
        this.payload = new Payload();
    }

    public IDToken(String tokenString, @Sensitive String clientId, String issuer, String signingAlgorithm) {
        super(tokenString, clientId, issuer, signingAlgorithm);
        this.payload = new Payload();
    }

    public IDToken(String tokenString, @Sensitive Object key, String clientId, String issuer, String signingAlgorithm, String accessToken) {
        super(tokenString, key, clientId, issuer, signingAlgorithm);
        this.payload = new Payload();
        if (accessToken != null) {
            this.ath = this.accessTokenHash(accessToken);
        }
    }

    public String accessTokenHash(String accessToken) {
        return JsonTokenUtil.accessTokenHash(accessToken);
    }

    public boolean verifyAccessTokenHash(String accessTokenHash) {
        String decodedAccessTokenHash = JsonTokenUtil.decodeFromBase64String(accessTokenHash);
        String ourDecodedAccessTokenHash = JsonTokenUtil.decodeFromBase64String(this.ath);
        return ourDecodedAccessTokenHash != null && ourDecodedAccessTokenHash.equalsIgnoreCase(decodedAccessTokenHash);
    }

    @Override
    public Payload getPayload() {
        return this.payload;
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    protected void addToPayloadFields(String key) {
        try {
            PayloadParameter param = PayloadParameter.valueOf(key.toUpperCase());
            switch (param) {
                case EXP: {
                    this.payload.setExpirationTimeSeconds((Long)this.payload.get("exp"));
                    break;
                }
                case NBF: {
                    this.payload.setNotBeforeTimeSeconds((Long)this.payload.get("nbf"));
                    break;
                }
                case IAT: {
                    this.payload.setIssuedAtTimeSeconds((Long)this.payload.get("iat"));
                    break;
                }
                case ISS: {
                    this.payload.setIssuer((String)this.payload.get("iss"));
                    break;
                }
                case AUD: {
                    this.payload.setAudience(this.payload.get("aud"));
                    break;
                }
                case JTI: {
                    this.payload.setJwtId((String)this.payload.get("jti"));
                    break;
                }
                case TYP: {
                    this.payload.setType((String)this.payload.get("typ"));
                    break;
                }
                case SUB: {
                    this.payload.setSubject((String)this.payload.get("sub"));
                    break;
                }
                case AUTH_TIME: {
                    this.payload.setAuthorizationTimeSeconds((Long)this.payload.get("auth_time"));
                    break;
                }
                case AZP: {
                    this.payload.setAuthorizedParty((String)this.payload.get("azp"));
                    break;
                }
                case NONCE: {
                    this.payload.setNonce((String)this.payload.get("nonce"));
                    break;
                }
                case AT_HASH: {
                    this.payload.setAccessTokenHash((String)this.payload.get("at_hash"));
                    break;
                }
                case ACR: {
                    this.payload.setClassReference((String)this.payload.get("acr"));
                    break;
                }
                case AMR: {
                    this.payload.setMethodsReferences((List)this.payload.get("amr"));
                    break;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    protected void addToPayloadFields(IdTokenImpl idTokenImpl, String key) {
        try {
            PayloadParameter param = PayloadParameter.valueOf(key.toUpperCase());
            switch (param) {
                case EXP: {
                    idTokenImpl.setExpirationTimeSeconds((Long)this.payload.get("exp"));
                    break;
                }
                case NBF: {
                    idTokenImpl.setNotBeforeTimeSeconds((Long)this.payload.get("nbf"));
                    break;
                }
                case IAT: {
                    idTokenImpl.setIssuedAtTimeSeconds((Long)this.payload.get("iat"));
                    break;
                }
                case ISS: {
                    idTokenImpl.setIssuer((String)this.payload.get("iss"));
                    break;
                }
                case AUD: {
                    idTokenImpl.setAudience(this.payload.get("aud"));
                    break;
                }
                case JTI: {
                    idTokenImpl.setJwtId((String)this.payload.get("jti"));
                    break;
                }
                case TYP: {
                    idTokenImpl.setType((String)this.payload.get("typ"));
                    break;
                }
                case SUB: {
                    idTokenImpl.setSubject((String)this.payload.get("sub"));
                    break;
                }
                case AUTH_TIME: {
                    idTokenImpl.setAuthorizationTimeSeconds((Long)this.payload.get("auth_time"));
                    break;
                }
                case AZP: {
                    idTokenImpl.setAuthorizedParty((String)this.payload.get("azp"));
                    break;
                }
                case NONCE: {
                    idTokenImpl.setNonce((String)this.payload.get("nonce"));
                    break;
                }
                case AT_HASH: {
                    idTokenImpl.setAccessTokenHash((String)this.payload.get("at_hash"));
                    break;
                }
                case ACR: {
                    idTokenImpl.setClassReference((String)this.payload.get("acr"));
                    break;
                }
                case AMR: {
                    idTokenImpl.setMethodsReferences((List)this.payload.get("amr"));
                    break;
                }
                default: {
                    idTokenImpl.setOtherClaims(key, this.payload.get(key));
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            idTokenImpl.setOtherClaims(key, this.payload.get(key));
        }
    }

    protected void addToPayload() {
        Set keys = super.getPayload().keySet();
        for (String key : keys) {
            this.addToPayloadFields(key);
        }
    }

    public void addToIdTokenImpl(IdTokenImpl idTokenImpl) {
        Set keys = super.getPayload().keySet();
        for (String key : keys) {
            this.addToPayloadFields(idTokenImpl, key);
        }
        if (this.getClientId() != null) {
            idTokenImpl.setClientId(this.getClientId());
        }
    }

    @Override
    public boolean verify() throws IDTokenValidationFailedException {
        return this.verify(180L);
    }

    @Override
    public boolean verify(long clockSkew) throws IDTokenValidationFailedException {
        return this.verify(clockSkew, this.getKey());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @FFDCIgnore(value={IDTokenValidationFailedException.class})
    public boolean verify(long clockSkew, Object key) throws IDTokenValidationFailedException {
        boolean verified = false;
        if (!super.verify(clockSkew, key)) return verified;
        this.payload.putAll(super.getPayload());
        this.addToPayload();
        if (this.payload.getAccessTokenHash() == null) return true;
        String athash = this.payload.getAccessTokenHash();
        if (this.ath == null) {
            Tr.error((TraceComponent)tc, (String)"OIDC_IDTOKEN_VERIFY_ATHASH_ERR", (Object[])new Object[]{this.getClientId(), this.ath, athash});
            throw IDTokenValidationFailedException.format("OIDC_IDTOKEN_VERIFY_ATHASH_ERR", this.getClientId(), this.ath, athash);
        }
        if (this.verifyAccessTokenHash(athash)) {
            return true;
        }
        Tr.error((TraceComponent)tc, (String)"OIDC_IDTOKEN_VERIFY_ATHASH_ERR", (Object[])new Object[]{this.getClientId(), this.ath, athash});
        throw IDTokenValidationFailedException.format("OIDC_IDTOKEN_VERIFY_ATHASH_ERR", this.getClientId(), this.ath, athash);
    }
}

