/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientRequest;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientUtil;
import com.ibm.ws.webcontainer.security.CookieHelper;
import io.openliberty.security.oidcclientcore.storage.OidcStorageUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Random;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OidcUtil {
    private static final TraceComponent tc = Tr.register(OidcUtil.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    static final char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    static final int iCharlength = chars.length;
    static final int iTwoCharsLenth = chars.length * chars.length;
    public static final int TIMESTAMP_LENGTH = 15;
    public static final int RANDOM_LENGTH = 9;
    public static final int STATEVALUE_LENGTH = 24;
    static final long serialVersionUID = 2894293139209692946L;

    @Trivial
    public static String generateRandomID() {
        return "_" + OidcUtil.generateRandom(32);
    }

    @Trivial
    public static String generateRandom() {
        return OidcUtil.generateRandom(32);
    }

    @Trivial
    public static String generateRandom(int iCharCnt) {
        char[] strChars = new char[iCharCnt];
        Random r = OidcUtil.getRandom();
        int i = 0;
        while (i < iCharCnt) {
            int rnd = r.nextInt(iTwoCharsLenth);
            int firstChar = rnd / iCharlength;
            strChars[i++] = chars[firstChar];
            if (i >= iCharCnt) continue;
            int secondChar = rnd % iCharlength;
            strChars[i++] = chars[secondChar];
        }
        return new String(strChars);
    }

    @Trivial
    static Random getRandom() {
        return new SecureRandom();
    }

    @Trivial
    public static StringBuffer dumpStackTrace(Throwable cause, int iLimited) {
        int iI;
        StackTraceElement[] stackTrace = cause.getStackTrace();
        if (iLimited == -1 || iLimited > stackTrace.length) {
            iLimited = stackTrace.length;
        }
        StringBuffer sb = new StringBuffer("\n  ");
        for (iI = 0; iI < iLimited; ++iI) {
            sb.append(stackTrace[iI].toString() + "\n  ");
        }
        if (iI < stackTrace.length) {
            sb.append("  ....\n");
        }
        return sb;
    }

    public static void removeCookie(OidcClientRequest oidcClientRequest) {
        String cookieName = oidcClientRequest.getOidcClientCookieName();
        OidcClientUtil.invalidateReferrerURLCookie(oidcClientRequest.getRequest(), oidcClientRequest.getResponse(), cookieName);
    }

    public static String getUserNameFromSubject(Subject subject) {
        Iterator<Principal> it = subject.getPrincipals().iterator();
        String username = it.next().getName();
        return username;
    }

    public static String encode(String value) {
        if (value == null) {
            return value;
        }
        try {
            value = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.openidconnect.clients.common.OidcUtil", (String)"134", null, (Object[])new Object[]{value});
        }
        return value;
    }

    public static String encodeQuery(String query) {
        String[] queryParams;
        if (query == null) {
            return null;
        }
        StringBuilder rebuiltQuery = new StringBuilder();
        for (String param : queryParams = query.split("&")) {
            String rebuiltParam = OidcUtil.encode(param);
            int equalIndex = param.indexOf("=");
            if (equalIndex > -1) {
                String name = param.substring(0, equalIndex);
                String value = equalIndex < param.length() - 1 ? param.substring(equalIndex + 1) : "";
                rebuiltParam = OidcUtil.encode(name) + "=" + OidcUtil.encode(value);
            }
            if (rebuiltParam.isEmpty()) continue;
            rebuiltQuery.append(rebuiltParam + "&");
        }
        if (rebuiltQuery.length() > 0 && rebuiltQuery.charAt(rebuiltQuery.length() - 1) == '&') {
            rebuiltQuery.deleteCharAt(rebuiltQuery.length() - 1);
        }
        return rebuiltQuery.toString();
    }

    public static String getCauseMsg(Throwable e) {
        if (e instanceof NullPointerException) {
            return "[Missing some data. Got a NullPointerException]";
        }
        String exceptionName = e.getClass().getSimpleName();
        String exceptionMsg = e.getMessage();
        String result = "[" + exceptionName + "]";
        if (exceptionMsg != null) {
            return result + "[" + exceptionMsg + "]";
        }
        return result;
    }

    @Trivial
    public static boolean verifyNonce(OidcClientRequest oidcClientRequest, String nonceInIDToken, ConvergedClientConfig clientConfig, String responseState) {
        String cookieName = OidcStorageUtils.getNonceStorageKey((String)clientConfig.getClientId(), (String)responseState);
        String cookieValue = OidcStorageUtils.createNonceStorageValue((String)nonceInIDToken, (String)responseState, (String)clientConfig.getClientSecret());
        String oldCookieValue = CookieHelper.getCookieValue((Cookie[])oidcClientRequest.getRequest().getCookies(), (String)cookieName);
        OidcClientUtil.invalidateReferrerURLCookie(oidcClientRequest.getRequest(), oidcClientRequest.getResponse(), cookieName);
        return cookieValue.equals(oldCookieValue);
    }
}

