/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip.netty;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import com.ibm.ws.sip.properties.SipPropertiesMap;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.dispatch.Dispatcher;
import com.ibm.ws.sip.stack.transaction.transport.UseCompactHeaders;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import com.ibm.ws.sip.stack.transport.sip.netty.BaseConnection;
import com.ibm.ws.sip.stack.transport.sip.netty.SipUdpConnection;
import com.ibm.ws.sip.stack.transport.sip.netty.SipUdpInboundChannel;
import com.ibm.ws.sip.stack.transport.sip.netty.UdpSender;
import com.ibm.ws.sip.stack.util.StackTaskDurationMeasurer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.concurrent.GenericFutureListener;
import jain.protocol.ip.sip.ListeningPoint;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class SipUdpConnLink
implements UdpSender,
ChannelFutureListener {
    private static final TraceComponent tc = Tr.register(SipUdpConnLink.class);
    private static final LogMgr c_logger = Log.get(SipUdpConnLink.class);
    private static HashMap s_instances = new HashMap();
    private static SipUdpConnLink s_connectingInstance = null;
    private boolean m_connected;
    private SipUdpInboundChannel m_channel;
    private SendThread m_sendThread;
    private ByteBuf m_outboundBuffer;
    private String m_receiveBufferSizeSocket;
    private String m_sendBufferSizeSocket;
    private String m_receiveBufferSizeChannel;
    private boolean m_needToLearnRouterEndpoint;

    static SipUdpConnLink instance(SipUdpInboundChannel channel) {
        ListeningPoint lp = channel.getListeningPoint();
        SipUdpConnLink connLink = (SipUdpConnLink)s_instances.get(lp);
        if (connLink == null) {
            connLink = new SipUdpConnLink(channel);
            s_instances.put(lp, connLink);
        }
        return connLink;
    }

    private SipUdpConnLink(SipUdpInboundChannel channel) {
        this.m_channel = channel;
        this.m_sendThread = new SendThread(this);
        this.m_connected = false;
        this.m_outboundBuffer = null;
        this.m_sendThread.start();
        SipPropertiesMap config = ApplicationProperties.getProperties();
        this.m_receiveBufferSizeSocket = config.getString("receiveBufferSizeSocket");
        if (this.m_receiveBufferSizeSocket.equals("") || this.m_receiveBufferSizeSocket.length() == 0) {
            this.m_receiveBufferSizeSocket = null;
        }
        this.m_sendBufferSizeSocket = config.getString("sendBufferSizeSocket");
        if (!this.m_sendBufferSizeSocket.equals("") || this.m_sendBufferSizeSocket.length() == 0) {
            this.m_sendBufferSizeSocket = null;
        }
        this.m_receiveBufferSizeChannel = config.getString("receiveBufferSizeChannel");
        if (this.m_receiveBufferSizeChannel.equals("") || this.m_receiveBufferSizeChannel.length() == 0) {
            this.m_receiveBufferSizeChannel = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{"receiveBufferSizeSocket [" + this.m_receiveBufferSizeSocket + "] sendBufferSizeSocket [" + this.m_sendBufferSizeSocket + "] receiveBufferSizeChannel [" + this.m_receiveBufferSizeChannel + ']'});
        }
    }

    static SipUdpConnLink getPendingConnection() {
        SipUdpConnLink current = s_connectingInstance;
        s_connectingInstance = null;
        return current;
    }

    private void connect(MessageContext messageContext) throws IOException {
        String outboundChainName = this.m_channel.getOutboundChainName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"<connect>", (Object[])new Object[]{"outboundChainName = " + outboundChainName});
        }
    }

    @Override
    public void send(MessageContext messageContext, UseCompactHeaders useCompactHeaders) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("SipUdpConnLink.send: " + System.identityHashCode(messageContext) + " isconnected = " + this.m_connected), (Object[])new Object[0]);
        }
        if (!this.m_connected) {
            this.connect(messageContext);
        }
        this.m_sendThread.queue(messageContext);
    }

    protected boolean sendNow(MessageContext messageContext) throws IOException {
        SipMessageByteBuffer message = messageContext.getSipMessageByteBuffer();
        messageContext.setSipMessageByteBuffer(null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("SipUdpConnLink.sendNow: " + System.identityHashCode(message)), (Object[])new Object[0]);
        }
        if (message == null) {
            throw new IOException("message is null in SipUdpConnLink.sendNow");
        }
        if (this.m_outboundBuffer != null) {
            throw new IOException("previous send not completed in SipUdpConnLink.sendNow");
        }
        SipUdpConnection sipConnection = (SipUdpConnection)messageContext.getSipConnection();
        String remoteHost = sipConnection.getRemoteHost();
        int remotePort = sipConnection.getRemotePort();
        InetSocketAddress address = InetAddressCache.getInetSocketAddress(remoteHost, remotePort);
        this.m_outboundBuffer = BaseConnection.stackBufferToByteBuf(message);
        DatagramPacket pkt = new DatagramPacket(this.m_outboundBuffer, address);
        ChannelFuture writeFuture = sipConnection.getChannel().writeAndFlush((Object)pkt);
        boolean complete = writeFuture.isDone();
        writeFuture.addListener((GenericFutureListener)this);
        return complete;
    }

    public void complete(SipMessageByteBuffer buffer, InetSocketAddress senderAddr) {
        boolean drop = Dispatcher.instance().isOverLoaded();
        if (drop && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"complete", (Object[])new Object[]{"Warning: dropping request under overloaded situation"});
        }
        if (!this.m_connected) {
            this.m_connected = true;
        }
        if (senderAddr == null) {
            if (c_logger.isInfoEnabled()) {
                c_logger.info("complete", null, "A message in order to use UDP connection link");
            }
        } else {
            SipUdpConnection bc = new SipUdpConnection(this.m_channel, this, this.m_channel.getChannel());
            bc.setRemoteAddress(senderAddr);
            bc.messageReceived(buffer);
        }
    }

    public void error(Throwable e2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"SipUdpConnLink(read).error", (Object[])new Object[]{e2});
        }
        this.close(e2);
    }

    public void complete() {
        this.m_sendThread.sendComplete();
    }

    void releaseOutboundBuffer() {
        this.m_outboundBuffer = null;
    }

    public void close(Throwable e2) {
        if (!this.m_connected) {
            return;
        }
        this.m_connected = false;
        s_instances.remove(this.m_channel.getListeningPoint());
        this.m_channel.connectionClosed();
        this.m_sendThread.terminate();
    }

    public void close() {
        this.close(null);
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (future.isSuccess()) {
            this.complete();
        } else {
            Throwable t = future.cause();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Caught exception " + t.toString() + " while sending data.  Packet is lost."), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"1", (Object)this);
            this.complete();
        }
    }

    private static class SendThread
    extends Thread {
        private final SipUdpConnLink m_connLink;
        private final LinkedList<MessageContext> m_outMessages;
        private volatile boolean m_locked;
        private volatile boolean m_running;

        SendThread(SipUdpConnLink connLink) {
            super("SipUdpConnLink.SendThread");
            this.m_connLink = connLink;
            this.m_outMessages = new LinkedList();
            this.m_locked = false;
            this.m_running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void queue(MessageContext messageContext) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("SipUdpConnLink$SendThread.queue: " + System.identityHashCode(messageContext)), (Object[])new Object[0]);
            }
            LinkedList<MessageContext> linkedList = this.m_outMessages;
            synchronized (linkedList) {
                if (PerformanceMgr.getInstance().isTaskDurationOutboundQueuePMIEnabled() && messageContext != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"SipUdpConnLink$SendThread.queue", (Object[])new Object[]{"start measuring task duration"});
                    }
                    messageContext.setStackTaskDurationMeasurer(new StackTaskDurationMeasurer());
                    messageContext.getSipContainerQueueDuration().startMeasuring();
                }
                if (messageContext != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"SipUdpConnLink$SendThread.queue", (Object[])new Object[]{"update QueueMonitoring outbound queue statistics - task queued"});
                    }
                    PerformanceMgr.getInstance().updateQueueMonitoringTaskQueuedInOutboundQueue();
                }
                this.m_outMessages.addLast(messageContext);
                this.m_outMessages.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendComplete() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"SipUdpConnLink$SendThread.sendComplete", (Object[])new Object[0]);
            }
            SendThread sendThread = this;
            synchronized (sendThread) {
                this.m_connLink.releaseOutboundBuffer();
                this.m_locked = false;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void terminate() {
            LinkedList<MessageContext> linkedList = this.m_outMessages;
            synchronized (linkedList) {
                this.m_running = false;
                this.m_outMessages.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block21: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"SipUdpConnLink thread started", (Object[])new Object[0]);
                }
                try {
                    while (this.m_running) {
                        boolean immediate;
                        MessageContext messageContext = null;
                        Object object = this.m_outMessages;
                        synchronized (object) {
                            block22: {
                                if (this.m_outMessages.isEmpty() || !this.m_connLink.m_connected) {
                                    this.m_outMessages.wait();
                                }
                                if (!this.m_running) {
                                    break;
                                }
                                try {
                                    messageContext = this.m_outMessages.removeFirst();
                                    if (messageContext == null || !PerformanceMgr.getInstance().isTaskDurationOutboundQueuePMIEnabled()) break block22;
                                    PerformanceMgr.getInstance().measureTaskDurationOutboundQueue(messageContext.getSipContainerQueueDuration().takeTimeMeasurement());
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((Object)this, (TraceComponent)tc, (String)"run", (Object[])new Object[]{"update QueueMonitoring outbound queue statistics - task dequeued"});
                                    }
                                    PerformanceMgr.getInstance().updateQueueMonitoringTaskDequeuedFromOutboundQueue();
                                }
                                catch (NoSuchElementException e2) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((Object)this, (TraceComponent)tc, (String)"run", (Object[])new Object[]{"Trying to remove message from empty list"});
                                    }
                                    continue;
                                }
                            }
                        }
                        object = this;
                        synchronized (object) {
                            if (this.m_locked) {
                                this.wait();
                            }
                        }
                        if (!this.m_running) break;
                        this.m_locked = true;
                        try {
                            immediate = this.m_connLink.sendNow(messageContext);
                            messageContext.writeComplete();
                        }
                        catch (IOException e3) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"run", (Object[])new Object[]{"IOException", e3});
                            }
                            messageContext.writeError(e3);
                            immediate = true;
                        }
                        if (!immediate) continue;
                        this.sendComplete();
                    }
                }
                catch (InterruptedException e4) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block21;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"run", (Object[])new Object[]{"InterruptedException", e4});
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"SipUdpConnLink thread terminated", (Object[])new Object[0]);
            }
        }
    }
}

