/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.was;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.events.EventsDispatcher;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.parser.ServletsInstanceHolder;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.router.SipAppDescManager;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInitializationCollaborator;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServlet;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@Component(configurationPolicy=ConfigurationPolicy.IGNORE, configurationPid={"com.ibm.ws.sip.container.was.WebsphereAppLoadListener"}, service={WebAppInitializationCollaborator.class}, property={"service.vendor=IBM"})
public class WebsphereAppLoadListener
implements WebAppInitializationCollaborator {
    private static final LogMgr c_logger = Log.get(WebsphereAppLoadListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started(Container moduleContainer) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("started");
        }
        try {
            List<SipServlet> sipServletsList;
            WebAppConfiguration webConfig = (WebAppConfiguration)moduleContainer.adapt(WebAppConfig.class);
            String name = webConfig.getModuleName();
            SipAppDescManager appDescMangar = SipAppDescManager.getInstance();
            SipAppDesc appDesc = appDescMangar.getSipAppDesc(name);
            if (appDesc == null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipModuleStateListener Failed finding SipAppDesc for " + name);
                }
                return;
            }
            String vhost = webConfig.getVirtualHostName();
            appDesc.setVirtualHost(vhost, webConfig.getVirtualHostList());
            List<SipServletDesc> siplets = appDesc.getSipServlets();
            for (SipServletDesc sipDesc : siplets) {
                if (!sipDesc.isServletLoadOnStartup()) continue;
                try {
                    appDescMangar.initSipAppIfNeeded(name);
                }
                catch (ServletException e2) {
                    if (!c_logger.isErrorEnabled()) break;
                    c_logger.error("error.init.loadonstartup.app", null, e2.getLocalizedMessage());
                }
                catch (Throwable e3) {
                    if (!c_logger.isErrorEnabled()) break;
                    c_logger.error("error.init.loadonstartup.app", null, e3.getLocalizedMessage());
                }
                break;
            }
            List<SipServlet> list = sipServletsList = appDesc.getLoadOnStartupServlets();
            synchronized (list) {
                for (SipServlet sipServlet : sipServletsList) {
                    EventsDispatcher.sipServletInitiated(appDesc, sipServlet, (ServletContext)webConfig.getWebApp(), -1);
                    if (!c_logger.isTraceDebugEnabled()) continue;
                    c_logger.traceDebug((Object)null, "module started", "Triggering event servlet initialized, servlet name " + sipServlet.getServletName());
                }
            }
        }
        catch (UnableToAdaptException e4) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug((Object)null, "started", "not SipAppDesc found not a sip application: " + moduleContainer.getName(), e4);
            }
        }
        finally {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(null, "moduleStarted");
            }
        }
    }

    public void starting(Container moduleContainer) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)null, "starting", moduleContainer.getName());
        }
    }

    public void stopped(Container moduleContainer) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("stopped");
        }
    }

    public void stopping(Container moduleContainer) {
        block8: {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug((Object)null, "stopping", moduleContainer.getName());
            }
            try {
                WebAppConfiguration webConfig = (WebAppConfiguration)moduleContainer.adapt(WebAppConfig.class);
                String moduleName = webConfig.getModuleName();
                WebApp webApp = webConfig.getWebApp();
                SipAppDesc appDesc = SipAppDescManager.getInstance().getSipAppDesc(webApp);
                if (null != appDesc && appDesc.wasInitialized()) {
                    PropertiesStore store;
                    boolean invalidate;
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "stopping", "SIP Application: module=" + moduleName + ", app=" + appDesc.getAppName());
                    }
                    if (invalidate = (store = PropertiesStore.getInstance()).getProperties().getBoolean("invalidateSessionOnShutdown")) {
                        this.invalidateAppSessions(appDesc.getApplicationName());
                    }
                    List<SipServletDesc> serlvets = appDesc.getSipServlets();
                    String appName = appDesc.getApplicationName();
                    if (serlvets != null) {
                        this.removeSipServlets(appName, serlvets);
                    }
                    SipContainer.getInstance().unloadAppConfiguration(appDesc.getAppName());
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "stopping", "applications left running = " + SipContainer.getInstance().getNumOfRunningApplications());
                    }
                }
            }
            catch (UnableToAdaptException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block8;
                c_logger.traceDebug((Object)null, "stopping", "not SipAppDesc found not a sip application: " + moduleContainer.getName(), e2);
            }
        }
    }

    private void invalidateAppSessions(String sipAppName) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "invalidateAppSessions", "SIP Application: " + sipAppName);
        }
        List<SipApplicationSessionImpl> snapshot = SessionRepository.getInstance().getAllAppSessions();
        for (SipApplicationSession sipApplicationSession : snapshot) {
            String appName = sipApplicationSession.getApplicationName();
            if (!appName.equals(sipAppName)) continue;
            sipApplicationSession.invalidate();
        }
    }

    protected void activate(ComponentContext context) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("activated");
        }
    }

    public void deactivate(int reason) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("deactivated, reason=" + reason);
        }
    }

    private void removeSipServlets(String appname, List<SipServletDesc> servlets) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "removeSipletServlets");
        }
        for (SipServletDesc desc : servlets) {
            ServletsInstanceHolder.getInstance().removeSipletInstance(appname, desc.getClassName());
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "removeSipServlets");
        }
    }
}

