/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.timer;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.timer.BaseTimer;
import java.util.concurrent.ScheduledFuture;

public class SipTimerTask
implements Runnable {
    private static final LogMgr c_logger = Log.get(SipTimerTask.class);
    private BaseTimer m_timer;
    private static final int s_reportInterval = PropertiesStore.getInstance().getProperties().getInt("statReportInterval");
    private ScheduledFuture<?> scheduledFuture;
    private static long s_lastReport = 0L;
    private static int s_instances = 0;
    private static int s_invoked = 0;
    private static int s_cancelled = 0;
    private static final int NTYPES = 6;
    private static int[] s_instancesByType = new int[6];
    private static int[] s_invokedByType = new int[6];
    private static int[] s_cancelledByType = new int[6];
    private static final Object s_reportLock = new Object();

    private static void report() {
        long now = System.currentTimeMillis();
        if (now - s_lastReport < (long)s_reportInterval) {
            return;
        }
        s_lastReport = now;
        StringBuffer report = new StringBuffer(1024);
        report.append("SipTimerTask [").append(s_invoked);
        report.append('/').append(s_cancelled);
        report.append('/').append(s_instances).append(']');
        for (int i = 0; i < 6; ++i) {
            report.append(' ');
            report.append(i).append('-').append(s_invokedByType[i]);
            report.append('/').append(s_cancelledByType[i]);
            report.append('/').append(s_instancesByType[i]);
        }
        System.out.println(report.toString());
    }

    private static int timerType(BaseTimer timer) {
        String className = timer.getClass().getName();
        int type = className.endsWith(".ExpirationTimer") ? 1 : (className.endsWith(".Invite2xxRetransmitTimer") ? 2 : (className.endsWith(".ReliabeResponseRetransmitTimer") ? 3 : (className.endsWith(".SequencialSearchTimer") ? 4 : (className.endsWith(".ServletTimerImpl") ? 5 : 0))));
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipTimerTask(BaseTimer timer) {
        this.m_timer = timer;
        if (s_reportInterval > 0) {
            int type = SipTimerTask.timerType(timer);
            Object object = s_reportLock;
            synchronized (object) {
                ++s_instances;
                int n = type;
                s_instancesByType[n] = s_instancesByType[n] + 1;
            }
            SipTimerTask.report();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BaseTimer timer;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(null, "run");
        }
        if ((timer = this.m_timer) != null) {
            block10: {
                if (s_reportInterval > 0) {
                    int type = SipTimerTask.timerType(timer);
                    Object object = s_reportLock;
                    synchronized (object) {
                        ++s_invoked;
                        int n = type;
                        s_invokedByType[n] = s_invokedByType[n] + 1;
                    }
                    SipTimerTask.report();
                }
                if (!timer.isCancelled()) {
                    try {
                        timer.fire();
                    }
                    catch (Throwable e2) {
                        FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sip.container.timer.SipTimerTask.run", (String)"1", (Object)this);
                        if (!c_logger.isErrorEnabled()) break block10;
                        c_logger.error("error.exception", "Report.LOG", null, e2);
                    }
                }
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(null, "run");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        BaseTimer timer;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(null, "cancel");
        }
        if ((timer = this.m_timer) == null) {
            return false;
        }
        boolean canceledSuccessfully = this.scheduledFuture.cancel(false);
        this.m_timer = null;
        int type = SipTimerTask.timerType(timer);
        Object object = s_reportLock;
        synchronized (object) {
            ++s_cancelled;
            int n = type;
            s_cancelledByType[n] = s_cancelledByType[n] + 1;
        }
        if (canceledSuccessfully && s_reportInterval > 0) {
            SipTimerTask.report();
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "cancel", canceledSuccessfully);
        }
        return canceledSuccessfully;
    }

    public void setScheduledFuture(ScheduledFuture<?> sFuture) {
        this.scheduledFuture = sFuture;
    }
}

