/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.PublicApi;
import graphql.schema.GraphQLSchemaElement;
import java.util.Objects;
import java.util.function.Consumer;

@PublicApi
public class GraphqlTypeComparatorEnvironment {
    private Class<? extends GraphQLSchemaElement> parentType;
    private Class<? extends GraphQLSchemaElement> elementType;

    private GraphqlTypeComparatorEnvironment(Class<? extends GraphQLSchemaElement> parentType, Class<? extends GraphQLSchemaElement> elementType) {
        this.parentType = parentType;
        this.elementType = elementType;
    }

    public Class<? extends GraphQLSchemaElement> getParentType() {
        return this.parentType;
    }

    public Class<? extends GraphQLSchemaElement> getElementType() {
        return this.elementType;
    }

    public GraphqlTypeComparatorEnvironment transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphqlTypeComparatorEnvironment.newEnvironment(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphqlTypeComparatorEnvironment that = (GraphqlTypeComparatorEnvironment)o;
        return Objects.equals(this.parentType, that.parentType) && this.elementType.equals(that.elementType);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.parentType);
        result = 31 * result + Objects.hashCode(this.elementType);
        return result;
    }

    public static Builder newEnvironment() {
        return new Builder();
    }

    public static Builder newEnvironment(GraphqlTypeComparatorEnvironment existing) {
        return new Builder(existing);
    }

    public static class Builder {
        private Class<? extends GraphQLSchemaElement> parentType;
        private Class<? extends GraphQLSchemaElement> elementType;

        public Builder() {
        }

        public Builder(GraphqlTypeComparatorEnvironment existing) {
            this.parentType = existing.parentType;
            this.elementType = existing.elementType;
        }

        public <T extends GraphQLSchemaElement> Builder parentType(Class<T> parentType) {
            this.parentType = parentType;
            return this;
        }

        public <T extends GraphQLSchemaElement> Builder elementType(Class<T> elementType) {
            this.elementType = elementType;
            return this;
        }

        public GraphqlTypeComparatorEnvironment build() {
            return new GraphqlTypeComparatorEnvironment(this.parentType, this.elementType);
        }
    }
}

