/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.client.security.ssl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import io.grpc.netty.GrpcSslContexts;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.openliberty.grpc.internal.client.GrpcSSLService;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={GrpcSSLService.class}, property={"service.vendor=IBM"})
public class LibertyGrpcClientSSLSupport
implements GrpcSSLService {
    private static final TraceComponent tc = Tr.register(LibertyGrpcClientSSLSupport.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.client.security.resources.grpcclientsecuritymessages");
    static final String KEY_KEYSTORE_SERVICE_REF = "keyStoreService";
    private final AtomicServiceReference<KeyStoreService> keyStoreServiceRef = new AtomicServiceReference("keyStoreService");
    static final long serialVersionUID = -6156862733145694004L;

    @Activate
    protected void activate(ComponentContext cc) {
        this.keyStoreServiceRef.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.keyStoreServiceRef.deactivate(cc);
    }

    @Reference(name="keyStoreService", service=KeyStoreService.class)
    protected void setKeyStoreService(ServiceReference<KeyStoreService> reference) {
        this.keyStoreServiceRef.setReference(reference);
    }

    protected void unsetKeyStoreService(ServiceReference<KeyStoreService> reference) {
        this.keyStoreServiceRef.unsetReference(reference);
    }

    /*
     * WARNING - void declaration
     */
    public SslContext getOutboundClientSSLContext(String sslRef, String host, String port) {
        Properties props;
        SslContext context = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getOutboundClientSSLContext ssl reference ID: {0}", (Object[])new Object[]{sslRef});
        }
        if ((props = LibertyGrpcClientSSLSupport.getSSLProps(sslRef, host, port)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"attempting to build SslContext with props: {0}", (Object[])new Object[]{props});
            }
            try {
                List<String> ciphers;
                String sslProtocol;
                KeyManagerFactory keyFactory;
                SslContextBuilder builder = GrpcSslContexts.forClient();
                TrustManagerFactory trustFactory = this.getTrustManagerFactory(props);
                if (trustFactory != null) {
                    builder.trustManager(trustFactory);
                }
                if ((keyFactory = this.getKeyManagerFactory(props)) != null) {
                    builder.keyManager(keyFactory);
                }
                if ((sslProtocol = LibertyGrpcClientSSLSupport.getSSLProtocol(props)) != null) {
                    if (!sslProtocol.equals("TLSv1.2") && !sslProtocol.equals("TLSv1.3")) {
                        Tr.warning((TraceComponent)tc, (String)"invalid.ssl.protocol", (Object[])new Object[]{sslProtocol, LibertyGrpcClientSSLSupport.getSSLAlias(props)});
                    }
                    builder.protocols(new String[]{sslProtocol});
                }
                if ((ciphers = LibertyGrpcClientSSLSupport.getCiphers(props)) != null && !ciphers.isEmpty()) {
                    builder.ciphers(ciphers);
                }
                builder.clientAuth(ClientAuth.OPTIONAL);
                context = builder.build();
            }
            catch (Exception builder) {
                void e;
                FFDCFilter.processException((Throwable)builder, (String)"io.openliberty.grpc.internal.client.security.ssl.LibertyGrpcClientSSLSupport", (String)"127", (Object)this, (Object[])new Object[]{sslRef, host, port});
                Tr.warning((TraceComponent)tc, (String)"client.ssl.failed", (Object[])new Object[]{LibertyGrpcClientSSLSupport.getSSLAlias(props), e});
            }
        }
        return context;
    }

    /*
     * WARNING - void declaration
     */
    protected static Properties getSSLProps(final String sslRef, String target, String port) {
        Properties sslProps;
        block3: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getSSLProps for ssl reference ID: {0} host: {1} port: {2}", (Object[])new Object[]{sslRef, target, port});
            }
            final JSSEHelper helper = JSSEHelper.getInstance();
            final HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", target);
            connectionInfo.put("com.ibm.ssl.remotePort", port);
            sslProps = null;
            try {
                sslProps = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){
                    static final long serialVersionUID = 456991138651008198L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Properties run() throws Exception {
                        return helper.getProperties(sslRef, connectionInfo, null, false);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"io.openliberty.grpc.internal.client.security.ssl.LibertyGrpcClientSSLSupport$1", 1.class, null, null);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"io.openliberty.grpc.internal.client.security.ssl.LibertyGrpcClientSSLSupport", (String)"160", null, (Object[])new Object[]{sslRef, target, port});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"getSSLProps failed", (Object[])new Object[]{e});
            }
        }
        return sslProps;
    }

    protected static String getSSLAlias(Properties props) {
        return props.getProperty("com.ibm.ssl.alias");
    }

    protected static String getSSLProtocol(Properties props) {
        return props.getProperty("com.ibm.ssl.protocol");
    }

    protected static List<String> getCiphers(Properties props) {
        String enabledCipherString = props.getProperty("com.ibm.ssl.enabledCipherSuites");
        if (enabledCipherString != null) {
            String[] requested = enabledCipherString.split("[,\\s]+");
            return Arrays.asList(requested);
        }
        return null;
    }

    protected KeyManagerFactory getKeyManagerFactory(Properties props) {
        KeyManagerFactory keyFactory;
        block2: {
            String keyStoreName = props.getProperty("com.ibm.ssl.keyStoreName");
            char[] keyStorePass = props.getProperty("com.ibm.ssl.keyStorePassword").toCharArray();
            keyFactory = null;
            try {
                keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore ks = this.loadKeyStore(keyStoreName);
                keyFactory.init(ks, keyStorePass);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ks) {
                FFDCFilter.processException((Throwable)ks, (String)"io.openliberty.grpc.internal.client.security.ssl.LibertyGrpcClientSSLSupport", (String)"198", (Object)this, (Object[])new Object[]{props});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"getKeyManagerFactory failed to load  factory for {0}", (Object[])new Object[]{keyStoreName});
            }
        }
        return keyFactory;
    }

    protected TrustManagerFactory getTrustManagerFactory(Properties props) {
        TrustManagerFactory trustFactory;
        block2: {
            String trustStoreName = props.getProperty("com.ibm.ssl.trustStoreName");
            trustFactory = null;
            try {
                trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore ks = this.loadKeyStore(trustStoreName);
                trustFactory.init(ks);
            }
            catch (KeyStoreException | NoSuchAlgorithmException ks) {
                FFDCFilter.processException((Throwable)ks, (String)"io.openliberty.grpc.internal.client.security.ssl.LibertyGrpcClientSSLSupport", (String)"218", (Object)this, (Object[])new Object[]{props});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"getTrustManagerFactory failed to load  factory for {0}", (Object[])new Object[]{trustStoreName});
            }
        }
        return trustFactory;
    }

    private KeyStore loadKeyStore(String name) throws KeyStoreException {
        KeyStoreService service = (KeyStoreService)this.keyStoreServiceRef.getServiceWithException();
        KeyStore store = null;
        if (service != null) {
            store = service.getKeyStore(name);
        }
        return store;
    }
}

